/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.graph.stress.util;

import com.ibm.vis.engine.internal.grammar.layout.graph.Node;
import com.ibm.vis.engine.internal.grammar.layout.graph.stress.util.CoordComparator;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class OverlapRemoval {
    private static final double ORTHO_PRECISION = 0.01;
    private final double gap;
    private final List<Node> sortedNodes;
    private double aspect;
    private final Node[] nodes;

    public OverlapRemoval(Node[] nodeArray, double d, double d2) {
        this.nodes = nodeArray;
        this.gap = d2;
        this.aspect = d;
        this.sortedNodes = new ArrayList<Node>();
    }

    public void layout() {
        int n;
        this.sortedNodes.clear();
        for (Node node : this.nodes) {
            this.sortedNodes.add(node);
        }
        BasicFactory.sortList(this.sortedNodes, new CoordComparator(true));
        for (n = 0; n < this.sortedNodes.size(); ++n) {
            this.bumpNode(n, 0.0, true);
        }
        BasicFactory.sortList(this.sortedNodes, new CoordComparator(false));
        for (n = 0; n < this.sortedNodes.size(); ++n) {
            this.bumpNode(n, 0.0, false);
        }
    }

    private void bumpNode(int n, double d, boolean bl) {
        Node node = this.sortedNodes.get(n);
        for (int i = n + 1; i < this.sortedNodes.size(); ++i) {
            double d2;
            Node node2 = this.sortedNodes.get(i);
            Rect rect = node.getCurrentBounds();
            Rect rect2 = node2.getCurrentBounds();
            Rect rect3 = (Rect)node.getCurrentBounds().expand(this.gap);
            if (!rect3.intersectsRect(rect2)) continue;
            if (bl) {
                double d3;
                d2 = rect.getMaxX() - rect2.getMinX();
                if ((d2 * this.aspect <= (d3 = Math.min(rect.getMaxY() - rect2.getMinY(), rect2.getMaxY() - rect.getMinY())) && bl || this.aligned(node, node2, true)) && !this.aligned(node, node2, false)) {
                    this.bumpNode(i, d + d2 + this.gap, bl);
                    continue;
                }
                this.bumpNode(i, d, bl);
                continue;
            }
            d2 = rect.getMaxY() - rect2.getMinY() + this.gap;
            this.bumpNode(i, d + d2 + this.gap, bl);
        }
        if (bl) {
            node.moveBy(d, 0.0);
        } else {
            node.moveBy(0.0, d);
        }
    }

    private boolean aligned(Node node, Node node2, boolean bl) {
        if (bl) {
            return Math.abs(node.getY() - node2.getY()) <= 0.01;
        }
        return Math.abs(node.getX() - node2.getX()) <= 0.01;
    }
}

