/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.pack;

import com.ibm.vis.engine.internal.grammar.layout.Layout;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.MappedJSONObject;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.ElementLabelSpec;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.LayoutSpec;
import com.ibm.vis.spec.internal.PackParametersSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class PackLayout
extends Layout {
    public static final String ORIENTATION_TOP_TO_BOTTOM = "top-to-bottom";
    public static final String ORIENTATION_BOTTOM_TO_TOP = "bottom-to-top";
    public static final String ORIENTATION_LEFT_TO_RIGHT = "left-to-right";
    public static final String ORIENTATION_RIGHT_TO_LEFT = "right-to-left";
    private static final String METHOD_PACKED = "packed";
    private static final String METHOD_GRID = "grid";
    private static final String MAJOR_ROW = "row";
    private static final String MAJOR_COLUMN = "column";
    private String method;
    private int specRows;
    private int specColumns;
    private boolean rowMajor;
    private boolean rowOrder;
    private boolean columnOrder;
    private String align;
    private String valign;
    private boolean includeEllipsis;
    private Number ellipsisPosition;
    private Dim maximumShapeSize;
    private Insets padding;
    private Dim gridCellSize;
    int numRows;
    int numColumns;
    private Shape ellipsis = null;

    public PackLayout(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
    }

    @Override
    public boolean needsAestheticsPreApplied() {
        return true;
    }

    @Override
    public boolean respectsTransforms() {
        return false;
    }

    @Override
    public List<Shape> makeElementShapes(int n, Dim dim) {
        this.setParameters();
        List<Shape> list = this.createShapes(n);
        this.computeCellSize(list, dim);
        this.getGridSize(dim);
        return this.packShapes(list, dim);
    }

    @Override
    public List<Shape> makeNonElementShapes(Dim dim) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        if (this.ellipsis != null) {
            arrayList.add(this.ellipsis);
        }
        return arrayList;
    }

    private void setParameters() {
        MappedJSONObject mappedJSONObject;
        LayoutSpec layoutSpec = this.adapter.getSpec();
        String string = layoutSpec == null ? ORIENTATION_TOP_TO_BOTTOM : layoutSpec.orientation;
        this.method = METHOD_PACKED;
        this.specRows = 0;
        this.specColumns = 0;
        this.rowMajor = false;
        this.rowOrder = true;
        this.columnOrder = true;
        this.align = "start";
        this.valign = "middle";
        this.includeEllipsis = true;
        this.ellipsisPosition = null;
        if (ORIENTATION_LEFT_TO_RIGHT.equals(string)) {
            this.rowMajor = true;
        } else if (ORIENTATION_RIGHT_TO_LEFT.equals(string)) {
            this.rowMajor = true;
            this.columnOrder = false;
        } else if (ORIENTATION_BOTTOM_TO_TOP.equals(string)) {
            this.rowOrder = false;
        }
        if (layoutSpec != null && layoutSpec.packParameters != null) {
            mappedJSONObject = layoutSpec.packParameters;
            if (METHOD_PACKED.equals(((PackParametersSpec)mappedJSONObject).method)) {
                this.method = METHOD_PACKED;
            } else if (METHOD_GRID.equals(((PackParametersSpec)mappedJSONObject).method)) {
                this.method = METHOD_GRID;
            }
            if (((PackParametersSpec)mappedJSONObject).rows != null) {
                this.specRows = ((PackParametersSpec)mappedJSONObject).rows.intValue();
            }
            if (((PackParametersSpec)mappedJSONObject).columns != null) {
                this.specColumns = ((PackParametersSpec)mappedJSONObject).columns.intValue();
            }
            if (MAJOR_ROW.equals(((PackParametersSpec)mappedJSONObject).major)) {
                this.rowMajor = true;
            } else if (MAJOR_COLUMN.equals(((PackParametersSpec)mappedJSONObject).major)) {
                this.rowMajor = false;
            }
            if (ORIENTATION_TOP_TO_BOTTOM.equals(((PackParametersSpec)mappedJSONObject).rowOrder)) {
                this.rowOrder = true;
            } else if (ORIENTATION_BOTTOM_TO_TOP.equals(((PackParametersSpec)mappedJSONObject).rowOrder)) {
                this.rowOrder = false;
            }
            if (ORIENTATION_LEFT_TO_RIGHT.equals(((PackParametersSpec)mappedJSONObject).columnOrder)) {
                this.columnOrder = true;
            } else if (ORIENTATION_RIGHT_TO_LEFT.equals(((PackParametersSpec)mappedJSONObject).columnOrder)) {
                this.columnOrder = false;
            }
            if (((PackParametersSpec)mappedJSONObject).includeEllipsis != null) {
                this.includeEllipsis = ((PackParametersSpec)mappedJSONObject).includeEllipsis;
            }
            this.ellipsisPosition = ((PackParametersSpec)mappedJSONObject).ellipsisPosition;
        }
        if ((mappedJSONObject = this.adapter.getStyle()) != null) {
            if (PackLayout.isValidAlign(mappedJSONObject.align)) {
                this.align = mappedJSONObject.align;
            }
            if (PackLayout.isValidAlign(mappedJSONObject.valign)) {
                this.valign = mappedJSONObject.valign;
            }
        }
    }

    public static boolean isValidAlign(String string) {
        return "start".equals(string) || "end".equals(string) || "middle".equals(string);
    }

    private List<Shape> createShapes(int n) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        for (int i = 0; i < n; ++i) {
            Shape shape = this.adapter.makeItemAtSimpleCoordinates(new double[]{0.0, 0.0}, i, true);
            if (shape == null) continue;
            arrayList.add(shape);
        }
        return arrayList;
    }

    private void computeCellSize(List<Shape> list, Dim dim) {
        Object object;
        double d = 1.0;
        double d2 = 1.0;
        for (Shape object22 : list) {
            object = object22.getBounds();
            d = Math.max(d, ((Rect)object).getWidth());
            d2 = Math.max(d2, ((Rect)object).getHeight());
        }
        this.maximumShapeSize = new Dim(d, d2);
        StyleSpec styleSpec = this.adapter.getStyle();
        Insets insets = styleSpec != null ? Insets.makeForStylePadding(styleSpec.padding, this.maximumShapeSize, dim) : Insets.NONE;
        object = Insets.makeForStylePadding(this.adapter.getSpec().padding, this.maximumShapeSize, dim);
        this.padding = new Insets(Math.max(0.0, Math.max(insets.top, ((Insets)object).top)), Math.max(0.0, Math.max(insets.left, ((Insets)object).left)), Math.max(0.0, Math.max(insets.bottom, ((Insets)object).bottom)), Math.max(0.0, Math.max(insets.right, ((Insets)object).right)));
        this.gridCellSize = new Dim(this.maximumShapeSize.getWidth() + this.padding.left + this.padding.right, this.maximumShapeSize.getHeight() + this.padding.top + this.padding.bottom);
    }

    private void getGridSize(Dim dim) {
        this.numRows = (int)Math.floor(dim.getHeight() / this.gridCellSize.getHeight());
        if (this.numRows <= 0) {
            this.numRows = 1;
        }
        this.numColumns = (int)Math.floor(dim.getWidth() / this.gridCellSize.getWidth());
        if (this.numColumns <= 0) {
            this.numColumns = 1;
        }
        if (this.specRows > 0) {
            this.numRows = Math.min(this.numRows, this.specRows);
        }
        if (this.specColumns > 0) {
            this.numColumns = Math.min(this.numColumns, this.specColumns);
        }
        if (METHOD_PACKED.equals(this.method)) {
            if (this.rowMajor) {
                this.numColumns = Math.max(0, this.specColumns);
            } else {
                this.numRows = Math.max(0, this.specRows);
            }
        }
    }

    private List<Shape> packShapes(List<Shape> list, Dim dim) {
        int n;
        double d;
        int n2;
        double d2;
        double d3;
        int n3;
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        int n4 = list.size();
        int n5 = 0;
        boolean bl = METHOD_GRID.equals(this.method);
        if (this.rowMajor) {
            n3 = this.numRows;
            d3 = this.gridCellSize.getHeight();
            d2 = dim.getHeight();
            n2 = this.numColumns;
            d = dim.getWidth();
        } else {
            n3 = this.numColumns;
            d3 = this.gridCellSize.getWidth();
            d2 = dim.getWidth();
            n2 = this.numRows;
            d = dim.getHeight();
        }
        if (n2 == 0) {
            n2 = (int)d;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        ArrayList<Point> arrayList2 = new ArrayList<Point>();
        boolean bl2 = false;
        int n6 = 0;
        block0: for (n = 0; n5 < n4 && n < n3; ++n) {
            d4 = (double)n * d3;
            d5 = 0.0;
            n6 = 0;
            while (n5 < n4 && n6 < n2) {
                Shape shape = list.get(n5);
                Rect rect = shape.getBounds();
                double d6 = bl ? (this.rowMajor ? this.gridCellSize.getWidth() : this.gridCellSize.getHeight()) : (this.rowMajor ? rect.getWidth() + this.padding.left + this.padding.right : rect.getHeight() + this.padding.top + this.padding.bottom);
                if (!bl && d6 > d) {
                    bl2 = true;
                    ++n5;
                    continue;
                }
                if (!(d5 + d6 <= d) || !(d4 <= d2)) continue block0;
                this.placeShape(shape, dim, d4, d5, d3, d6, this.align, this.valign, 0.0);
                arrayList2.add(new Point(d4, d5));
                arrayList.add(shape);
                ++n5;
                ++n6;
                d5 += d6;
            }
        }
        if (this.includeEllipsis && (n5 < n4 || bl2)) {
            this.createEllipsis();
            boolean bl3 = n < n3 - 1 || n6 < n2 - 1;
            this.placeEllipsis(arrayList, arrayList2, d4, d5, dim, d2, d, bl3);
        } else {
            this.ellipsis = null;
        }
        return arrayList;
    }

    private void placeEllipsis(List<Shape> list, List<Point> list2, double d, double d2, Dim dim, double d3, double d4, boolean bl) {
        double d5;
        String string;
        double d6;
        double d7;
        Rect rect = this.ellipsis.getBounds();
        if (rect.getHeight() > dim.getHeight() || rect.getWidth() > dim.getWidth()) {
            this.ellipsis = null;
            return;
        }
        if (this.rowMajor) {
            d7 = Math.min(rect.getWidth(), d3);
            d6 = Math.min(this.gridCellSize.getHeight(), d4);
        } else {
            d7 = Math.min(this.gridCellSize.getWidth(), d3);
            d6 = Math.min(rect.getHeight(), d4);
        }
        if (this.ellipsisPosition == null) {
            string = "middle";
            d5 = 0.0;
        } else {
            string = "start";
            d5 = this.ellipsisPosition.doubleValue();
            if (d5 < 0.0) {
                d5 = 0.0;
            }
            if (d5 > this.gridCellSize.getWidth() - 5.0 - rect.getWidth()) {
                d5 = this.gridCellSize.getWidth() - 5.0 - rect.getWidth();
            }
        }
        if (bl && d + d7 <= d3 && d2 + d6 <= d4) {
            this.placeShape(this.ellipsis, dim, d, d2, d7, d6, string, "start", d5);
        } else if (bl && d + 2.0 * d7 <= d3) {
            Shape shape;
            Rect rect2;
            this.placeShape(this.ellipsis, dim, d + d7, 0.0, d7, d6, string, "start", d5);
            list.remove(list.size() - 1);
            Rect rect3 = this.ellipsis.getBounds();
            while (list.size() > 0 && rect3.intersectsRect(rect2 = (shape = list.get(list.size() - 1)).getBounds())) {
                list.remove(list.size() - 1);
            }
        } else {
            while (list.size() > 0) {
                Point point = list2.get(list.size() - 1);
                list.remove(list.size() - 1);
                if (!(point.getX() + d7 <= d3) || !(point.getY() + d6 <= d4)) continue;
                this.placeShape(this.ellipsis, dim, point.getX(), point.getY(), d7, d6, string, "start", d5);
                break;
            }
            if (list.size() == 0) {
                this.placeShape(this.ellipsis, dim, 0.0, 0.0, d7, d6, string, "start", d5);
            }
        }
    }

    private void placeShape(Shape shape, Dim dim, double d, double d2, double d3, double d4, String string, String string2, double d5) {
        double d6;
        double d7;
        double d8;
        double d9;
        if (this.rowMajor) {
            d9 = d2;
            d8 = d;
            d7 = d4;
            d6 = d3;
        } else {
            d9 = d;
            d8 = d2;
            d7 = d3;
            d6 = d4;
        }
        if (!this.rowOrder) {
            d8 = dim.getHeight() - d8 - d6;
        }
        if (!this.columnOrder) {
            d9 = dim.getWidth() - d9 - d7;
        }
        d9 += this.padding.left;
        d8 += this.padding.top;
        d9 += d5;
        Rect rect = shape.getBounds();
        double d10 = d7 - rect.getWidth() - d5 - this.padding.left - this.padding.right;
        double d11 = d6 - rect.getHeight() - this.padding.top - this.padding.bottom;
        if ("middle".equals(string)) {
            d9 += d10 / 2.0;
        } else if ("end".equals(string)) {
            d9 += d10;
        }
        if ("middle".equals(string2)) {
            d8 += d11 / 2.0;
        } else if ("end".equals(string2)) {
            d8 += d11;
        }
        shape.affine(1.0, d9 - rect.getX(), 1.0, d8 - rect.getY(), true);
    }

    private void createEllipsis() {
        ElementLabelSpec elementLabelSpec = new ElementLabelSpec();
        elementLabelSpec.content = new Object[]{"\u2026"};
        elementLabelSpec.style = new StyleSpec();
        elementLabelSpec.style.font = new FontSpec();
        elementLabelSpec.style.font.weight = "bold";
        Rect rect = Rect.makeRectFromDim(this.gridCellSize);
        Shape shape = ShapeFactory2.CreateRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        this.ellipsis = this.adapter.makeLabelShape(elementLabelSpec, shape);
        if (this.ellipsis == null) {
            this.ellipsis = shape;
        }
    }

    @Override
    public Dim getPreferredSize(int n) {
        Dim dim;
        this.setParameters();
        List<Shape> list = this.createShapes(n);
        Dim dim2 = new Dim(500.0, 400.0);
        this.computeCellSize(list, dim2);
        if (METHOD_GRID.equals(this.method)) {
            dim = this.rowMajor ? this.getGridRowMajorPreferredSize(n, list) : this.getGridColumnMajorPreferredSize(n, list);
            if (this.specColumns > 0) {
                dim.setWidth(Math.max(dim.getWidth(), (double)this.specColumns * this.gridCellSize.getWidth()));
            }
            if (this.specRows > 0) {
                dim.setHeight(Math.max(dim.getHeight(), (double)this.specRows * this.gridCellSize.getHeight()));
            }
        } else {
            assert (METHOD_PACKED.equals(this.method));
            dim = this.rowMajor ? this.getPackedRowMajorPreferredSize(n, list) : this.getPackedColumnMajorPreferredSize(n, list);
            if (!this.rowMajor && this.specColumns > 0) {
                dim.setWidth(Math.max(dim.getWidth(), (double)this.specColumns * this.gridCellSize.getWidth()));
            }
            if (this.rowMajor && this.specRows > 0) {
                dim.setHeight(Math.max(dim.getHeight(), (double)this.specRows * this.gridCellSize.getHeight()));
            }
        }
        return dim;
    }

    private Dim getPackedColumnMajorPreferredSize(int n, List<Shape> list) {
        int n2 = 0;
        int n3 = 1;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (Shape shape : list) {
            if (this.specRows > 0 && n2 >= this.specRows) {
                if (this.specColumns > 0 && n3 >= this.specColumns) break;
                n2 = 0;
                d = 0.0;
                ++n3;
            }
            Dim dim = this.padding.expandRect(shape.getBounds()).getExtent();
            d2 = Math.max(d2, dim.getWidth());
            ++n2;
            d3 = Math.max(d3, d += dim.getHeight());
        }
        return new Dim((double)n3 * d2, d3);
    }

    private Dim getPackedRowMajorPreferredSize(int n, List<Shape> list) {
        int n2 = 0;
        int n3 = 1;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (Shape shape : list) {
            if (this.specColumns > 0 && n2 >= this.specColumns) {
                if (this.specRows > 0 && n3 >= this.specRows) break;
                n2 = 0;
                d = 0.0;
                ++n3;
            }
            Dim dim = this.padding.expandRect(shape.getBounds()).getExtent();
            d3 = Math.max(d3, dim.getHeight());
            ++n2;
            d2 = Math.max(d2, d += dim.getWidth());
        }
        return new Dim(d2, (double)n3 * d3);
    }

    private Dim getGridColumnMajorPreferredSize(int n, List<Shape> list) {
        int n2 = n;
        if (this.specRows > 0) {
            n2 = Math.min(this.specRows, n2);
        }
        int n3 = (int)Math.floor((n + n2 - 1) / n2);
        if (this.specColumns > 0) {
            n3 = Math.min(this.specColumns, n3);
        }
        return new Dim(this.gridCellSize.getWidth() * (double)n3, this.gridCellSize.getHeight() * (double)n2);
    }

    private Dim getGridRowMajorPreferredSize(int n, List<Shape> list) {
        int n2 = n;
        if (this.specColumns > 0) {
            n2 = Math.min(this.specColumns, n2);
        }
        int n3 = (int)Math.floor((n + n2 - 1) / n2);
        if (this.specRows > 0) {
            n3 = Math.min(this.specRows, n3);
        }
        return new Dim(this.gridCellSize.getWidth() * (double)n2, this.gridCellSize.getHeight() * (double)n3);
    }
}

