/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.spiral;

import com.ibm.vis.engine.diagramService.Diagram;
import com.ibm.vis.engine.diagramService.DiagramConnector;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Circle;
import com.ibm.vis.geom.CompositeGeom;
import com.ibm.vis.geom.Curve;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Geom;
import com.ibm.vis.geom.Line;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Wedge;
import com.ibm.vis.spec.internal.PreferredSizeSpec;

class SpiralDiagram
extends Diagram {
    private double loops;
    private int bands;
    private double cx;
    private double cy;
    private double rMin;
    private double rMax;
    private double symbolRadius;
    private int N;
    private double innerRadius;
    private double importantRadius;
    private int version;

    SpiralDiagram() {
    }

    @Override
    public void initialize(DiagramConnector diagramConnector) {
        super.initialize(diagramConnector);
    }

    @Override
    public Dim calculatePreferredSize() {
        return new Dim(400.0, 400.0);
    }

    @Override
    public boolean connectsExistingShapes() {
        return false;
    }

    @Override
    public void build(Dim dim) {
        this.setSpiralParameters(dim);
        this.addBullseye();
        this.addBands();
        this.addSpiral();
        this.addPoints();
    }

    private void setSpiralParameters(Dim dim) {
        this.loops = this.connector.numericParameter("loops", 2.0).doubleValue();
        this.bands = (int)Math.ceil(this.connector.numericParameter("bands", this.loops).doubleValue());
        this.cx = dim.getWidth() / 2.0;
        this.cy = dim.getHeight() / 2.0;
        double d = dim.getMin();
        double d2 = this.getBullseyeSize(d);
        this.rMin = d2 / 2.0;
        this.rMax = d / 2.0;
        this.symbolRadius = this.connector.getElementSize().getMin() / 2.0;
        this.N = this.connector.getRowCount();
        this.version = (int)Math.ceil(this.connector.numericParameter("version", 1).doubleValue());
        this.innerRadius = this.connector.numericParameter("innerRadius", 0.6).doubleValue();
        this.importantRadius = this.connector.numericParameter("importantRadius", 1.0).doubleValue();
    }

    private double getBullseyeSize(double d) {
        Object object = this.connector.objectParameter("bullseyeSize", "25%");
        if (BasicFactory.isObject(object)) {
            PreferredSizeSpec preferredSizeSpec = new PreferredSizeSpec();
            preferredSizeSpec.min = BasicFactory.getItem(object, "min");
            preferredSizeSpec.max = BasicFactory.getItem(object, "max");
            preferredSizeSpec.preferred = BasicFactory.getItem(object, "preferred");
            if (preferredSizeSpec.preferred == null) {
                preferredSizeSpec.preferred = "25%";
            }
            object = preferredSizeSpec;
        }
        return UnitConverter.convertLength(object, d, d);
    }

    private void addBullseye() {
        Shape shape;
        String string;
        Circle circle = new Circle(this.cx, this.cy, this.rMin);
        Shape shape2 = (Shape)this.connector.addNonElementShape(circle, new String[]{"bullseye"});
        if (shape2 != null) {
            shape2.setMeta("part", "bullseye");
        }
        if ((string = this.connector.stringParameter("title", null)) != null && (shape = (Shape)this.connector.addNonElementLabel(string, circle, new String[]{"title"})) != null) {
            shape.setMeta("part", "title");
        }
    }

    private void addBands() {
        Point point = new Point(this.cx, this.cy);
        double d = 0.0;
        double d2 = this.rMin;
        double d3 = (this.rMax - d2) / (double)this.bands;
        for (int i = 0; i < this.bands; ++i) {
            d = d2;
            Wedge wedge = new Wedge(point, d, d2 += d3, 0.0, Math.PI * 2);
            Shape shape = (Shape)this.connector.addNonElementShape(wedge, new String[]{"band_" + i});
            if (shape == null) continue;
            shape.setMeta("part", "band_" + i);
        }
    }

    private void addSpiral() {
        int n = (int)(Math.ceil(this.loops) * 100.0);
        double[] dArray = new double[n + 1];
        double[] dArray2 = new double[n + 1];
        boolean[] blArray = new boolean[n + 1];
        Point point = null;
        for (int i = 0; i <= n; ++i) {
            double d = 1.0 - (double)i / (double)n;
            point = this.calculateSpiralPoint(d, point, false);
            dArray[i] = point.getX();
            dArray2[i] = point.getY();
            blArray[i] = false;
        }
        Curve curve = new Curve(dArray, dArray2, blArray, false);
        Shape shape = (Shape)this.connector.addNonElementShape(curve, new String[]{"spiral"});
        if (shape != null) {
            shape.setMeta("part", "spiral");
        }
    }

    private Point calculateSpiralPoint(double d, Point point, boolean bl) {
        double d2 = this.calculateRadius(d, bl);
        double d3 = this.calculateAngle(d);
        double d4 = this.cx + d2 * Math.cos(d3);
        double d5 = this.cy + d2 * Math.sin(d3);
        if (point == null) {
            return new Point(d4, d5);
        }
        point.setX(d4);
        point.setY(d5);
        return point;
    }

    private double calculateAngle(double d) {
        return Math.PI * 2 * this.loops * (1.0 - d) - Math.PI;
    }

    private double calculateValueFromAngle(double d) {
        return 1.0 - (d + Math.PI) / (this.loops * 2.0 * Math.PI);
    }

    private double calculateRadius(double d, boolean bl) {
        double d2 = this.rMin + (this.rMax - this.rMin) * (1.0 - d);
        d2 = bl ? Math.max(this.rMin + this.symbolRadius, Math.min(this.rMax, d2)) : Math.max(this.rMin, Math.min(this.rMax, d2));
        return d2;
    }

    private void addPoints() {
        double[][] dArray = this.makeDataTable();
        if (this.N > 0 && this.connector.booleanParameter("dodge", true).booleanValue()) {
            this.dodge(dArray);
        }
        String[] stringArray = new String[]{};
        String[] stringArray2 = new String[]{"symbol", "link"};
        String[] stringArray3 = new String[]{"symbol"};
        for (int i = 0; i < this.N; ++i) {
            String[] stringArray4;
            Geom[] geomArray;
            double d = dArray[0][i];
            double d2 = dArray[1][i];
            double d3 = dArray[4][i];
            Geom geom = this.makeSymbol(d, d2, d3);
            Geom geom2 = this.makeLink(d, d2, d3);
            if (geom2 != null) {
                geomArray = new Geom[]{geom, geom2};
                stringArray4 = stringArray2;
            } else {
                geomArray = new Geom[]{geom};
                stringArray4 = stringArray3;
            }
            CompositeGeom compositeGeom = new CompositeGeom(geomArray, false, stringArray4);
            this.connector.addElementShape(compositeGeom, i, stringArray);
        }
    }

    private void dodge(double[][] dArray) {
        int[] nArray = BasicFactory.makeSortOrder(dArray[2]);
        int[] nArray2 = this.makeGroups();
        while (this.mergeGroups(dArray, nArray2, nArray)) {
            int n = 0;
            while (n < this.N) {
                int n2 = this.findGroupEnd(nArray2, n);
                this.dodgeGroup(dArray, nArray, n, n2);
                n = n2;
            }
        }
    }

    private int findGroupEnd(int[] nArray, int n) {
        int n2;
        int n3 = nArray[n];
        for (n2 = n; n2 < this.N && nArray[n2] == n3; ++n2) {
        }
        return n2;
    }

    private void dodgeGroup(double[][] dArray, int[] nArray, int n, int n2) {
        int n3;
        int n4 = n2 - n;
        int n5 = n + (int)Math.floor((double)n4 / 2.0);
        dArray[0][nArray[n5]] = this.findMiddleSymbolValue(dArray, nArray, n, n2);
        for (n3 = n5 - 1; n3 >= n; --n3) {
            dArray[0][nArray[n3]] = this.findAdjacentSymbolValue(dArray, nArray, n3 + 1, n3);
        }
        for (n3 = n5 + 1; n3 < n2; ++n3) {
            dArray[0][nArray[n3]] = this.findAdjacentSymbolValue(dArray, nArray, n3 - 1, n3);
        }
    }

    private double calculateMeanOfGroup(double[][] dArray, int[] nArray, int n, int n2) {
        int n3 = n2 - n;
        double d = 0.0;
        for (int i = n; i < n2; ++i) {
            d += dArray[3][nArray[i]];
        }
        return d / (double)n3;
    }

    private double findMiddleSymbolValue(double[][] dArray, int[] nArray, int n, int n2) {
        double d;
        int n3 = n2 - n;
        double d2 = d = this.calculateMeanOfGroup(dArray, nArray, n, n2);
        if (n3 % 2 == 0) {
            double d3 = this.calculateRadius(d, true);
            double d4 = this.calculateAngle(d);
            double d5 = 2.0 * Math.asin(this.symbolRadius / d3);
            d2 = this.calculateValueFromAngle(d4 + d5 / 2.0);
        }
        return d2;
    }

    private int[] makeGroups() {
        int[] nArray = new int[this.N];
        for (int i = 0; i < this.N; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    private boolean mergeGroups(double[][] dArray, int[] nArray, int[] nArray2) {
        boolean bl = false;
        int n = 0;
        int n2 = this.findGroupEnd(nArray, n);
        Point point = null;
        Point point2 = null;
        while (n2 < this.N) {
            double d = dArray[0][nArray2[n2 - 1]];
            double d2 = dArray[0][nArray2[n2]];
            point = this.calculateSpiralPoint(d, point, true);
            point2 = this.calculateSpiralPoint(d2, point2, true);
            double d3 = this.findSymbolRadius(dArray[4][nArray2[n2 - 1]]);
            double d4 = this.findSymbolRadius(dArray[4][nArray2[n2]]);
            if (d < d2 || point.distance(point2) < d3 + d4) {
                bl = true;
                int n3 = this.findGroupEnd(nArray, n2);
                for (int i = n2; i < n3; ++i) {
                    nArray[i] = nArray[n];
                }
                n2 = n3;
                continue;
            }
            n = n2;
            n2 = this.findGroupEnd(nArray, n);
        }
        return bl;
    }

    private double findSymbolRadius(double d) {
        double d2 = this.symbolRadius;
        if (d > 0.0) {
            d2 *= this.importantRadius;
        }
        return d2;
    }

    private double findAdjacentSymbolValue(double[][] dArray, int[] nArray, int n, int n2) {
        double d = dArray[0][nArray[n]];
        double d2 = this.findSymbolRadius(dArray[4][n]);
        double d3 = this.findSymbolRadius(dArray[4][nArray[n2]]);
        int n3 = n2 - n;
        double d4 = this.calculateRadius(d, true);
        double d5 = this.calculateAngle(d);
        Point point = this.calculateSpiralPoint(d, null, true);
        Point point2 = null;
        double d6 = 2.0 * Math.asin(Math.max(d2, d3) / d4);
        double d7 = d;
        double d8 = this.calculateValueFromAngle(d5 + (double)(2 * n3) * d6);
        double d9 = 1.0;
        do {
            double d10;
            double d11;
            if ((d11 = (point2 = this.calculateSpiralPoint(d10 = (d7 + d8) / 2.0, point2, true)).distance(point) - (d2 + d3)) >= 0.0) {
                d8 = d10;
                d9 = d11;
                continue;
            }
            d7 = d10;
        } while (d9 > 0.5);
        return d8;
    }

    private double[][] makeDataTable() {
        double[][] dArrayArray = new double[][]{new double[this.N], new double[this.N], new double[this.N], new double[this.N], new double[this.N]};
        int n = this.connector.columnCount();
        for (int i = 0; i < this.N; ++i) {
            Double[] doubleArray = this.connector.row(i);
            dArrayArray[0][i] = doubleArray[0];
            dArrayArray[4][i] = n > 2 ? doubleArray[2] : 0.0;
            dArrayArray[1][i] = n > 1 ? doubleArray[1] : Double.NaN;
            dArrayArray[2][i] = 1.0 - dArrayArray[0][i] + (double)i * 1.0E-12;
            dArrayArray[3][i] = dArrayArray[0][i];
        }
        return dArrayArray;
    }

    private Geom makeLink(double d, double d2, double d3) {
        double d4 = this.calculateAngle(d);
        double d5 = this.calculateRadius(d, true);
        double d6 = d5 - this.symbolRadius - this.getSymbolOverlap(d2, d3);
        Line line = null;
        if (d6 > this.rMin) {
            double d7 = Math.sin(d4);
            double d8 = Math.cos(d4);
            double d9 = this.cx + this.rMin * d8;
            double d10 = this.cy + this.rMin * d7;
            double d11 = this.cx + d6 * d8;
            double d12 = this.cy + d6 * d7;
            line = new Line(d9, d10, d11, d12);
        }
        return line;
    }

    private Geom makeSymbol(double d, double d2, double d3) {
        Geom geom;
        Point point = this.calculateSpiralPoint(d, null, true);
        if (this.version == 1) {
            geom = d2 > 1.0 && d2 <= 2.0 ? this.makeTwoInputSymbol(point) : (d2 > 2.0 && d2 <= 3.0 ? this.makeClusterSymbol3(point, d) : (d2 > 3.0 && d2 <= 4.0 ? this.makeClusterSymbol4(point, d) : (d2 > 4.0 && d2 <= 5.0 ? this.makeClusterSymbol5(point, d) : (d2 >= 6.0 ? this.makeClusterSymbol6(point, d) : new Circle(point.getX(), point.getY(), this.symbolRadius)))));
        } else {
            int n = (int)Math.floor(d2);
            double d4 = this.findSymbolRadius(d3);
            geom = n > 1 && n <= 6 ? this.makeVersion2Symbol(point, n, d4) : (n > 6 ? this.makeVersion2Symbol(point, 12, d4) : new Circle(point.getX(), point.getY(), d4));
        }
        return geom;
    }

    private Geom makeTwoInputSymbol(Point point) {
        Wedge wedge = new Wedge(point, 0.0, this.symbolRadius, -1.5707963267948966, 1.5707963267948966);
        Wedge wedge2 = new Wedge(point, 0.0, this.symbolRadius, 1.5707963267948966, 4.71238898038469);
        return new CompositeGeom(new Geom[]{wedge, wedge2}, false, new String[]{"symbol", "symbol"});
    }

    private Geom makeVersion2Symbol(Point point, int n, double d) {
        Geom[] geomArray = new Geom[n + 1];
        String[] stringArray = new String[n + 1];
        geomArray[0] = new Circle(point.getX(), point.getY(), d * this.innerRadius);
        stringArray[0] = "symbol";
        double d2 = Math.PI * 2 / (double)n;
        for (int i = 0; i < n; ++i) {
            geomArray[i + 1] = new Wedge(point, d * this.innerRadius, d, -1.5707963267948966 + (double)(i - 1) * d2, -1.5707963267948966 + (double)i * d2);
            stringArray[i + 1] = "segment";
        }
        return new CompositeGeom(geomArray, false, stringArray);
    }

    private Geom makeClusterSymbol3(Point point, double d) {
        double d2 = this.calculateAngle(d);
        double d3 = Math.tan(0.5235987755982988);
        double d4 = Math.sin(1.0471975511965976);
        double d5 = this.symbolRadius / 2.0 / d4;
        double d6 = -d5 * d3;
        Circle circle = this.makeClusterCircle(point, d2, 0.0, -d5 / d4, d5);
        Circle circle2 = this.makeClusterCircle(point, d2, d5, -d6, d5);
        Circle circle3 = this.makeClusterCircle(point, d2, -d5, -d6, d5);
        Geom[] geomArray = new Geom[]{circle, circle2, circle3};
        String[] stringArray = new String[]{"symbol", "symbol", "symbol"};
        return new CompositeGeom(geomArray, false, stringArray);
    }

    private Geom makeClusterSymbol4(Point point, double d) {
        double d2 = this.calculateAngle(d);
        double d3 = Math.sin(1.0471975511965976);
        double d4 = this.symbolRadius / 2.0 / d3;
        Circle circle = this.makeClusterCircle(point, d2, 0.0, -this.symbolRadius, d4);
        Circle circle2 = this.makeClusterCircle(point, d2, d4, 0.0, d4);
        Circle circle3 = this.makeClusterCircle(point, d2, -d4, 0.0, d4);
        Circle circle4 = this.makeClusterCircle(point, d2, 0.0, this.symbolRadius, d4);
        Geom[] geomArray = new Geom[]{circle, circle2, circle3, circle4};
        String[] stringArray = new String[]{"symbol", "symbol", "symbol", "symbol"};
        return new CompositeGeom(geomArray, false, stringArray);
    }

    private Geom makeClusterSymbol5(Point point, double d) {
        double d2 = this.calculateAngle(d);
        double d3 = Math.sin(1.0471975511965976);
        double d4 = Math.tan(0.5235987755982988);
        double d5 = this.symbolRadius * d3 / 2.0;
        double d6 = 2.0 * d5 * d3;
        double d7 = -d5 * d4;
        Circle circle = this.makeClusterCircle(point, d2, 0.0, -d6 + d7, d5);
        Circle circle2 = this.makeClusterCircle(point, d2, d5, d7, d5);
        Circle circle3 = this.makeClusterCircle(point, d2, -d5, d7, d5);
        Circle circle4 = this.makeClusterCircle(point, d2, d5, 2.0 * d5 + d7, d5);
        Circle circle5 = this.makeClusterCircle(point, d2, -d5, 2.0 * d5 + d7, d5);
        Geom[] geomArray = new Geom[]{circle, circle2, circle3, circle4, circle5};
        String[] stringArray = new String[]{"symbol", "symbol", "symbol", "symbol", "symbol"};
        return new CompositeGeom(geomArray, false, stringArray);
    }

    private Geom makeClusterSymbol6(Point point, double d) {
        double d2 = this.calculateAngle(d);
        double d3 = Math.sin(1.0471975511965976);
        double d4 = Math.tan(0.5235987755982988);
        double d5 = this.symbolRadius * d3 / 2.0;
        double d6 = 2.0 * d5 * d3;
        double d7 = -d5 * d4;
        Circle circle = this.makeClusterCircle(point, d2, 0.0, -d6 + d7, d5);
        Circle circle2 = this.makeClusterCircle(point, d2, d5, d7, d5);
        Circle circle3 = this.makeClusterCircle(point, d2, -d5, d7, d5);
        Circle circle4 = this.makeClusterCircle(point, d2, 0.0, d6 + d7, d5);
        Circle circle5 = this.makeClusterCircle(point, d2, 2.0 * d5, d6 + d7, d5);
        Circle circle6 = this.makeClusterCircle(point, d2, -2.0 * d5, d6 + d7, d5);
        Geom[] geomArray = new Geom[]{circle, circle2, circle3, circle4, circle5, circle6};
        String[] stringArray = new String[]{"symbol", "symbol", "symbol", "symbol", "symbol", "symbol"};
        return new CompositeGeom(geomArray, false, stringArray);
    }

    private double getSymbolOverlap(double d, double d2) {
        if (this.version > 1) {
            return this.findSymbolRadius(d2) - this.symbolRadius;
        }
        double d3 = Math.sin(1.0471975511965976);
        if (d <= 2.0) {
            return 0.0;
        }
        if (d <= 3.0) {
            double d4 = this.symbolRadius / 2.0 / d3;
            return d4 * (1.0 / d3 + 1.0) - this.symbolRadius;
        }
        if (d <= 4.0) {
            return this.symbolRadius / 2.0 / d3;
        }
        return this.symbolRadius * d3 / 2.0;
    }

    private Circle makeClusterCircle(Point point, double d, double d2, double d3, double d4) {
        double d5 = Math.sin(-1.5707963267948966 + d);
        double d6 = Math.cos(-1.5707963267948966 + d);
        double d7 = d2 * d6 - d3 * d5;
        double d8 = d2 * d5 + d3 * d6;
        return new Circle(point.getX() + d7, point.getY() + d8, d4);
    }
}

