/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.treemap;

import com.ibm.vis.engine.internal.extension.ExtensionFactory;
import com.ibm.vis.engine.internal.extension.RAVEExtensionManager;
import com.ibm.vis.engine.internal.grammar.layout.treemap.PivotBySize;
import com.ibm.vis.engine.internal.grammar.layout.treemap.SliceAndDice;
import com.ibm.vis.engine.internal.grammar.layout.treemap.Squarify;
import com.ibm.vis.engine.internal.grammar.layout.treemap.StackTreeMap;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapLayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapLayouts;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class DefaultTreeMapAlgorithms
implements ExtensionFactory {
    private static boolean registered;

    DefaultTreeMapAlgorithms() {
    }

    static synchronized void registerExtensions() {
        if (!registered) {
            registered = true;
            RAVEExtensionManager.INSTANCE.registerDefaultFactory(new DefaultTreeMapAlgorithms());
        }
    }

    @Override
    public Object newInstance(String string, Object object) {
        TreeMapLayoutAdapter treeMapLayoutAdapter = null;
        if (object != null && object instanceof TreeMapLayoutAdapter) {
            treeMapLayoutAdapter = (TreeMapLayoutAdapter)object;
        }
        if (TreeMapLayouts.squarify.name().equals(string)) {
            return new Squarify(treeMapLayoutAdapter);
        }
        if (TreeMapLayouts.pivotBySize.name().equals(string)) {
            return new PivotBySize(treeMapLayoutAdapter);
        }
        if (TreeMapLayouts.sliceAndDice.name().equals(string)) {
            SliceAndDice sliceAndDice = new SliceAndDice(treeMapLayoutAdapter);
            sliceAndDice.setHorizontal(false);
            return sliceAndDice;
        }
        if (TreeMapLayouts.sliceAndDiceVertical.name().equals(string)) {
            SliceAndDice sliceAndDice = new SliceAndDice(treeMapLayoutAdapter);
            sliceAndDice.setHorizontal(true);
            return sliceAndDice;
        }
        if (TreeMapLayouts.stack.name().equals(string)) {
            StackTreeMap stackTreeMap = new StackTreeMap(treeMapLayoutAdapter);
            return stackTreeMap;
        }
        if (TreeMapLayouts.stackFillSpace.name().equals(string)) {
            StackTreeMap stackTreeMap = new StackTreeMap(treeMapLayoutAdapter);
            stackTreeMap.setFillSpace(true);
            return stackTreeMap;
        }
        return null;
    }
}

