/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.treemap;

import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapBoundsSetter;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapLayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeNode;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class PivotBySize
implements TreeMapAlgorithm {
    private final TreeMapLayoutAdapter adapter;

    public PivotBySize(TreeMapLayoutAdapter treeMapLayoutAdapter) {
        this.adapter = treeMapLayoutAdapter;
    }

    @Override
    public void createBounds(TreeNode treeNode, Rect rect, TreeMapBoundsSetter treeMapBoundsSetter) {
        if (treeNode != null) {
            this.layoutNode(treeNode, rect, treeMapBoundsSetter);
        }
    }

    private static Rect getRectangleAvailableForChildren(Rect rect, double d, double d2) {
        if (!rect.hasExtent()) {
            return new Rect(0.0, 0.0, 0.0, 0.0);
        }
        double d3 = rect.getWidth() * rect.getHeight();
        double d4 = d3 * ((d2 - d) / d2);
        if (rect.getWidth() > rect.getHeight()) {
            double d5 = d4 / rect.getHeight();
            return new Rect(rect.getX(), rect.getY(), d5, rect.getHeight());
        }
        double d6 = d4 / rect.getWidth();
        return new Rect(rect.getX(), rect.getY(), rect.getWidth(), d6);
    }

    private void layoutNode(TreeNode treeNode, Rect rect, TreeMapBoundsSetter treeMapBoundsSetter) {
        double d;
        Rect rect2 = rect;
        if (treeNode.rowIndex > -1) {
            treeMapBoundsSetter.setBounds(treeNode, rect2);
            rect2 = treeNode.bounds;
        }
        if ((d = treeNode.getSize()) > 0.0) {
            rect2 = PivotBySize.getRectangleAvailableForChildren(rect2, d, treeNode.getAggregatedSize(false));
        }
        if (this.adapter != null) {
            rect2 = this.adapter.computePaddedBounds(treeNode, rect2);
        }
        this.layoutSiblingNodes(treeNode.getChildren(), rect2, treeMapBoundsSetter);
    }

    private void layoutSiblingNodes(List<TreeNode> list, Rect rect, TreeMapBoundsSetter treeMapBoundsSetter) {
        Rect rect2;
        Rect rect3;
        Rect rect4;
        Rect rect5;
        double d;
        if (list == null || list.size() == 0) {
            return;
        }
        if (list.size() == 1) {
            TreeNode treeNode = list.get(0);
            this.layoutNode(treeNode, rect, treeMapBoundsSetter);
            return;
        }
        int n = PivotBySize.pivotIndex(list);
        TreeNode treeNode = list.get(n);
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        double d2 = 0.0;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                arrayList.add(list.get(i));
            }
            d2 = PivotBySize.sum(arrayList);
        }
        double d3 = 0.0;
        ArrayList<TreeNode> arrayList2 = new ArrayList<TreeNode>();
        if (n < list.size() - 1) {
            for (int i = n + 1; i < list.size(); ++i) {
                arrayList2.add(list.get(i));
            }
            d3 = PivotBySize.sum(arrayList2);
        }
        if ((d = rect.getWidth() * rect.getHeight()) == 0.0) {
            return;
        }
        double d4 = d2 + treeNode.getAggregatedSize(false) + d3;
        double d5 = d2 * d / d4;
        double d6 = d3 * d / d4;
        double d7 = treeNode.getAggregatedSize(false) * d / d4;
        ArrayList<TreeNode> arrayList3 = new ArrayList<TreeNode>();
        boolean bl = PivotBySize.isHorizontalLayout(rect);
        if (bl) {
            double d8 = d5 / rect.getHeight();
            double d9 = d7 / rect.getHeight();
            double d10 = d6 / rect.getHeight();
            rect5 = new Rect(rect.getX(), rect.getY(), d8, rect.getHeight());
            rect4 = new Rect(rect5.getX() + rect5.getWidth(), rect.getY(), d9, rect.getHeight());
            rect3 = new Rect(rect4.getX() + rect4.getWidth(), rect.getY(), d10, rect.getHeight());
            rect2 = new Rect(rect4.getX(), rect.getY() + rect.getHeight(), rect4.getWidth(), 0.0);
            this.transferToPivotRect(rect4, rect3, rect2, bl, arrayList2, arrayList3);
        } else {
            double d11 = d5 / rect.getWidth();
            double d12 = d7 / rect.getWidth();
            double d13 = d6 / rect.getWidth();
            rect5 = new Rect(rect.getX(), rect.getY(), rect.getWidth(), d11);
            rect4 = new Rect(rect.getX(), rect.getY() + rect5.getHeight(), rect.getWidth(), d12);
            rect3 = new Rect(rect.getX(), rect4.getY() + rect4.getHeight(), rect.getWidth(), d13);
            rect2 = new Rect(rect.getX() + rect.getWidth(), rect.getY() + rect5.getHeight(), 0.0, rect4.getHeight());
            this.transferToPivotRect(rect4, rect3, rect2, bl, arrayList2, arrayList3);
        }
        this.layoutNode(treeNode, rect4, treeMapBoundsSetter);
        if (arrayList.size() > 0) {
            this.layoutSiblingNodes(arrayList, rect5, treeMapBoundsSetter);
        }
        if (arrayList3.size() > 0) {
            this.layoutSiblingNodes(arrayList3, rect2, treeMapBoundsSetter);
        }
        if (arrayList2.size() > 0) {
            this.layoutSiblingNodes(arrayList2, rect3, treeMapBoundsSetter);
        }
    }

    boolean addToPivot(Rect rect, Rect rect2, Rect rect3, List<TreeNode> list, int n, boolean bl, List<TreeNode> list2) {
        if (list.size() == 0) {
            return false;
        }
        Rect rect4 = new Rect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        double d = rect2.getHeight() * rect2.getWidth();
        double d2 = rect.getHeight() * rect.getWidth();
        TreeNode treeNode = list.get(n);
        double d3 = d * treeNode.getAggregatedSize(false) / PivotBySize.sum(list);
        if (bl) {
            double d4 = d3 / rect2.getHeight();
            rect4.setWidth(rect4.getWidth() + d4);
            rect4.setHeight(d2 / rect4.getWidth());
            if (PivotBySize.aspectRatio(rect) > PivotBySize.aspectRatio(rect4)) {
                rect.setWidth(rect4.getWidth());
                rect.setHeight(rect4.getHeight());
                rect2.setX(rect.getX() + rect.getWidth());
                rect2.setWidth(rect2.getWidth() - d4);
                rect3.setWidth(rect4.getWidth());
                rect3.setHeight(rect2.getHeight() - rect4.getHeight());
                rect3.setY(rect.getY() + rect.getHeight());
                TreeNode treeNode2 = list.get(n);
                list.remove(treeNode2);
                list2.add(treeNode2);
                return list.size() != 0;
            }
        } else {
            double d5 = d3 / rect2.getWidth();
            rect4.setHeight(rect4.getHeight() + d5);
            rect4.setWidth(d2 / rect4.getHeight());
            if (PivotBySize.aspectRatio(rect) > PivotBySize.aspectRatio(rect4)) {
                rect.setWidth(rect4.getWidth());
                rect.setHeight(rect4.getHeight());
                rect2.setY(rect.getY() + rect.getHeight());
                rect2.setHeight(rect2.getHeight() - d5);
                rect3.setWidth(rect2.getWidth() - rect.getWidth());
                rect3.setHeight(rect.getHeight());
                rect3.setX(rect.getX() + rect.getWidth());
                TreeNode treeNode3 = list.get(n);
                list.remove(treeNode3);
                list2.add(treeNode3);
                return list.size() != 0;
            }
        }
        return false;
    }

    private static double sum(List<TreeNode> list) {
        double d = 0.0;
        for (TreeNode treeNode : list) {
            d += treeNode.getAggregatedSize(false);
        }
        return d;
    }

    private static int pivotIndex(List<TreeNode> list) {
        int n = 0;
        double d = list.get(n).getAggregatedSize(false);
        for (int i = 0; i < list.size(); ++i) {
            double d2 = list.get(i).getAggregatedSize(false);
            if (!(d2 > d)) continue;
            n = i;
            d = list.get(n).getAggregatedSize(false);
        }
        return n;
    }

    private static boolean isHorizontalLayout(Rect rect) {
        return rect.getWidth() > rect.getHeight();
    }

    private void transferToPivotRect(Rect rect, Rect rect2, Rect rect3, boolean bl, List<TreeNode> list, List<TreeNode> list2) {
        for (int i = 0; i < list.size() && this.addToPivot(rect, rect2, rect3, list, i, bl, list2); ++i) {
        }
    }

    public static double aspectRatio(Rect rect) {
        return Math.max(rect.getWidth(), rect.getHeight()) / Math.min(rect.getWidth(), rect.getHeight());
    }
}

