/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.treemap;

import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapBoundsSetter;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapLayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeNode;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class SliceAndDice
implements TreeMapAlgorithm {
    private boolean horizontal;
    private final TreeMapLayoutAdapter adapter;

    public SliceAndDice(TreeMapLayoutAdapter treeMapLayoutAdapter) {
        this.adapter = treeMapLayoutAdapter;
    }

    public void setHorizontal(boolean bl) {
        this.horizontal = bl;
    }

    @Override
    public void createBounds(TreeNode treeNode, Rect rect, TreeMapBoundsSetter treeMapBoundsSetter) {
        assert (treeNode != null);
        assert (rect != null);
        assert (treeMapBoundsSetter != null);
        treeMapBoundsSetter.setBounds(treeNode, rect);
        this.layoutChildrenForNode(treeNode, rect, treeMapBoundsSetter, this.horizontal);
    }

    private void layoutChildrenForNode(TreeNode treeNode, Rect rect, TreeMapBoundsSetter treeMapBoundsSetter, boolean bl) {
        ArrayList<TreeNode> arrayList = treeNode.getChildren();
        Rect rect2 = rect;
        if (this.adapter != null) {
            rect2 = this.adapter.computePaddedBounds(treeNode, rect);
        }
        if (arrayList != null && !arrayList.isEmpty()) {
            double d = rect2.getX();
            double d2 = rect2.getY();
            double d3 = rect2.getWidth();
            double d4 = rect2.getHeight();
            for (TreeNode treeNode2 : arrayList) {
                Rect rect3;
                double d5;
                if (bl) {
                    d5 = d3 * treeNode2.getAggregatedSize(false) / treeNode.getAggregatedSize(false);
                    rect3 = new Rect(d, d2, d5, d4);
                    d += d5;
                } else {
                    d5 = d4 * treeNode2.getAggregatedSize(false) / treeNode.getAggregatedSize(false);
                    rect3 = new Rect(d, d2, d3, d5);
                    d2 += d5;
                }
                treeMapBoundsSetter.setBounds(treeNode2, rect3);
                this.layoutChildrenForNode(treeNode2, treeNode2.bounds, treeMapBoundsSetter, !bl);
            }
        }
    }
}

