/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.treemap;

import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapBoundsSetter;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapLayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeNode;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeNodeAreaComparator;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class Squarify
implements TreeMapAlgorithm {
    private final TreeMapLayoutAdapter adapter;

    public Squarify(TreeMapLayoutAdapter treeMapLayoutAdapter) {
        this.adapter = treeMapLayoutAdapter;
    }

    protected TreeMapLayoutAdapter getTreeMapLayoutAdapter() {
        return this.adapter;
    }

    @Override
    public void createBounds(TreeNode treeNode, Rect rect, TreeMapBoundsSetter treeMapBoundsSetter) {
        if (treeNode.rowIndex != -1) {
            treeMapBoundsSetter.setBounds(treeNode, rect);
        }
        if (treeNode.getChildCount() > 0) {
            this.layoutChildLevel(treeNode, rect);
            for (TreeNode treeNode2 : treeNode.getChildren()) {
                if (treeNode2.bounds == null) continue;
                this.createBounds(treeNode2, treeNode2.bounds, treeMapBoundsSetter);
            }
        }
    }

    private void layoutChildLevel(TreeNode treeNode, Rect rect) {
        Rect rect2 = rect;
        if (this.adapter != null) {
            rect2 = this.adapter.computePaddedBounds(treeNode, rect);
        }
        double d = rect2.getWidth() * rect2.getHeight();
        double d2 = treeNode.getAggregatedSize(false);
        if (treeNode.getSize() > 0.0) {
            double d3 = d * (treeNode.getSize() / d2);
            double d4 = Squarify.getShortSideLength(rect2);
            double d5 = d3 / d4;
            Rect rect3 = Squarify.isVerticalLayout(rect2) ? new Rect(rect2.getX(), rect2.getY(), rect2.getWidth(), rect2.getHeight() - d5) : new Rect(rect2.getX(), rect2.getY(), rect2.getWidth() - d5, rect2.getHeight());
            rect2 = rect3;
            d = rect2.getWidth() * rect2.getHeight();
            d2 -= treeNode.getSize();
        }
        if (treeNode.getChildCount() > 0) {
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
            for (TreeNode treeNode2 : treeNode.getChildren()) {
                treeNode2.area = d * (treeNode2.getAggregatedSize(false) / d2);
                if (!(treeNode2.area > 0.0)) continue;
                arrayList.add(treeNode2);
            }
            Squarify.sortDecendingOnArea(arrayList);
            this.squarify(arrayList, rect2, Squarify.getShortSideLength(rect2));
        }
    }

    private void squarify(List<TreeNode> list, Rect rect, double d) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        while (!list.isEmpty()) {
            if (list.size() + arrayList.size() == 1) {
                TreeNode treeNode = list.size() == 1 ? list.get(0) : (TreeNode)arrayList.get(0);
                treeNode.bounds = rect;
                break;
            }
            if (list.size() >= 2 && arrayList.size() == 0) {
                TreeNode treeNode = list.get(0);
                arrayList.add(treeNode);
                list.remove(treeNode);
            }
            double d2 = this.worstAspectRatio(arrayList, d);
            TreeNode treeNode = list.get(0);
            ArrayList<TreeNode> arrayList2 = new ArrayList<TreeNode>();
            arrayList2.addAll(arrayList);
            arrayList2.add(treeNode);
            double d3 = this.worstAspectRatio(arrayList2, d);
            if (d2 >= d3) {
                treeNode = list.get(0);
                arrayList.add(treeNode);
                list.remove(treeNode);
                continue;
            }
            rect = Squarify.layoutRow(arrayList, rect, d);
            d = Squarify.getShortSideLength(rect);
            arrayList = new ArrayList();
        }
        if (list.size() == 0 && arrayList.size() > 0) {
            Squarify.layoutRow(arrayList, rect, d);
        }
    }

    private static Rect layoutRow(List<TreeNode> list, Rect rect, double d) {
        if (Squarify.isVerticalLayout(rect)) {
            return Squarify.layoutHRow(list, rect, d);
        }
        return Squarify.layoutVRow(list, rect, d);
    }

    private static Rect layoutVRow(List<TreeNode> list, Rect rect, double d) {
        double d2 = 0.0;
        for (TreeNode treeNode : list) {
            d2 += treeNode.area;
        }
        double d3 = d2 / d;
        double d4 = 0.0;
        for (TreeNode treeNode : list) {
            Rect rect2;
            double d5 = treeNode.area / d3;
            treeNode.bounds = rect2 = new Rect(rect.getX(), rect.getY() + d4, d3, d5);
            d4 += d5;
        }
        return new Rect(rect.getX() + d3, rect.getY(), rect.getWidth() - d3, rect.getHeight());
    }

    private static Rect layoutHRow(List<TreeNode> list, Rect rect, double d) {
        double d2 = 0.0;
        for (TreeNode treeNode : list) {
            d2 += treeNode.area;
        }
        double d3 = d2 / d;
        double d4 = 0.0;
        for (TreeNode treeNode : list) {
            Rect rect2;
            double d5 = treeNode.area / d3;
            treeNode.bounds = rect2 = new Rect(rect.getX() + d4, rect.getY(), d5, d3);
            d4 += d5;
        }
        return new Rect(rect.getX(), rect.getY() + d3, rect.getWidth(), rect.getHeight() - d3);
    }

    private static double getShortSideLength(Rect rect) {
        return rect.getWidth() < rect.getHeight() ? rect.getWidth() : rect.getHeight();
    }

    private static boolean isVerticalLayout(Rect rect) {
        return rect.getWidth() < rect.getHeight();
    }

    double worstAspectRatio(List<TreeNode> list, double d) {
        if (list == null || list.size() == 0) {
            return Double.MAX_VALUE;
        }
        double d2 = 0.0;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        for (TreeNode treeNode : list) {
            double d5 = treeNode.area;
            if (d5 == 0.0) continue;
            d2 += d5;
            if (d3 > d5) {
                d3 = d5;
            }
            if (!(d4 < d5)) continue;
            d4 = d5;
        }
        if (d2 == 0.0) {
            return Double.MIN_VALUE;
        }
        double d6 = d2 * d2;
        double d7 = d * d;
        double d8 = d6 / (d7 * d3);
        double d9 = d7 * d4 / d6;
        return d8 > d9 ? d8 : d9;
    }

    private static void sortDecendingOnArea(List<TreeNode> list) {
        BasicFactory.sortList(list, new TreeNodeAreaComparator(true));
    }
}

