/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.treemap;

import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapBoundsSetter;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapLayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeNode;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.StyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class StackTreeMap
implements TreeMapAlgorithm {
    private final TreeMapLayoutAdapter adapter;
    private Rect overallBounds;
    private int treeHeight;
    private boolean fillArcSpace = false;
    private static final String DEFAULT_CHILD_ALIGNMENT = "start";

    public StackTreeMap(TreeMapLayoutAdapter treeMapLayoutAdapter) {
        this.adapter = treeMapLayoutAdapter;
    }

    @Override
    public void createBounds(TreeNode treeNode, Rect rect, TreeMapBoundsSetter treeMapBoundsSetter) {
        this.overallBounds = rect;
        this.treeHeight = treeNode.getHeight();
        this.createBoundsInternal(treeNode, rect, treeMapBoundsSetter);
    }

    private void createBoundsInternal(TreeNode treeNode, Rect rect, TreeMapBoundsSetter treeMapBoundsSetter) {
        if (treeNode == null) {
            return;
        }
        double d = rect.getY();
        double d2 = this.getHeight(treeNode);
        if (!treeNode.isDummyRoot) {
            treeMapBoundsSetter.setBounds(treeNode, new Rect(rect.getX(), rect.getY(), rect.getWidth(), d2));
            d += this.getHeight(treeNode);
        }
        if (treeNode.getChildCount() == 0) {
            return;
        }
        double d3 = treeNode.getAggregatedSize(this.fillArcSpace);
        double d4 = rect.getX();
        if (treeNode.getSize() > 0.0) {
            double d5 = treeNode.getSize() / d3 * rect.getWidth();
            String string = this.getChildrenAlignment(treeNode);
            if ("middle".equals(string)) {
                d4 += d5 / 2.0;
            } else if ("end".equals(string)) {
                d4 += d5;
            }
        }
        for (TreeNode treeNode2 : treeNode.getChildren()) {
            double d6 = treeNode2.getAggregatedSize(this.fillArcSpace);
            double d7 = d6 / d3;
            double d8 = rect.getWidth() * d7;
            d8 = MathUtil.r3(d8).doubleValue();
            Rect rect2 = new Rect(d4, d, d8, this.getHeight(treeNode2));
            this.createBoundsInternal(treeNode2, rect2, treeMapBoundsSetter);
            d4 += d8;
        }
    }

    private String getChildrenAlignment(TreeNode treeNode) {
        StyleSpec styleSpec;
        if (treeNode.getChildCount() > 0 && !this.fillArcSpace && (styleSpec = this.adapter.getStyle(treeNode.getChild(0))) != null) {
            return styleSpec.align != null ? styleSpec.align : DEFAULT_CHILD_ALIGNMENT;
        }
        return DEFAULT_CHILD_ALIGNMENT;
    }

    private double getHeight(TreeNode treeNode) {
        Double d;
        StyleSpec styleSpec = this.adapter.getStyle(treeNode);
        if (styleSpec != null && (d = UnitConverter.convertLength(styleSpec.height, this.overallBounds.getHeight(), this.overallBounds.getHeight())) != null) {
            return d;
        }
        return Math.round(this.overallBounds.getHeight() / (double)this.treeHeight);
    }

    public final void setFillSpace(boolean bl) {
        this.fillArcSpace = bl;
    }
}

