/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.treemap;

import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeNode;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class TreeBuilder {
    private static final double DEFAULT_SIZE_VALUE = 0.0;
    private static final double CONSTANT_SIZE_VALUE = 1.0;

    TreeBuilder() {
    }

    private static TreeNode makeDummyRoot() {
        TreeNode treeNode = new TreeNode(null, null, 0.0, -1);
        treeNode.isDummyRoot = true;
        return treeNode;
    }

    public TreeNode buildNonRecursiveTree(int n, List<String> list, LayoutAdapter layoutAdapter, String string) {
        int n2 = list.size();
        HashMap<String, TreeNode> hashMap = new HashMap<String, TreeNode>();
        TreeNode treeNode = TreeBuilder.makeDummyRoot();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList arrayList = null;
        for (int i = 0; i < n; ++i) {
            double d;
            if (arrayList == null) {
                arrayList = new ArrayList();
            } else {
                arrayList.clear();
            }
            double d2 = 0.0;
            Double d3 = null;
            if (string != null && !Double.isNaN(d = layoutAdapter.getFieldNumericValue(string, i))) {
                d3 = d;
            }
            String string2 = null;
            TreeNode treeNode2 = treeNode;
            boolean bl3 = false;
            TreeNode treeNode3 = null;
            for (int j = 0; j < n2 && !bl3; ++j) {
                bl3 = j == n2 - 1;
                String string3 = list.get(j);
                Double d4 = layoutAdapter.getFieldNumericValue(string3, i);
                if (d4 == null || d4 < 0.0) {
                    treeNode2.dataRowSpecified(true);
                    bl3 = true;
                } else {
                    string2 = string2 == null ? ((Object)d4).toString() : string2 + "," + d4;
                    treeNode3 = (TreeNode)hashMap.get(string2);
                }
                if (treeNode3 == null) {
                    int n3 = (int)layoutAdapter.getFieldNumericValue(string3, i);
                    if (Double.isNaN(n3)) break;
                    String string4 = layoutAdapter.getFieldStringValue(string3, i);
                    if (string4 == null) {
                        string4 = "";
                    }
                    string4 = string4 + n3;
                    if (j == n2 - 1 && d3 != null) {
                        d2 = d3;
                    } else if (string == null) {
                        d2 = 1.0;
                    }
                    if (bl3 && d2 == 0.0) continue;
                    treeNode3 = new TreeNode(string4, null, d2, i);
                    if (bl3) {
                        treeNode3.dataRowSpecified(true);
                    }
                    treeNode2.addChild(treeNode3);
                    hashMap.put(string2, treeNode3);
                } else if (bl3) {
                    if (d3 != null) {
                        d2 = d3;
                    }
                    if (d2 == 0.0) continue;
                    treeNode3.setSize(d2);
                    treeNode3.setIndex(i);
                }
                treeNode2 = treeNode3;
            }
            if (!bl && d2 < 0.0) {
                bl = true;
            }
            if (bl2 || !(d2 > 0.0)) continue;
            bl2 = true;
        }
        if (!bl2 || bl) {
            this.pruneTree(treeNode, bl2 && bl);
        }
        return TreeBuilder.getRealRoot(treeNode);
    }

    protected TreeNode buildRecursiveTree(int n, String string, String string2, LayoutAdapter layoutAdapter, String string3) {
        TreeNode treeNode = TreeBuilder.makeDummyRoot();
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            String string4 = layoutAdapter.getFieldStringValue(string2, i);
            if (string4 == null) continue;
            if (string3 != null) {
                double d2 = layoutAdapter.getFieldNumericValue(string3, i);
                if (Double.isNaN(d2)) continue;
                d = d2;
                if (!bl2 && d < 0.0) {
                    bl2 = true;
                }
                if (!bl && d > 0.0) {
                    bl = true;
                }
            } else {
                d = 1.0;
            }
            String string5 = null;
            if (string != null) {
                string5 = layoutAdapter.getFieldStringValue(string, i);
            }
            TreeNode treeNode2 = new TreeNode(string4, string5, d, i);
            treeNode2.dataRowSpecified(true);
            if (string5 != null) {
                arrayList.add(treeNode2);
                hashMap.put(string4, i);
                hashMap2.put(string5, i);
                arrayList2.add(string5);
                continue;
            }
            treeNode.addChild(treeNode2);
        }
        TreeBuilder.addImplicitRoots(treeNode, hashMap, hashMap2, arrayList2);
        if (treeNode.getChildCount() == 0) {
            return treeNode;
        }
        this.makeRecursiveTree(arrayList, treeNode, hashMap2);
        treeNode = TreeBuilder.getRealRoot(treeNode);
        this.pruneTree(treeNode, bl && bl2);
        return treeNode;
    }

    private static void addImplicitRoots(TreeNode treeNode, HashMap<String, Integer> hashMap, HashMap<String, Integer> hashMap2, List<String> list) {
        if (treeNode.getChildCount() == 0) {
            HashMap<String, Integer> hashMap3 = new HashMap<String, Integer>();
            for (String string : list) {
                if (hashMap3.containsKey(string) || hashMap.containsKey(string)) continue;
                Number number = hashMap2.get(string);
                int n = (int)number.doubleValue();
                hashMap3.put(string, n);
                TreeNode treeNode2 = new TreeNode(string, null, 0.0, n);
                treeNode.addChild(treeNode2);
            }
        }
    }

    private void makeRecursiveTree(List<TreeNode> list, TreeNode treeNode, HashMap<String, Integer> hashMap) {
        int n = 0;
        int n2 = list.size();
        while (list.size() > 0) {
            if (n > list.size() - 1) {
                if (n2 == list.size()) break;
                n2 = list.size();
                n = 0;
            }
            TreeNode treeNode2 = list.get(n);
            if (treeNode2.parentId != null) {
                TreeNode treeNode3 = this.findParent(treeNode, treeNode2.parentId, hashMap);
                if (treeNode3 != null) {
                    treeNode3.addChild(treeNode2);
                    list.remove(treeNode2);
                    continue;
                }
                ++n;
                continue;
            }
            list.remove(treeNode2);
        }
    }

    private void pruneTree(TreeNode treeNode, boolean bl) {
        double d = treeNode.getSize();
        if (d < 0.0 && !bl) {
            treeNode.setSize(-d);
        }
        int n = treeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            double d2;
            TreeNode treeNode2 = treeNode.getChild(i);
            this.pruneTree(treeNode2, bl);
            if (treeNode2.getChildCount() != 0 || (d2 = treeNode2.getSize()) != 0.0 && (!bl || !(d2 < 0.0))) continue;
            treeNode.removeChild(i);
            --i;
            --n;
        }
    }

    private static TreeNode getRealRoot(TreeNode treeNode) {
        if (treeNode.getChildCount() == 1) {
            treeNode = treeNode.getChild(0);
        }
        return treeNode;
    }

    private TreeNode findParent(TreeNode treeNode, String string, HashMap<String, Integer> hashMap) {
        TreeNode treeNode2;
        int n;
        int n2 = treeNode.getChildCount();
        for (n = 0; n < n2; ++n) {
            treeNode2 = treeNode.getChild(n);
            if (!string.equals(treeNode2.id)) continue;
            return treeNode2;
        }
        for (n = 0; n < n2; ++n) {
            TreeNode treeNode3;
            treeNode2 = treeNode.getChild(n);
            if (!hashMap.containsKey(treeNode2.id) || (treeNode3 = this.findParent(treeNode2, string, hashMap)) == null) continue;
            return treeNode3;
        }
        return null;
    }
}

