/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.treemap;

import com.ibm.rave.codegenerator.annotations.OnDemandLoad;
import com.ibm.vis.engine.internal.extension.RAVEExtensionManager;
import com.ibm.vis.engine.internal.grammar.ShapeList;
import com.ibm.vis.engine.internal.grammar.layout.Layout;
import com.ibm.vis.engine.internal.grammar.layout.LayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.treemap.DefaultTreeMapAlgorithms;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeBuilder;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapAlgorithm;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapBoundsSetter;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapLayoutAdapter;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapLayouts;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeNode;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.ElementLabelSpec;
import com.ibm.vis.spec.internal.FieldRefSpec;
import com.ibm.vis.spec.internal.LayoutSpec;
import com.ibm.vis.spec.internal.LevelsSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.TransformSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@OnDemandLoad(value="com/ibm/vis/layers/layoutsLayer")
class TreeMapLayout
extends Layout
implements TreeMapBoundsSetter {
    private static final String HIDE = "hide";
    private static final String PIVOT_BY_SIZE = "pivotBySize";
    private final TreeMapAlgorithm algorithm;
    private TreeNode tree;
    private final TreeBuilder builder;
    private boolean leafOnly;
    private final HashMap<String, Shape> nodeLabelMap;
    private boolean hideOverlappingLabels;
    private final LayoutSpec spec;
    private static final double DEFAULT_STROKE_WIDTH = 1.0;
    private int treeLevelCounter;

    public TreeMapLayout(LayoutAdapter layoutAdapter) {
        super(layoutAdapter);
        String string;
        this.spec = layoutAdapter.getSpec();
        if (this.spec.leafOnly != null) {
            this.leafOnly = this.spec.leafOnly;
        }
        if ((string = this.spec.layout) == null) {
            string = PIVOT_BY_SIZE;
        } else {
            TreeMapLayout.validateTreeMapLayout(string);
        }
        TreeMapLayoutAdapter treeMapLayoutAdapter = new TreeMapLayoutAdapter(this);
        DefaultTreeMapAlgorithms.registerExtensions();
        this.algorithm = (TreeMapAlgorithm)RAVEExtensionManager.INSTANCE.newInstance(string, treeMapLayoutAdapter);
        this.builder = new TreeBuilder();
        this.nodeLabelMap = new HashMap();
        this.hideOverlappingLabels = false;
        String string2 = layoutAdapter.getLabelCollisionHandling();
        if ("full".equals(string2) || "limited".equals(string2)) {
            this.hideOverlappingLabels = true;
        }
    }

    private static void validateTreeMapLayout(String string) {
        if (TreeMapLayouts.pivotBySize.name().equals(string) || TreeMapLayouts.squarify.name().equals(string) || TreeMapLayouts.sliceAndDice.name().equals(string) || TreeMapLayouts.sliceAndDiceVertical.name().equals(string) || TreeMapLayouts.stack.name().equals(string) || TreeMapLayouts.stackFillSpace.name().equals(string)) {
            return;
        }
        throw new SpecException("The layout '" + string + "' is not valid for the method 'treemap'. ", ErrorCode.SPEC_INVALID_VALUE, null);
    }

    @Override
    public boolean respectsTransforms() {
        TransformSpec[] transformSpecArray = this.getAdapter().getTransform();
        if (transformSpecArray == null) {
            return true;
        }
        for (TransformSpec transformSpec : transformSpecArray) {
            if ("transpose".equals(transformSpec.type) || "polar".equals(transformSpec.type)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Shape> makeElementShapes(int n, Dim dim) {
        Object object;
        boolean bl = this.spec.parent != null;
        FieldRefSpec fieldRefSpec = (FieldRefSpec)this.spec.size;
        String string = null;
        if (fieldRefSpec != null) {
            string = fieldRefSpec.$ref;
        }
        if (bl) {
            object = null;
            if (this.spec.parent != null) {
                object = this.spec.parent.$ref;
            }
            String string2 = null;
            if (this.spec.id != null) {
                string2 = this.spec.id.$ref;
            }
            this.tree = this.builder.buildRecursiveTree(n, (String)object, string2, this.adapter, string);
        } else {
            object = this.spec.levels;
            ArrayList<String> arrayList = new ArrayList<String>();
            if (object != null) {
                for (LevelsSpec levelsSpec : object) {
                    arrayList.add(levelsSpec.field.$ref);
                }
                this.tree = this.builder.buildNonRecursiveTree(n, arrayList, this.adapter, string);
            }
        }
        this.algorithm.createBounds(this.tree, this.getPaddedBounds(dim), this);
        object = new ArrayList();
        this.treeLevelCounter = 0;
        this.addShapes(this.tree, (ArrayList<Shape>)object);
        this.setRowIndicesToInteriorShapes((List<Shape>)object);
        return object;
    }

    protected void setRowIndicesToInteriorShapes(List<Shape> list) {
        for (Shape shape : list) {
            TreeNode treeNode = (TreeNode)shape.getTemporaryTreeMapNodeInfo();
            if (treeNode == null || treeNode.getChildCount() == 0) continue;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            this.addRowIndices(treeNode, arrayList);
            int[] nArray = new int[arrayList.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = (Integer)arrayList.get(i);
            }
            shape.setRows(nArray);
        }
    }

    private void addRowIndices(TreeNode treeNode, List<Integer> list) {
        if (treeNode.hasDataRowSpecified()) {
            list.add(treeNode.rowIndex);
        }
        if (treeNode.getChildCount() == 0) {
            return;
        }
        for (TreeNode treeNode2 : treeNode.getChildren()) {
            this.addRowIndices(treeNode2, list);
        }
    }

    private void addShapes(TreeNode treeNode, ArrayList<Shape> arrayList) {
        Object object;
        if (treeNode != null && treeNode.bounds != null && (this.leafOnly && treeNode.getChildCount() == 0 || !this.leafOnly) && (object = this.adapter.makeItemInRect(treeNode.bounds, treeNode.rowIndex)) != null) {
            ((Shape)object).setTemporaryTreeMapNodeInfo(treeNode);
            if (treeNode.getChildCount() > 0) {
                ((Shape)object).setNeedsConsistentLabels(false);
            }
            if (treeNode.getChildCount() > 1 || treeNode.getChildCount() == 1 && this.treeLevelCounter == 0) {
                ++this.treeLevelCounter;
            }
            String object2 = Integer.toString(this.treeLevelCounter);
            ((Shape)object).setKey(object2);
            arrayList.add((Shape)object);
        }
        if (treeNode.getChildCount() > 0) {
            for (TreeNode treeNode2 : treeNode.getChildren()) {
                this.addShapes(treeNode2, arrayList);
            }
        }
    }

    protected StyleSpec getStyleSpec(int n, boolean bl) {
        if (n < 0) {
            return null;
        }
        return this.getStyleForLevel(n, false, bl);
    }

    protected ElementLabelSpec getLabelSpec(int n, boolean bl) {
        if (n < 0) {
            return null;
        }
        ElementLabelSpec elementLabelSpec = new ElementLabelSpec();
        elementLabelSpec.style = this.getStyleForLevel(n, true, bl);
        elementLabelSpec.content = this.spec.levels != null && this.spec.levels.length > n && this.spec.levels[n] != null ? this.spec.levels[n].labelContent : null;
        if (elementLabelSpec.style == null && elementLabelSpec.content == null) {
            return null;
        }
        return elementLabelSpec;
    }

    private boolean isStackLayout() {
        return TreeMapLayouts.stack.name().equals(this.spec.layout) || TreeMapLayouts.stackFillSpace.name().equals(this.spec.layout);
    }

    private StyleSpec getStyleForLevel(int n, boolean bl, boolean bl2) {
        int n2;
        String string = TreeMapLayout.getStyleId(n, bl, bl2);
        StyleSpec styleSpec = this.adapter.getTargetedStyle(string);
        if (styleSpec != null) {
            return styleSpec;
        }
        if (bl2 && !this.isStackLayout()) {
            return null;
        }
        int n3 = n2 = bl2 ? n : n - 1;
        while (styleSpec == null && n2 >= 0) {
            string = TreeMapLayout.getStyleId(n2, bl, false);
            styleSpec = this.adapter.getTargetedStyle(string);
            --n2;
        }
        return styleSpec;
    }

    private static String getStyleId(int n, boolean bl, boolean bl2) {
        String string = "level_";
        if (bl) {
            string = string + "label_";
        }
        if (bl2) {
            return string + "leaf";
        }
        return string + n;
    }

    @Override
    public final boolean applyStyles(Shape shape) {
        TreeNode treeNode = (TreeNode)shape.getTemporaryTreeMapNodeInfo();
        if (treeNode == null) {
            return false;
        }
        StyleSpec styleSpec = this.getStyleSpec(treeNode.getLevel(), treeNode.getChildCount() == 0);
        if (styleSpec != null) {
            StyleBuilder.setFilled(shape, styleSpec);
            StyleSpec styleSpec2 = this.adapter.getStyle();
            if (styleSpec2 != null && styleSpec2.fill != null) {
                StyleBuilder.modifyPaletteFill(shape, styleSpec2);
            }
            return true;
        }
        return false;
    }

    protected static boolean overlapsAncestorLabel(Shape shape, TreeNode treeNode, HashMap<String, Shape> hashMap) {
        for (TreeNode treeNode2 = treeNode.getParent(); treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            Shape shape2 = hashMap.get(treeNode2.id);
            if (shape2 == null) continue;
            Rect rect = shape2.getBounds();
            Rect rect2 = shape.getBounds();
            if (!rect2.intersectsRect(rect)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean applyLabels(Shape shape, ShapeList shapeList, boolean bl) {
        ElementLabelSpec elementLabelSpec;
        TreeNode treeNode = (TreeNode)shape.getTemporaryTreeMapNodeInfo();
        if (treeNode == null) {
            return false;
        }
        if (treeNode.getChildCount() > 0) {
            shape.setNeedsConsistentLabels(false);
        }
        if ((elementLabelSpec = this.getLabelSpec(treeNode.getLevel(), treeNode.getChildCount() == 0)) != null) {
            if (elementLabelSpec.content != null) {
                Text text;
                if (elementLabelSpec.style == null) {
                    elementLabelSpec.style = new StyleSpec();
                }
                if (elementLabelSpec.style.location == null) {
                    elementLabelSpec.style.location = "inside";
                }
                if ((text = (Text)this.adapter.makeLabelShape(elementLabelSpec, shape)) != null) {
                    boolean bl2 = shape.isVisible() && text.isVisible();
                    text.setVisible(bl2);
                    if (!this.hideOverlappingLabels || !TreeMapLayout.overlapsAncestorLabel(text, treeNode, this.nodeLabelMap)) {
                        String string = shape.getID();
                        int n = string.indexOf(83);
                        String string2 = string.substring(0, n);
                        String string3 = string.substring(n + 1);
                        Shape shape2 = this.adapter.makeLabelBackgroundShape(elementLabelSpec, text, shape);
                        if (shape2 != null) {
                            shape2.setVisible(bl2);
                            shape2.setID(string2 + "LB" + string3);
                        }
                        text.setID(string2 + "L" + string3);
                        if (bl) {
                            text.disableTooltip();
                        }
                        shapeList.addPlaqueAndLabelForShape(shape, text, shape2, false, null);
                        this.nodeLabelMap.put(treeNode.id, text);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void setBounds(TreeNode treeNode, Rect rect) {
        if (treeNode.rowIndex > -1) {
            treeNode.bounds = rect.copy();
        }
    }
}

