/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.treemap;

import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeMapLayout;
import com.ibm.vis.engine.internal.grammar.layout.treemap.TreeNode;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.FontHelper;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.ElementLabelSpec;
import com.ibm.vis.spec.internal.FontSpec;
import com.ibm.vis.spec.internal.StyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class TreeMapLayoutAdapter {
    protected TreeMapLayout layout;

    public TreeMapLayoutAdapter(TreeMapLayout treeMapLayout) {
        this.layout = treeMapLayout;
    }

    protected Rect computePaddedBounds(TreeNode treeNode, Rect rect) {
        StyleSpec styleSpec;
        if (this.layout != null && (styleSpec = this.layout.getStyleSpec(treeNode.getLevel(), treeNode.getChildCount() == 0)) != null && styleSpec.padding != null) {
            Dim dim = rect.getExtent();
            Insets insets = Insets.makeForStylePadding(styleSpec.padding, dim, dim);
            FontSpec fontSpec = null;
            Font font = null;
            ElementLabelSpec elementLabelSpec = this.layout.getLabelSpec(treeNode.getLevel(), true);
            if (elementLabelSpec != null) {
                fontSpec = elementLabelSpec.style.font;
                font = FontHelper.makeFromSpec(fontSpec, null, true);
            }
            if (insets != null) {
                Rect rect2 = insets.insetRect(rect);
                if (rect2.hasExtent() && this.respectLabelSize(rect2, font)) {
                    return rect2;
                }
                throw new EngineException("Padding value specified is too high", ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, null);
            }
        }
        return rect;
    }

    public boolean respectLabelSize(Rect rect, Font font) {
        return font == null ? true : rect.getHeight() >= font.getHeight() && rect.getWidth() >= font.getWidthFromString("\u2026");
    }

    protected StyleSpec getStyle(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        return this.layout.getStyleSpec(treeNode.getLevel(), treeNode.getChildCount() == 0);
    }
}

