/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.layout.treemap;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Rect;
import java.util.ArrayList;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class TreeNode {
    private ArrayList<TreeNode> children;
    private HashMap<String, TreeNode> nodeMap;
    protected int rowIndex;
    protected Rect bounds;
    protected String id;
    protected String parentId;
    protected boolean isDummyRoot;
    private double size;
    private TreeNode parentNode;
    private Double subTreeSize = null;
    private boolean needsAggregationFlag;
    protected double area;
    private boolean hasDataRow;

    TreeNode(String string, String string2, double d, int n) {
        this.id = string;
        this.parentId = string2;
        this.size = d;
        this.needsAggregationFlag = true;
        this.rowIndex = n;
    }

    public double getAggregatedSize(boolean bl) {
        if (this.subTreeSize == null || this.needsAggregationFlag) {
            double d = this.size;
            if (this.children != null) {
                if (bl) {
                    d = 0.0;
                }
                for (TreeNode treeNode : this.children) {
                    d += treeNode.getAggregatedSize(bl);
                }
            }
            this.subTreeSize = d;
            this.needsAggregationFlag = false;
        }
        return this.subTreeSize;
    }

    public int getLevel() {
        if (this.parentNode != null) {
            return this.parentNode.getLevel() + 1;
        }
        if (this.isDummyRoot || this.rowIndex < 0) {
            return -1;
        }
        return 0;
    }

    public void addChild(TreeNode treeNode) {
        TreeNode treeNode2;
        if (treeNode == null) {
            return;
        }
        TreeNode treeNode3 = treeNode2 = this.nodeMap == null ? null : this.nodeMap.get(treeNode.id);
        if (treeNode2 != null) {
            treeNode2.setSize(treeNode2.getSize() + treeNode.getSize());
        } else {
            if (this.children == null) {
                this.children = new ArrayList();
                this.nodeMap = new HashMap();
            }
            this.children.add(treeNode);
            this.nodeMap.put(treeNode.id, treeNode);
            treeNode.parentNode = this;
        }
        this.needsAggregation();
    }

    protected void removeChild(int n) {
        TreeNode treeNode;
        if (n < this.getChildCount() && (treeNode = this.children.get(n)) != null) {
            this.children.remove(treeNode);
            this.nodeMap.remove(treeNode.id);
            treeNode.parentNode = null;
            this.needsAggregation();
        }
    }

    public TreeNode getChild(int n) {
        return this.children.get(n);
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public double getSize() {
        return this.size;
    }

    protected void setSize(double d) {
        this.size = d;
    }

    public void needsAggregation() {
        this.needsAggregationFlag = true;
        if (this.parentNode != null) {
            this.parentNode.needsAggregation();
        }
    }

    public TreeNode getParent() {
        return this.parentNode;
    }

    public ArrayList<TreeNode> getChildren() {
        return this.children;
    }

    public void setIndex(int n) {
        this.rowIndex = n;
    }

    public final void dataRowSpecified(boolean bl) {
        this.hasDataRow = bl;
    }

    public final boolean hasDataRowSpecified() {
        return this.hasDataRow;
    }

    public int getHeight() {
        int n = 0;
        if (this.children != null) {
            for (TreeNode treeNode : this.children) {
                n = Math.max(n, treeNode.getHeight());
            }
        }
        if (this.isDummyRoot) {
            return n;
        }
        return n + 1;
    }
}

