/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.Affine;
import com.ibm.vis.engine.internal.ColorUtil;
import com.ibm.vis.engine.internal.Stroke;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.coordinate.CoordinateTransform;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.coordinate.PolarTransform;
import com.ibm.vis.engine.internal.grammar.label.LabelProducer;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.scale.GridBandBuilder;
import com.ibm.vis.engine.internal.grammar.scale.GridLineBuilder;
import com.ibm.vis.engine.internal.grammar.scale.GridShapeBuilder;
import com.ibm.vis.engine.internal.grammar.scale.NestedTickInfo;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.scale.ScaleGeometry;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.Tick;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.MultiPartText;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.ShapeLine;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.geom.Wedge;
import com.ibm.vis.internal.accessibility.AccessibilityValidation;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.internal.GroupSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.provisional.SceneNode;
import com.ibm.vis.scenetree.provisional.SceneNodeType;
import com.ibm.vis.spec.internal.AxisSpec;
import com.ibm.vis.spec.internal.PreferredSizeSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2015\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Axis {
    public static final String AXIS_TITLE_SUFFIX = "Title";
    private static final double MIN_CHARTSPACE_PERMITTED = 40.0;
    private static final double TICK_LABEL_SAFETY_GAP = 0.5;
    public static final double TICK_LABEL_TO_MARK_SIZE_RATIO = 3.0;
    public static final String TICK_METHOD_VERTICAL = "vertical";
    public static final String TICK_METHOD_HORIZONTAL = "horizontal";
    public static final String TICK_METHOD_STAGGER = "stagger";
    public static final String TICK_METHOD_BETWEEN = "between";
    public static final String TICK_METHOD_AUTO = "auto";
    public static final String TICK_AS_NORMAL = "normal";
    public static final String TICK_AS_PERCENTAGE = "percentage";
    public static final double AXIS_PREFERRED_SIZE_EXTRA = 2.0;
    private static final int TICK_FUDGE_PADDING = 3;
    public static final String PERCENTAGE_SYMBOL = "%";
    private static boolean tickLabelHeightReduced = false;
    private final Coordinates coordinates;
    private final VisContext context;
    private final int whichScale;
    private final int drawPosition;
    private final boolean areTickMarksDrawn;
    private final AxisSpec axisSpec;
    private double tickMarkSize;
    private double minorMarkSize;
    private final double spacing;
    private final LabelProducer tickLabeler;
    private final LabelProducer titleLabeler;
    private List<Tick> ticks;
    private List<Tick> minorTicks;
    private List<Integer> potentialSpanOverlaps;
    private double tickHeight;
    private String method;
    private final ScaleGeometry geometry;
    private String tickAlign;
    private String tickVAlign;
    private int[] parents;
    private double offset;
    private int axisDrawCount;
    private NestedTickInfo[][] tickInfo;
    private boolean drawTickLabels;
    private boolean drawOppositeSide = false;
    private ArrayList<ScaleSpan> spans;
    private Dim maxTickLabelSizeCache;
    private boolean isOverlappingTick;
    private boolean outsideTickLabels = false;
    private final String tickAs;
    private boolean alignWithOtherAxis = false;
    private double tickLabelAngle;
    private double titleActualSize;
    private static final Stroke DEFAULT_BOX_STROKE = new Stroke(1.5, null, null, null, ColorUtil.getDefaultStrokeColor());

    public static boolean isEmpty(StyleSpec styleSpec) {
        return styleSpec != null && styleSpec.align == null && styleSpec.font == null && styleSpec.fill == null && styleSpec.outline == null && styleSpec.effect == null && styleSpec.image == null && styleSpec.location == null && styleSpec.stroke == null && styleSpec.padding == null && styleSpec.valign == null && styleSpec.width == null && styleSpec.height == null && styleSpec.size == null && styleSpec.angle == null && styleSpec.snap == null;
    }

    public Axis(int n, Coordinates coordinates, AxisSpec axisSpec, ArrayList<ScaleSpan> arrayList, boolean bl) {
        double d;
        String string;
        this.whichScale = n;
        this.coordinates = coordinates;
        this.context = coordinates.visContext;
        this.drawPosition = coordinates.getDrawnPosition(n);
        this.axisSpec = axisSpec;
        this.offset = 0.0;
        this.axisDrawCount = 1;
        this.tickLabelAngle = Double.NaN;
        this.titleActualSize = Double.NaN;
        this.spans = arrayList;
        this.tickAs = axisSpec.tickAs;
        this.alignWithOtherAxis = axisSpec.alignWithOtherAxis != null ? axisSpec.alignWithOtherAxis : false;
        this.outsideTickLabels = axisSpec.outsideTickLabels == null ? false : axisSpec.outsideTickLabels;
        this.method = axisSpec.method;
        if (this.coordinates.containsPolar() && (TICK_METHOD_STAGGER.equals(this.method) || TICK_METHOD_BETWEEN.equals(this.method))) {
            throw new EngineException("Unsupported axis method for polar transform:" + this.method, ErrorCode.ENGINE_UNSUPPORTED_OPERATION, null);
        }
        if (TICK_METHOD_BETWEEN.equals(this.method) && axisSpec.minorStyle != null) {
            throw new SpecException("Minor Ticks are not support with 'between' Axis method.", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        if (this.coordinates.containsCluster() && this.axisSpec.gridBand != null) {
            throw new SpecException("GridBands are not supported for Cluster charts.", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        boolean bl2 = this.areTickMarksDrawn = Axis.isStyleDefined(axisSpec.markStyle, true) || Axis.isStyleDefined(axisSpec.boxStyle, false);
        StyleSpec styleSpec = axisSpec.tickStyle == null ? new StyleSpec() : (!Axis.isEmpty(axisSpec.tickStyle) ? axisSpec.tickStyle : null);
        this.setDrawTickLabels();
        if (axisSpec.title == null) {
            this.titleLabeler = null;
        } else {
            if (axisSpec.titleStyle != null) {
                axisSpec.titleStyle.angle = null;
            }
            this.titleLabeler = LabelProducer.makeSimpleInside(coordinates.vis, axisSpec.titleStyle, null, null, null);
        }
        if (axisSpec.opposite != null) {
            boolean bl3 = axisSpec.opposite;
            this.drawOppositeSide = bl ? !bl3 : bl3;
        } else {
            this.drawOppositeSide = bl;
        }
        this.tickAlign = styleSpec == null ? null : styleSpec.align;
        this.tickVAlign = styleSpec == null ? null : styleSpec.valign;
        String string2 = this.tickAlign;
        if (string2 == null) {
            string2 = "middle";
            if (axisSpec.boxStyle == null && this.isYAxis()) {
                String string3 = string2 = this.drawOppositeSide ? "start" : "end";
            }
        }
        if ((string = this.tickVAlign) == null) {
            string = "middle";
            if (axisSpec.boxStyle == null && this.isXAxis()) {
                string = this.drawOppositeSide ? "end" : "start";
            }
        }
        this.tickLabeler = LabelProducer.makeSimpleInside(coordinates.vis, styleSpec, string2, string, null);
        if (this.drawTickLabels && styleSpec != null && BasicFactory.isNumber(styleSpec.angle)) {
            d = ((Number)styleSpec.angle).doubleValue();
            this.tickLabelAngle = (d %= 360.0) * Math.PI / 180.0;
        }
        d = this.tickLabeler.font.getHeight();
        this.tickMarkSize = this.getTickMarkSize(this.axisSpec, d, 0.0);
        this.minorMarkSize = Axis.getMinorTickMarkSize(this.axisSpec, d, this.tickMarkSize, 0.0);
        this.spacing = styleSpec == null || styleSpec.padding == null ? d / 6.0 : 0.0;
        this.geometry = ScaleGeometry.makeUnsized(this.isYAxis());
        this.tickHeight = 0.0;
        this.maxTickLabelSizeCache = new Dim(0.0, 0.0);
        this.defineParents();
    }

    public final ScaleGeometry getGeometry() {
        return this.geometry;
    }

    public final String getTickAs() {
        return this.tickAs;
    }

    public final boolean isAlignWithOtherAxis() {
        return this.alignWithOtherAxis;
    }

    public final void setAlignWithOtherAxis(boolean bl) {
        this.alignWithOtherAxis = bl;
    }

    public final List<Tick> getMinorTicks() {
        return this.minorTicks;
    }

    public void setOutsideTickLabels(boolean bl) {
        this.outsideTickLabels = bl;
    }

    public final double getTickHeight() {
        return this.tickHeight;
    }

    public final double getSpacing() {
        return this.spacing;
    }

    public final int getDrawPosition() {
        return this.drawPosition;
    }

    public final int getAxisDrawCount() {
        return this.axisDrawCount;
    }

    public final Dim getFirstTickLabelSize() {
        if (this.ticks != null && this.ticks.size() != 0) {
            return this.tickLabeler.calculateLabelSize(this.ticks.get(0).getContentClone());
        }
        return new Dim(0.0, 0.0);
    }

    public final String getMethod() {
        return this.method;
    }

    public final void setMethod(String string) {
        this.method = string;
    }

    public final boolean isRadialYAxis() {
        return this.coordinates.containsPolar() && this.isYAxis() && this.coordinates.scales.length == 2;
    }

    public final Scale getScale() {
        return this.coordinates.scales[this.whichScale];
    }

    public final int getScaleIndex() {
        return this.whichScale;
    }

    public final boolean isVisible() {
        return this.getAxisSpec().visible == null || this.getAxisSpec().visible != false;
    }

    public final AxisSpec getAxisSpec() {
        return this.axisSpec;
    }

    public final boolean isDrawTicks() {
        return this.drawTickLabels;
    }

    public final void setSpans(ArrayList<ScaleSpan> arrayList) {
        this.spans = arrayList;
    }

    public final ArrayList<ScaleSpan> getSpans() {
        return this.spans;
    }

    public final boolean isDrawOppositeSide() {
        return this.drawOppositeSide;
    }

    public final List<Tick> getTicks() {
        return this.ticks;
    }

    public final LabelProducer getTickLabeler() {
        return this.tickLabeler;
    }

    private boolean isRotatedXaxisLabel() {
        boolean bl = false;
        if (this.isRotatedXAxisLabelSupported() && !Double.isNaN(this.tickLabelAngle) && !this.isHorizontalAngle()) {
            bl = true;
        }
        return bl;
    }

    private boolean isRotatedXAxisLabelSupported() {
        return this.isXAxis() && this.whichScale == 1 && !this.coordinates.containsCluster() && !this.coordinates.transposesAxes() && this.getAxisSpec().boxStyle == null;
    }

    private boolean isHorizontalAngle() {
        boolean bl = false;
        if (!Double.isNaN(this.tickLabelAngle) && Math.abs(this.tickLabelAngle % Math.PI) == 0.0) {
            bl = true;
        }
        return bl;
    }

    private boolean isVerticalAngle() {
        boolean bl = false;
        if (!Double.isNaN(this.tickLabelAngle) && Math.abs(this.tickLabelAngle) == 1.5707963267948966) {
            bl = true;
        }
        return bl;
    }

    private boolean isLeftRotation() {
        boolean bl;
        boolean bl2 = bl = this.tickLabelAngle < 0.0 && this.tickLabelAngle > -1.5707963267948966 || this.tickLabelAngle < -Math.PI && this.tickLabelAngle > -4.71238898038469 || this.tickLabelAngle > 1.5707963267948966 && this.tickLabelAngle < Math.PI || this.tickLabelAngle > 4.71238898038469 && this.tickLabelAngle < Math.PI * 2;
        if (this.drawOppositeSide) {
            bl = !bl;
        }
        return bl;
    }

    private void setDrawTickLabels() {
        if (this.axisSpec.tickStyle == null) {
            this.drawTickLabels = true;
        } else if (!Axis.isEmpty(this.axisSpec.tickStyle)) {
            double d;
            StyleSpec styleSpec = this.axisSpec.tickStyle;
            this.drawTickLabels = styleSpec.font != null && styleSpec.font.size != null ? !((d = UnitConverter.convertLength(styleSpec.font.size, 10.0, 10.0).doubleValue()) <= 0.0) : true;
        } else {
            this.drawTickLabels = false;
        }
    }

    protected static double getMinorTickMarkSize(AxisSpec axisSpec, double d, double d2, double d3) {
        if (d2 == 0.0) {
            return d / 6.0;
        }
        if (axisSpec.minorStyle == null || axisSpec.minorStyle.size == null) {
            return d2 / 2.0;
        }
        return UnitConverter.convertLength(axisSpec.minorStyle.size, d2 / 2.0, d3);
    }

    double getTickMarkSize(AxisSpec axisSpec, double d, double d2) {
        if (!this.areTickMarksDrawn || axisSpec.boxStyle != null) {
            return 0.0;
        }
        if (axisSpec.markStyle == null || axisSpec.markStyle.size == null) {
            return d / 3.0;
        }
        return UnitConverter.convertLength(axisSpec.markStyle.size, d / 3.0, d2);
    }

    public final double getInitializedTickMarkSize() {
        return this.tickMarkSize;
    }

    protected Shape modifyShape(Shape shape, Dim dim, int n, int n2) {
        if (shape == null || this.whichScale == 0) {
            return shape;
        }
        NestedTickInfo nestedTickInfo = this.tickInfo[n2][n];
        shape.setPosition(nestedTickInfo.pos);
        Shape shape2 = this.coordinates.modifyAxisTickOrLabel(shape, dim, this.whichScale, this.ticks.size());
        return this.copyShape(shape2);
    }

    protected Shape copyShape(Shape shape) {
        if (shape == null) {
            return shape;
        }
        Shape shape2 = shape.makeGeometryClone();
        shape2.copyInfoFrom(shape);
        return shape2;
    }

    public void defineLocationVisTransform(SceneNode sceneNode, Point point, Dim dim) {
        if (this.coordinates.insideAxes) {
            sceneNode.intTranslate(point.getX(), point.getY());
        } else if (this.isXAxis()) {
            sceneNode.intTranslate(point.getX(), point.getY() + dim.getHeight());
        } else {
            sceneNode.intTranslate(point.getX(), point.getY());
        }
    }

    /*
     * WARNING - void declaration
     */
    public CompositeSceneNode getForegroundShapes(Dim dim, String string) {
        Object object2;
        Object object3;
        int n;
        Object object4;
        Object object5;
        String string2 = this.drawOppositeSide ? "O" : "";
        String string3 = string + "A" + this.whichScale + string2;
        GroupSceneNode groupSceneNode = SceneNodeFactory.createGroupNode(SceneNodeType.AXIS);
        boolean bl = this.axisDrawCount > 1;
        boolean bl2 = bl && this.areTickMarksDrawn && this.drawTickLabels;
        boolean bl3 = this.axisSpec.boxStyle != null;
        double d = 0.0;
        Point point = null;
        if (Axis.isStyleDefined(this.axisSpec.lineStyle, true) && this.offset == 0.0) {
            object5 = this.makeAxisLine(dim);
            if (((Shape)object5).getGeom() instanceof Wedge) {
                object4 = (Wedge)((Shape)object5).getGeom();
                d = ((Wedge)object4).getR2();
                point = ((Wedge)object4).getOrigin();
            }
            ((Shape)object5).setID(string3 + "L");
            groupSceneNode.addChild(((Shape)object5).createSceneNode());
        }
        if (this.axisSpec.title != null && (object5 = this.makeAxisTitle(dim)) != null) {
            ((Shape)object5).setID(string3 + AXIS_TITLE_SUFFIX);
            if (this.context.getGenerateAccessibility() && this.axisSpec.titleStyle != null) {
                AccessibilityValidation.addAccessibility(groupSceneNode, this.axisSpec.titleStyle.accessibility, false);
            }
            groupSceneNode.addChild(((Text)object5).createSceneNode());
        }
        object5 = null;
        if (this.areTickMarksDrawn && !bl2) {
            object4 = null;
            object5 = SceneNodeFactory.createGroupNode(SceneNodeType.AXIS_MARK);
            for (n = 0; n < this.axisDrawCount; ++n) {
                for (int i = 0; i < this.ticks.size(); ++i) {
                    Shape shape = this.makeTickShape(i, dim, this.tickMarkSize, n, false);
                    Shape shape2 = this.modifyShape(shape, dim, i, n);
                    if (shape2 != null && bl && object4 != null) {
                        object3 = shape2.getBounds();
                        if (this.boundsTooClose((Rect)object3, (Rect)object4)) {
                            shape2 = null;
                        } else {
                            object4 = object3;
                        }
                    } else if (shape2 != null && bl && object4 == null) {
                        object4 = shape2.getBounds();
                        this.addMarkToGroup(string3, (GroupSceneNode)object5, n, i, shape2);
                    }
                    this.addMarkToGroup(string3, (GroupSceneNode)object5, n, i, shape2);
                }
            }
        }
        n = (object4 = this.getAxisAlignedTo()) == null && this.axisSpec.minorStyle != null && !Axis.isEmpty(this.axisSpec.minorStyle) || object4 != null && ((Axis)object4).getAxisSpec().minorStyle != null && !Axis.isEmpty(this.axisSpec.minorStyle) ? 1 : 0;
        GroupSceneNode groupSceneNode2 = null;
        if (n != 0) {
            groupSceneNode2 = SceneNodeFactory.createGroupNode(SceneNodeType.AXIS_MINOR);
            this.minorTicks = object4 != null ? this.getScale().makeMinorTicksForSpans(((Axis)object4).getSpans()) : this.getScale().makeMinorTicksForSpans(this.spans);
            if (this.minorTicks != null) {
                for (int i = 0; i < this.axisDrawCount; ++i) {
                    for (int j = 0; j < this.minorTicks.size(); ++j) {
                        object3 = this.minorTicks.get(j);
                        object2 = this.makeTickShape(j, dim, this.minorMarkSize, i, true);
                        Shape shape = this.modifyShape((Shape)object2, dim, 0, i);
                        if (shape == null) continue;
                        String object8 = this.axisDrawCount > 1 ? i + "_" + j : "" + j;
                        shape.setID(string3 + "N" + object8);
                        this.addAxisValue(shape, ((Tick)object3).value);
                        groupSceneNode2.addChild(shape.createSceneNode());
                    }
                }
            }
        }
        CompositeSceneNode compositeSceneNode = null;
        if (this.drawTickLabels) {
            Rect rect;
            Rect rect2;
            int n2;
            Object object;
            Object object6;
            Shape shape;
            ArrayList arrayList = new ArrayList();
            if (bl2) {
                object5 = SceneNodeFactory.createGroupNode(SceneNodeType.AXIS_MARK);
            }
            object3 = null;
            object2 = null;
            for (int i = 0; i < this.axisDrawCount; ++i) {
                ArrayList<Shape> rect22 = new ArrayList<Shape>();
                arrayList.add(rect22);
                for (int j = 0; j < this.ticks.size(); ++j) {
                    double d2 = 1.0;
                    if (this.getScale().isCategorical()) {
                        d2 = this.ticks.get(j).getAdjacentTickSpace(j, this.ticks);
                    }
                    shape = this.makeTickLabel(j, dim, d2, i, d, point);
                    object6 = null;
                    if (bl2) {
                        object6 = this.makeTickShape(j, dim, this.tickMarkSize, i, false);
                        object6 = this.modifyShape((Shape)object6, dim, j, i);
                    }
                    if (shape != null && bl && object3 != null && this.boundsTooClose((Rect)(object = shape.getBounds()), (Rect)object3)) {
                        shape = null;
                        if (bl3) {
                            object6 = null;
                        }
                    }
                    if (shape != null) {
                        object = this.axisDrawCount > 1 ? i + "_" + j : "" + j;
                        shape.setID(string3 + "T" + (String)object);
                        if (bl) {
                            object3 = shape.getBounds();
                        }
                    }
                    rect22.add(shape);
                    if (object6 != null && !bl3) {
                        if (object2 == null) {
                            object2 = ((Shape)object6).getBounds();
                        } else {
                            object = ((Shape)object6).getBounds();
                            if (this.boundsTooClose((Rect)object, (Rect)object2)) {
                                object6 = null;
                            } else {
                                object2 = ((Shape)object6).getBounds();
                            }
                        }
                    }
                    if (object6 == null) continue;
                    this.addMarkToGroup(string3, (GroupSceneNode)object5, i, j, (Shape)object6);
                }
            }
            if (this.potentialSpanOverlaps != null) {
                for (Integer n3 : this.potentialSpanOverlaps) {
                    assert (this.ticks.size() > n3 && n3 > 0);
                    for (List list : arrayList) {
                        if (n3 > list.size() - 1 || n3 <= 0) continue;
                        Shape shape2 = (Shape)list.get(n3);
                        shape = (Shape)list.get(n3 - 1);
                        if (shape2 == null || shape == null || !this.boundsTooClose((Rect)(object6 = shape2.getBounds()), (Rect)(object = shape.getBounds()))) continue;
                        list.set(n3, null);
                    }
                }
            }
            compositeSceneNode = SceneNodeFactory.createGroupNode(SceneNodeType.AXIS_LABEL);
            for (n2 = 0; n2 < this.axisDrawCount; ++n2) {
                void var21_35;
                boolean bl4 = false;
                while (var21_35 < this.ticks.size()) {
                    Shape shape3 = (Shape)((List)arrayList.get(n2)).get((int)var21_35);
                    if (shape3 != null) {
                        this.addInfo(shape3, (int)var21_35, n2);
                        this.addAxisValue(shape3, this.ticks.get((int)var21_35).value);
                        compositeSceneNode.addChild(shape3.createSceneNode());
                    }
                    ++var21_35;
                }
            }
            if (this.context.getGenerateAccessibility() && this.axisSpec.tickStyle != null) {
                AccessibilityValidation.addAccessibility(compositeSceneNode, this.axisSpec.tickStyle.accessibility, true);
            }
            if (this.axisDrawCount == 1 && this.coordinates.containsPolar() && (n2 = compositeSceneNode.getChildrenCount()) >= 2 && this.boundsTooClose(rect2 = compositeSceneNode.getChild(0).getShape().getNodeBounds(), rect = compositeSceneNode.getChild(n2 - 1).getShape().getNodeBounds())) {
                compositeSceneNode.removeChildAt(n2 - 1);
            }
        }
        if (object5 != null && ((CompositeSceneNode)object5).getChildrenCount() > 0) {
            groupSceneNode.addChild((SceneNode)object5);
        }
        if (groupSceneNode2 != null && groupSceneNode2.getChildrenCount() > 0) {
            groupSceneNode.addChild(groupSceneNode2);
        }
        if (compositeSceneNode != null && compositeSceneNode.getChildrenCount() > 0) {
            groupSceneNode.addChild(compositeSceneNode);
        }
        return groupSceneNode;
    }

    private void addMarkToGroup(String string, GroupSceneNode groupSceneNode, int n, int n2, Shape shape) {
        if (shape != null) {
            String string2 = this.axisDrawCount > 1 ? n + "_" + n2 : "" + n2;
            shape.setID(string + "M" + string2);
            this.addInfo(shape, n2, n);
            groupSceneNode.addChild(shape.createSceneNode());
        }
    }

    private boolean boundsTooClose(Rect rect, Rect rect2) {
        double d = rect.getX() - 1.0;
        double d2 = d + rect.getWidth() + 2.0;
        double d3 = rect2.getX();
        double d4 = d3 + rect2.getWidth();
        if (d > d4 || d3 > d2) {
            return false;
        }
        double d5 = rect.getY() - 1.0;
        double d6 = d5 + rect.getHeight() + 2.0;
        double d7 = rect2.getY();
        double d8 = d7 + rect2.getHeight();
        return !(d5 > d8) && !(d7 > d6);
    }

    private void initializeTickInfo() {
        if (this.parents != null && !this.context.isUpdateViewport()) {
            for (int n : this.parents) {
                Scale scale = this.coordinates.scales[n];
                if (scale == null || scale.getTicks() == null) continue;
                this.axisDrawCount *= scale.getTicks().size();
            }
        }
        this.buildTickInfo();
    }

    private void buildTickInfo() {
        int n;
        int n2 = this.ticks.size();
        this.tickInfo = new NestedTickInfo[this.axisDrawCount][];
        for (n = 0; n < this.axisDrawCount; ++n) {
            this.tickInfo[n] = new NestedTickInfo[n2];
        }
        if (this.parents == null) {
            for (n = 0; n < this.ticks.size(); ++n) {
                Tick tick = this.ticks.get(n);
                double[] dArray = new double[]{tick.value};
                double[] dArray2 = new double[]{0.0, tick.location};
                double[] dArray3 = new double[]{0.0, tick.value};
                this.tickInfo[0][n] = new NestedTickInfo(dArray, dArray2, dArray3);
            }
        } else {
            for (n = 0; n < this.axisDrawCount; ++n) {
                for (int i = 0; i < this.ticks.size(); ++i) {
                    double[] dArray = new double[this.parents.length + 1];
                    double[] dArray4 = new double[this.parents.length + 2];
                    double[] dArray5 = new double[this.parents.length + 2];
                    int n3 = n;
                    for (int j = 0; j < this.parents.length; ++j) {
                        List<Tick> list = this.coordinates.scales[this.parents[j]].getTicks();
                        if (list == null || list.size() <= 0) continue;
                        int n4 = n3 % list.size();
                        Tick tick = list.get(n4);
                        dArray[this.parents.length - j - 1] = tick.value;
                        dArray4[this.parents.length - j] = tick.location;
                        dArray5[this.parents.length - j] = tick.value;
                        n3 = (int)Math.floor(n3 / list.size());
                    }
                    Tick tick = this.ticks.get(i);
                    dArray[this.parents.length] = tick.value;
                    dArray4[this.parents.length + 1] = tick.location;
                    dArray5[this.parents.length + 1] = tick.value;
                    this.tickInfo[n][i] = new NestedTickInfo(dArray, dArray4, dArray5);
                }
            }
        }
    }

    public void setisOverlappingTick(boolean bl) {
        this.isOverlappingTick = bl;
    }

    protected void addInfo(Shape shape, int n, int n2) {
        NestedTickInfo nestedTickInfo = this.tickInfo[n2][n];
        shape.setValue(nestedTickInfo.getCoords());
        String[] stringArray = this.coordinates.coordinateFieldIDs[this.whichScale];
        String string = null;
        if (stringArray != null && stringArray.length > 0 && stringArray.length == 1) {
            string = this.coordinates.coordinateFieldIDs[this.whichScale][0];
        }
        if (string != null) {
            shape.setField(string);
        } else if (this.spans != null && this.spans.get(0) != null && this.spans.get((int)0).dataField != null) {
            shape.setField(this.spans.get((int)0).dataField.id);
        }
        if (shape instanceof MultiPartText) {
            for (Shape shape2 : ((MultiPartText)shape).getParts()) {
                this.addInfo(shape2, n, n2);
            }
        }
    }

    protected void addAxisValue(Shape shape, double d) {
        if (shape.getValue() != null) {
            return;
        }
        shape.setValue(MathUtil.s4(d));
    }

    public CompositeSceneNode getBackgroundShapes(Dim dim, String string) {
        GridShapeBuilder gridShapeBuilder;
        String string2 = this.drawOppositeSide ? "O" : "";
        String string3 = string + "A" + this.whichScale + string2;
        GroupSceneNode groupSceneNode = SceneNodeFactory.createGroupNode(SceneNodeType.AXIS_BACK);
        if (this.axisSpec.gridStyle != null) {
            gridShapeBuilder = new GridLineBuilder(this.coordinates, dim, this);
            ((GridLineBuilder)gridShapeBuilder).makeGridShapes(string3, groupSceneNode);
        }
        if (this.axisSpec.gridBand != null) {
            gridShapeBuilder = new GridBandBuilder(this.coordinates, dim, this);
            ((GridBandBuilder)gridShapeBuilder).makeGridShapes(string3, groupSceneNode);
        }
        return groupSceneNode;
    }

    protected Shape makeStraightPolarGridLine(double[] dArray, double d, Dim dim, StyleSpec styleSpec) {
        Object object;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        PolarTransform polarTransform = this.coordinates.getPolarTransform();
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = d;
            object = polarTransform.transformPointShape(new Point(dArray[i], dArray2[i]), dim);
            arrayList.add((Point)object);
        }
        Point point = polarTransform.transformPointShape(new Point(dArray[0], dArray2[0]), dim);
        arrayList.add(point);
        object = new double[arrayList.size()];
        double[] dArray3 = new double[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[i] = ((Point)arrayList.get(i)).getX();
            dArray3[i] = ((Point)arrayList.get(i)).getY();
        }
        return ItemBuilder.makeLineForPoints((double[])object, dArray3, styleSpec);
    }

    public void modifyInnerCellSize(Rect rect, boolean bl) {
        if (this.coordinates.insideAxes || bl) {
            return;
        }
        if (this.isYAxis()) {
            if (!this.drawOppositeSide) {
                rect.setX(rect.getX() + this.tickHeight);
            }
            rect.setWidth(rect.getWidth() - this.tickHeight);
        } else {
            if (this.drawOppositeSide) {
                rect.setY(rect.getY() + this.tickHeight);
            }
            rect.setHeight(rect.getHeight() - this.tickHeight);
        }
    }

    public void initializeForBounds(Rect rect) {
        this.coordinates.initializeGeometryForBounds(this.geometry, rect.getBounds().getExtent());
        if (this.isXAxis() && (TICK_METHOD_AUTO.equals(this.method) || TICK_METHOD_BETWEEN.equals(this.method))) {
            Dim dim = rect.getExtent();
            if (this.context.isGenerateAllTicks()) {
                dim.setWidth(dim.getWidth() * this.geometry.getOutRange().getRange());
            }
            this.resolveAutoTickMethod(dim);
            this.giveSizeInfoToScale();
        }
        this.getScale().initializeForDisplayableExtent(this.geometry);
        this.recalculateTickSeparation();
    }

    public void adjustLayout(Rect rect, Rect rect2) {
        this.initializeTicks();
        if (this.isYAxis()) {
            this.defineAxisLayout(rect, rect2.getWidth());
        } else {
            this.defineAxisLayout(rect, rect2.getHeight());
        }
    }

    private void recalculateTickSeparation() {
        Dim dim;
        if (!this.getScale().isCategorical() && this.isXAxis() && TICK_METHOD_HORIZONTAL.equals(this.method) && (dim = this.getScale().getTicksBasedMaxSize(this.tickLabeler.font, this.getScale().getTicks(), this.context)).getWidth() > this.geometry.minimalTickSeparation) {
            this.geometry.minimalTickSeparation = dim.getWidth();
            this.getScale().initializeForDisplayableExtent(this.geometry);
        }
    }

    private static boolean isStyleDefined(StyleSpec styleSpec, boolean bl) {
        if (styleSpec == null) {
            return bl;
        }
        return !Axis.isEmpty(styleSpec);
    }

    public Insets computeExtraSpacingNeededForBounds(Rect rect) {
        Insets insets = Insets.NONE;
        if (this.ticks == null) {
            return insets;
        }
        int n = this.ticks.size();
        if (n == 0) {
            return insets;
        }
        if (this.drawTickLabels) {
            insets = this.computeExtraSpacingNeededForBoundsAtTick(0, insets, rect);
            if (n > 1) {
                insets = this.computeExtraSpacingNeededForBoundsAtTick(n - 1, insets, rect);
            }
        }
        return new Insets(Math.ceil(insets.top), Math.ceil(insets.left), Math.ceil(insets.bottom), Math.ceil(insets.right));
    }

    private Insets computeExtraSpacingNeededForBoundsAtTick(int n, Insets insets, Rect rect) {
        boolean bl;
        Tick tick = this.ticks.get(n);
        if (tick.location > 1.0 || tick.location < 0.0) {
            return insets;
        }
        Insets insets2 = insets;
        double d = tick.getAdjacentTickSpace(n, this.ticks);
        boolean bl2 = bl = n > 0 || this.ticks.size() == 1;
        if (this.isYAxis()) {
            double d2;
            double d3;
            double d4 = rect.getHeight();
            double d5 = (1.0 - tick.location) * d4;
            double d6 = this.tickLabeler.font.getHeight();
            Dim dim = new Dim(this.tickHeight - this.tickMarkSize - this.spacing - this.getTitleSize(), d4 * d);
            Text text = ItemBuilder.makeText(tick.getContentClone(), 0.0, 0.0, this.tickAlign, this.tickVAlign, this.tickLabeler.font, null, null, dim, false, null, null, this.context.getTooltipsForTruncatedText());
            if (text != null) {
                d6 = Math.max(text.getHeight(), this.tickLabeler.font.getHeight());
            }
            if (bl) {
                d3 = d5 - d6 / 2.0;
                if (d3 < 0.0) {
                    insets2 = new Insets(-d3 + 1.0, insets.left, insets.bottom, insets.right);
                }
            } else {
                Axis axis;
                d3 = d5 + d6 / 2.0;
                double d7 = 0.0;
                if (d3 > d4) {
                    d7 = d3 - d4;
                }
                if ((axis = this.coordinates.getAxisForDimension(1)) != null) {
                    d7 = d7 > axis.tickHeight ? (d7 -= axis.tickHeight) : 0.0;
                }
                insets2 = new Insets(insets.top, insets.left, d7, insets.right);
            }
            d3 = this.tickMarkSize + this.spacing + this.getTitleSize();
            String string = tick.getContent() == null || tick.getContent().getText() == null ? "" : tick.getContent().getText();
            Text text2 = Text.createTextWithUnshapedValue(string, 0.0, 0.0, this.tickLabeler.align, this.tickLabeler.valign, this.tickLabeler.font, this.tickLabeler.style, null, null, this.tickLabeler.shapingInfo, null, this.context.getTooltipsForTruncatedText());
            text2 = text2.fitInside(new Dim(rect.getX() - d3, rect.getHeight()));
            if (text2 != null && (d2 = text2.getWidth() + d3 - rect.getX()) > 0.0) {
                insets2 = new Insets(insets.top, d2, insets.bottom, insets.right);
            }
        } else {
            Object object;
            CoordinateTransform[] coordinateTransformArray;
            double d8;
            double d9 = rect.getWidth() - insets.left - insets.right;
            double d10 = tick.location * d9;
            double d11 = d * d9;
            String string = this.tickLabeler.align;
            double d12 = d8 = bl ? d10 + d11 / 2.0 : d10 - d11 / 2.0;
            if (this.axisSpec.boxStyle != null) {
                coordinateTransformArray = this.axisSpec.boxStyle;
                object = Insets.makeForStyleStroke(coordinateTransformArray.stroke, coordinateTransformArray.outline, rect.getExtent(), rect.getExtent(), null);
                d8 = bl ? (d8 += ((Insets)object).right) : (d8 -= ((Insets)object).left);
            } else if (!this.isRotatedXaxisLabel()) {
                double d13;
                if (TICK_METHOD_VERTICAL.equals(this.method)) {
                    d13 = this.tickHeight - this.tickMarkSize - this.spacing - this.getTitleSize() - this.tickLabeler.getPadding().getHorizontal();
                    Text text = this.tickLabeler.makeSimpleLabel(tick.getContentClone(), ShapeFactory2.CreateRect(0.0, 0.0, d13, d11));
                    d11 = text != null && ItemBuilder.isMultiLineText(this.tickLabeler.font, text, new Dim(d13, d11)) ? text.getHeight() + 3.0 : this.tickLabeler.font.getHeight() + 3.0;
                    string = this.tickLabeler.valign;
                } else {
                    if (TICK_METHOD_STAGGER.equals(this.method)) {
                        d11 *= 2.0;
                    }
                    if ((d13 = this.tickLabeler.calculateLabelSize(tick.getContent()).getWidth() + this.tickLabeler.getPadding().getHorizontal()) < d11 * 0.75) {
                        d11 = d13 + 3.0;
                    }
                }
                double d14 = d8 = bl ? d10 + d11 : d10 - d11;
                if ("middle".equals(string)) {
                    d8 = bl ? d10 + d11 / 2.0 : d10 - d11 / 2.0;
                }
            } else {
                double d15 = this.tickLabeler.font.getHeight();
                double d16 = d11;
                Dim dim = new Dim(this.tickHeight - this.tickMarkSize - this.spacing - this.getTitleSize(), d9 * d);
                Text text = ItemBuilder.makeText(tick.getContentClone(), 0.0, 0.0, this.tickAlign, this.tickVAlign, this.tickLabeler.font, null, null, dim, false, null, null, this.context.getTooltipsForTruncatedText());
                double d17 = Math.abs(MathUtil.r(Math.cos(this.tickLabelAngle)));
                double d18 = Math.abs(MathUtil.r(Math.sin(this.tickLabelAngle)));
                if (text != null) {
                    d15 = Math.max(text.getHeight(), this.tickLabeler.font.getHeight());
                    if (!this.isVerticalAngle()) {
                        double d19 = dim.getHeight() * d17 / d18;
                        d16 = Math.min(d19, text.calculateTextWidth() * d17);
                    }
                }
                if (this.isLeftRotation()) {
                    if ("start".equals(string)) {
                        d8 = bl ? d9 - d11 : -d16;
                    } else if ("middle".equals(string)) {
                        d8 = bl ? d9 - d11 / 2.0 : -d16 + d11 / 2.0;
                    } else if ("end".equals(string)) {
                        d8 = bl ? d9 : -d16 + d11;
                    }
                } else if ("start".equals(string)) {
                    d8 = bl ? d16 - d11 + d9 : 0.0;
                } else if ("middle".equals(string)) {
                    d8 = bl ? d16 - d11 / 2.0 + d9 : d11 / 2.0;
                } else if ("end".equals(string)) {
                    d8 = bl ? d16 + d9 : d11;
                }
                d8 += bl ? d15 * d17 : -d15 * d17;
                if (n == 0 && tick.location == 0.0 || n == this.ticks.size() - 1 && tick.location == 1.0) {
                    double d20 = d8 = bl ? d8 + d11 / 2.0 : d8 - d11 / 2.0;
                }
            }
            if (bl && d8 > d9) {
                insets2 = new Insets(insets.top, insets.left, insets.bottom, d8 - d9);
            }
            if (bl && this.getScale().reverse && (coordinateTransformArray = this.coordinates.getTransforms()) != null && coordinateTransformArray.length > 0 && coordinateTransformArray[0].isTranspose() && this.coordinates.axes.length == 1 && this.isXAxis()) {
                object = new Dim(this.tickHeight - this.tickMarkSize - this.spacing - this.getTitleSize(), d9 * d);
                Text text = ItemBuilder.makeText(tick.getContentClone(), 0.0, 0.0, this.tickAlign, this.tickVAlign, this.tickLabeler.font, null, null, (Dim)object, false, null, null, this.context.getTooltipsForTruncatedText());
                double d21 = 0.0;
                if (text != null) {
                    d21 = TICK_METHOD_VERTICAL.equals(this.method) ? text.getBounds().getHeight() / 2.0 : text.getBounds().getWidth() / 2.0;
                }
                if (d21 > tick.location) {
                    insets2 = new Insets(insets.top, d21 - tick.location, insets.bottom, insets.right);
                }
            }
            if (n == 0 && d8 < 0.0) {
                double d22 = -d8;
                int n2 = this.context.getParentVis().getCurrentSpec().grammar.length;
                Axis axis = null;
                if (this.coordinates.axes.length > 1 || n2 > 1) {
                    axis = this.coordinates.getAxisForDimension(0);
                }
                if (axis != null) {
                    d22 = -d8 > axis.tickHeight ? Math.abs(-d8 - axis.tickHeight) : insets.left;
                }
                insets2 = new Insets(insets.top, d22, insets.bottom, insets.right);
            }
        }
        return insets2;
    }

    private Shape makeAxisLine(Dim dim) {
        ShapeLine shapeLine;
        boolean bl;
        double[] dArray = null;
        boolean bl2 = bl = this.coordinates.isStraightPolarGridLine() && this.isXAxis();
        if (bl) {
            dArray = Tick.getTicksLocation(this.coordinates.axes[1].getTicks(), dim, false);
            return this.makeStraightPolarGridLine(dArray, 0.0, dim, this.axisSpec.lineStyle);
        }
        if (this.drawPosition == 0) {
            double d = this.drawOppositeSide ? dim.getWidth() : 0.0;
            double d2 = 0.0;
            double d3 = dim.getHeight();
            if (this.context.isGenerateAllTicks()) {
                d3 *= this.geometry.getOutRange().getRange();
                d2 = dim.getHeight() * this.geometry.getOutRange().getMin();
            }
            shapeLine = ItemBuilder.makeLine(d, d2, d, d3, this.axisSpec.lineStyle);
        } else {
            double d = 0.0;
            double d4 = this.drawOppositeSide ? -dim.getHeight() : 0.0;
            double d5 = dim.getWidth();
            if (this.context.isGenerateAllTicks()) {
                d5 *= this.geometry.getOutRange().getRange();
                d = dim.getWidth() * this.geometry.getOutRange().getMin();
            }
            shapeLine = ItemBuilder.makeLine(d, d4, d5, d4, this.axisSpec.lineStyle);
        }
        if (this.coordinates.insideAxes) {
            return this.coordinates.modifyShape(shapeLine, dim);
        }
        return shapeLine;
    }

    private Shape makeTickLabel(int n, Dim dim, double d, int n2, double d2, Point point) {
        Tick tick = this.ticks.get(n);
        double d3 = this.tickLabeler.calculateLabelSize(tick.getContent()).getHeight();
        if (!this.getScale().isCategorical()) {
            this.tickLabeler.isCategorical = false;
        }
        if (this.coordinates.insideAxes) {
            return this.makeTickLabelInsideAxis(dim, d2, point, tick, d3);
        }
        if (this.isYAxis() && !this.coordinates.transposesAxes()) {
            if (this.isOverlappingTick && !this.coordinates.containsCluster() && n == 0) {
                return null;
            }
            double d4 = this.tickHeight - this.getTitleSize();
            double d5 = (1.0 - tick.location) * dim.getHeight();
            double d6 = this.outsideTickLabels ? Math.max(d3, dim.getHeight() * d) : dim.getHeight() * d;
            double[] dArray = this.getTickPerpendicularLocation(-this.tickMarkSize, this.axisSpec.markStyle, dim);
            double d7 = this.drawOppositeSide ? dim.getWidth() + d4 + dArray[0] + this.spacing : 0.0;
            double d8 = d6 / 2.0;
            if ("start".equals(this.tickVAlign)) {
                d8 = 0.0;
            } else if ("end".equals(this.tickVAlign)) {
                d8 = d6;
            }
            Shape shape = ShapeFactory2.CreateRect(-d4 + this.offset + d7, d5 - d8, d4 + dArray[1] - this.spacing, d6);
            shape = this.modifyShape(shape, dim, n, n2);
            if (shape == null) {
                return null;
            }
            return this.tickLabeler.makeSimpleLabel(tick.getContentClone(), shape);
        }
        return this.makeTickLabelXAxis(n, dim, n2);
    }

    Point getTickPosition(Dim dim, Tick tick, double d) {
        Point point = new Point(0.0, 0.0);
        if (this.isRadialYAxis()) {
            Axis axis = this.coordinates.axes.length == 1 ? this.coordinates.axes[0] : this.coordinates.axes[1];
            List<Tick> list = axis.ticks;
            Tick tick2 = list.get(0);
            point.setX(tick2.location * dim.getWidth());
            point.setY((1.0 - tick.location) * dim.getHeight());
        } else {
            point.setX(tick.location * dim.getWidth());
            point.setY(-this.tickMarkSize - this.spacing - d);
        }
        return point;
    }

    private Text makeTickLabelXAxis(int n, Dim dim, int n2) {
        double d;
        double d2;
        double d3;
        Object object;
        Range range = this.makeParallelSpanForTick(this.ticks, n, dim, n2);
        double[] dArray = this.getTickPerpendicularLocation(this.tickMarkSize, this.axisSpec.markStyle, dim);
        double d4 = this.getTitleSize();
        if (d4 > 0.0) {
            d4 -= this.spacing / 2.0;
        }
        Dim dim2 = this.getMaxTickLabelSize(dim);
        double d5 = dim2.getHeight();
        double d6 = this.tickMarkSize + this.spacing;
        double d7 = this.tickHeight - d4;
        double d8 = -dArray[0];
        if (this.drawOppositeSide) {
            d8 = dim.getHeight() + d6 + d7 + 2.0 * this.offset - dArray[1];
        }
        if (TICK_METHOD_STAGGER.equals(this.method) && !this.isRotatedXaxisLabel()) {
            if (n % 2 > 0) {
                d6 += d5;
                if (this.drawOppositeSide) {
                    d8 += d5;
                }
            } else {
                d7 -= d5;
                if (this.drawOppositeSide) {
                    d8 -= d5;
                }
            }
            if ("start".equals(object = this.tickLabeler.align)) {
                range = range.unionValue(range.getMax() + range.getRange());
            } else if ("end".equals(object)) {
                range = range.unionValue(range.getMin() - range.getRange());
            } else {
                assert ("middle".equals(object));
                range = range.expand(range.getRange() / 2.0);
            }
        }
        double d9 = range.getMin();
        if (this.outsideTickLabels) {
            d3 = Math.max(dim2.getWidth(), Math.max(dim2.getHeight(), d7 - d6));
            d2 = Math.max(range.getRange(), d3);
            d9 += (range.getRange() - d2) / 2.0;
        } else {
            d3 = d7 - d6;
            d2 = range.getRange();
        }
        if (this.coordinates.transposesAxes() && this.whichScale > 0) {
            double d10 = dim.getHeight() / dim.getWidth();
            double d11 = 0.0;
            if (this.axisSpec.markStyle != null && this.axisSpec.markStyle.align != null) {
                if ("middle".equals(this.axisSpec.markStyle.align)) {
                    d11 = -this.tickMarkSize / 2.0;
                }
                if ("end".equals(this.axisSpec.markStyle.align)) {
                    d11 = -this.tickMarkSize;
                }
            }
            if ("start".equals(this.tickVAlign)) {
                d9 -= d2 / 2.0;
            } else if ("end".equals(this.tickVAlign)) {
                d9 += d2 / 2.0;
            }
            d = dim.getHeight() + (d6 + this.offset + d11) * d10;
            if (this.drawOppositeSide) {
                d = dim.getHeight() - (dim.getWidth() + d7 + this.offset + d11) * d10;
            }
            double d12 = d3 * d10;
            object = ShapeFactory2.CreateRect(d9, d, d2, d12);
        } else {
            object = ShapeFactory2.CreateRect(range.getMin(), d6 + this.offset - d8, d2, d3);
            if (this.isRotatedXaxisLabel() && !this.isVerticalAngle()) {
                Dim dim3 = Axis.getRotateLabelExtent(d2, d3, this.tickLabelAngle);
                ((Shape)object).setWidth(dim3.getWidth());
                ((Shape)object).setHeight(dim3.getHeight());
            }
        }
        Tick tick = this.ticks.get(n);
        Text text = null;
        if (TICK_METHOD_VERTICAL.equals(this.method) && !this.isRotatedXaxisLabel()) {
            ((Shape)object).setY(-((Shape)object).getY());
            object = this.modifyTickLabelPosition(n, dim, n2, (Shape)object);
            if (object == null) {
                return null;
            }
            text = this.tickLabeler.makeSimpleRotatedLabel(tick.getContentClone(), (Shape)object);
        } else {
            Shape shape = this.modifyShape((Shape)object, dim, n, n2);
            if (shape == null) {
                return null;
            }
            text = this.tickLabeler.makeSimpleLabel(tick.getContentClone(), (Shape)object);
            Rect rect = (Rect)((Shape)object).getGeom();
            if (this.isRotatedXaxisLabel() && text != null) {
                text = this.modifyRotatedTickLabel(text, n, dim, rect, range.getRange());
            }
            if ((this.tickLabelAngle == Math.PI || this.tickLabelAngle == -Math.PI) && text != null) {
                d = text.getHeight();
                if ("start".equals(this.tickVAlign)) {
                    text.updateTransform(Affine.makeTransform(0.0, d));
                } else if ("end".equals(this.tickVAlign)) {
                    text.updateTransform(Affine.makeTransform(0.0, -d));
                }
            }
        }
        return text;
    }

    private Text modifyRotatedTickLabel(Text text, int n, Dim dim, Rect rect, double d) {
        Tick tick = this.ticks.get(n);
        Text text2 = text;
        Rect rect2 = Axis.reduceBoundsForOverlappingLabels(text2, rect, this.tickLabelAngle, d);
        if (rect2 != null) {
            TextContent textContent = tick.getContentClone();
            textContent.removeTransform();
            Shape shape = ShapeFactory2.CreateRect(rect2.getX(), rect2.getY(), rect2.getWidth(), rect2.getHeight());
            text2 = this.tickLabeler.makeSimpleLabel(textContent, shape);
        }
        if (text2 != null) {
            this.offsetRotatedTickLabel(text2, n, dim, rect);
        }
        return text2;
    }

    protected static Rect reduceBoundsForOverlappingLabels(Text text, Rect rect, double d, double d2) {
        double d3 = Math.abs(MathUtil.r(Math.sin(d)));
        double d4 = Math.abs(MathUtil.r(Math.cos(d)));
        double d5 = text.getHeight();
        double d6 = text.calculateTextWidth();
        double d7 = text.getFont().getHeight();
        if (d2 * d3 < d5 && d2 * d4 < d6) {
            Rect rect2 = new Rect(rect.getX(), rect.getY(), d6, d5);
            double d8 = 0.0;
            double d9 = d2 * d3 / d5;
            double d10 = d2 * d3 / d5;
            boolean bl = false;
            if (d9 > d10) {
                rect2.setWidth(d2 * d4 * 0.8);
                bl = true;
            } else {
                d8 = d2 * d3 * 0.9;
                if (!Axis.isIntendedHeightTooSmall(d8, d7)) {
                    rect2.setHeight(d8);
                }
            }
            if (rect2.getWidth() * d3 + rect2.getHeight() * d4 > rect.getHeight()) {
                if (bl) {
                    d8 = (rect.getHeight() - rect2.getWidth() * d3) / d4;
                    if (!Axis.isIntendedHeightTooSmall(d8, d7)) {
                        rect2.setHeight(d8);
                    }
                } else {
                    rect2.setWidth((rect.getHeight() - rect2.getHeight() * d4) / d3);
                }
            }
            Affine affine = Affine.makeRotation(d, 0.0, 0.0);
            Rect rect3 = Shape.transformBounds(new Rect(0.0, 0.0, 1.0, 1.0), affine);
            d8 = rect2.getHeight() / rect3.getHeight();
            if (!Axis.isIntendedHeightTooSmall(d8, d7)) {
                rect2.setHeight(d8);
            }
            rect2.setWidth(rect2.getWidth() / rect3.getWidth());
            tickLabelHeightReduced = rect2.getHeight() < d5;
            return rect2;
        }
        tickLabelHeightReduced = false;
        return null;
    }

    private void offsetRotatedTickLabel(Text text, int n, Dim dim, Rect rect) {
        Object object;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.tickMarkSize + this.spacing + this.tickLabeler.getPadding().top;
        double d4 = MathUtil.r(Math.cos(this.tickLabelAngle));
        double d5 = MathUtil.r(Math.sin(this.tickLabelAngle));
        double d6 = text.calculateTextWidth();
        Tick tick = this.ticks.get(n);
        double d7 = tick.getAdjacentTickSpace(n, this.ticks) * dim.getWidth();
        if (this.tickLabelAngle > 0.0 || this.tickLabelAngle < 0.0 && this.drawOppositeSide) {
            if ("start".equals(this.tickAlign)) {
                d2 = -text.getPoint().getY() + d3;
            } else if ("middle".equals(this.tickAlign)) {
                d = -text.getPoint().getX() + d6 * d4 / 2.0 + tick.location * dim.getWidth();
                d2 = -text.getPoint().getY() + d6 / 2.0 * d5 + d3;
            } else if ("end".equals(this.tickAlign)) {
                d = -text.getPoint().getX() + d6 * d4 + tick.location * dim.getWidth() + d7 / 2.0;
                d2 = -text.getPoint().getY() + d6 * d5 + d3;
            }
        } else if (this.tickLabelAngle < 0.0 || this.tickLabelAngle > 0.0 && this.drawOppositeSide) {
            if ("start".equals(this.tickAlign)) {
                d = -text.getPoint().getX() - d6 * d4 + tick.location * dim.getWidth() - d7 / 2.0;
                d2 = -text.getPoint().getY() - d6 * d5 + d3;
            } else if ("middle".equals(this.tickAlign)) {
                d = -text.getPoint().getX() - d6 * d4 / 2.0 + tick.location * dim.getWidth();
                d2 = -text.getPoint().getY() - d6 / 2.0 * d5 + d3;
            } else if ("end".equals(this.tickAlign)) {
                d = -text.getPoint().getX() + tick.location * dim.getWidth() + d7 / 2.0;
                d2 = -text.getPoint().getY() + d3;
            }
        }
        if (text.getNumLines() > 1) {
            object = this.getOffsetForMultiLIneLabel(text);
            d += object[0];
            d2 += object[1];
        }
        if (this.drawOppositeSide) {
            d2 -= dim.getHeight() + 2.0 * d3;
            if (this.tickLabelAngle > 0.0 && this.tickLabelAngle < Math.PI || this.tickLabelAngle < -Math.PI && this.tickLabelAngle > Math.PI * -2) {
                d2 -= d6 * d5;
                d -= d6 * d4;
            }
        } else if (this.tickLabelAngle > Math.PI && this.tickLabelAngle < Math.PI * 2) {
            d2 -= d6 * d5;
            d -= d6 * d4;
        } else if (this.tickLabelAngle < -Math.PI && this.tickLabelAngle > Math.PI * -2) {
            d2 += d6 * d5;
            d += d6 * d4;
        }
        if (this.isVerticalAngle()) {
            object = this.tickLabeler.getOffsetForLabelAngle(text, this.tickLabelAngle, this.tickLabeler.getLocation(), this.tickLabeler.align, this.tickLabeler.valign, this.getRotatedTickLabelSize(new Dim(rect.getWidth(), rect.getHeight())));
            d -= ((Point)object).getX();
            d2 -= ((Point)object).getY();
        }
        if (d != 0.0 || d2 != 0.0) {
            text.updateTransform(Affine.makeTransform(d, d2));
        }
    }

    private double[] getOffsetForMultiLIneLabel(Text text) {
        MultiPartText multiPartText = (MultiPartText)text;
        double d = multiPartText.getLines().get(0).getHeight();
        double d2 = multiPartText.getLines().get(multiPartText.getNumLines() - 1).getHeight();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = Math.abs(MathUtil.r(Math.cos(this.tickLabelAngle)));
        double d6 = Math.abs(MathUtil.r(Math.sin(this.tickLabelAngle)));
        double d7 = text.getHeight();
        double[] dArray = new double[2];
        String string = this.tickVAlign;
        if ("end".equals(this.tickVAlign) && this.drawOppositeSide) {
            string = "start";
        } else if ("start".equals(this.tickVAlign) && this.drawOppositeSide) {
            string = "end";
        }
        if ("end".equals(string)) {
            if (this.tickLabelAngle < 0.0 && this.tickLabelAngle > -1.5707963267948966 || this.tickLabelAngle > 4.71238898038469 && this.tickLabelAngle < Math.PI * 2) {
                d4 += d7 * d5;
                d3 += (d7 - d) * d6;
            } else if (this.tickLabelAngle < -4.71238898038469 && this.tickLabelAngle > Math.PI * -2 || this.tickLabelAngle > 0.0 && this.tickLabelAngle < 1.5707963267948966) {
                d4 += d7 * d5;
                d3 -= (d7 - d) * d6;
            }
        } else if ("middle".equals(string)) {
            d4 += d7 * d5 / 2.0;
            if (this.tickLabelAngle < 0.0 && this.tickLabelAngle > -1.5707963267948966 || this.tickLabelAngle > 4.71238898038469 && this.tickLabelAngle < Math.PI * 2) {
                d3 += (d7 - d) * d6 / 2.0;
            } else if (this.tickLabelAngle < -4.71238898038469 && this.tickLabelAngle > Math.PI * -2 || this.tickLabelAngle > 0.0 && this.tickLabelAngle < 1.5707963267948966) {
                d3 -= (d7 - d) * d6 / 2.0;
            } else if (this.tickLabelAngle < -Math.PI && this.tickLabelAngle > -4.71238898038469 || this.tickLabelAngle > 1.5707963267948966 && this.tickLabelAngle < Math.PI) {
                d3 += (d7 - d2) * d6 / 2.0;
            } else if (this.tickLabelAngle < -1.5707963267948966 && this.tickLabelAngle > -Math.PI || this.tickLabelAngle > Math.PI && this.tickLabelAngle < 4.71238898038469) {
                d3 -= (d7 - d2) * d6 / 2.0;
            }
        } else if ("start".equals(string)) {
            if (this.tickLabelAngle > 1.5707963267948966 && this.tickLabelAngle < Math.PI || this.tickLabelAngle < -Math.PI && this.tickLabelAngle > -4.71238898038469) {
                d4 += d7 * d5;
                d3 += (d7 - d2) * d6;
            } else if (this.tickLabelAngle > Math.PI && this.tickLabelAngle < 4.71238898038469 || this.tickLabelAngle < -1.5707963267948966 && this.tickLabelAngle > -Math.PI) {
                d4 += d7 * d5;
                d3 -= (d7 - d2) * d6;
            }
        }
        dArray[0] = this.drawOppositeSide ? -d3 : d3;
        dArray[1] = this.drawOppositeSide ? -d4 : d4;
        return dArray;
    }

    private Shape modifyTickLabelPosition(int n, Dim dim, int n2, Shape shape) {
        Point point = shape.getCenter();
        Shape shape2 = ShapeFactory2.CreateRect(point.getX(), point.getY(), 0.0, 0.0);
        if ((shape2 = this.modifyShape(shape2, dim, n, n2)) == null) {
            return null;
        }
        shape.setX(shape.getX() + (shape2.getX() - point.getX()));
        shape.setY(shape.getY() + (shape2.getY() - point.getY()));
        return shape;
    }

    private Text makeAxisTitle(Dim dim) {
        double d = this.getTitleSize();
        Text text = null;
        if (d > this.tickHeight - this.tickMarkSize - this.spacing) {
            this.titleLabeler.valign = this.drawOppositeSide ? "start" : "end";
            d = this.tickHeight - this.tickMarkSize - this.spacing;
            this.titleActualSize = 0.0;
        }
        if (this.coordinates.insideAxes || this.titleLabeler == null) {
            return null;
        }
        if (this.isYAxis()) {
            double d2 = this.drawOppositeSide ? dim.getWidth() + 2.0 * this.tickHeight - d : 0.0;
            Shape shape = ShapeFactory2.CreateRect(-this.tickHeight - this.offset + d2, 0.0, d, dim.getHeight());
            text = this.titleLabeler.makeRotatedLabel(this.titleLabeler.makeTextContent(this.axisSpec.title, -1), shape);
        } else {
            double d3 = this.drawOppositeSide ? dim.getHeight() + 2.0 * this.tickHeight - d : 0.0;
            Shape shape = ShapeFactory2.CreateRect(0.0, this.tickHeight - d - d3, dim.getWidth(), d + 2.0 * this.offset);
            text = this.titleLabeler.makeLabel(this.axisSpec.title, shape);
        }
        if (text != null && !Double.isNaN(this.titleActualSize)) {
            this.titleActualSize = text.getHeight();
        }
        return text;
    }

    private Shape makeTickShape(int n, Dim dim, double d, int n2, boolean bl) {
        StyleSpec styleSpec = this.axisSpec.boxStyle;
        StyleSpec styleSpec2 = styleSpec != null ? null : (bl ? this.axisSpec.minorStyle : this.axisSpec.markStyle);
        List<Tick> list = bl ? this.minorTicks : this.ticks;
        Tick tick = list.get(n);
        if (this.coordinates.insideAxes) {
            double d2 = tick.location * dim.getWidth();
            double d3 = dim.getWidth() / 4.0;
            double d4 = 2.0 * (d + this.tickLabeler.font.getHeight());
            Shape shape = ItemBuilder.makeRectangle(d2 - d3 / 2.0, -d4, d3, d4, styleSpec2);
            return this.coordinates.modifyShape(shape, dim);
        }
        if (this.isYAxis() && !this.coordinates.transposesAxes()) {
            if (this.isOverlappingTick && !this.coordinates.containsCluster() && n == this.ticks.size() - 1) {
                return null;
            }
            if (styleSpec != null) {
                Range range = this.makeParallelSpanForTick(list, n, dim, n2);
                return this.makeBox(range, dim, styleSpec);
            }
            double d5 = this.parents == null || this.parents.length == 0 ? dim.getHeight() : dim.getHeight() / (double)this.axisDrawCount;
            double d6 = (1.0 - tick.location + (double)n2) * d5;
            double[] dArray = this.getTickPerpendicularLocation(-d, styleSpec2, dim);
            double d7 = this.drawOppositeSide ? dim.getWidth() : 0.0;
            return ItemBuilder.makeLine(dArray[0] + this.offset + d7, d6, dArray[1] + this.offset + d7, d6, styleSpec2);
        }
        Range range = this.makeParallelSpanForTick(list, n, dim, n2);
        if (styleSpec != null) {
            return this.makeBox(range, dim, styleSpec);
        }
        double d8 = range.mid();
        if (TICK_METHOD_BETWEEN.equals(this.axisSpec.method)) {
            if (n == 0) {
                return null;
            }
            d8 = range.getMin();
        }
        double[] dArray = this.getTickPerpendicularLocation(d, styleSpec2, dim);
        double d9 = this.isYAxis() ? 0.0 : this.offset;
        double d10 = this.drawOppositeSide ? dim.getHeight() + 2.0 * this.offset : 0.0;
        return ItemBuilder.makeLine(d8, dArray[0] + d9 - d10, d8, dArray[1] + d9 - d10, styleSpec2);
    }

    private Shape makeBox(Range range, Dim dim, StyleSpec styleSpec) {
        Shape shape;
        double d = this.getTitleSize();
        if (d > 0.0) {
            d -= this.spacing / 2.0;
        }
        double d2 = this.tickHeight;
        d2 = this.tickHeight - d;
        if (this.isYAxis() && !this.coordinates.transposesAxes()) {
            double d3 = 0.0;
            if (this.drawOppositeSide) {
                d3 = dim.getWidth() + d2;
            }
            shape = ItemBuilder.makeRectangle(-d2 + d3, range.getMin(), d2, range.getRange(), styleSpec);
        } else {
            double d4 = 0.0;
            if (this.drawOppositeSide) {
                d4 = dim.getHeight() + 2.0 * this.offset + this.tickHeight;
            }
            if (this.coordinates.transposesAxes()) {
                double d5 = dim.getHeight() / dim.getWidth();
                if (this.drawOppositeSide) {
                    d4 = dim.getWidth() + 2.0 * this.offset + this.tickHeight;
                }
                double d6 = dim.getHeight() + (this.offset - d4) * d5;
                double d7 = d2 * d5;
                shape = ItemBuilder.makeRectangle(range.getMin(), d6, range.getRange(), d7, styleSpec);
            } else {
                shape = ItemBuilder.makeRectangle(range.getMin(), this.offset - d4, range.getRange(), d2, styleSpec);
            }
        }
        if ((styleSpec == null || styleSpec.stroke == null || styleSpec.stroke.width == null) && shape.getStroke() == null) {
            shape.setStroke(DEFAULT_BOX_STROKE);
        }
        return shape;
    }

    protected Range makeParallelSpanForTick(List<Tick> list, int n, Dim dim, int n2) {
        double d;
        double d2 = dim.getWidth();
        if (this.parents != null && this.parents.length > 0) {
            NestedTickInfo nestedTickInfo = this.tickInfo[n2][n];
            d = nestedTickInfo.pos.X() * dim.getWidth();
            List<Tick> list2 = this.coordinates.scales[this.parents[this.parents.length - 1]].getTicks();
            if (list2 != null) {
                d2 = dim.getWidth() / (double)list2.size();
            }
        } else {
            double d3 = this.isYAxis() && !this.coordinates.transposesAxes() ? dim.getHeight() : dim.getWidth();
            Tick tick = list.get(n);
            d = tick.location * d3;
            int n3 = list.size();
            if (n3 > 1) {
                double d4 = n == 0 ? 1.0 : Math.abs(tick.location - list.get((int)(n - 1)).location);
                double d5 = n == n3 - 1 ? 1.0 : Math.abs(tick.location - list.get((int)(n + 1)).location);
                d2 = Math.min(d4, d5) * d3;
            }
        }
        if (TICK_METHOD_VERTICAL.equals(this.method) && this.geometry.len < 200.0) {
            d2 += 4.0;
        }
        return new Range(d - d2 / 2.0, d + d2 / 2.0);
    }

    private double[] getTickPerpendicularLocation(double d, StyleSpec styleSpec, Dim dim) {
        String string;
        double[] dArray = new double[2];
        String string2 = string = styleSpec != null && styleSpec.align != null ? styleSpec.align : "start";
        if ("start".equals(string)) {
            dArray[0] = this.isDrawOppositeSide() ? -d : 0.0;
            double d2 = dArray[1] = this.isDrawOppositeSide() ? 0.0 : d;
        }
        if ("middle".equals(string)) {
            dArray[0] = -d / 2.0;
            dArray[1] = d / 2.0;
        }
        if ("end".equals(string)) {
            dArray[0] = this.isDrawOppositeSide() ? 0.0 : -d;
            double d3 = dArray[1] = this.isDrawOppositeSide() ? d : 0.0;
        }
        if (this.coordinates.transposesAxes() && this.whichScale > 0) {
            double d4 = dim.getHeight() / dim.getWidth();
            dArray[0] = dim.getHeight() + dArray[0] * d4;
            dArray[1] = dim.getHeight() + dArray[1] * d4;
        }
        return dArray;
    }

    private void initializeTicks() {
        Axis axis = this.getAxisAlignedTo();
        if (axis != null) {
            List<Tick> list = axis.getTicks();
            this.ticks = this.getScale().getTicksForTicksLocation(list, this.spans);
        } else if (this.spans != null && this.spans.size() > 0) {
            this.potentialSpanOverlaps = new ArrayList<Integer>();
            this.ticks = new ArrayList<Tick>();
            List<List<Tick>> list = this.getScale().getTicksForSpans(this.spans);
            this.ticks.addAll((Collection<Tick>)list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                List<Tick> list2 = list.get(i);
                if (list2.size() > 0 && this.ticks.size() > 0 && list2.get(0).getLocation() == this.ticks.get(this.ticks.size() - 1).getLocation()) {
                    list2.remove(0);
                } else {
                    this.potentialSpanOverlaps.add(this.ticks.size());
                }
                this.ticks.addAll(list2);
            }
        } else {
            this.potentialSpanOverlaps = null;
            this.ticks = this.getScale().getTicks();
        }
        if (this.tickAs.equals(TICK_AS_PERCENTAGE)) {
            this.showTicksAsPercentage();
        }
        this.initializeTickInfo();
    }

    private void showTicksAsPercentage() {
        double d = this.getScale().getDataMaxValue();
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        for (Tick tick : this.ticks) {
            Tick tick2 = new Tick(TextContent.makeForString(MathUtil.r3(tick.value / d * 100.0) + PERCENTAGE_SYMBOL, this.context.getMinimumFontSize()), tick.location, tick.value, tick.getSpan());
            arrayList.add(tick2);
        }
        this.ticks = arrayList;
    }

    private void defineAxisLayout(Rect rect, double d) {
        boolean bl;
        double d2;
        this.adjustTickMarkSize(d);
        this.tickHeight = this.calculateAxisHeight(rect, d);
        double d3 = this.axisSpec.visible != false ? this.tickMarkSize + this.spacing + this.getTitleSize() : 0.0;
        double d4 = d2 = this.drawPosition == 0 ? rect.getWidth() - this.tickHeight : rect.getHeight() - this.tickHeight;
        if (this.outsideTickLabels) {
            bl = true;
        } else {
            boolean bl2 = bl = this.hasSpaceForTickLabels(rect, d) && d2 >= this.getReservedChartSpace();
        }
        if (this.getScaleIndex() > 1 && !bl && this.isXAxis() && this.coordinates.containsCluster()) {
            this.modifyParentAxesMethod(rect, d, d2, this.whichScale - 1);
            d2 = rect.getHeight() - this.tickHeight;
            bl = this.outsideTickLabels ? true : this.hasSpaceForTickLabels(rect, d) && d2 >= this.getReservedChartSpace();
        }
        this.setDrawTickLabels();
        if (this.drawTickLabels) {
            this.drawTickLabels = bl;
        }
        if (!this.drawTickLabels) {
            this.tickHeight = d3;
            d2 = this.isYAxis() ? rect.getWidth() - d3 : rect.getHeight() - d3;
        }
        this.tickHeight = Math.ceil(this.tickHeight);
        if (this.coordinates.containsCluster()) {
            if (d2 < d / 3.0) {
                this.reduceAxesSize(rect, d);
            }
            this.calculateOffset();
        }
    }

    private boolean hasSpaceForTickLabels(Rect rect, double d) {
        boolean bl = true;
        if (this.tickLabeler != null) {
            double d2 = rect.getHeight() * rect.getWidth() / d;
            double d3 = this.tickLabeler.font.getHeight() + this.tickLabeler.getPadding().getVertical();
            if (d3 * 2.0 > d2) {
                bl = false;
            }
        }
        return bl;
    }

    private double calculateAxisHeight(Rect rect, double d) {
        boolean bl;
        Object object;
        this.maxTickLabelSizeCache = new Dim(0.0, 0.0);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.tickMarkSize + this.spacing;
        if (Axis.isStyleDefined(this.axisSpec.tickStyle, true)) {
            Dim dim = this.getMaxTickLabelSize(rect.getExtent());
            d2 = dim.getWidth() + 3.0;
            d3 = dim.getHeight();
        }
        boolean bl2 = true;
        if (this.isYAxis()) {
            this.method = TICK_METHOD_HORIZONTAL;
            d4 += d2;
            bl2 = false;
        } else if (this.isXAxis()) {
            if (this.isRotatedXaxisLabel()) {
                object = this.getRotatedTickLabelSize(new Dim(d2, d3));
                d4 += ((Dim)object).getHeight();
                this.tickVAlign = this.tickLabeler.valign = this.tickVAlign == null ? "middle" : this.tickVAlign;
                this.tickAlign = this.tickLabeler.align = this.tickAlign == null ? "middle" : this.tickAlign;
            } else if (TICK_METHOD_VERTICAL.equals(this.method)) {
                d4 += d2;
                this.tickLabeler.valign = this.tickAlign == null ? "middle" : this.tickAlign;
                this.tickLabeler.align = this.drawOppositeSide ? "start" : "end";
                bl2 = false;
            } else {
                d4 = TICK_METHOD_STAGGER.equals(this.method) ? (d4 += d3 * 2.0) : (d4 += d3);
            }
        }
        d4 = bl2 ? (d4 += Math.max(0.0, this.tickLabeler.getPadding().getVertical())) : (d4 += Math.max(0.0, this.tickLabeler.getPadding().getHorizontal()));
        d4 += this.getTitleSize();
        object = this.axisSpec.preferredSize;
        boolean bl3 = bl = object != null && (this.axisSpec.preferredSize.min != null || ((PreferredSizeSpec)object).max != null || ((PreferredSizeSpec)object).preferred != null);
        if (bl) {
            boolean bl4 = TICK_METHOD_STAGGER.equals(this.method) || TICK_METHOD_HORIZONTAL.equals(this.method);
            d4 = StyleBuilder.getPreferredSize((PreferredSizeSpec)object, d4, bl4, d);
        } else if (d > 200.0 && d4 > d / 3.0) {
            d4 = d / 3.0;
        } else if (this.isXAxis() && d4 > d / 2.0) {
            d4 = d / 2.0;
        } else if (this.isYAxis() && d4 > 2.0 * d / 3.0) {
            d4 = 2.0 * d / 3.0;
        }
        return d4;
    }

    private void adjustTickMarkSize(double d) {
        String string;
        if (this.axisSpec.markStyle != null && this.axisSpec.markStyle.size != null && BasicFactory.isString(this.axisSpec.markStyle.size) && (string = (String)this.axisSpec.markStyle.size).endsWith("%%")) {
            this.tickMarkSize = this.getTickMarkSize(this.axisSpec, this.tickLabeler.font.getHeight(), d);
        }
        if (this.axisSpec.minorStyle != null && this.axisSpec.minorStyle.size != null && BasicFactory.isString(this.axisSpec.minorStyle.size) && (string = (String)this.axisSpec.minorStyle.size).endsWith("%%")) {
            this.minorMarkSize = Axis.getMinorTickMarkSize(this.axisSpec, this.tickLabeler.font.getHeight(), this.tickMarkSize, d);
        }
    }

    private void calculateOffset() {
        this.offset = 0.0;
        for (Axis axis : this.coordinates.axes) {
            if (axis.whichScale <= this.whichScale || axis.getDrawPosition() != this.getDrawPosition() || this.drawOppositeSide != axis.drawOppositeSide) continue;
            this.offset += axis.getTickHeight();
        }
    }

    private void defineParents() {
        int n = 0;
        if (this.coordinates.scales.length > 2) {
            int n2;
            for (n2 = 1; n2 < this.coordinates.scales.length; ++n2) {
                if (n2 >= this.whichScale) continue;
                ++n;
            }
            this.parents = new int[n];
            for (n2 = 1; n2 < this.coordinates.scales.length; ++n2) {
                if (n2 >= this.whichScale) continue;
                this.parents[--n] = n2;
            }
        }
    }

    private Rect modifyParentAxesMethod(Rect rect, double d, double d2, int n) {
        if (n < 1) {
            return rect;
        }
        ArrayList<Axis> arrayList = new ArrayList<Axis>();
        for (Axis object : this.coordinates.axes) {
            if (object.whichScale >= this.whichScale || object.isDrawOppositeSide() != this.drawOppositeSide || object.getDrawPosition() != this.getDrawPosition()) continue;
            arrayList.add(object);
        }
        if (arrayList.size() == 0) {
            return rect;
        }
        if (this.hasSpaceForTickLabels(rect, d) && d2 >= this.getReservedChartSpace()) {
            return rect;
        }
        rect.setHeight(d);
        for (Axis axis : arrayList) {
            if (axis.getScaleIndex() == n) {
                String string;
                AxisSpec axisSpec = axis.getAxisSpec();
                String string2 = string = axisSpec != null && axisSpec.method != null ? axisSpec.method : TICK_METHOD_AUTO;
                if (!TICK_METHOD_AUTO.equals(string) && !TICK_METHOD_BETWEEN.equals(string) || !TICK_METHOD_VERTICAL.equals(axis.getMethod())) continue;
                axis.setMethod(TICK_METHOD_HORIZONTAL);
                axis.tickLabeler.align = "middle";
                axis.initializeTicks();
                axis.tickHeight = axis.calculateAxisHeight(rect, d);
                axis.modifyInnerCellSize(rect, false);
                continue;
            }
            axis.modifyInnerCellSize(rect, false);
        }
        this.tickHeight = this.calculateAxisHeight(rect, d);
        return this.modifyParentAxesMethod(rect, d, rect.getHeight() - this.tickHeight, n - 1);
    }

    private void reduceAxesSize(Rect rect, double d) {
        ArrayList<Axis> arrayList = new ArrayList<Axis>();
        arrayList.add(this);
        for (Axis object2 : this.coordinates.axes) {
            if (object2.whichScale >= this.whichScale || object2.getDrawPosition() != this.getDrawPosition()) continue;
            arrayList.add(object2);
        }
        if (this.isYAxis()) {
            rect.setX(0.0);
            rect.setWidth(d);
        } else {
            rect.setHeight(d);
        }
        double d2 = 2.0 * d / 3.0;
        int n = arrayList.size();
        ArrayList<Axis> arrayList2 = new ArrayList<Axis>();
        for (Axis axis : arrayList) {
            if (axis.tickHeight <= d2 / (double)n) {
                if (axis != this) {
                    axis.modifyInnerCellSize(rect, false);
                }
                d2 -= axis.tickHeight;
                --n;
                continue;
            }
            arrayList2.add(axis);
        }
        n = arrayList2.size();
        for (Axis axis : arrayList2) {
            axis.tickHeight = Math.floor(d2 / (double)n);
            if (axis == this) continue;
            axis.modifyInnerCellSize(rect, false);
        }
    }

    public Dim getMaxTickLabelSize(Dim dim) {
        if (Scale.hasSize(this.maxTickLabelSizeCache)) {
            return this.maxTickLabelSizeCache;
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.ticks.size(); ++i) {
            Dim dim2 = this.getTickLabelSize(i, dim);
            d = Math.max(d, dim2.getWidth());
            d2 = Math.max(d2, dim2.getHeight());
        }
        this.maxTickLabelSizeCache = new Dim(d, d2);
        return this.maxTickLabelSizeCache;
    }

    protected Dim getTickLabelSize(int n, Dim dim) {
        Tick tick = this.ticks.get(n);
        Dim dim2 = new Dim(Double.MAX_VALUE, Double.MAX_VALUE);
        if (TICK_METHOD_HORIZONTAL.equals(this.method) && this.isXAxis()) {
            dim2.setWidth(this.makeParallelSpanForTick(this.ticks, n, dim, 0).getRange());
        }
        Dim dim3 = this.tickLabeler.calculateConstrainedLabelSize(tick.getContentClone(), dim2);
        return dim3;
    }

    protected Dim getRotatedTickLabelSize(Dim dim) {
        return Axis.getRotatedLabelSize(dim, this.tickLabelAngle, this.tickLabeler.getPadding());
    }

    private static Dim getRotatedLabelSize(Dim dim, double d, Insets insets) {
        Affine affine = Affine.makeRotation(d, 0.0, 0.0);
        Rect rect = new Rect(0.0, 0.0, dim.getWidth() + insets.getHorizontal(), dim.getHeight() + insets.getVertical());
        Rect rect2 = Shape.transformBounds(rect, affine);
        return new Dim(rect2.getWidth(), rect2.getHeight());
    }

    private double getTitleSize() {
        if (this.coordinates.insideAxes || this.axisSpec.title == null) {
            return 0.0;
        }
        if (!Double.isNaN(this.titleActualSize)) {
            return this.titleActualSize;
        }
        double d = this.spacing;
        if (this.titleLabeler != null && this.titleLabeler.font != null) {
            TextContent textContent = this.titleLabeler.makeTextContent(this.axisSpec.title, -1);
            d = this.titleLabeler.calculateLabelSize(textContent).getHeight() + this.titleLabeler.getPadding().bottom + this.titleLabeler.getPadding().top + this.spacing;
        }
        return d;
    }

    public void giveSizeInfoToScale() {
        Dim dim = this.getScale().getMaxTickLabelSize(this.tickLabeler.font);
        this.setMinimalTickSeparation(dim);
    }

    private void setMinimalTickSeparation(Dim dim) {
        if (this.tickAs.equals(TICK_AS_PERCENTAGE)) {
            String string = Math.ceil(this.getScale().getDataMaxValue()) + ".000" + PERCENTAGE_SYMBOL;
            Text text = Text.createTextWithUnshapedValue(string, 0.0, 0.0, this.tickLabeler.align, this.tickLabeler.valign, this.tickLabeler.font, this.tickLabeler.style, null, null, this.tickLabeler.shapingInfo, null, this.context.getTooltipsForTruncatedText());
            dim.setWidth(this.tickLabeler.font.getWidth(text));
        }
        dim.setHeight(Math.max(dim.getHeight(), this.tickLabeler.font.getHeight()));
        double d = (dim.getWidth() + this.tickLabeler.getPadding().getHorizontal()) / 2.0;
        double d2 = dim.getWidth() + this.tickLabeler.getPadding().getHorizontal();
        double d3 = dim.getHeight() + this.tickLabeler.getPadding().getVertical();
        if (this.isRotatedXaxisLabel()) {
            double d4 = this.getRotatedTickLabelSize(dim).getWidth();
            double d5 = d4 == 0.0 ? d3 : Math.min(d3, d4);
            this.geometry.ticksNoSmallerThan(d5 + 0.5);
        } else if (TICK_METHOD_VERTICAL.equals(this.method)) {
            this.geometry.ticksNoSmallerThan(d3 + 0.5);
        } else if (TICK_METHOD_STAGGER.equals(this.method)) {
            this.geometry.ticksNoSmallerThan(d + 0.5);
        } else if (TICK_METHOD_HORIZONTAL.equals(this.method) || this.isHorizontalAngle()) {
            double d6 = d2 == 0.0 ? d3 : Math.min(d3, d2);
            this.geometry.ticksNoSmallerThan(d6 + 0.5);
        } else if (this.geometry.isYAxis) {
            this.geometry.ticksNoSmallerThan(d3 + 0.5);
        } else {
            this.geometry.ticksNoSmallerThan(Math.min(d3, d) + 0.5);
        }
    }

    private void resolveAutoTickMethod(Dim dim) {
        if (this.coordinates.insideAxes && this.coordinates.containsPolar()) {
            return;
        }
        double d = dim.getWidth();
        Scale scale = this.getScale();
        int n = 0;
        Axis axis = this.getAxisAlignedTo();
        n = this.whichScale > 1 ? (axis != null ? axis.getTickCountForInnerAxis(axis.getScaleIndex()) : this.getTickCountForInnerAxis(this.whichScale)) : (axis != null ? scale.computeTickCountForExtent(axis.getGeometry()) : scale.computeTickCountForExtent(this.geometry));
        d = this.coordinates.getAvailableWidth(d, n);
        Dim dim2 = scale.getMaxTickLabelSize(this.tickLabeler.font);
        double d2 = dim2.getWidth() + this.tickLabeler.getPadding().getHorizontal();
        double d3 = dim2.getHeight() + this.tickLabeler.getPadding().getVertical();
        if (n <= 0 || d / (double)n >= d2 || this.isHorizontalAngle()) {
            this.method = TICK_METHOD_HORIZONTAL;
        } else if (n > 2 && (d / (double)n - 0.5) * 2.0 >= d2) {
            this.method = this.axisSpec.boxStyle == null && dim.getHeight() > 100.0 ? TICK_METHOD_STAGGER : TICK_METHOD_VERTICAL;
        } else if (Double.isNaN(this.tickLabelAngle) && this.isRotatedXAxisLabelSupported()) {
            double d4;
            double d5 = Math.abs(MathUtil.r(Math.sin(-0.7853981633974483)));
            Affine affine = Affine.makeRotation(-0.7853981633974483, 0.0, 0.0);
            Rect rect = Shape.transformBounds(new Rect(0.0, 0.0, d2, d3), affine);
            double d6 = dim.getHeight() < 200.0 ? dim.getHeight() / 2.0 : dim.getHeight() / 3.0;
            d6 = d6 - this.tickMarkSize - this.spacing - this.getTitleSize();
            double d7 = d4 = n > 1 ? d / (double)n : d;
            if (rect.getHeight() >= d6 || (double)n * d3 > d || rect.getWidth() > d || d3 > d4 * d5) {
                this.method = TICK_METHOD_VERTICAL;
            } else {
                this.tickLabeler.angle = -45;
                this.tickLabelAngle = -0.7853981633974483;
            }
        } else {
            this.method = TICK_METHOD_VERTICAL;
        }
    }

    private int getTickCountForInnerAxis(int n) {
        Scale[] scaleArray = this.coordinates.scales;
        int n2 = 1;
        for (int i = 1; i <= n && i < scaleArray.length; ++i) {
            n2 *= scaleArray[i].computeTickCountForExtent(this.geometry);
        }
        return n2;
    }

    public String[][] getHierarchicalFieldIDs() {
        if (this.parents == null) {
            return new String[][]{this.coordinates.coordinateFieldIDs[this.whichScale]};
        }
        String[][] stringArray = new String[this.parents.length + 1][];
        for (int i = 0; i <= this.parents.length; ++i) {
            stringArray[i] = this.coordinates.coordinateFieldIDs[i + 1];
        }
        return stringArray;
    }

    protected double getReservedChartSpace() {
        if (this.isPreferredOrMinSpecified()) {
            return 0.0;
        }
        return 40.0;
    }

    private boolean isPreferredOrMinSpecified() {
        PreferredSizeSpec preferredSizeSpec = this.axisSpec.preferredSize;
        if (preferredSizeSpec != null) {
            return preferredSizeSpec.min != null || preferredSizeSpec.preferred != null;
        }
        return false;
    }

    public final double getOffset() {
        return this.offset;
    }

    public Axis getAxisAlignedTo() {
        if (this.alignWithOtherAxis && this.coordinates.axes.length > 1) {
            for (Axis axis : this.coordinates.axes) {
                if (axis.isAlignWithOtherAxis() || axis.getScaleIndex() != this.whichScale) continue;
                return axis;
            }
        }
        return null;
    }

    public Dim getPreferredSize() {
        double d = 0.0;
        double d2 = 0.0;
        Dim dim = this.getPreferredTitleSize();
        if (this.ticks == null) {
            Rect rect = new Rect(0.0, 0.0, 1000.0, 1000.0);
            this.initializeForBounds(rect);
            this.adjustLayout(rect, rect);
        }
        if (this.isYAxis()) {
            d = this.tickHeight + dim.getWidth();
            d2 = Math.max(dim.getHeight() == 0.0 ? 0.0 : dim.getHeight() + 2.0, this.geometry.len);
        } else {
            d = Math.max(dim.getWidth() == 0.0 ? 0.0 : dim.getWidth() + 2.0, this.geometry.len);
            d2 = this.tickHeight + dim.getHeight();
        }
        return new Dim(d, d2);
    }

    private Dim getPreferredTitleSize() {
        double d = 0.0;
        double d2 = 0.0;
        if (this.titleLabeler != null && this.titleLabeler.font != null) {
            TextContent textContent = this.titleLabeler.makeTextContent(this.axisSpec.title, -1);
            Dim dim = this.titleLabeler.calculateLabelSize(textContent);
            d = dim.getHeight();
            d2 = dim.getWidth();
            if (this.isYAxis()) {
                double d3 = d;
                d = d2;
                d2 = d3 + this.titleLabeler.getPadding().bottom + this.titleLabeler.getPadding().top + this.spacing;
            } else if (this.axisSpec.titleStyle == null || this.axisSpec.titleStyle.angle == null) {
                d += this.titleLabeler.getPadding().bottom + this.titleLabeler.getPadding().top + this.spacing;
            } else {
                Dim dim2 = Axis.getRotatedLabelSize(dim, ((Number)this.axisSpec.titleStyle.angle).doubleValue(), this.titleLabeler.getPadding());
                d = dim2.getHeight();
                d2 = dim2.getWidth();
            }
        }
        return new Dim(d2, d);
    }

    public double estimateTickSize(boolean bl) {
        StyleSpec styleSpec = this.getAxisSpec().tickStyle;
        if (styleSpec != null) {
            double d;
            Insets insets = Insets.makeForStylePadding(styleSpec.padding, new Dim(0.0, 0.0), new Dim(0.0, 0.0));
            double d2 = d = bl ? insets.getHorizontal() : insets.getVertical();
            if (styleSpec.font == null || styleSpec.font.size == null) {
                return d + 12.0;
            }
            return d + UnitConverter.convertLength(styleSpec.font.size, 12.0, 12.0);
        }
        return 20.0;
    }

    public void reset() {
        this.drawTickLabels = this.axisSpec.tickStyle == null || !Axis.isEmpty(this.axisSpec.tickStyle);
        this.method = this.axisSpec.method == null ? TICK_METHOD_AUTO : this.axisSpec.method;
    }

    public final boolean isRadialXAxis() {
        return this.coordinates.containsPolar() && this.isXAxis() && this.coordinates.scales.length == 2;
    }

    private Shape makeTickLabelInsideAxis(Dim dim, double d, Point point, Tick tick, double d2) {
        Point point2 = this.getTickPosition(dim, tick, d2);
        Text text = TICK_METHOD_VERTICAL.equals(this.method) ? this.makeTickLabelVerticalInsideAxis(dim, d, point, tick, point2) : (TICK_METHOD_HORIZONTAL.equals(this.method) ? this.makeTickLabelHorizontalInsideAxis(dim, d, point, tick, point2) : this.makeTickLabelAutoInsideAxis(dim, point, tick, point2));
        if (text == null) {
            return null;
        }
        return this.coordinates.modifyShape(text, dim);
    }

    private Text makeTickLabelAutoInsideAxis(Dim dim, Point point, Tick tick, Point point2) {
        Dim dim2 = new Dim(dim.getWidth(), dim.getHeight());
        Text text = tick.makeText(point2, "middle", "middle", this.tickLabeler.font, this.tickLabeler.clipSymbol, this.tickLabeler.shapingInfo, this.axisSpec.tickStyle, dim2, true, this.context.getTooltipsForTruncatedText());
        if (text == null) {
            return null;
        }
        text.tickLabelOrientation = TICK_METHOD_AUTO;
        return text;
    }

    private Text makeTickLabelHorizontalInsideAxis(Dim dim, double d, Point point, Tick tick, Point point2) {
        Text text;
        Dim dim2 = new Dim(dim.getWidth(), dim.getHeight());
        if (this.isRadialXAxis() && point != null) {
            double d2 = Math.PI * 2 * d;
            double d3 = d2 / (double)this.ticks.size();
            dim2.setWidth(d3);
        }
        if ((text = tick.makeText(point2, "middle", "middle", this.tickLabeler.font, this.tickLabeler.clipSymbol, this.tickLabeler.shapingInfo, this.axisSpec.tickStyle, dim2, true, this.context.getTooltipsForTruncatedText())) == null) {
            return null;
        }
        text.tickLabelOrientation = TICK_METHOD_HORIZONTAL;
        return text;
    }

    private Text makeTickLabelVerticalInsideAxis(Dim dim, double d, Point point, Tick tick, Point point2) {
        Text text;
        Dim dim2 = new Dim(dim.getWidth(), dim.getHeight());
        if (this.isRadialXAxis() && point != null) {
            double d2 = Math.PI * 2 * d;
            double d3 = d2 / (double)this.ticks.size();
            double d4 = Math.min(dim.getWidth() - point.getX() - d, point.getX() - d);
            double d5 = Math.min(dim.getHeight() - point.getY() - d, point.getY() - d);
            double d6 = Math.min(d4, d5);
            dim2.setWidth(d6);
            dim2.setHeight(d3);
        }
        if ((text = tick.makeText(point2, "end", "middle", this.tickLabeler.font, this.tickLabeler.clipSymbol, this.tickLabeler.shapingInfo, this.axisSpec.tickStyle, dim2, true, this.context.getTooltipsForTruncatedText())) == null) {
            return null;
        }
        text.vertical = true;
        text.tickLabelOrientation = TICK_METHOD_VERTICAL;
        return text;
    }

    public void relayoutForNewOutRange() {
        if (this.axisDrawCount > 1) {
            this.getScale().setDrawnMultiple(true);
        }
        this.getScale().initializeForDisplayableExtent(this.geometry);
        this.giveSizeInfoToScale();
        this.recalculateTickSeparation();
        this.initializeTicks();
    }

    public boolean isYAxis() {
        return this.getDrawPosition() == 0;
    }

    public boolean isXAxis() {
        return this.getDrawPosition() == 1;
    }

    private static Dim getRotateLabelExtent(double d, double d2, double d3) {
        double d4 = Math.abs(MathUtil.r(Math.sin(d3)));
        double d5 = Math.abs(MathUtil.r(Math.cos(d3)));
        return new Dim(d2 * d4 + d * d5, d2 * d5 + d * d4);
    }

    public static boolean isTickLabelHeightReduced() {
        return tickLabelHeightReduced;
    }

    private static boolean isIntendedHeightTooSmall(double d, double d2) {
        return d < d2;
    }
}

