/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.IntHashMap;
import com.ibm.vis.engine.internal.nativeImpl.collections.IntPrimitiveArrayList;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class CategoricalDomain {
    private int inputCount;
    private final boolean reverseOutput;
    private Number[] definedValues;
    public boolean restrictToExisting;
    private final ArrayList<Field> fieldsForExisting;
    private int[] outputValues;
    private IntHashMap<Integer> dataToIndexMap;
    private HashMap<Integer, Double> categoryWeightMap;
    private boolean sortByWeight;
    private Boolean followDataOrder;

    public CategoricalDomain(int n, boolean bl) {
        this.inputCount = n;
        this.reverseOutput = bl;
        this.fieldsForExisting = new ArrayList();
        this.categoryWeightMap = null;
        this.sortByWeight = false;
    }

    public void basedOnField(Field field) {
        this.fieldsForExisting.add(field);
    }

    public void setDefinedValues(Number[] numberArray) {
        this.definedValues = numberArray;
    }

    public int[] getOutputValues() {
        if (this.outputValues == null) {
            this.build();
        }
        return this.outputValues;
    }

    public Integer getDomainValueForFieldValue(Number number) {
        if (number == null) {
            return null;
        }
        if (this.outputValues == null) {
            this.build();
        }
        int n = (int)Math.round(number.doubleValue());
        return this.dataToIndexMap.get(n);
    }

    public Integer getFieldValueForDomainValue(Number number) {
        int n;
        if (number == null) {
            return null;
        }
        if (this.outputValues == null) {
            this.build();
        }
        if ((n = (int)Math.round(number.doubleValue())) < this.outputValues.length) {
            return this.outputValues[n];
        }
        return null;
    }

    public int getOutputCount() {
        if (this.outputValues == null) {
            this.build();
        }
        return this.outputValues.length;
    }

    public void fillInDetailsFrom(CategoricalDomain categoricalDomain) {
        if (this.inputCount < 0) {
            this.inputCount = categoricalDomain.inputCount;
        }
        if (this.fieldsForExisting.size() == 0) {
            this.fieldsForExisting.addAll(categoricalDomain.fieldsForExisting);
        }
        this.restrictToExisting = categoricalDomain.restrictToExisting;
        if (this.getFollowDataOrder() == null) {
            this.setFollowDataOrder(categoricalDomain.getFollowDataOrder());
        }
    }

    private void build() {
        int[] nArray;
        if (this.inputCount > 0) {
            boolean[] blArray = new boolean[this.inputCount];
            if (this.restrictToExisting) {
                this.restrictForFields(blArray);
            }
            nArray = this.createDesiredValues(blArray);
        } else {
            nArray = this.createFromFields();
        }
        if (this.sortByWeight && this.isWeighted()) {
            nArray = this.sortCategoriesByWeight(nArray);
        } else if (this.needsToFollowDataOrder()) {
            nArray = this.sortCategoriesByDataOrder(nArray);
        }
        int n = nArray.length;
        this.outputValues = new int[n];
        this.dataToIndexMap = new IntHashMap();
        int n2 = this.isOutputReversed() ? n - 1 : 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n3;
            this.outputValues[n2] = n3 = nArray[i];
            this.dataToIndexMap.put(n3, n2);
            if (this.isOutputReversed()) {
                --n2;
                continue;
            }
            ++n2;
        }
    }

    private boolean needsToFollowDataOrder() {
        return this.getFollowDataOrder() != null && this.getFollowDataOrder() != false;
    }

    private int[] sortCategoriesByDataOrder(int[] nArray) {
        int n;
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        IntPrimitiveArrayList intPrimitiveArrayList2 = new IntPrimitiveArrayList();
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            intPrimitiveArrayList2.add(nArray[n]);
        }
        n = 0;
        boolean bl = true;
        int n3 = 0;
        while (n3 < n2 && bl) {
            bl = false;
            for (Field field : this.fieldsForExisting) {
                int n4;
                int n5;
                if (n >= field.data.rows.length) continue;
                bl = true;
                Row row = field.data.rows[n];
                if (field.getIndex() >= row.data.length || (n5 = intPrimitiveArrayList2.indexOf(n4 = (int)row.data[field.getIndex()])) == -1 || intPrimitiveArrayList.contains(n4)) continue;
                ++n3;
                intPrimitiveArrayList.add(n4);
                intPrimitiveArrayList2.set(n5, -1);
            }
            ++n;
        }
        if (n3 < n2) {
            int n6 = -1;
            for (int i = 0; i < intPrimitiveArrayList2.size(); ++i) {
                n6 = intPrimitiveArrayList2.get(i);
                if (n6 == -1) continue;
                intPrimitiveArrayList.add(n6);
            }
        }
        return intPrimitiveArrayList.toArray();
    }

    /*
     * WARNING - void declaration
     */
    private int[] createFromFields() {
        HashSet<Number> hashSet = new HashSet<Number>();
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        for (Field field : this.fieldsForExisting) {
            Row[] rowArray = field.data.rows;
            for (Row row : rowArray) {
                double d = row.data[field.getIndex()];
                if (Double.isNaN(d)) continue;
                hashSet.add(d);
            }
        }
        if (this.definedValues != null) {
            for (Number number : this.definedValues) {
                if (number == null || !hashSet.contains(number.doubleValue()) || intPrimitiveArrayList.contains(number.intValue())) continue;
                intPrimitiveArrayList.add(number.intValue());
            }
        }
        if (intPrimitiveArrayList.size() == 0) {
            void var3_9;
            this.validateDomainValues(hashSet);
            for (Number number : hashSet) {
                intPrimitiveArrayList.add(number.intValue());
            }
            int[] nArray = intPrimitiveArrayList.toArray();
            BasicFactory.sortArray(nArray);
            if (!this.restrictToExisting) {
                int[] nArray2 = this.updateDomainForSpecs(nArray);
            }
            return var3_9;
        }
        return intPrimitiveArrayList.toArray();
    }

    protected void validateDomainValues(HashSet<Number> hashSet) {
        if (hashSet == null) {
            return;
        }
        for (Number number : hashSet) {
            if (!(number.doubleValue() < 0.0) && number.doubleValue() - Math.floor(number.doubleValue()) == 0.0) continue;
            throw new SpecException("Data value " + number + " is not valid. Negative or fractional category values are invalid.", ErrorCode.SPEC_INVALID_VALUE, null);
        }
    }

    protected int[] updateDomainForSpecs(int[] nArray) {
        if (nArray.length > 0) {
            int n = 0;
            int n2 = nArray[nArray.length - 1];
            IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
            for (int i = n; i <= n2; ++i) {
                intPrimitiveArrayList.add(i);
            }
            return intPrimitiveArrayList.toArray();
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    private int[] createDesiredValues(boolean[] blArray) {
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList();
        if (this.definedValues != null) {
            for (Number number : this.definedValues) {
                int n;
                if (number == null || (n = (int)Math.round(number.doubleValue())) < 0 || n >= this.inputCount || blArray[n]) continue;
                intPrimitiveArrayList.add(n);
                blArray[n] = true;
            }
        } else {
            void var3_5;
            boolean i = false;
            while (var3_5 < this.inputCount) {
                if (!blArray[var3_5]) {
                    intPrimitiveArrayList.add((int)var3_5);
                }
                ++var3_5;
            }
        }
        int[] nArray = new int[intPrimitiveArrayList.size()];
        int n = 0;
        for (int i = 0; i < intPrimitiveArrayList.size(); ++i) {
            int n2 = intPrimitiveArrayList.get(i);
            nArray[n++] = n2;
        }
        return nArray;
    }

    private void restrictForFields(boolean[] blArray) {
        boolean[] blArray2 = new boolean[blArray.length];
        for (Field field : this.fieldsForExisting) {
            Row[] rowArray;
            for (Row row : rowArray = field.data.rows) {
                int n;
                double d;
                if (row.data.length <= field.getIndex() || Double.isNaN(d = row.data[field.getIndex()]) || (n = (int)Math.round(d)) < 0 || n >= this.inputCount) continue;
                blArray2[n] = true;
            }
        }
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray2[i]) continue;
            blArray[i] = true;
        }
    }

    public int[] getDataOutputValues() {
        int[] nArray;
        if (this.restrictToExisting) {
            nArray = this.getOutputValues();
        } else {
            CategoricalDomain categoricalDomain = new CategoricalDomain(this.inputCount, this.isOutputReversed());
            categoricalDomain.fieldsForExisting.addAll(this.fieldsForExisting);
            categoricalDomain.definedValues = this.definedValues;
            categoricalDomain.restrictToExisting = true;
            categoricalDomain.setFollowDataOrder(this.getFollowDataOrder());
            nArray = categoricalDomain.getOutputValues();
        }
        return nArray;
    }

    private final Boolean getFollowDataOrder() {
        return this.followDataOrder;
    }

    public final void setFollowDataOrder(Boolean bl) {
        this.followDataOrder = bl;
    }

    public final void setCategoryWeights(Field field, Field field2) {
        if (field.data.id != field2.data.id) {
            throw new SpecException("CategoryWeights spec does not reference fields in the same data table.", ErrorCode.SPEC_MISMATCHED_FIELD_REFERENCE, null);
        }
        this.categoryWeightMap = new HashMap();
        int n = field.getIndex();
        int n2 = field2.getIndex();
        Row[] rowArray = field.data.rows;
        for (int i = 0; i < field.data.rows.length; ++i) {
            Integer n3 = (int)rowArray[i].data[n];
            Double d = rowArray[i].data[n2];
            Double d2 = this.categoryWeightMap.get(n3);
            if (d2 != null) {
                d = d + d2;
            }
            this.categoryWeightMap.put(n3, Math.max(d, 0.0));
        }
    }

    public final double getCategoryWeight(Integer n) {
        Number number;
        Number number2 = 0.0;
        if (this.isWeighted() && (number = (Number)this.categoryWeightMap.get(n)) != null) {
            number2 = number;
        }
        return number2;
    }

    public final double sumWeightsForCategories(int[] nArray) {
        double d = 0.0;
        if (this.isWeighted()) {
            for (int i = 0; i < nArray.length; ++i) {
                d += this.getCategoryWeight(nArray[i]);
            }
        }
        return d;
    }

    public final boolean isWeighted() {
        return this.categoryWeightMap != null && this.categoryWeightMap.size() > 0;
    }

    public final void setSortCategoriesByWeight(boolean bl) {
        this.sortByWeight = bl;
    }

    private int[] sortCategoriesByWeight(int[] nArray) {
        IntPrimitiveArrayList intPrimitiveArrayList = new IntPrimitiveArrayList(nArray.length);
        intPrimitiveArrayList.add(nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            int n = nArray[i];
            Double d = this.getCategoryWeight(n);
            boolean bl = false;
            for (int j = 0; j < intPrimitiveArrayList.size(); ++j) {
                Double d2 = this.getCategoryWeight(intPrimitiveArrayList.get(j));
                if (!(d > d2)) continue;
                intPrimitiveArrayList.add(j, n);
                bl = true;
                break;
            }
            if (bl) continue;
            intPrimitiveArrayList.add(n);
        }
        return intPrimitiveArrayList.toArray();
    }

    public boolean isOutputReversed() {
        return this.reverseOutput;
    }
}

