/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.FormatInfo;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.VisInterface;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.format.RAVEFormatter;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.scale.CategoricalDomain;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.scale.ScaleFitInfo;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.Tick;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class CategoricalScaleSpan
extends ScaleSpan {
    private final CategoricalDomain domain;
    private String[] categoryLabels;
    private int frequency;
    private Dim maxTickLabelSizeCache = new Dim(0.0, 0.0);
    private int maxTicksRestriction;
    private boolean drawnMultiple;
    private boolean reverse;

    public CategoricalScaleSpan(Unit unit, Integer n, ScaleFitInfo scaleFitInfo, RAVEFormatter rAVEFormatter, VisContext visContext, Range range, String string, String[] stringArray, CategoricalDomain categoricalDomain, Field field) {
        super(unit, n, scaleFitInfo, rAVEFormatter, visContext, range, string);
        this.domain = categoricalDomain;
        this.categoryLabels = stringArray;
        this.dataField = field;
        this.frequency = 1;
        this.drawnMultiple = false;
        this.reverse = false;
    }

    @Override
    public void addTicks(List<Tick> list, boolean bl) {
        this.addTicksAtFrequency(list, bl, this.frequency);
        this.maxTickLabelSizeCache = new Dim(0.0, 0.0);
    }

    public void setReversed(boolean bl) {
        this.reverse = bl;
    }

    public void setDrawnMultiple(boolean bl) {
        this.drawnMultiple = bl;
    }

    private TextContent getFormattedValue(int n, int n2) {
        String string;
        if (this.categoryLabels == null) {
            string = "" + n;
        } else {
            string = this.categoryLabels[n];
            if (string == null) {
                return null;
            }
        }
        String string2 = this.dataField != null ? this.dataField.id : null;
        String string3 = this.visContext.formatContext.formatString(string, this.specifiedFormatter, -1, string2);
        VisInterface visInterface = this.visContext.getParentVis();
        Field field = (Field)visInterface.getByID(string2);
        FormatInfo formatInfo = null;
        if (field != null) {
            formatInfo = field.getFormatInfo(n, n2, null);
        }
        return this.addFormattingContentToTickLabel(string3, n2, formatInfo);
    }

    @Override
    public void setupForTickCount(int n, int n2) {
        int n3;
        int n4 = (int)Math.round((double)this.domain.getOutputCount() / (double)n);
        if (n4 < (n3 = (int)Math.ceil((double)this.domain.getOutputCount() / (double)n2))) {
            n4 = n3;
        }
        if (n4 < 1) {
            n4 = 1;
        }
        this.frequency = n4;
    }

    @Override
    public void setupMaxTickCount(int n) {
        this.maxTicksRestriction = n;
    }

    @Override
    public Dim getMaxTickLabelSize(Font font) {
        if (Scale.hasSize(this.maxTickLabelSizeCache)) {
            return this.maxTickLabelSizeCache;
        }
        double d = 0.0;
        double d2 = 0.0;
        int[] nArray = this.domain.getOutputValues();
        for (int i = 0; i < nArray.length; ++i) {
            Text text;
            int n = nArray[i];
            TextContent textContent = this.getFormattedValue(n, i);
            if (textContent == null || (text = ItemBuilder.makeText(textContent, 0.0, 0.0, "start", "middleOfFirstLine", font, null, null, new Dim(Double.MAX_VALUE, Double.MAX_VALUE), false, null, this.visContext.getNumericShapingInfo(), this.visContext.getTooltipsForTruncatedText())) == null) continue;
            d = Math.max(d, text.calculateTextWidth());
            d2 = Math.max(d2, text.getHeight());
        }
        this.maxTickLabelSizeCache = new Dim(d, d2);
        return this.maxTickLabelSizeCache;
    }

    @Override
    public boolean isApplicable(Unit unit) {
        if (unit == null) {
            return true;
        }
        String string = unit.name;
        return unit.measure.matches(this.inputUnit.measure) && string.equals(this.inputUnit.name);
    }

    @Override
    public Double toZeroOne(Number number, Unit unit, boolean bl) {
        if (unit != null && !this.isApplicable(unit)) {
            return null;
        }
        CategoricalDomain categoricalDomain = this.domain;
        Integer n = categoricalDomain.getDomainValueForFieldValue(number);
        if (n == null) {
            return null;
        }
        double d = categoricalDomain.isWeighted() ? this.scaleWeightedIndexToZeroOne(number.intValue()) : this.scaleIndexToZeroOne(n);
        if (bl) {
            if (d < 0.0) {
                return 0.0;
            }
            if (d > 1.0) {
                return 1.0;
            }
        }
        return this.getOutRange().fromZeroOne(d);
    }

    public Integer getScaleIndexFromFieldIndex(Number number) {
        return this.domain.getDomainValueForFieldValue(number);
    }

    public Integer getFieldIndexFromScaleIndex(Number number) {
        return this.domain.getFieldValueForDomainValue(number);
    }

    private double scaleIndexToZeroOne(int n) {
        int n2 = this.domain.getOutputCount();
        if (n2 == 1) {
            return 0.5;
        }
        if (this.fitInfo.canExpand()) {
            return ((double)n + 0.5) / (double)n2;
        }
        return (double)n / (double)(n2 - 1);
    }

    private double scaleWeightedIndexToZeroOne(int n) {
        if (this.domain.getOutputCount() == 1) {
            return 0.5;
        }
        assert (this.domain.isWeighted());
        int[] nArray = this.domain.restrictToExisting ? this.domain.getDataOutputValues() : this.domain.getOutputValues();
        double d = this.domain.sumWeightsForCategories(nArray);
        double d2 = 0.0;
        for (int n2 : nArray) {
            if (n2 == n) {
                double d3 = (d2 += this.domain.getCategoryWeight(n2) * 0.5) / d;
                return d3;
            }
            d2 += this.domain.getCategoryWeight(n2);
        }
        throw new EngineException("Attempted to scale weighted category index that does not exist in categorical domain.", ErrorCode.ENGINE_CATEGORICAL_INDEX_NOT_FOUND, null);
    }

    @Override
    public void addMinorTicks(List<Tick> list) {
    }

    @Override
    public int computeTickCount() {
        return (int)Math.floor(this.domain.getOutputCount() / this.frequency);
    }

    @Override
    public double getTickMin() {
        return 0.0;
    }

    @Override
    public double getTickSize() {
        return this.frequency;
    }

    @Override
    public Range getInputRange() {
        return new Range(0.0, this.domain.getOutputCount());
    }

    @Override
    public Range getAdjustedInputRange() {
        return new Range(0.0, this.domain.getOutputCount());
    }

    @Override
    public Unit getTickUnit() {
        return this.inputUnit;
    }

    @Override
    public Double zeroOneToDataValue(double d) {
        int n = this.domain.getOutputCount();
        int n2 = (int)Math.round(d * (double)n - 0.5);
        if (n2 > n - 1) {
            n2 = n - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.reverse) {
            n2 = n - 1 - n2;
        }
        return this.domain.getOutputValues()[n2];
    }

    @Override
    public int getCategoryCount() {
        return this.domain.getOutputCount();
    }

    @Override
    public void getUndefinedParametersFrom(ScaleSpan scaleSpan) {
        super.getUndefinedParametersFrom(scaleSpan);
        CategoricalScaleSpan categoricalScaleSpan = (CategoricalScaleSpan)scaleSpan;
        if (this.categoryLabels == null) {
            this.categoryLabels = categoricalScaleSpan.categoryLabels;
        }
        this.domain.fillInDetailsFrom(categoricalScaleSpan.domain);
    }

    @Override
    public double getGoodDisplaySpanSize() {
        return this.getCategoryCount();
    }

    public int getIndexFromZeroOne(double d) {
        double d2 = this.getOutRange().toZeroOne(d);
        int n = this.domain.getOutputCount();
        if (this.fitInfo.canExpand()) {
            return (int)Math.round((double)n * d2 - 0.5);
        }
        return (int)Math.round(d2 * (double)(n - 1));
    }

    @Override
    public void addAllTicks(List<Tick> list, boolean bl) {
        this.addTicksAtFrequency(list, bl, 1);
    }

    private void addTicksAtFrequency(List<Tick> list, boolean bl, int n) {
        int n2 = 0;
        int[] nArray = bl ? this.domain.getDataOutputValues() : this.domain.getOutputValues();
        n2 = this.maxTicksRestriction > 0 && this.maxTicksRestriction < nArray.length ? this.maxTicksRestriction : nArray.length;
        for (int i = 0; i < n2; i += n) {
            double d;
            double d2;
            double d3;
            int n3;
            int n4 = nArray[i];
            double d4 = this.domain.isWeighted() ? this.scaleWeightedIndexToZeroOne(n4) : this.scaleIndexToZeroOne(i);
            TextContent textContent = this.getFormattedValue(n4, i);
            if (this.reverse) {
                n3 = n2 - 1 - i;
                d3 = this.domain.isWeighted() ? this.scaleWeightedIndexToZeroOne(n4) : this.scaleIndexToZeroOne(n3);
            } else {
                n3 = i;
                d3 = d4;
            }
            if (this.drawnMultiple) {
                list.add(new Tick(textContent, this.getOutRange().fromZeroOne(d4), n4, this));
                continue;
            }
            if (n3 > 0) {
                d2 = this.domain.isWeighted() ? this.scaleWeightedIndexToZeroOne(nArray[n3 - 1]) : this.scaleIndexToZeroOne(n3 - 1);
                d2 = (d2 + d3) * 0.5;
            } else {
                d2 = 0.0;
            }
            if (n3 < n2 - 1) {
                d = this.domain.isWeighted() ? this.scaleWeightedIndexToZeroOne(nArray[n3 + 1]) : this.scaleIndexToZeroOne(n3 + 1);
                d = (d + d3) * 0.5;
            } else {
                d = 1.0;
            }
            if (!(this.getOutRange().fromZeroOne(d) > -1.0E-6 && this.getOutRange().fromZeroOne(d2) < 1.000001) && !this.visContext.isGenerateAllTicks()) continue;
            list.add(new Tick(textContent, this.getOutRange().fromZeroOne(d4), n4, this));
        }
    }

    @Override
    public Double getBase(boolean bl) {
        int n = this.domain.getOutputCount();
        int n2 = bl ? n - 1 : 0;
        return this.domain.getOutputValues()[n2];
    }

    @Override
    public boolean isUnitApplicable(Number number, Unit unit) {
        boolean bl = true;
        if (unit != null && !this.isApplicable(unit)) {
            bl = false;
        }
        if (bl && this.domain.getDomainValueForFieldValue(number) == null) {
            bl = false;
        }
        if (unit != null && (unit.isCustomUnit() || this.inputUnit.isCustomUnit())) {
            return unit.name.equals(this.inputUnit.name);
        }
        return bl;
    }

    @Override
    public double getDataMaxValue() {
        return -1.0;
    }

    @Override
    public Tick createTickForLocation(double d) {
        Tick tick = null;
        int n = this.zeroOneToDataValue(this.getOutRange().toZeroOne(d)).intValue();
        int[] nArray = this.domain.getOutputValues();
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            n2 = i;
            break;
        }
        tick = new Tick(this.getFormattedValue(n, n2), d, n, this);
        this.maxTickLabelSizeCache = new Dim(0.0, 0.0);
        return tick;
    }

    public void createAllTicks(List<Tick> list, List<Tick> list2) {
        for (int i = 0; i < list.size(); ++i) {
            int[] nArray = this.domain.getOutputValues();
            int n = 0;
            int n2 = 0;
            while (i < nArray.length) {
                if (nArray[n2] == i) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            Tick tick = new Tick(this.getFormattedValue(i, n), list.get((int)i).location, i, this);
            list2.add(tick);
        }
        this.maxTickLabelSizeCache = new Dim(0.0, 0.0);
    }

    @Override
    public boolean areCompatible(ScaleSpan scaleSpan) {
        int[] nArray;
        int[] nArray2;
        int n;
        if (this == scaleSpan) {
            return true;
        }
        if (scaleSpan == null || !(scaleSpan instanceof CategoricalScaleSpan)) {
            return false;
        }
        CategoricalScaleSpan categoricalScaleSpan = (CategoricalScaleSpan)scaleSpan;
        if (this.categoryLabels == null || categoricalScaleSpan.categoryLabels == null) {
            if (this.categoryLabels != null || categoricalScaleSpan.categoryLabels != null) {
                return false;
            }
        } else {
            int n2 = this.categoryLabels.length;
            if (n2 != categoricalScaleSpan.categoryLabels.length) {
                return false;
            }
            for (int i = 0; i < n2; ++i) {
                if (this.categoryLabels[i].equals(categoricalScaleSpan.categoryLabels[i])) continue;
                return false;
            }
        }
        if ((n = (nArray2 = this.domain.getOutputValues()).length) != (nArray = categoricalScaleSpan.domain.getOutputValues()).length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (nArray2[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public Double getSuggestedSize(Number number) {
        Double d;
        if (this.domain.isWeighted()) {
            int[] nArray = this.domain.restrictToExisting ? this.domain.getDataOutputValues() : this.domain.getOutputValues();
            double d2 = this.domain.sumWeightsForCategories(nArray);
            double d3 = this.domain.getCategoryWeight(number.intValue());
            d = d3 / d2 * this.spanLengthPreTransform;
        } else {
            d = super.getSuggestedSize(number);
        }
        return d;
    }
}

