/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.FormatInfo;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.format.RAVEFormatter;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.scale.MultiplierInfo;
import com.ibm.vis.engine.internal.grammar.scale.ScaleFitInfo;
import com.ibm.vis.engine.internal.grammar.scale.ScaleGeometry;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.Tick;
import com.ibm.vis.engine.internal.grammar.units.Measure;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.engine.internal.util.MathUtil;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.monitor.LogComponent;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class ContinuousScaleSpan
extends ScaleSpan {
    protected Range inputNumDomain;
    private Range modifiedInputNumDomain;
    private Range tickDomain;
    private Range originalTickDomain;
    private Double appliedGranularity;
    protected boolean numDomainDefinedInSpec;
    private Unit ticksUnit;
    private Unit tickFormatUnit = null;
    private double tickDelta;
    private double originalTickDelta;
    protected double minorDivisions;
    private boolean useTickDeltaFromSpec;
    private String stackedFieldLabel;
    private double tickDeltaFromSpec;
    private boolean useMinorDivisionsFromSpec;
    private Range originalDataInputRange;
    protected boolean hasUnitDefinedInSpec;
    private boolean needDec = false;
    protected static final double TOLERANT_EXPAND = 1.0E-6;
    private List<Tick> baseTicks = null;
    private int maxTicksRestriction = 0;

    public ContinuousScaleSpan(Unit unit, Integer n, ScaleFitInfo scaleFitInfo, RAVEFormatter rAVEFormatter, VisContext visContext, Range range, String string, Number number, Number number2, Range range2, Field field, boolean bl, boolean bl2) {
        super(unit, n, scaleFitInfo, rAVEFormatter, visContext, range, string);
        this.dataField = field;
        this.hasUnitDefinedInSpec = bl;
        boolean bl3 = Unit.isWildCard(unit);
        if (bl && bl3) {
            this.tickFormatUnit = unit;
            this.hasUnitDefinedInSpec = false;
        } else if (bl3) {
            this.tickFormatUnit = unit;
        }
        this.setInputNumDomain(range2);
        this.numDomainDefinedInSpec = bl2;
        this.originalDataInputRange = new Range(range2.getMin(), range2.getMax());
        if (number2 != null) {
            this.setMinorDivisions(Math.round(number2.doubleValue()));
            this.setUseMinorDivisionsFromSpec(true);
        } else {
            this.setUseMinorDivisionsFromSpec(false);
        }
        if (number != null) {
            this.originalTickDelta = number.doubleValue();
            this.setTickDelta(number.doubleValue());
            this.tickDeltaFromSpec = number.doubleValue();
            this.setUseTickDeltaFromSpec(true);
        } else {
            this.tickDeltaFromSpec = 0.0;
            this.setUseTickDeltaFromSpec(false);
        }
        if (this.getUseTickDeltaFromSpec() && this.getTickDelta() <= 0.0) {
            if (this.visContext.getLogger().hasListeners()) {
                this.visContext.getLogger().grammarWarning(LogComponent.CommonGrammar, "badValueTickDelta (tickDelta must be greater than 0 in all scales)");
            }
            this.tickDeltaFromSpec = 0.0;
            this.setUseTickDeltaFromSpec(false);
        }
    }

    public final void setStacked(String string) {
        this.stackedFieldLabel = string;
    }

    public final Range getInputNumDomain() {
        return this.inputNumDomain;
    }

    public final void setInputNumDomain(Range range) {
        this.inputNumDomain = range;
    }

    protected final double getTickDeltaFromSpec() {
        return this.tickDeltaFromSpec;
    }

    protected final Range getModifiedInputNumDomain() {
        return this.modifiedInputNumDomain;
    }

    protected final void setModifiedInputNumDomain(Range range) {
        this.modifiedInputNumDomain = range;
    }

    protected final Range getTickDomain() {
        return this.tickDomain;
    }

    public final Double getAppliedGranularity() {
        return this.appliedGranularity;
    }

    public final void setAppliedGranularity(Double d) {
        this.appliedGranularity = d;
    }

    protected final Unit getTicksUnit() {
        return this.ticksUnit;
    }

    protected final void setTicksUnit(Unit unit) {
        this.ticksUnit = unit;
    }

    protected final double getTickDelta() {
        return this.tickDelta;
    }

    protected final void setTickDelta(double d) {
        this.tickDelta = d;
    }

    protected final double getMinorDivisions() {
        return this.minorDivisions;
    }

    protected final void setMinorDivisions(double d) {
        this.minorDivisions = d;
    }

    protected final boolean getUseTickDeltaFromSpec() {
        return this.useTickDeltaFromSpec;
    }

    protected final void setUseTickDeltaFromSpec(boolean bl) {
        this.useTickDeltaFromSpec = bl;
    }

    protected final boolean getUseMinorDivisionsFromSpec() {
        return this.useMinorDivisionsFromSpec;
    }

    protected final void setUseMinorDivisionsFromSpec(boolean bl) {
        this.useMinorDivisionsFromSpec = bl;
    }

    private static double nicifyDown(double d, double d2) {
        double d3 = Math.pow(10.0, Math.floor(Math.log(d2) / MathUtil.LN10));
        double d4 = 10.0 * d3 * Math.floor(d / (10.0 * d3));
        if (d4 >= d - d2 && d4 <= d) {
            return d4;
        }
        return d3 * Math.floor(d / d3);
    }

    private static double nicifyUp(double d, double d2) {
        double d3 = Math.pow(10.0, Math.floor(Math.log(d2) / MathUtil.LN10));
        double d4 = 10.0 * d3 * Math.ceil(d / (10.0 * d3));
        if (d4 >= d && d4 <= d + d2) {
            return d4;
        }
        return d3 * Math.ceil(d / d3);
    }

    private void modifyTickDomainForPan(double d) {
        if (this.visContext.isGenerateAllTicks()) {
            this.tickDomain.setMin(this.tickDomain.getMin() - d * Math.floor((this.tickDomain.getMin() - this.originalTickDomain.getMin()) / d));
            this.tickDomain.setMax(this.originalTickDomain.getMax());
        } else {
            Range range = this.expandToEdges(this.originalTickDomain);
            this.tickDomain.setMin(this.tickDomain.getMin() - d * Math.floor((this.tickDomain.getMin() - range.getMin()) / d));
            this.tickDomain.setMax(range.getMax());
        }
    }

    private Range expandToEdges(Range range) {
        Range range2 = this.getOutRange();
        double d = range.getRange() / range2.getRange();
        Range range3 = range.copy();
        if (this.scaleOutRange.getMin() == 0.0) {
            range3.setMin(range.getMin() - d * range2.getMin());
        }
        if (this.scaleOutRange.getMax() == 1.0) {
            range3.setMax(range.getMax() + d * (1.0 - range2.getMax()));
        }
        return range3;
    }

    private double modifyTickDomainForZoom(double d) {
        if (Math.abs(this.getOutRange().getMax() - this.originalFinalOutRange.getMax()) < Double.MIN_VALUE && Math.abs(this.getOutRange().getMin() - this.originalFinalOutRange.getMin()) < Double.MIN_VALUE) {
            this.tickDomain = this.originalTickDomain.copy();
            return this.originalTickDelta;
        }
        double d2 = this.originalTickDomain.getRange() / this.originalTickDelta;
        Range range = this.expandToEdges(this.originalTickDomain);
        d = range.getRange() / d2;
        double d3 = d / d2;
        d = ContinuousScaleSpan.nicifyDown(d, d3);
        this.tickDomain.setMin(ContinuousScaleSpan.nicifyUp(range.getMin(), d));
        this.tickDomain.setMax(range.getMax());
        return d;
    }

    @Override
    public void setupForExtent(ScaleGeometry scaleGeometry) {
        if (this.visContext != null && this.visContext.isUpdateViewport()) {
            if (this.visContext.isViewportPan()) {
                this.modifyTickDomainForPan(this.tickDelta);
            } else {
                this.tickDelta = this.modifyTickDomainForZoom(this.tickDelta);
            }
            this.fitInfo.setGeometry(scaleGeometry);
        } else {
            super.setupForExtent(scaleGeometry);
        }
    }

    @Override
    public void addTicks(List<Tick> list, boolean bl) {
        if (this.getInputNumDomain().getRange() == 0.0 && this.desiredTicks == null) {
            double d = UnitConverter.convert(this.getInputNumDomain().getMin(), this.getTicksUnit(), this.inputUnit);
            this.addTick(list, this.getInputNumDomain().getMin(), d);
        } else {
            double d = this.scaleTransform.transform(this.tickDomain.getMin());
            double d2 = this.scaleTransform.transform(this.tickDomain.getMax());
            double d3 = this.getTickDelta();
            double d4 = Double.POSITIVE_INFINITY;
            long l = Math.round((d2 - d) / d3);
            if (this.maxTicksRestriction > 0 && l > (long)this.maxTicksRestriction) {
                l = this.maxTicksRestriction;
            }
            int n = 0;
            while ((long)n <= l) {
                double d5 = d + (double)n * d3;
                if (d5 != d4) {
                    double d6 = this.scaleTransform.inverse(d5);
                    double d7 = UnitConverter.convert(d6, this.getTicksUnit(), this.inputUnit);
                    this.addTick(list, d6, d7);
                    d4 = d5;
                }
                ++n;
            }
        }
    }

    private void addTick(List<Tick> list, double d, double d2) {
        if (this.shouldAddTick(d2)) {
            double d3 = this.scaleTransform.transformToZeroOne(d2);
            if (this.centreSingleTick()) {
                d3 = 0.5;
            }
            Tick tick = new Tick(this.getFormattedTickValue(d), this.getOutRange().fromZeroOne(d3), d2, this);
            list.add(tick);
        }
    }

    protected TextContent getFormattedTickValue(double d) {
        Range range = null;
        Range range2 = new Range(this.tickDomain.getMin(), this.tickDomain.getMin() + this.tickDelta);
        String string = this.dataField != null ? this.dataField.id : null;
        int n = this.dataField != null ? this.dataField.getNearestMatchingRowIndex(d) : -1;
        range = range2.getFormattingPrecision() > this.tickDomain.getFormattingPrecision() ? range2 : this.tickDomain;
        Unit unit = this.getTicksUnit();
        if (this.tickFormatUnit != null) {
            d = UnitConverter.convert(d, this.getTicksUnit(), this.tickFormatUnit);
            unit = this.tickFormatUnit;
        }
        if (unit.measure.type.equals(Unit.DOLLARS.measure.type)) {
            range.calculateDeltaAndPrecision(this.tickDelta);
            if (this.needDec || range.getPrecision() == 0 && Math.floor(d) != d) {
                range.setPrecision(2);
                this.needDec = true;
            }
        }
        if (this.tickDelta > 0.001 && this.tickDelta < 1000.0 && (this.transformMethod == null || !this.transformMethod.equals("log"))) {
            double d2 = 1000.0;
            double d3 = 1.0;
            while (this.tickDelta > 0.0 && this.tickDelta < d3) {
                d3 *= 0.1;
                d2 *= 10.0;
            }
            d = (double)Math.round(d * d2) / d2;
        }
        String string2 = this.visContext.formatContext.formatNumber(d, this.specifiedFormatter, -1, string, range, unit);
        FormatInfo formatInfo = new FormatInfo();
        formatInfo.setNumeric(true);
        formatInfo.setSpecifiedFormatter(this.specifiedFormatter);
        formatInfo.setRange(range);
        formatInfo.setDataValue(d);
        return this.addFormattingContentToTickLabel(string2, n, formatInfo);
    }

    protected boolean shouldAddTick(double d) {
        double d2;
        if (this.visContext.isUpdateViewport()) {
            double d3 = this.scaleTransform.transformToZeroOne(d);
            return Range.makeInverse(this.getOutRange().getMin(), this.getOutRange().getMax()).containsTolerantly(d3, 1.0E-6) || this.visContext.isGenerateAllTicks();
        }
        if (!this.fitInfo.canExpand() && !this.visContext.isUpdateViewport()) {
            Range range = this.getInputNumDomain();
            double d4 = range.getMin() - Math.abs(range.getMin() * 1.0E-6);
            if (d < d4) {
                return false;
            }
            double d5 = range.getMax() + Math.abs(range.getMax() * 1.0E-6);
            if (d > d5) {
                return false;
            }
        }
        return Range.ZERO_ONE.containsTolerantly(d2 = this.scaleTransform.transformToZeroOne(d), 1.0E-6) && Range.ZERO_ONE.containsTolerantly(this.getOutRange().fromZeroOne(d2), 1.0E-6) || this.visContext.isGenerateAllTicks();
    }

    @Override
    public Dim getMaxTickLabelSize(Font font) {
        double d = 0.0;
        double d2 = 0.0;
        this.makeNumericSpanDetails(5, 20);
        TextContent textContent = this.getFormattedTickValue(this.tickDomain.getMin());
        TextContent textContent2 = this.getFormattedTickValue(this.tickDomain.getMax());
        Text text = ItemBuilder.makeText(textContent, 0.0, 0.0, "start", "middleOfFirstLine", font, null, null, new Dim(Double.MAX_VALUE, Double.MAX_VALUE), false, null, this.visContext.getNumericShapingInfo(), this.visContext.getTooltipsForTruncatedText());
        Text text2 = ItemBuilder.makeText(textContent2, 0.0, 0.0, "start", "middleOfFirstLine", font, null, null, new Dim(Double.MAX_VALUE, Double.MAX_VALUE), false, null, this.visContext.getNumericShapingInfo(), this.visContext.getTooltipsForTruncatedText());
        d = Math.max(text.calculateTextWidth(), text2.calculateTextWidth());
        d2 = Math.max(text.getHeight(), text2.getHeight());
        return new Dim(d, d2);
    }

    @Override
    public boolean isApplicable(Unit unit) {
        Unit unit2 = this.inputUnit;
        if (unit != null && (unit.isCustomUnit() || unit2.isCustomUnit())) {
            return unit.name.equals(unit2.name) && unit.measure.matches(unit2.measure);
        }
        return unit == null || unit.measure.matches(unit2.measure);
    }

    @Override
    public Double getBase(boolean bl) {
        double d;
        if (this.getModifiedInputNumDomain() == null) {
            return null;
        }
        double d2 = d = bl ? 1.0 : 0.0;
        if (this.scaleTransform != null) {
            d = this.scaleTransform.getOriginInZeroOne(bl);
        }
        return this.getOutRange().fromZeroOne(d);
    }

    @Override
    public Double toZeroOne(Number number, Unit unit, boolean bl) {
        if (unit != null && !this.isApplicable(unit)) {
            return null;
        }
        if (unit == null || !unit.measure.categorical) {
            if (this.getModifiedInputNumDomain() == null) {
                return null;
            }
            double d = number.doubleValue();
            if (unit != null) {
                d = UnitConverter.convert(d, unit, this.inputUnit);
            }
            double d2 = this.scaleTransform.transformToZeroOne(d);
            if (bl) {
                d2 = Range.ZERO_ONE.clamp(d2);
            }
            return this.getOutRange().fromZeroOne(d2);
        }
        return null;
    }

    @Override
    public void setupForTickCount(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n < 2) {
            n3 = 2;
        }
        if (n > 1000) {
            n3 = 1000;
        }
        if (n2 < 2) {
            n4 = 2;
        }
        this.makeNumericSpanDetails(n3 - 1, n4 - 1);
    }

    @Override
    public void setupMaxTickCount(int n) {
        this.maxTicksRestriction = n;
    }

    @Override
    public int computeTickCount() {
        if (!this.tickDomain.isComplete()) {
            return 0;
        }
        double d = this.scaleTransform.transform(this.tickDomain.getMax());
        double d2 = this.scaleTransform.transform(this.tickDomain.getMin());
        double d3 = this.getTickDelta();
        double d4 = 1.0E-6;
        return (int)Math.floor((d - d2) / d3 + d4) + 1;
    }

    @Override
    public void getUndefinedParametersFrom(ScaleSpan scaleSpan) {
        super.getUndefinedParametersFrom(scaleSpan);
        if (scaleSpan instanceof ContinuousScaleSpan) {
            ContinuousScaleSpan continuousScaleSpan;
            if (!this.getInputNumDomain().isComplete()) {
                continuousScaleSpan = (ContinuousScaleSpan)scaleSpan;
                Range range = continuousScaleSpan.getInputNumDomain();
                if (this.inputUnit != null && !this.inputUnit.equals(scaleSpan.inputUnit)) {
                    range = UnitConverter.convertRange(range, scaleSpan.inputUnit, this.inputUnit);
                }
                this.setInputNumDomain(this.getInputNumDomain().complete(range));
                if (!this.fitInfo.canExpand() && continuousScaleSpan.getAppliedGranularity() != null) {
                    this.setInputNumDomain(this.getInputNumDomain().expand(-continuousScaleSpan.getAppliedGranularity().doubleValue() / 2.0));
                }
            } else if (((ContinuousScaleSpan)scaleSpan).stackedFieldLabel != null && this.dataField.label.equals(((ContinuousScaleSpan)scaleSpan).stackedFieldLabel)) {
                this.adaptInputNumDomainFrom(scaleSpan);
            }
            continuousScaleSpan = (ContinuousScaleSpan)scaleSpan;
            if (continuousScaleSpan.originalDataInputRange.isComplete()) {
                this.originalDataInputRange = continuousScaleSpan.originalDataInputRange;
            } else if (!this.originalDataInputRange.isComplete()) {
                this.originalDataInputRange = this.originalDataInputRange.complete(continuousScaleSpan.originalDataInputRange);
            }
            if (this.inputUnit != null && !this.inputUnit.equals(scaleSpan.inputUnit)) {
                this.originalDataInputRange = UnitConverter.convertRange(this.originalDataInputRange, scaleSpan.inputUnit, this.inputUnit);
            }
        }
    }

    @Override
    public void adaptInputNumDomainFrom(ScaleSpan scaleSpan) {
        if (scaleSpan instanceof ContinuousScaleSpan) {
            ContinuousScaleSpan continuousScaleSpan = (ContinuousScaleSpan)scaleSpan;
            Range range = continuousScaleSpan.getInputNumDomain();
            if (this.inputUnit != null && !this.inputUnit.equals(continuousScaleSpan.inputUnit)) {
                range = UnitConverter.convertRange(range, continuousScaleSpan.inputUnit, this.inputUnit);
            }
            this.inputNumDomain = this.inputNumDomain.createUnion(range);
            if (this.originalDataInputRange.isComplete()) {
                this.originalDataInputRange = this.originalDataInputRange.createUnion(range);
            }
        }
    }

    protected double applyMultipliers(Range range, double d, double[] dArray, int n, int n2) {
        MultiplierInfo multiplierInfo = new MultiplierInfo(range, d, 1.0, this.fitInfo.canExpand());
        for (double d2 : dArray) {
            MultiplierInfo multiplierInfo2 = new MultiplierInfo(range, d, d2, this.fitInfo.canExpand());
            if (!multiplierInfo2.isBetterThan(multiplierInfo, n, n2)) continue;
            multiplierInfo = multiplierInfo2;
        }
        return d * multiplierInfo.multiplier;
    }

    protected Unit findBestUnit(double d, Unit unit, ArrayList<Unit> arrayList, int n) {
        if (this.inputNumDomain.getRange() == 0.0 && !Unit.isTime(unit)) {
            return unit;
        }
        double d2 = d;
        if (unit.measure != Measure.DATETIME) {
            d2 /= 2.0;
        }
        Unit unit2 = null;
        double d3 = 0.0;
        for (Unit unit3 : arrayList) {
            double d4;
            String string = unit3.system;
            if (!string.equals(unit.system) || Double.isNaN(d4 = UnitConverter.convert(d2, unit, unit3))) continue;
            double d5 = Math.abs(d4 - (double)n);
            if (unit2 != null && (!(d4 > 2.0) || !(d5 < d3))) continue;
            d3 = d5;
            unit2 = unit3;
        }
        Unit unit4 = this.visContext.getZoomUnit();
        if (unit4 != null && UnitConverter.convert(1.0, unit4, unit2) > 1.0) {
            return unit4;
        }
        return unit2;
    }

    protected void makeNumericSpanDetails(int n, int n2) {
        Range range;
        this.verifyInputNumDomain();
        Range range2 = this.expandInitialRange(this.getInputNumDomain());
        Range range3 = this.calculateTickRange(n, n2, range2);
        this.calculateTickDomain(range3);
        this.addExtraSpacing(this.getInputNumDomain(), n, n2);
        if (this.centreSingleTick()) {
            range = UnitConverter.convertRange(range3, this.getTicksUnit(), this.inputUnit);
        } else {
            range = this.ensureNiceRange();
            Range range4 = UnitConverter.convertRange(range, this.getTicksUnit(), this.inputUnit);
            range = this.fitInfo.finalizeRange(this.getInputNumDomain(), range4, this.scaleTransform);
        }
        this.setModifiedInputNumDomain(range);
        this.scaleTransform.setRange(this.getModifiedInputNumDomain());
    }

    protected Range calculateTickRange(int n, int n2, Range range) {
        Range range2;
        if (this.getUseTickDeltaFromSpec()) {
            this.setTicksUnit(this.inputUnit);
            range2 = range;
        } else {
            Unit unit = this.inputUnit;
            if (!this.hasUnitDefinedInSpec) {
                unit = this.findBestUnit(range.getRange(), this.inputUnit, this.inputUnit.measure.units, n);
                unit = unit == null ? this.inputUnit : unit;
            }
            this.setTicksUnit(unit);
            range2 = UnitConverter.convertRange(range, this.inputUnit, unit);
            this.setTickDelta(this.calculateTickDelta(n, n2, range2));
        }
        return range2;
    }

    protected Range ensureNiceRange() {
        double d;
        Range range = this.tickDomain;
        double d2 = this.scaleTransform.transform(range.getMin());
        if (Double.isNaN(d2)) {
            d = this.scaleTransform.getIntermediatePoint(this.getInputNumDomain().getMin(), range.getMin());
            range = new Range(d, range.getMax());
        }
        if (Double.isNaN(d = this.scaleTransform.transform(range.getMax()))) {
            double d3 = this.scaleTransform.getIntermediatePoint(this.getInputNumDomain().getMax(), range.getMax());
            range = new Range(range.getMin(), d3);
        }
        return range;
    }

    protected void calculateTickDomain(Range range) {
        double d = this.scaleTransform.transform(range.getMin());
        double d2 = Math.floor(d / this.tickDelta + 1.0E-6) * this.tickDelta;
        double d3 = this.scaleTransform.transform(range.getMax());
        double d4 = Math.ceil(d3 / this.tickDelta - 1.0E-6) * this.tickDelta;
        this.tickDomain = new Range(this.scaleTransform.inverse(d2), this.scaleTransform.inverse(d4));
        this.originalTickDomain = this.tickDomain.copy();
    }

    boolean centreSingleTick() {
        return this.getInputNumDomain().getRange() == 0.0;
    }

    protected double calculateTickDelta(int n, int n2, Range range) {
        double d = ContinuousScaleSpan.getFactorOfTen(range.getRange() / (double)n);
        double d2 = this.applyMultipliers(range, d, this.getTicksUnit().multipliers, n, n2);
        if (d2 >= range.getRange() && !this.fitInfo.canExpand()) {
            double d3 = range.getRange() / (double)n2;
            if (d2 > d3) {
                d2 = d3;
            }
            if (d2 > range.getRange()) {
                d2 = range.getRange();
            }
        }
        this.originalTickDelta = d2;
        return d2;
    }

    public Range expandInitialRange(Range range) {
        double d;
        double d2 = d = this.dataField != null && "percent".equals(this.dataField.getSourceOperation()) ? 100.0 : Double.NaN;
        if (range.getRange() == 0.0) {
            if (!this.fitInfo.canExpand()) {
                return range;
            }
            Range range2 = this.makeRangeAbout(range.getMin());
            return this.fitInfo.expandRange(range2, true, this.scaleTransform, this.inputUnit, d);
        }
        return this.fitInfo.expandRange(range, false, this.scaleTransform, this.inputUnit, d);
    }

    private void addExtraSpacing(Range range, int n, int n2) {
        if (!this.fitInfo.canExpand() || this.fitInfo.getGeometry() == null) {
            return;
        }
        Range range2 = UnitConverter.convertRange(this.tickDomain, this.getTicksUnit(), this.inputUnit);
        if (this.fitInfo.needsExtraSpacing(range, range2)) {
            Range range3;
            double d = this.dataField != null && "percent".equals(this.dataField.getSourceOperation()) ? 100.0 : Double.NaN;
            Range range4 = null;
            if (range.getRange() == 0.0) {
                range3 = this.makeRangeAbout(range.getMin());
                range4 = this.fitInfo.addExtraPadding(range3, true, this.scaleTransform, this.inputUnit, d);
            } else {
                range4 = this.fitInfo.addExtraPadding(range, false, this.scaleTransform, this.inputUnit, d);
            }
            range3 = this.calculateTickRange(n, n2, range4);
            this.calculateTickDomain(range3);
        }
    }

    protected Range makeRangeAbout(double d) {
        double d2 = this.scaleTransform.transform(0.0);
        if (this.inputUnit.measure.zeroMeaningful && !Double.isNaN(d2)) {
            if (d < 0.0) {
                return new Range(2.0 * d, 0.0);
            }
            if (d > 0.0) {
                return new Range(0.0, 2.0 * d);
            }
        }
        return new Range(d - 1.0, d + 1.0);
    }

    private static double getFactorOfTen(double d) {
        double d2 = Math.floor(Math.log(d) / Math.log(10.0));
        return Math.pow(10.0, d2);
    }

    @Override
    public void addMinorTicks(List<Tick> list) {
        double d;
        boolean bl = this.getUseMinorDivisionsFromSpec();
        double d2 = d = bl ? this.getMinorDivisions() : this.scaleTransform.getMinorTickDivisions(this.getTicksUnit().minorDivisions);
        if (d < 2.0) {
            return;
        }
        double d3 = this.scaleTransform.transform(this.tickDomain.getMin());
        double d4 = this.scaleTransform.transform(this.tickDomain.getMax());
        double d5 = this.getTickDelta();
        for (double d6 = d3 - d5; d6 < d4 + d5; d6 += d5) {
            double d7 = this.scaleTransform.inverse(d6 + d5) - this.scaleTransform.inverse(d6);
            int n = 1;
            while ((double)n < d) {
                double d8 = this.scaleTransform.inverse(d6) + d7 * (double)n / d;
                double d9 = UnitConverter.convert(d8, this.getTicksUnit(), this.inputUnit);
                double d10 = this.scaleTransform.transformToZeroOne(d9);
                if (Range.ZERO_ONE.containsTolerantly(d10, 1.0E-4)) {
                    Tick tick = new Tick(null, this.getOutRange().fromZeroOne(d10), d9, this);
                    list.add(tick);
                }
                ++n;
            }
        }
    }

    @Override
    public double getTickMin() {
        return this.getModifiedInputNumDomain().getMin();
    }

    @Override
    public double getTickSize() {
        return UnitConverter.convert(this.getTickDelta(), this.getTicksUnit(), this.inputUnit);
    }

    @Override
    public Range getInputRange() {
        return this.getInputNumDomain();
    }

    @Override
    public Range getAdjustedInputRange() {
        return this.getModifiedInputNumDomain();
    }

    @Override
    public Unit getTickUnit() {
        return this.getTicksUnit();
    }

    @Override
    public Double zeroOneToDataValue(double d) {
        return this.scaleTransform.transformFromZeroOne(d);
    }

    @Override
    public int getCategoryCount() {
        return 0;
    }

    @Override
    public double getGoodDisplaySpanSize() {
        if (this.getInputNumDomain().isComplete() && this.getInputNumDomain().getRange() < 1.0E-9) {
            return 1.0;
        }
        return 9.0;
    }

    @Override
    public void addAllTicks(List<Tick> list, boolean bl) {
        this.addTicks(list, bl);
    }

    @Override
    public boolean isUnitApplicable(Number number, Unit unit) {
        if (unit != null && !this.isApplicable(unit)) {
            return false;
        }
        return this.getModifiedInputNumDomain() != null;
    }

    protected void verifyInputNumDomain() throws EngineException {
    }

    @Override
    public double getDataMaxValue() {
        return this.originalDataInputRange.getMax();
    }

    @Override
    public Tick createTickForLocation(double d) {
        Tick tick = null;
        if (this.getInputNumDomain().getRange() == 0.0 && this.desiredTicks == null) {
            double d2 = UnitConverter.convert(this.getInputNumDomain().getMin(), this.getTicksUnit(), this.inputUnit);
            tick = new Tick(this.getFormattedTickValue(this.getInputNumDomain().getMin()), d, d2, this);
        } else {
            double d3 = this.scaleTransform.transform(this.scaleTransform.getRange().getMin());
            double d4 = this.scaleTransform.transform(this.scaleTransform.getRange().getMax());
            if (this.baseTicks != null && d == 0.0) {
                this.secondaryAxisNeedsDecimal(d3, d4);
            }
            double d5 = d3 + this.getOutRange().toZeroOne(d) * (d4 - d3);
            d5 = UnitConverter.convert(d5, this.inputUnit, this.getTicksUnit());
            double d6 = this.scaleTransform.inverse(d5);
            double d7 = UnitConverter.convert(d6, this.getTicksUnit(), this.inputUnit);
            tick = new Tick(this.getFormattedTickValue(d6), d, d7, this);
        }
        return tick;
    }

    private void secondaryAxisNeedsDecimal(double d, double d2) {
        for (Tick tick : this.baseTicks) {
            double d3 = d + tick.getLocation() / this.getOutRange().getRange() * (d2 - d);
            double d4 = this.scaleTransform.inverse(d3 = UnitConverter.convert(d3, this.inputUnit, this.getTicksUnit()));
            if (d4 - Math.floor(d4) == 0.0) continue;
            this.needDec = true;
            break;
        }
    }

    public abstract ContinuousScaleSpan makeCopyWithoutTickInfo();

    public boolean isNumDomainDefinedInSpec() {
        return this.numDomainDefinedInSpec;
    }

    public void setNumDomainDefinedInSpec(boolean bl) {
        this.numDomainDefinedInSpec = bl;
    }

    public List<Tick> getBaseTicks() {
        return this.baseTicks;
    }

    public void setBaseTicks(List<Tick> list) {
        this.baseTicks = list;
    }
}

