/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.scale.Axis;
import com.ibm.vis.engine.internal.grammar.scale.GridLineBuilder;
import com.ibm.vis.engine.internal.grammar.scale.GridShape;
import com.ibm.vis.engine.internal.grammar.scale.GridShapeBuilder;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.PolyShape;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeFactory2;
import com.ibm.vis.engine.internal.struct.ShapeLine;
import com.ibm.vis.engine.internal.struct.WedgeShape;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.geom.Wedge;
import com.ibm.vis.scenetree.internal.GroupSceneNode;
import com.ibm.vis.spec.internal.GridBandSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.LinkedHashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GridBandBuilder
extends GridShapeBuilder {
    private static final String GRID_BAND_IDENTIFIER = "B";

    public GridBandBuilder(Coordinates coordinates, Dim dim, Axis axis) {
        super(coordinates, dim, axis);
    }

    @Override
    public void makeGridShapes(String string, GroupSceneNode groupSceneNode) {
        GridLineBuilder gridLineBuilder = new GridLineBuilder(this.coordinates, this.coordinateExtent, this.axis);
        LinkedHashMap<Integer, List<GridShape>> linkedHashMap = gridLineBuilder.makeGridLinesForBands();
        this.makeGridBands(linkedHashMap, string, groupSceneNode);
    }

    protected void makeGridBands(LinkedHashMap<Integer, List<GridShape>> linkedHashMap, String string, GroupSceneNode groupSceneNode) {
        int n = 0;
        for (int i = 0; i < this.axisDrawCount; ++i) {
            List<GridShape> list = linkedHashMap.get(i);
            if (list == null || list.size() <= 1) continue;
            for (int j = 0; j < list.size() - 1; ++j) {
                Shape shape;
                GridShape gridShape = list.get(j);
                GridShape gridShape2 = list.get(j + 1);
                Shape shape2 = gridShape.shape;
                Shape shape3 = gridShape2.shape;
                if (gridShape.scaleSpan != gridShape2.scaleSpan || (shape = this.makeBandBetween(shape2, shape3, this.getGridBandFillStyleForIndex(n))) == null) continue;
                String string2 = this.makeSceneItemId(i, n++);
                shape.setID(string + string2);
                groupSceneNode.addChild(shape.createSceneNode());
            }
        }
    }

    @Override
    protected String getShapeIdentifier() {
        return GRID_BAND_IDENTIFIER;
    }

    protected Shape makeBandBetween(Shape shape, Shape shape2, StyleSpec styleSpec) {
        if (this.isWedgeBandsRequired()) {
            return this.makeWedgeBands(shape, shape2, styleSpec);
        }
        return GridBandBuilder.makeNormalBands(shape, shape2, styleSpec);
    }

    private static Shape makeNormalBands(Shape shape, Shape shape2, StyleSpec styleSpec) {
        if (shape instanceof PolyShape && shape2 instanceof PolyShape) {
            int n;
            PolyShape polyShape = (PolyShape)shape;
            PolyShape polyShape2 = (PolyShape)shape2;
            if (GridBandBuilder.hasCurves(polyShape.getTypes()) || GridBandBuilder.hasCurves(polyShape2.getTypes())) {
                throw new EngineException("GridBand creation when grid lines are curved Path is not supported.", ErrorCode.ENGINE_UNSUPPORTED_OPERATION, "GridBandBuilder");
            }
            double[] dArray = new double[polyShape.getXArray().length * 2 + 1];
            double[] dArray2 = new double[polyShape.getYArray().length * 2 + 1];
            int n2 = 0;
            for (n = 0; n < polyShape.getXArray().length; ++n) {
                dArray[n2] = polyShape.getXArray()[n];
                dArray2[n2] = polyShape.getYArray()[n];
                ++n2;
            }
            for (n = polyShape2.getXArray().length - 1; n >= 0; --n) {
                dArray[n2] = polyShape2.getXArray()[n];
                dArray2[n2] = polyShape2.getYArray()[n];
                ++n2;
            }
            dArray[n2] = polyShape.getXArray()[0];
            dArray2[n2] = polyShape.getYArray()[0];
            return ItemBuilder.makePoly(dArray, dArray2, styleSpec);
        }
        return null;
    }

    private static boolean hasCurves(char[] cArray) {
        if (cArray == null) {
            return false;
        }
        for (char c : cArray) {
            if (c == 'M' || c == 'L') continue;
            return true;
        }
        return false;
    }

    private Shape makeWedgeBands(Shape shape, Shape shape2, StyleSpec styleSpec) {
        if (this.drawPosition == 0) {
            if (shape.getGeom().type() == 1006 && shape2.getGeom().type() == 1006) {
                Point point;
                Wedge wedge = (Wedge)shape.getGeom();
                Wedge wedge2 = (Wedge)shape2.getGeom();
                Point point2 = new Point(wedge.getOrigin().getX(), wedge.getOrigin().getY());
                if (point2.equals(point = new Point(wedge2.getOrigin().getX(), wedge2.getOrigin().getY()))) {
                    double d = Math.min(wedge.getR2(), wedge2.getR2());
                    double d2 = Math.max(wedge.getR2(), wedge2.getR2());
                    WedgeShape wedgeShape = ShapeFactory2.createWedge(point2.getX(), point2.getY(), d, d2, 0.0, Math.PI * 2);
                    StyleBuilder.setFilled(wedgeShape, styleSpec);
                    return wedgeShape;
                }
            }
        } else if (this.drawPosition == 1 && shape instanceof ShapeLine && shape2 instanceof ShapeLine) {
            ShapeLine shapeLine = (ShapeLine)shape;
            ShapeLine shapeLine2 = (ShapeLine)shape2;
            Point point = new Point(shapeLine.getXArray()[1], shapeLine.getYArray()[1]);
            Point point3 = new Point(shapeLine2.getXArray()[1], shapeLine2.getYArray()[1]);
            assert (point.equals(point3));
            double d = 0.0;
            double d3 = shapeLine.getLength();
            double d4 = this.getClockWiseAngleWithHorizontal(shapeLine);
            double d5 = this.getClockWiseAngleWithHorizontal(shapeLine2);
            if (d5 < d4) {
                d5 += Math.PI * 2;
            }
            WedgeShape wedgeShape = ShapeFactory2.createWedge(point.getX(), point.getY(), d, d3, d4, d5);
            StyleBuilder.setFilled(wedgeShape, styleSpec);
            return wedgeShape;
        }
        return null;
    }

    private double getClockWiseAngleWithHorizontal(ShapeLine shapeLine) {
        return Math.PI + shapeLine.getTangentAngle("start", null);
    }

    protected boolean isWedgeBandsRequired() {
        return this.coordinates.isValidRadar() && !this.coordinates.isStraightPolarGridLine();
    }

    private StyleSpec getGridBandFillStyleForIndex(int n) {
        StyleSpec styleSpec = new StyleSpec();
        if (this.axisSpec.gridBand != null) {
            GridBandSpec gridBandSpec = this.axisSpec.gridBand;
            if (gridBandSpec.fill != null && gridBandSpec.fill.length > 0 && n >= 0) {
                int n2 = gridBandSpec.fill.length;
                styleSpec.fill = gridBandSpec.fill[n % n2];
            }
        }
        return styleSpec;
    }
}

