/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.scale.Axis;
import com.ibm.vis.engine.internal.grammar.scale.GridShape;
import com.ibm.vis.engine.internal.grammar.scale.GridShapeBuilder;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.Tick;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.engine.internal.struct.ShapeLine;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.scenetree.internal.GroupSceneNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class GridLineBuilder
extends GridShapeBuilder {
    private static final String GRID_LINE_IDENTIFIER = "G";

    public GridLineBuilder(Coordinates coordinates, Dim dim, Axis axis) {
        super(coordinates, dim, axis);
    }

    @Override
    public void makeGridShapes(String string, GroupSceneNode groupSceneNode) {
        List<Tick> list = this.axis.getTicks();
        for (int i = 0; i < this.axisDrawCount; ++i) {
            for (int j = 0; j < list.size(); ++j) {
                Shape shape = this.makeGridLineForTickIndex(list, j, i, this.axisSpec.method);
                if (shape == null) continue;
                this.addGridShapeToScene(string, groupSceneNode, i, j, shape);
            }
        }
    }

    public LinkedHashMap<Integer, List<GridShape>> makeGridLinesForBands() {
        LinkedHashMap<Integer, List<GridShape>> linkedHashMap = new LinkedHashMap<Integer, List<GridShape>>();
        for (int i = 0; i < this.axisDrawCount; ++i) {
            ArrayList<GridShape> arrayList = new ArrayList<GridShape>();
            List<Tick> list = GridLineBuilder.cloneTicks(this.axis.getTicks());
            for (int j = 0; j < list.size(); ++j) {
                Shape shape = this.makeGridLineForTickIndex(list, j, i, this.axisSpec.method);
                if (shape == null) continue;
                String string = this.makeSceneItemId(i, j);
                ScaleSpan scaleSpan = null;
                Tick tick = list.get(j);
                scaleSpan = tick.getSpan();
                GridShape gridShape = new GridShape(j, i, shape, scaleSpan, string);
                arrayList.add(gridShape);
            }
            if (this.dummyTickRequiredAtExtent(list, this.axisSpec.method)) {
                this.makeDummyTickAtExtent(list, this.axisSpec.method);
                this.makeGridShapeForDummyTick(i, arrayList, list, list.size() - 1, false);
            }
            if (this.dummyTickRequiredAtOrigin(list, this.axisSpec.method)) {
                this.makeDummyTickAtOrigin(list, this.axisSpec.method);
                this.makeGridShapeForDummyTick(i, arrayList, list, list.size() - 1, true);
            }
            linkedHashMap.put(i, arrayList);
        }
        return linkedHashMap;
    }

    private void makeGridShapeForDummyTick(int n, List<GridShape> list, List<Tick> list2, int n2, boolean bl) {
        Shape shape = this.makeGridLineForTickIndex(list2, n2, n, null);
        if (shape != null) {
            String string = this.makeSceneItemId(n, n2);
            ScaleSpan scaleSpan = null;
            Tick tick = list2.get(list2.size() - 1);
            scaleSpan = tick.getSpan();
            GridShape gridShape = new GridShape(n2, n, shape, scaleSpan, string);
            if (bl) {
                list.add(0, gridShape);
            } else {
                list.add(gridShape);
            }
        }
    }

    private static List<Tick> cloneTicks(List<Tick> list) {
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        arrayList.addAll(list);
        return arrayList;
    }

    private boolean dummyTickRequiredAtOrigin(List<Tick> list, String string) {
        if (this.coordinates.containsCluster()) {
            return false;
        }
        boolean bl = false;
        if ("between".equals(string)) {
            bl = true;
        } else if (!Tick.isZeroth(0, list.get(0)) || this.skipGridShape(0, list, string)) {
            bl = true;
            if (this.coordinates.insideAxes) {
                bl = this.drawPosition == 0;
            }
        }
        return bl;
    }

    private Tick makeDummyTickAtOrigin(List<Tick> list, String string) {
        Tick tick = null;
        tick = this.coordinates.containsTranspose() && "between".equals(string) && this.drawPosition == 0 ? new Tick(null, 1.0, 0.0, list.get(0).getSpan()) : new Tick(null, 0.0, 0.0, list.get(0).getSpan());
        list.add(tick);
        return tick;
    }

    private boolean dummyTickRequiredAtExtent(List<Tick> list, String string) {
        if (this.coordinates.containsCluster()) {
            return false;
        }
        boolean bl = false;
        if ("between".equals(string)) {
            bl = true;
        } else {
            int n = list.size() - 1;
            boolean bl2 = this.drawPosition == 0;
            Tick tick = list.get(n);
            if (!tick.isTickAtExtent(bl2, this.coordinateExtent)) {
                bl = true;
            }
        }
        return bl;
    }

    private Tick makeDummyTickAtExtent(List<Tick> list, String string) {
        Tick tick = null;
        tick = this.coordinates.insideAxes && this.drawPosition == 1 ? list.get(0) : (this.coordinates.containsTranspose() && "between".equals(string) && this.drawPosition == 0 ? new Tick(null, 0.0, 0.0, list.get(list.size() - 1).getSpan()) : new Tick(null, 1.0, 0.0, list.get(list.size() - 1).getSpan()));
        list.add(tick);
        return tick;
    }

    @Override
    protected String getShapeIdentifier() {
        return GRID_LINE_IDENTIFIER;
    }

    private Shape makeGridLineForTickIndex(List<Tick> list, int n, int n2, String string) {
        if (this.skipGridShape(n, list, string) || this.coordinateExtent.getWidth() <= 0.0 || this.coordinateExtent.getHeight() <= 0.0) {
            return null;
        }
        Tick tick = list.get(n);
        if (this.coordinates.insideAxes) {
            return this.makeShapeForInsideAxes(tick);
        }
        if (this.isHorizontalClusterAxis()) {
            return this.makeShapeForHorizontalClusterAxis(list, n, n2);
        }
        if (this.drawPosition == 0) {
            double d;
            if (this.coordinates.containsTranspose() && "between".equals(string)) {
                Range range = this.axis.makeParallelSpanForTick(list, n, this.coordinateExtent, n2);
                d = 1.0 - range.getMin() / this.coordinateExtent.getWidth();
            } else {
                d = tick.location;
            }
            double d2 = (1.0 - d) * this.coordinateExtent.getHeight();
            return ItemBuilder.makeLine(0.0, d2, this.coordinateExtent.getWidth(), d2, this.axisSpec.gridStyle);
        }
        Range range = this.axis.makeParallelSpanForTick(list, n, this.coordinateExtent, n2);
        double d = "between".equals(string) ? range.getMin() : tick.location * this.coordinateExtent.getWidth();
        return ItemBuilder.makeLine(d, 0.0, d, -this.coordinateExtent.getHeight(), this.axisSpec.gridStyle);
    }

    private boolean isHorizontalClusterAxis() {
        return this.coordinates.containsCluster() && (this.drawPosition == 1 || this.drawPosition == 0 && this.coordinates.containsTranspose());
    }

    private void addGridShapeToScene(String string, GroupSceneNode groupSceneNode, int n, int n2, Shape shape) {
        String string2 = this.makeSceneItemId(n, n2);
        shape.setID(string + string2);
        this.axis.addInfo(shape, n2, n);
        groupSceneNode.addChild(shape.createSceneNode());
    }

    private boolean skipGridShape(int n, List<Tick> list, String string) {
        Tick tick = list.get(n);
        if (Tick.isZeroth(n, tick)) {
            return !this.coordinates.isValidRadar() || this.drawPosition != 1;
        }
        return "between".equals(string) && n == 0;
    }

    private Shape makeShapeForInsideAxes(Tick tick) {
        ShapeLine shapeLine = null;
        if (this.isStraightPolarGridLine()) {
            double[] dArray = Tick.getTicksLocation(this.coordinates.axes[1].getTicks(), this.coordinateExtent, false);
            double d = tick.getLocationMappedToExtent(this.coordinateExtent, true);
            return this.axis.makeStraightPolarGridLine(dArray, d, this.coordinateExtent, this.axisSpec.gridStyle);
        }
        if (this.axis.isRadialYAxis()) {
            double d = tick.getLocationMappedToExtent(this.coordinateExtent, true);
            shapeLine = ItemBuilder.makeLine(0.0, d, this.coordinateExtent.getWidth(), d, this.axisSpec.gridStyle);
        } else {
            double d = tick.getLocationMappedToExtent(this.coordinateExtent, false);
            shapeLine = ItemBuilder.makeLine(d, 0.0, d, this.coordinateExtent.getHeight(), this.axisSpec.gridStyle);
        }
        if (shapeLine != null) {
            return this.coordinates.modifyShape(shapeLine, this.coordinateExtent);
        }
        return null;
    }

    private boolean isStraightPolarGridLine() {
        return this.coordinates.isStraightPolarGridLine() && this.drawPosition == 0;
    }

    private Shape makeShapeForHorizontalClusterAxis(List<Tick> list, int n, int n2) {
        Range range = this.axis.makeParallelSpanForTick(list, n, this.coordinateExtent, n2);
        double d = range.mid();
        double d2 = this.drawPosition == 0 ? this.coordinateExtent.getHeight() : -this.coordinateExtent.getHeight();
        ShapeLine shapeLine = ItemBuilder.makeLine(d, 0.0, d, d2, this.axisSpec.gridStyle);
        return this.axis.modifyShape(shapeLine, this.coordinateExtent, n, n2);
    }
}

