/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.grammar.coordinate.Coordinates;
import com.ibm.vis.engine.internal.grammar.scale.Axis;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.scenetree.internal.GroupSceneNode;
import com.ibm.vis.spec.internal.AxisSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class GridShapeBuilder {
    protected final Coordinates coordinates;
    protected final Dim coordinateExtent;
    protected final Axis axis;
    protected final int drawPosition;
    protected final int axisDrawCount;
    protected final AxisSpec axisSpec;

    public GridShapeBuilder(Coordinates coordinates, Dim dim, Axis axis) {
        assert (coordinates != null);
        assert (dim != null && dim.getWidth() >= 0.0 && dim.getHeight() >= 0.0);
        assert (axis != null);
        this.coordinates = coordinates;
        this.coordinateExtent = dim;
        this.axis = axis;
        this.drawPosition = axis.getDrawPosition();
        this.axisDrawCount = this.axis.getAxisDrawCount();
        this.axisSpec = this.axis.getAxisSpec();
    }

    public abstract void makeGridShapes(String var1, GroupSceneNode var2);

    protected abstract String getShapeIdentifier();

    protected String makeSceneItemId(int n, int n2) {
        String string = this.axisDrawCount > 1 ? n + "_" + n2 : "" + n2;
        return this.getShapeIdentifier() + string;
    }
}

