/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.format.RAVEFormatter;
import com.ibm.vis.engine.internal.grammar.scale.ContinuousScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.ScaleFitInfo;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.exceptions.internal.SpecException;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class LogScaleSpan
extends ContinuousScaleSpan {
    public LogScaleSpan(Unit unit, Integer n, ScaleFitInfo scaleFitInfo, RAVEFormatter rAVEFormatter, VisContext visContext, Range range, String string, Number number, Number number2, Range range2, Field field, boolean bl, boolean bl2) {
        super(unit, n, scaleFitInfo, rAVEFormatter, visContext, range, string, number, number2, range2, field, bl, bl2);
        LogScaleSpan.verifySpecRange(range2);
    }

    private static void verifySpecRange(Range range) throws SpecException {
        if (!LogScaleSpan.isValidRange(range)) {
            throw new SpecException("The minimum and maximum value of a logarithmic span must be greater than 0.", ErrorCode.SPEC_INVALID_VALUE, null);
        }
    }

    @Override
    protected void makeNumericSpanDetails(int n, int n2) {
        Range range;
        this.verifyInputNumDomain();
        Range range2 = this.expandInitialRange(this.getInputNumDomain());
        Range range3 = this.calculateTickRange(n, n2, range2);
        this.calculateTickDomain(range3);
        if (this.centreSingleTick()) {
            range = UnitConverter.convertRange(range3, this.getTicksUnit(), this.inputUnit);
        } else if (this.fitInfo.canExpand()) {
            range = this.ensureNiceRange();
            Range range4 = UnitConverter.convertRange(range, this.getTicksUnit(), this.inputUnit);
            range = this.fitInfo.finalizeRange(range2, range4, this.scaleTransform);
        } else {
            range = this.getInputNumDomain();
        }
        this.setModifiedInputNumDomain(range);
        this.scaleTransform.setRange(this.getModifiedInputNumDomain());
    }

    @Override
    protected void verifyInputNumDomain() throws EngineException {
        if (!LogScaleSpan.isValidRange(this.getInputNumDomain())) {
            throw new EngineException("Data that is less than or equal to 0 can't be used with a logarithmic span.", ErrorCode.ENGINE_LOG_INVALID_DATA, null);
        }
    }

    private static boolean isValidRange(Range range) {
        return !(range.getMin() <= 0.0) && !(range.getMax() <= 0.0);
    }

    private static double getPowerOfTen(double d, boolean bl) {
        return bl ? Math.floor(Math.log(d) / Math.log(10.0)) : Math.ceil(Math.log(d) / Math.log(10.0));
    }

    @Override
    protected double calculateTickDelta(int n, int n2, Range range) {
        double d;
        assert (n != 0);
        assert (n2 != 0);
        double d2 = LogScaleSpan.getPowerOfTen(range.getMin(), true);
        double d3 = LogScaleSpan.getPowerOfTen(range.getMax(), false);
        double d4 = d3 - d2;
        if (d4 == 0.0) {
            d4 = d2 == 0.0 ? 1.0 : Math.abs(d2);
        }
        double d5 = Math.ceil(d4 / (double)n);
        if (!this.fitInfo.canExpand() && d5 > (d = Math.ceil(d4 / (double)n2))) {
            d5 = d;
        }
        return d5;
    }

    @Override
    protected Range makeRangeAbout(double d) {
        double d2 = 0.999999;
        return new Range(d * d2, d / d2);
    }

    @Override
    public ContinuousScaleSpan makeCopyWithoutTickInfo() {
        return new LogScaleSpan(this.inputUnit, null, this.fitInfo, this.specifiedFormatter, this.visContext, this.getOutRange(), this.transformMethod, null, this.minorDivisions, this.inputNumDomain, this.dataField, this.hasUnitDefinedInSpec, this.isNumDomainDefinedInSpec());
    }

    @Override
    public boolean areCompatible(ScaleSpan scaleSpan) {
        if (this == scaleSpan) {
            return true;
        }
        if (!(scaleSpan instanceof LogScaleSpan)) {
            return false;
        }
        LogScaleSpan logScaleSpan = (LogScaleSpan)scaleSpan;
        return this.inputUnit.equals(logScaleSpan.inputUnit) && this.inputNumDomain.equals(logScaleSpan.inputNumDomain);
    }
}

