/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class MultiplierInfo {
    public final double multiplier;
    final double coverage;
    final int gapCount;

    public MultiplierInfo(Range range, double d, double d2, boolean bl) {
        assert (d2 > 0.0);
        this.multiplier = d2;
        double d3 = d2 * d;
        double d4 = Math.floor(range.getMin() / d3);
        if (!bl && d3 * d4 < range.getMin()) {
            d4 += 1.0;
        }
        double d5 = Math.floor(range.getMax() / d3);
        if (bl && range.getMax() > d3 * d5) {
            d5 += 1.0;
        }
        if (d5 <= d4) {
            this.gapCount = 0;
            this.coverage = 999.0;
        } else {
            this.gapCount = (int)Math.round(d5 - d4);
            double d6 = range.getRange() / ((d5 - d4) * d3);
            this.coverage = d6 > 1.0 ? d6 - 1.0 : 1.0 / d6 - 1.0;
        }
    }

    public boolean isBetterThan(MultiplierInfo multiplierInfo, int n, int n2) {
        if (this.gapCount != multiplierInfo.gapCount) {
            if (this.gapCount > n2) {
                return this.gapCount < multiplierInfo.gapCount;
            }
            if (multiplierInfo.gapCount > n2) {
                return true;
            }
        }
        if (Math.abs(this.coverage - multiplierInfo.coverage) > 0.3) {
            return this.coverage < multiplierInfo.coverage;
        }
        double d = this.gapCount - n;
        double d2 = multiplierInfo.gapCount - n;
        if (d < 0.0) {
            d = -2.1 * d;
        }
        if (d2 < 0.0) {
            d2 = -2.1 * d2;
        }
        if (d != d2) {
            return d < d2;
        }
        return this.coverage < multiplierInfo.coverage;
    }
}

