/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.scale.CategoricalScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.ContinuousScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.ScaleGeometry;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpanByUnitComparator;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpanComparator;
import com.ibm.vis.engine.internal.grammar.scale.Tick;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.grammar.units.UnitMatchingCodes;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.struct.Insets;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.spec.internal.PaddingSpec;
import com.ibm.vis.spec.internal.ScaleSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2015\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Scale {
    public final ArrayList<ScaleSpan> spans;
    private ArrayList<ScaleSpan> spansSortedByOutRangeCache;
    public Boolean localScale;
    private List<Tick> ticks;
    public boolean reverse;
    private boolean drawnMultiple;
    private List<Tick> ticksForData;
    private List<Tick> allTicks;
    private Object padding;
    private final Dim visSize;
    private final ScaleSpec spec;
    private Dim maxTickLabelSizeCache = new Dim(0.0, 0.0);
    private ScaleSpan simpleScaleSpan;
    private Map<String, ArrayList<ScaleSpan>> sortedSpansByUnit;
    private Range paddedRange;
    private Range outRange = Range.ZERO_ONE;

    public final Range getOutRange() {
        return this.outRange;
    }

    public Scale(ScaleSpec scaleSpec, Dim dim) {
        this.visSize = dim;
        this.spec = scaleSpec;
        this.spans = new ArrayList();
        this.reverse = false;
        this.drawnMultiple = false;
        this.localScale = false;
        if (scaleSpec != null) {
            if (scaleSpec.reverse != null) {
                this.reverse = scaleSpec.reverse;
            }
            if (scaleSpec.local != null) {
                this.localScale = scaleSpec.local;
            }
            if (scaleSpec.padding != null) {
                this.padding = scaleSpec.padding;
            }
        }
    }

    public void addSpan(ScaleSpan scaleSpan) {
        this.spans.add(scaleSpan);
        this.simpleScaleSpan = this.spans.size() == 1 ? scaleSpan : null;
        this.spansSortedByOutRangeCache = null;
        this.sortedSpansByUnit = null;
    }

    public void setDrawnMultiple(boolean bl) {
        this.drawnMultiple = bl;
    }

    static double getDefaultElementSizeWithNoScaleInfo(double d) {
        return Math.max(5.0, (double)Math.round(d * 0.03));
    }

    public double getDefaultElementSize(double d, ValueProvider valueProvider, String string) {
        double d2 = Double.POSITIVE_INFINITY;
        boolean bl = this.spans.size() > 1;
        for (ScaleSpan scaleSpan : this.spans) {
            if (!scaleSpan.isApplicable(valueProvider.getUnit())) continue;
            scaleSpan.setPreTransformSpanLength(d);
            Double d3 = scaleSpan.getSuggestedElementSize(d, valueProvider.getGranularity());
            if (bl && scaleSpan instanceof ContinuousScaleSpan) {
                scaleSpan.setSuggestedSize(d3);
            }
            if (d3 == null) continue;
            d2 = Math.min(d2, d3);
        }
        if (!Double.isInfinite(d2)) {
            return d2;
        }
        if (string != null && !string.equals("text") && (this.isCategorical() || this.spans.isEmpty())) {
            return d;
        }
        return Scale.getDefaultElementSizeWithNoScaleInfo(d);
    }

    public double getMininalDistance(double d, ValueProvider valueProvider) {
        double d2 = d;
        for (ScaleSpan scaleSpan : this.spans) {
            if (!scaleSpan.isApplicable(valueProvider.getUnit())) continue;
            scaleSpan.setPreTransformSpanLength(d);
            Double d3 = valueProvider.getMinimalDataDiff();
            if (d3 == null || Double.isNaN(d3) || !(d3 > 0.0) || scaleSpan.getAdjustedInputRange() == null) continue;
            d2 = Math.min(d2, d * d3 * scaleSpan.getOutRange().getRange() / scaleSpan.getAdjustedInputRange().getRange());
        }
        return d2;
    }

    double getDataMaxValue() {
        double d = Double.NEGATIVE_INFINITY;
        for (ScaleSpan scaleSpan : this.spans) {
            d = Math.max(d, scaleSpan.getDataMaxValue());
        }
        return d;
    }

    Dim getMaxTickLabelSize(Font font) {
        if (Scale.hasSize(this.maxTickLabelSizeCache)) {
            return this.maxTickLabelSizeCache;
        }
        double d = 0.0;
        double d2 = 0.0;
        for (ScaleSpan scaleSpan : this.spans) {
            Dim dim = scaleSpan.getMaxTickLabelSize(font);
            d = Math.max(d, dim.getWidth());
            d2 = Math.max(d2, dim.getHeight());
        }
        this.maxTickLabelSizeCache = new Dim(d, d2);
        return this.maxTickLabelSizeCache;
    }

    public static boolean hasSize(Dim dim) {
        double d = Math.max(0.0, dim.getWidth()) * Math.max(0.0, dim.getHeight());
        return !Double.isNaN(dim.getWidth()) && !Double.isNaN(dim.getHeight()) && !Double.isNaN(d) && d != 0.0;
    }

    public Dim getTicksBasedMaxSize(Font font, List<Tick> list, VisContext visContext) {
        double d = 0.0;
        double d2 = 0.0;
        for (Tick tick : list) {
            TextContent textContent = tick.getContent();
            Text text = ItemBuilder.makeText(textContent, 0.0, 0.0, "start", "middleOfFirstLine", font, null, null, new Dim(Double.MAX_VALUE, Double.MAX_VALUE), false, null, visContext.getNumericShapingInfo(), visContext.getTooltipsForTruncatedText());
            if (text == null) continue;
            d = Math.max(text.calculateTextWidth(), d);
            d2 = Math.max(text.getHeight(), d2);
        }
        return new Dim(d, d2);
    }

    private Insets getPaddingAsInsets(ScaleGeometry scaleGeometry) {
        Insets insets = null;
        if (this.padding != null) {
            Object object;
            double d;
            double d2 = d = scaleGeometry.isYAxis ? this.visSize.getHeight() : this.visSize.getWidth();
            if (this.padding instanceof PaddingSpec) {
                object = (PaddingSpec)this.padding;
                if (((PaddingSpec)object).top != null || ((PaddingSpec)object).bottom != null) {
                    throw new SpecException("Scale Padding does not support \"top\" and \"bottom\" attributes.Please use \"left\" and \"right\" attributes instead.", ErrorCode.SPEC_INVALID_VALUE, this.padding.toString());
                }
            }
            object = new Dim(scaleGeometry.len, scaleGeometry.len);
            Dim dim = new Dim(d, d);
            insets = Insets.makeForStylePadding(this.padding, (Dim)object, dim);
        }
        return insets;
    }

    Range computePaddedOutRange(ScaleGeometry scaleGeometry) {
        double d = 0.0;
        double d2 = 0.0;
        Insets insets = null;
        if (this.padding != null && this.paddedRange == null) {
            insets = this.getPaddingAsInsets(scaleGeometry);
            if (insets == null) {
                String string = "\"padding\": ";
                throw new SpecException("", ErrorCode.SPEC_INVALID_LENGTH, string + this.padding);
            }
            d = insets.left / scaleGeometry.len;
            d2 = insets.right / scaleGeometry.len;
            if (d + d2 > 1.0) {
                String string = "\"padding\": ";
                throw new EngineException("Invalid padding on scale (left and right padding exceeds 100% of available space)", ErrorCode.ENGINE_LAYOUT_DOES_NOT_FIT, string + this.padding);
            }
            this.paddedRange = new Range(d, 1.0 - d2);
        }
        return this.paddedRange;
    }

    private ArrayList<ScaleSpan> getSpansSortedByOutRange() {
        if (this.spansSortedByOutRangeCache == null) {
            this.spansSortedByOutRangeCache = new ArrayList<ScaleSpan>(this.spans);
            BasicFactory.sortList(this.spansSortedByOutRangeCache, new ScaleSpanComparator());
        }
        return this.spansSortedByOutRangeCache;
    }

    public void initializeForDisplayableExtent(ScaleGeometry scaleGeometry) {
        this.initializeOutRange(scaleGeometry);
        ArrayList<ScaleSpan> arrayList = this.getSpansSortedByOutRange();
        ScaleSpan scaleSpan = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            scaleSpan = arrayList.get(i);
            double d = i == 0 ? this.outRange.getMin() : 0.0;
            double d2 = i == arrayList.size() - 1 ? 1.0 - this.outRange.getMax() : 0.0;
            scaleSpan.prepareOutRange(this.outRange, d, d2);
            scaleSpan.setupForExtent(scaleGeometry);
        }
        this.ticks = this.makeTicks();
    }

    private void initializeOutRange(ScaleGeometry scaleGeometry) {
        this.outRange = scaleGeometry.getOutRange();
        Range range = this.computePaddedOutRange(scaleGeometry);
        if (range != null) {
            this.outRange = range.remap(this.outRange);
        }
    }

    public void initializeForRequiredTickCount(Integer n) {
        for (ScaleSpan scaleSpan : this.spans) {
            int n2 = scaleSpan.desiredTicks != null ? scaleSpan.desiredTicks : (n != null ? n : (int)Math.round(5.0 / (double)this.spans.size()));
            scaleSpan.setupForTickCount(n2, n2 * 2);
        }
        this.ticks = this.makeTicks();
    }

    List<Tick> makeMinorTicksForSpans(ArrayList<ScaleSpan> arrayList) {
        ArrayList<Object> arrayList2 = new ArrayList();
        arrayList2 = arrayList == null ? this.spans : arrayList;
        ArrayList<Tick> arrayList3 = new ArrayList<Tick>();
        if (this.ticks.size() > 1 && arrayList2 != null) {
            for (ScaleSpan scaleSpan : arrayList2) {
                scaleSpan.addMinorTicks(arrayList3);
            }
            if (this.reverse) {
                Scale.reverseTicks(arrayList3);
            }
        }
        return arrayList3;
    }

    private static void reverseTicks(List<Tick> list) {
        for (Tick tick : list) {
            tick.location = 1.0 - tick.location;
        }
    }

    private List<Tick> makeTicks() {
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        for (ScaleSpan scaleSpan : this.spans) {
            if (scaleSpan instanceof CategoricalScaleSpan) {
                CategoricalScaleSpan categoricalScaleSpan = (CategoricalScaleSpan)scaleSpan;
                categoricalScaleSpan.setReversed(this.reverse);
                categoricalScaleSpan.setDrawnMultiple(this.drawnMultiple);
            }
            scaleSpan.addTicks(arrayList, false);
        }
        if (this.reverse) {
            Scale.reverseTicks(arrayList);
        }
        if (this.localScale.booleanValue()) {
            this.ticksForData = arrayList;
        }
        return arrayList;
    }

    private List<List<Tick>> makeTicksForSpans(ArrayList<ScaleSpan> arrayList) {
        ArrayList<ScaleSpan> arrayList2 = new ArrayList<ScaleSpan>(arrayList);
        BasicFactory.sortList(arrayList2, new ScaleSpanComparator());
        ArrayList<List<Tick>> arrayList3 = new ArrayList<List<Tick>>();
        for (ScaleSpan object : arrayList2) {
            ArrayList<Tick> arrayList4 = new ArrayList<Tick>();
            object.addTicks(arrayList4, false);
            if (this.reverse) {
                Scale.reverseTicks(arrayList4);
            }
            arrayList3.add(arrayList4);
        }
        if (this.localScale.booleanValue()) {
            this.ticksForData = new ArrayList<Tick>();
            for (List list : arrayList3) {
                this.ticksForData.addAll(list);
            }
        }
        return arrayList3;
    }

    int computeTickCountForExtent(ScaleGeometry scaleGeometry) {
        this.maxTickLabelSizeCache = new Dim(0.0, 0.0);
        int n = 0;
        for (ScaleSpan scaleSpan : this.spans) {
            scaleSpan.setupForExtent(scaleGeometry);
            n += scaleSpan.computeTickCount();
        }
        return n;
    }

    public List<Tick> getTicks() {
        return this.ticks;
    }

    List<List<Tick>> getTicksForSpans(ArrayList<ScaleSpan> arrayList) {
        return this.makeTicksForSpans(arrayList);
    }

    public List<Tick> getAllTicks() {
        if (this.allTicks == null) {
            this.allTicks = new ArrayList<Tick>();
            for (ScaleSpan scaleSpan : this.spans) {
                scaleSpan.addAllTicks(this.allTicks, false);
            }
            if (this.reverse) {
                Scale.reverseTicks(this.allTicks);
            }
        }
        return this.allTicks;
    }

    public Double toZeroOne(double d, Unit unit, Integer n) {
        Double d2;
        if (Double.isNaN(d)) {
            return null;
        }
        if (n != null && this.isSpanToUseValid(unit, n)) {
            Double d3 = this.spans.get(n).toZeroOne(d, unit, false);
            if (d3 != null) {
                return this.reverse ? 1.0 - d3 : d3;
            }
            return null;
        }
        ScaleSpan scaleSpan = this.simpleScaleSpan;
        if (scaleSpan == null) {
            scaleSpan = this.getMatchingSpan(d, unit);
        }
        if (scaleSpan != null && (d2 = scaleSpan.toZeroOne(d, unit, false)) != null) {
            return this.reverse ? 1.0 - d2 : d2;
        }
        return null;
    }

    boolean isSpanToUseValid(Unit unit, Integer n) {
        if (n < 0 || n >= this.spans.size()) {
            throw new SpecException("span index \"" + n + "\" does not exist", ErrorCode.SPEC_INVALID_VALUE, null);
        }
        if (this.spans.get(n).isApplicable(unit)) {
            return true;
        }
        throw new SpecException("span unit \"" + this.spans.get((int)n.intValue()).inputUnit + "\" does not match data unit \"" + unit.name + "\"", ErrorCode.SPEC_INVALID_VALUE, this.spec != null ? this.spec.toString() : null);
    }

    public double getSpanOrigin(Double d, Unit unit, Integer n) {
        if (d == null) {
            return this.reverse ? 1.0 : 0.0;
        }
        if (n != null && this.isSpanToUseValid(unit, n)) {
            return this.getOriginFromSpan(this.spans.get(n));
        }
        ScaleSpan scaleSpan = this.getMatchingSpan(d, unit);
        if (scaleSpan != null) {
            return this.getOriginFromSpan(scaleSpan);
        }
        return this.reverse ? 1.0 : 0.0;
    }

    private double getOriginFromSpan(ScaleSpan scaleSpan) {
        double d = 0.0;
        Double d2 = scaleSpan.toZeroOne(0.0, null, false);
        if (d2 != null) {
            d = d2;
        }
        return this.reverse ? 1.0 - d : d;
    }

    public ScaleSpan getSimpleScaleSpan() {
        return this.simpleScaleSpan;
    }

    public ScaleSpan getMatchingSpan(Number number, Unit unit) {
        ScaleSpan scaleSpan = this.simpleScaleSpan;
        if (scaleSpan != null) {
            return scaleSpan;
        }
        Double d = null;
        List<ScaleSpan> list = this.getSpansSortedByUnit(unit);
        for (ScaleSpan scaleSpan2 : list) {
            if (!scaleSpan2.isUnitApplicable(number, unit)) continue;
            double d2 = 0.0;
            double d3 = unit != null ? UnitConverter.convert(number.doubleValue(), unit, scaleSpan2.inputUnit) : number.doubleValue();
            Range range = scaleSpan2.getAdjustedInputRange();
            if (range.contains(d3)) {
                return scaleSpan2;
            }
            if (d3 < range.getMin()) {
                d2 = range.getMin() - d3;
            } else if (d3 > range.getMax()) {
                d2 = d3 - range.getMax();
            }
            if (scaleSpan == null) {
                scaleSpan = scaleSpan2;
                d = d2;
                continue;
            }
            if (!(d2 < d)) continue;
            d = d2;
            scaleSpan = scaleSpan2;
        }
        return scaleSpan;
    }

    private List<ScaleSpan> getSpansSortedByUnit(Unit unit) {
        ArrayList<ScaleSpan> arrayList = null;
        if (unit != null) {
            if (this.sortedSpansByUnit == null) {
                this.sortedSpansByUnit = new HashMap<String, ArrayList<ScaleSpan>>();
            } else {
                arrayList = this.sortedSpansByUnit.get(unit.name);
            }
        }
        if (arrayList == null) {
            arrayList = new ArrayList<ScaleSpan>(this.spans);
            BasicFactory.sortList(arrayList, new ScaleSpanByUnitComparator(unit));
            if (unit != null) {
                this.sortedSpansByUnit.put(unit.name, arrayList);
            }
        }
        return arrayList;
    }

    public Double toZeroOneClamped(Number number, Unit unit) {
        if (number == null) {
            return null;
        }
        for (ScaleSpan scaleSpan : this.spans) {
            Double d = scaleSpan.toZeroOne(number, unit, true);
            if (d == null) continue;
            return this.reverse ? 1.0 - d : d;
        }
        return null;
    }

    public Double dimensionValueToDataValue(double d, double d2) {
        double d3 = d / d2;
        return this.zeroOneToDataValue(d3);
    }

    public double dimensionToDataValueInterpolate(double d, double d2) {
        double d3 = -1.0;
        if (this.spans.size() > 0) {
            double d4 = d / d2;
            if (this.reverse) {
                d4 = 1.0 - d4;
            }
            ScaleSpan scaleSpan = this.spans.get(0);
            if (scaleSpan.scaleTransform.getRange() != null) {
                double d5 = scaleSpan.getOutRange().toZeroOne(d4);
                d3 = scaleSpan.scaleTransform.getRange().fromZeroOne(d5);
            }
        }
        return d3;
    }

    public Double zeroOneToDataValue(double d) {
        if (this.reverse) {
            d = 1.0 - d;
        }
        for (ScaleSpan scaleSpan : this.spans) {
            if (!scaleSpan.getOutRange().contains(d)) continue;
            return scaleSpan.zeroOneToDataValue(d);
        }
        return null;
    }

    public void useValuesFrom(Scale scale) {
        ArrayList<ScaleSpan> arrayList = new ArrayList<ScaleSpan>();
        if (scale.spans.size() < 1) {
            return;
        }
        this.sortedSpansByUnit = null;
        if (this.spans.isEmpty()) {
            this.spans.addAll(scale.spans);
        } else {
            ScaleSpan scaleSpan;
            for (ScaleSpan scaleSpan2 : this.spans) {
                scaleSpan = Scale.findBestMatchingSpanFrom(scale, scaleSpan2.inputUnit);
                if (scaleSpan != null) {
                    scaleSpan2.getUndefinedParametersFrom(scaleSpan);
                    scaleSpan.setSpanMatching(true);
                }
                arrayList.add(scaleSpan2);
            }
            for (ScaleSpan scaleSpan2 : scale.spans) {
                if (scaleSpan2.isMatchingSpan()) continue;
                scaleSpan = Scale.findBestMatchingSpanFrom(this, scaleSpan2.inputUnit);
                if (scaleSpan != null) {
                    scaleSpan.adaptInputNumDomainFrom(scaleSpan2);
                    scaleSpan2.setSpanMatching(true);
                    continue;
                }
                arrayList.add(scaleSpan2);
            }
            this.spans.clear();
            this.spans.addAll(arrayList);
            this.spansSortedByOutRangeCache = null;
        }
        this.simpleScaleSpan = this.spans.size() == 1 ? this.spans.get(0) : null;
    }

    private static ScaleSpan findBestMatchingSpanFrom(Scale scale, Unit unit) {
        ScaleSpan scaleSpan = scale.getSpanWithUnitMatching(unit, UnitMatchingCodes.SYSTEM_MATCH);
        if (scaleSpan == null) {
            scaleSpan = scale.getSpanMatching(unit);
        }
        return scaleSpan;
    }

    public void checkSpansUnitMatching(Scale scale) {
        ScaleSpan scaleSpan = null;
        String string = "";
        String string2 = Scale.getScaleSpansUnitsString(this, "or");
        if (string2.equals("")) {
            return;
        }
        for (ScaleSpan scaleSpan2 : scale.spans) {
            scaleSpan = Scale.findBestMatchingSpanFrom(this, scaleSpan2.inputUnit);
            if (scaleSpan != null) continue;
            string = string + "Unit \"" + scaleSpan2.inputUnit.name + "\" could not be converted to " + string2 + ".\n";
        }
        if (!string.equals("")) {
            throw new SpecException(string, ErrorCode.SPEC_INVALID_VALUE, null);
        }
    }

    public static String getScaleSpansUnitsString(Scale scale, String string) {
        String string2 = "";
        int n = scale.spans.size() - 1;
        int n2 = 0;
        for (ScaleSpan scaleSpan : scale.spans) {
            if (n2 == n && n > 0) {
                string2 = string2 + " " + string + " ";
            } else if (n2 > 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + "\"" + scaleSpan.inputUnit.name + "\"";
            ++n2;
        }
        return string2;
    }

    private ScaleSpan getSpanMatching(Unit unit) {
        List<ScaleSpan> list = this.getSpansSortedByUnit(unit);
        for (ScaleSpan scaleSpan : list) {
            if (!scaleSpan.isApplicable(unit)) continue;
            return scaleSpan;
        }
        return null;
    }

    private ScaleSpan getSpanWithUnitMatching(Unit unit, UnitMatchingCodes unitMatchingCodes) {
        if (this.spans.size() > 0) {
            List<ScaleSpan> list = this.getSpansSortedByUnit(unit);
            ScaleSpan scaleSpan = list.get(0);
            if (scaleSpan.inputUnit.getMatchingLevel(unit).compareTo(unitMatchingCodes) >= 0) {
                return scaleSpan;
            }
        }
        return null;
    }

    public double getBase() {
        for (ScaleSpan scaleSpan : this.spans) {
            Double d = scaleSpan.getBase(this.reverse);
            if (d == null) continue;
            return d;
        }
        return 0.0;
    }

    public int getCategoryCount() {
        int n = 0;
        if (this.spans.get(0) instanceof CategoricalScaleSpan) {
            CategoricalScaleSpan categoricalScaleSpan = (CategoricalScaleSpan)this.spans.get(0);
            n = categoricalScaleSpan.getCategoryCount();
        }
        return n;
    }

    public Integer getScaleCategoryIndex(Number number, Unit unit) {
        ScaleSpan scaleSpan = this.getSpanMatching(unit);
        if (scaleSpan == null) {
            return null;
        }
        CategoricalScaleSpan categoricalScaleSpan = (CategoricalScaleSpan)scaleSpan;
        Integer n = categoricalScaleSpan.getScaleIndexFromFieldIndex(number);
        if (this.reverse && n != null) {
            n = categoricalScaleSpan.getCategoryCount() - 1 - n;
        }
        return n;
    }

    public Integer getFieldCategoryIndex(Integer n, Unit unit) {
        ScaleSpan scaleSpan = this.getSpanMatching(unit);
        if (scaleSpan == null) {
            return null;
        }
        CategoricalScaleSpan categoricalScaleSpan = (CategoricalScaleSpan)scaleSpan;
        if (this.reverse) {
            n = categoricalScaleSpan.getCategoryCount() - 1 - n;
        }
        Integer n2 = categoricalScaleSpan.getFieldIndexFromScaleIndex(n);
        return n2;
    }

    public List<Tick> getTicksForData() {
        if (this.ticksForData == null) {
            this.ticksForData = new ArrayList<Tick>();
            for (ScaleSpan scaleSpan : this.spans) {
                scaleSpan.addTicks(this.ticksForData, true);
            }
        }
        return this.ticksForData;
    }

    public void includeValue(double d) {
        if (this.spans.isEmpty() || this.isCategorical()) {
            return;
        }
        ContinuousScaleSpan continuousScaleSpan = (ContinuousScaleSpan)this.spans.get(0);
        continuousScaleSpan.setInputNumDomain(continuousScaleSpan.getInputNumDomain().unionValue(d));
    }

    public void defineSpanOutputRanges() {
        if (this.spans.isEmpty()) {
            return;
        }
        double d = 0.0;
        Unit unit = null;
        for (ScaleSpan scaleSpan : this.spans) {
            d += scaleSpan.getGoodDisplaySpanSize();
            if (unit != null && (!unit.measure.equals(scaleSpan.inputUnit.measure) || unit.measure.categorical)) {
                d += 1.0;
            }
            unit = scaleSpan.inputUnit;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        unit = null;
        for (ScaleSpan scaleSpan : this.spans) {
            double d4 = scaleSpan.getGoodDisplaySpanSize();
            if (unit != null && !unit.measure.categorical && unit.measure.equals(scaleSpan.inputUnit.measure)) {
                d2 = d3;
            }
            scaleSpan.setScaleOutRange(new Range(d2, d2 + d4 / d));
            d3 = d2 + d4 / d;
            d2 += (d4 + 1.0) / d;
            unit = scaleSpan.inputUnit;
        }
        this.spansSortedByOutRangeCache = null;
    }

    public Integer getCategoryIndexFromZeroOne(Double d, Unit unit) {
        ScaleSpan scaleSpan = this.getSpanMatching(unit);
        if (scaleSpan == null) {
            return null;
        }
        CategoricalScaleSpan categoricalScaleSpan = (CategoricalScaleSpan)scaleSpan;
        Integer n = categoricalScaleSpan.getIndexFromZeroOne(d);
        if (this.reverse && n != null) {
            n = categoricalScaleSpan.getCategoryCount() - 1 - n;
        }
        return n;
    }

    public boolean isCategorical() {
        return this.spans.size() == 1 && this.spans.get(0).getCategoryCount() > 0;
    }

    public final ArrayList<ScaleSpan> getSpans() {
        return this.spans;
    }

    public ArrayList<ArrayList<ScaleSpan>> makeSpanGroups() {
        ArrayList<ArrayList<ScaleSpan>> arrayList = new ArrayList<ArrayList<ScaleSpan>>();
        ArrayList<ScaleSpan> arrayList2 = new ArrayList<ScaleSpan>();
        ArrayList<ScaleSpan> arrayList3 = new ArrayList<ScaleSpan>();
        for (int i = 0; i < this.spans.size(); ++i) {
            ScaleSpan scaleSpan = this.spans.get(i);
            scaleSpan.addToGroup(arrayList2, arrayList3);
        }
        arrayList.add(arrayList2);
        arrayList.add(arrayList3);
        return arrayList;
    }

    public boolean isLocalUndefined() {
        return this.localScale == null || this.spec != null && this.spec.local == null;
    }

    public void validateOutRange() {
        boolean bl = this.isOutRangesDefined();
        for (int i = 0; i < this.spans.size(); ++i) {
            ScaleSpan scaleSpan = this.spans.get(i);
            if (scaleSpan.isOutRangeSetFromSpec() == null || scaleSpan.isOutRangeSetFromSpec() == bl) continue;
            throw new SpecException("All or no span should have outRange specified.", ErrorCode.SPEC_INVALID_VALUE, null);
        }
    }

    public boolean isOutRangesDefined() {
        if (this.spans.size() > 0) {
            for (ScaleSpan scaleSpan : this.spans) {
                if (scaleSpan.isOutRangeSetFromSpec() == null) continue;
                return scaleSpan.isOutRangeSetFromSpec();
            }
        }
        return false;
    }

    List<Tick> getTicksForTicksLocation(List<Tick> list, ArrayList<ScaleSpan> arrayList) {
        ArrayList<Tick> arrayList2 = new ArrayList<Tick>();
        ArrayList<Object> arrayList3 = new ArrayList();
        arrayList3 = arrayList == null ? this.spans : arrayList;
        for (ScaleSpan scaleSpan : arrayList3) {
            if (scaleSpan instanceof ContinuousScaleSpan) {
                ((ContinuousScaleSpan)scaleSpan).setBaseTicks(list);
            }
            if (this.drawnMultiple && scaleSpan instanceof CategoricalScaleSpan) {
                ((CategoricalScaleSpan)scaleSpan).createAllTicks(list, arrayList2);
                continue;
            }
            for (Tick tick : list) {
                Tick tick2;
                if (!scaleSpan.getOutRange().contains(tick.location) || (tick2 = scaleSpan.createTickForLocation(tick.getLocation())) == null) continue;
                arrayList2.add(tick2);
            }
        }
        if (this.reverse) {
            Scale.reverseTicks(arrayList2);
        }
        if (this.localScale.booleanValue()) {
            this.ticksForData = arrayList2;
        }
        return arrayList2;
    }

    public void setRangeForSpan(Range range, Integer n) {
        ScaleSpan scaleSpan;
        if (n != null && n >= 0 && n < this.spans.size() && (scaleSpan = this.spans.get(n)) != null && scaleSpan instanceof ContinuousScaleSpan && !((ContinuousScaleSpan)scaleSpan).isNumDomainDefinedInSpec()) {
            ContinuousScaleSpan continuousScaleSpan = (ContinuousScaleSpan)scaleSpan;
            if (range != null) {
                Range range2 = continuousScaleSpan.getInputNumDomain();
                if (range2 != null) {
                    continuousScaleSpan.setInputNumDomain(range2.createUnion(range));
                } else {
                    continuousScaleSpan.setInputNumDomain(range);
                }
            }
        }
    }

    public boolean areCompatible(Scale scale) {
        boolean bl;
        if (this == scale) {
            return true;
        }
        if (scale == null) {
            return false;
        }
        if (this.reverse != scale.reverse) {
            return false;
        }
        boolean bl2 = this.localScale != null && this.localScale != false;
        boolean bl3 = bl = scale.localScale != null && scale.localScale != false;
        if (bl2 != bl) {
            return false;
        }
        int n = this.spans.size();
        if (n != scale.spans.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.spans.get(i).areCompatible(scale.spans.get(i))) continue;
            return false;
        }
        return true;
    }

    public Range getPaddedRange() {
        if (this.spec != null && this.spec.padding != null) assert (this.paddedRange != null);
        return this.paddedRange != null ? this.paddedRange : Range.ZERO_ONE;
    }

    public int getFirstVisibleTick(double[] dArray) {
        List<Tick> list = this.getTicks();
        ScaleSpan scaleSpan = this.getSpans().get(0);
        int n = list.size() - 1;
        int n2 = 0;
        double d = list.get(n2).getLocation();
        double d2 = scaleSpan.getOutRange().fromZeroOne(dArray[0]);
        while (n2 < n && d < d2) {
            d = list.get(++n2).getLocation();
        }
        if (d < d2) {
            ++n2;
        }
        return n2;
    }

    public int getLastVisibleTick(double[] dArray) {
        List<Tick> list = this.getTicks();
        ScaleSpan scaleSpan = this.getSpans().get(0);
        int n = list.size() - 1;
        int n2 = 0;
        double d = list.get(n2).getLocation();
        double d2 = scaleSpan.getOutRange().fromZeroOne(dArray[1]);
        while (n2 < n && d < d2) {
            d = list.get(++n2).getLocation();
        }
        if (d > d2) {
            --n2;
        }
        return n2;
    }
}

