/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.format.RAVEFormatter;
import com.ibm.vis.engine.internal.grammar.scale.CategoricalDomain;
import com.ibm.vis.engine.internal.grammar.scale.ContinuousScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.scale.ScaleFitInfo;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpanBuilder;
import com.ibm.vis.engine.internal.grammar.units.Measure;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.spec.internal.ScaleSpec;
import com.ibm.vis.spec.internal.SpanSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ScaleBuilder {
    private final Scale target;
    private final ArrayList<Field> fields;
    private final boolean fitToData;
    private final VisContext visContext;
    public boolean reverseCategoricalScales;

    public static ScaleBuilder makeForProvider(Scale scale, ValueProvider valueProvider, boolean bl, VisContext visContext) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        Field field = valueProvider.getBaseField();
        if (field != null) {
            arrayList.add(field);
        }
        return new ScaleBuilder(scale, arrayList, bl, visContext);
    }

    public static ScaleBuilder makeForMany(Scale scale, ArrayList<Field> arrayList, boolean bl, VisContext visContext) {
        return new ScaleBuilder(scale, arrayList, bl, visContext);
    }

    private ScaleBuilder(Scale scale, ArrayList<Field> arrayList, boolean bl, VisContext visContext) {
        this.target = scale;
        this.fields = arrayList;
        this.fitToData = bl;
        this.visContext = visContext;
    }

    public static Scale createFromSpec(ScaleSpec scaleSpec, boolean bl, Boolean bl2, ArrayList<Field> arrayList, ArrayList<Unit> arrayList2, Vis vis, Integer n, HashMap<Integer, String> hashMap) {
        Scale scale = new Scale(scaleSpec, vis.getSize());
        ArrayList<String> arrayList3 = new ArrayList<String>();
        Field field = null;
        if (arrayList != null && arrayList.size() > 0) {
            field = arrayList.get(0);
            for (Field object : arrayList) {
                if (object.id == null) continue;
                arrayList3.add(object.id);
            }
        }
        if (scaleSpec.spans != null) {
            for (int i = 0; i < scaleSpec.spans.length; ++i) {
                SpanSpec spanSpec = scaleSpec.spans[i];
                Unit unit = ScaleBuilder.getDefaultUnitForSpanIndex(arrayList2, i);
                if (hashMap != null && hashMap.get(i) != null && arrayList3.contains(hashMap.get(i))) {
                    field = (Field)vis.getByID(hashMap.get(i));
                }
                if (field != null && spanSpec != null && spanSpec.max != null && spanSpec.min != null) {
                    double d = spanSpec.max.doubleValue() - spanSpec.min.doubleValue();
                    double d2 = field.getDataRange().getRange();
                    if (d2 / d > 20.0 && !vis.getSettingScaleInteractively()) {
                        throw new EngineException("Scale span of " + d + " less than one twentieth of total field range.", ErrorCode.ENGINE_SCALE_TOO_SMALL, null);
                    }
                }
                scale.addSpan(ScaleSpanBuilder.createFromSpec(spanSpec, bl, vis, bl2, unit, field, n));
            }
        }
        return scale;
    }

    public static void setFieldToScaleSpans(Scale scale, Vis vis, ArrayList<Field> arrayList, HashMap<Integer, String> hashMap) {
        if (scale != null) {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            Field field = null;
            if (arrayList != null && arrayList.size() > 0) {
                field = arrayList.get(0);
                for (Field field2 : arrayList) {
                    if (field2.id == null) continue;
                    arrayList2.add(field2.id);
                }
            }
            ArrayList<ScaleSpan> arrayList3 = scale.getSpans();
            for (int i = 0; i < arrayList3.size(); ++i) {
                ScaleSpan scaleSpan;
                if (hashMap != null && hashMap.get(i) != null && arrayList2.contains(hashMap.get(i))) {
                    field = (Field)vis.getByID(hashMap.get(i));
                }
                if (field == null || (scaleSpan = (ScaleSpan)arrayList3.get(i)) == null) continue;
                scaleSpan.setDataField(field);
            }
        }
    }

    private static Unit getDefaultUnitForSpanIndex(ArrayList<Unit> arrayList, int n) {
        if (arrayList != null && arrayList.size() > 0) {
            return arrayList.get(Math.min(n, arrayList.size() - 1));
        }
        return null;
    }

    public void createSpansFromProvider(ValueProvider valueProvider) {
        ScaleFitInfo scaleFitInfo = new ScaleFitInfo(true, false, false, null);
        RAVEFormatter rAVEFormatter = valueProvider.getFormatter();
        if (valueProvider.isCategorical()) {
            this.addCategoricalSpan(valueProvider.getUnit(), valueProvider.getCategories(), rAVEFormatter, scaleFitInfo);
        } else {
            this.addNumericSpan(valueProvider.getUnit(), valueProvider.getRange(), rAVEFormatter, scaleFitInfo, valueProvider.getGranularity(), null, null);
        }
        this.target.defineSpanOutputRanges();
    }

    public void addNumericSpan(Unit unit, Range range, RAVEFormatter rAVEFormatter, ScaleFitInfo scaleFitInfo, Double d, Integer n, String string) {
        ScaleSpan scaleSpan;
        if (unit == null) {
            unit = Unit.RATIO;
        }
        if (this.fitToData) {
            range = this.fitRangeToData(range, unit.measure);
        }
        if (scaleFitInfo.canExpand() && d != null) {
            ScaleFitInfo scaleFitInfo2 = new ScaleFitInfo(false, scaleFitInfo.elementRequiresZero(), scaleFitInfo.ignoresZero(), n);
            scaleSpan = ScaleSpanBuilder.createForRange(range, unit, scaleFitInfo2, null, d, rAVEFormatter, this.visContext, this.getField(), n);
        } else {
            scaleSpan = ScaleSpanBuilder.createForRange(range, unit, scaleFitInfo, null, null, rAVEFormatter, this.visContext, this.getField(), n);
        }
        if (scaleSpan instanceof ContinuousScaleSpan) {
            ((ContinuousScaleSpan)scaleSpan).setStacked(string);
        }
        this.target.addSpan(scaleSpan);
    }

    public void addCategoricalSpan(Unit unit, String[] stringArray, RAVEFormatter rAVEFormatter, ScaleFitInfo scaleFitInfo) {
        int n = stringArray == null ? -1 : stringArray.length;
        CategoricalDomain categoricalDomain = new CategoricalDomain(n, this.reverseCategoricalScales);
        ScaleSpan scaleSpan = ScaleSpanBuilder.createForCategories(categoricalDomain, stringArray, unit, scaleFitInfo, rAVEFormatter, this.visContext, this.getField());
        categoricalDomain.restrictToExisting = this.fitToData;
        for (Field field : this.fields) {
            if (!scaleSpan.isApplicable(field.unit)) continue;
            categoricalDomain.basedOnField(field);
        }
        this.target.addSpan(scaleSpan);
    }

    private Range fitRangeToData(Range range, Measure measure) {
        Range range2 = Range.EMPTY;
        for (Field field : this.fields) {
            if (!measure.matches(field.unit.measure)) continue;
            Range range3 = field.getDataRange();
            range2 = range2.unionValue(range3.getMin());
            range2 = range2.unionValue(range3.getMax());
        }
        if (range2.getMin() > range.getMin()) {
            range = new Range(range2.getMin(), range.getMax());
        }
        if (range2.getMax() < range.getMax()) {
            range = new Range(range.getMin(), range2.getMax());
        }
        return range;
    }

    protected Field getField() {
        if (!this.fields.isEmpty() && this.fields.size() == 1 && this.fields.get((int)0).id != null) {
            return this.fields.get(0);
        }
        HashSet<Field> hashSet = new HashSet<Field>();
        hashSet.addAll(this.fields);
        if (!hashSet.isEmpty() && hashSet.size() == 1) {
            Field field = (Field)hashSet.iterator().next();
            if (field.id != null) {
                return field;
            }
        }
        return null;
    }
}

