/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.scale.RangeProvider;
import com.ibm.vis.engine.internal.grammar.scale.ScaleGeometry;
import com.ibm.vis.engine.internal.grammar.scale.transform.ScaleTransform;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import java.util.HashMap;
import java.util.Map;

public final class ScaleFitInfo {
    private final boolean expand;
    private boolean elementNeedsZero;
    private boolean ignoreZero;
    private double padPixels;
    private double padPercent;
    private ScaleGeometry geometry;
    private final Integer dimension;
    private final Map<RangeProvider, Double> paddingPixels = new HashMap<RangeProvider, Double>();
    private final Map<RangeProvider, Double> paddingPercent = new HashMap<RangeProvider, Double>();

    public ScaleFitInfo(boolean bl, boolean bl2, boolean bl3, Integer n) {
        this.expand = bl;
        this.elementNeedsZero = bl2;
        this.ignoreZero = bl3;
        this.padPixels = 0.0;
        this.padPercent = 0.0;
        this.dimension = n;
    }

    public void requirePadding(RangeProvider rangeProvider, double d, double d2) {
        this.padPixels = Math.max(this.padPixels, d);
        this.padPercent = Math.max(this.padPercent, d2);
        this.paddingPixels.put(rangeProvider, d);
        this.paddingPercent.put(rangeProvider, d2);
    }

    public Range expandRange(Range range, boolean bl, ScaleTransform scaleTransform, Unit unit, double d) {
        if (!this.expand || this.geometry == null || this.dimension == null) {
            return range;
        }
        Range range2 = range;
        for (RangeProvider rangeProvider : this.paddingPixels.keySet()) {
            Range range3 = rangeProvider.getDataRange(this.dimension, unit);
            range3 = range3.intersect(range);
            double d2 = 0.0;
            double d3 = 0.0;
            if (!bl) {
                if (Double.isNaN(this.geometry.len) || this.geometry.len < 1.0) {
                    d2 = this.paddingPercent.get(rangeProvider);
                    d2 = Math.min(0.2, Math.max(0.01, d2));
                } else {
                    d2 = 1.5 * this.paddingPixels.get(rangeProvider) / this.geometry.len + this.paddingPercent.get(rangeProvider);
                    d2 = Math.min(0.2, Math.max(0.01, d2));
                    d3 = d2 / this.geometry.len;
                }
            }
            Range range4 = new Range(d3, 1.0 - d3);
            if (this.zeroRequired(unit) && scaleTransform.allowsZero()) {
                range3 = range3.unionValue(0.0);
            }
            scaleTransform.setRange(range3);
            range4 = range4.expand(d2 * range4.getRange());
            range2 = range2.unionValue(scaleTransform.transformFromZeroOne(range4.getMin()));
            range2 = range2.unionValue(scaleTransform.transformFromZeroOne(range4.getMax()));
        }
        double d4 = range2.getMin();
        double d5 = range2.getMax();
        if (Double.isNaN(d4)) {
            d5 = Double.NaN;
        }
        if (Double.isNaN(d5)) {
            d4 = Double.NaN;
        }
        if (this.zeroDesirable(unit) && scaleTransform.allowsZero()) {
            if (d4 > 0.0 && d4 / d5 <= 0.25 || d4 < 0.0 && range.getMin() >= 0.0) {
                d4 = 0.0;
            } else if (d5 < 0.0 && d5 / d4 <= 0.25 || d5 > 0.0 && range.getMax() <= 0.0) {
                d5 = 0.0;
            }
        } else if (this.ignoreZero) {
            if (range.getMin() >= 0.0 && d4 < 0.0) {
                double d6 = d4 = scaleTransform.allowsZero() ? 0.0 : range.getMin();
            }
            if (range.getMax() <= 0.0 && d5 > 0.0) {
                double d7 = d5 = scaleTransform.allowsZero() ? 0.0 : range.getMax();
            }
        }
        if (!Double.isNaN(d) && range.getMax() <= d + 1.0E-6 && d5 > d) {
            d5 = d;
        }
        return new Range(d4, d5);
    }

    public boolean needsExtraSpacing(Range range, Range range2) {
        double d = this.padPixels / this.geometry.len;
        double d2 = range2.toZeroOne(range.getMax());
        double d3 = range2.toZeroOne(range.getMin());
        double d4 = range2.fromZeroOne(d2 + d);
        double d5 = range2.fromZeroOne(d3 - d);
        if (d5 > 0.0 && d5 / d4 <= 0.25 || d5 < 0.0 && range.getMin() >= 0.0) {
            d5 = 0.0;
        }
        if (d4 < 0.0 && d4 / d5 <= 0.25 || d4 > 0.0 && range.getMax() <= 0.0) {
            d4 = 0.0;
        }
        return d4 > range2.getMax() || d5 < range2.getMin();
    }

    public Range addExtraPadding(Range range, boolean bl, ScaleTransform scaleTransform, Unit unit, double d) {
        double d2 = 0.0;
        if (!bl) {
            d2 = Double.isNaN(this.geometry.len) ? this.padPercent : this.padPixels / this.geometry.len + this.padPercent;
        }
        double d3 = this.geometry.len + this.padPixels + this.padPercent * this.geometry.len;
        Range range2 = range;
        if (this.zeroRequired(unit) && scaleTransform.allowsZero()) {
            range2 = range.unionValue(0.0);
        }
        scaleTransform.setRange(range2);
        double d4 = (1.0 + d2) * d3 / this.geometry.len;
        double d5 = 1.0 - d4;
        double d6 = scaleTransform.transformFromZeroOne(d4);
        double d7 = scaleTransform.transformFromZeroOne(d5);
        if (this.zeroDesirable(unit) && scaleTransform.allowsZero()) {
            if (d7 > 0.0 && d7 / d6 <= 0.25 || d7 < 0.0 && range.getMin() >= 0.0) {
                d7 = 0.0;
            }
            if (d6 < 0.0 && d6 / d7 <= 0.25 || d6 > 0.0 && range.getMax() <= 0.0) {
                d6 = 0.0;
            }
        }
        if (!Double.isNaN(d) && range.getMax() <= d + 1.0E-6 && d6 > d) {
            d6 = d;
        }
        return new Range(d7, d6);
    }

    final void setGeometry(ScaleGeometry scaleGeometry) {
        this.geometry = scaleGeometry;
    }

    final ScaleGeometry getGeometry() {
        return this.geometry;
    }

    final void copyFrom(ScaleFitInfo scaleFitInfo) {
        this.padPercent = scaleFitInfo.padPercent;
        this.padPixels = scaleFitInfo.padPixels;
        this.paddingPercent.putAll(scaleFitInfo.paddingPercent);
        this.paddingPixels.putAll(scaleFitInfo.paddingPixels);
        this.elementNeedsZero = scaleFitInfo.elementNeedsZero;
        this.ignoreZero = scaleFitInfo.ignoreZero;
    }

    Range finalizeRange(Range range, Range range2, ScaleTransform scaleTransform) {
        if (!this.expand) {
            return range;
        }
        Range range3 = range;
        if (this.expand) {
            double d;
            Range range4 = new Range(scaleTransform.transformToZeroOne(range.getMin()), scaleTransform.transformToZeroOne(range.getMax()));
            Range range5 = new Range(scaleTransform.transformToZeroOne(range2.getMin()), scaleTransform.transformToZeroOne(range2.getMax()));
            range3 = range2;
            if ((range5.getMax() - range4.getMax()) / range5.getRange() > 0.25 && (d = scaleTransform.getIntermediatePoint(range.getMax(), range2.getMax())) > range.getMax()) {
                range3 = new Range(range3.getMin(), d);
            }
            if ((range4.getMin() - range5.getMin()) / range5.getRange() > 0.25 && (d = scaleTransform.getIntermediatePoint(range.getMin(), range2.getMin())) < range.getMin()) {
                range3 = new Range(d, range3.getMax());
            }
        }
        return range3;
    }

    final boolean canExpand() {
        return this.expand;
    }

    final boolean zeroRequired(Unit unit) {
        return this.expand && !this.ignoreZero && unit.measure.zeroMeaningful && (this.elementNeedsZero || unit == Unit.COUNT);
    }

    final boolean zeroDesirable(Unit unit) {
        return this.expand && !this.ignoreZero && unit.measure.zeroMeaningful;
    }

    public final double getPadPixels() {
        return this.padPixels;
    }

    public final double getPadPercent() {
        return this.padPercent;
    }

    final boolean elementRequiresZero() {
        return this.elementNeedsZero;
    }

    final boolean ignoresZero() {
        return this.ignoreZero;
    }
}

