/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ScaleGeometry {
    public final boolean isYAxis;
    public double len;
    double minimalTickSeparation;
    private Range outRange;
    public static final double MINIMAL_TICK_SEPARATION = 2.0;

    public static ScaleGeometry makeSized(double d, boolean bl) {
        return new ScaleGeometry(d, bl);
    }

    public static ScaleGeometry makeUnsized(boolean bl) {
        return new ScaleGeometry(1.0, bl);
    }

    private ScaleGeometry(double d, boolean bl) {
        this.setOutRange(Range.ZERO_ONE);
        this.len = d;
        this.isYAxis = bl;
        this.minimalTickSeparation = 2.0;
    }

    public void ticksNoSmallerThan(double d) {
        this.minimalTickSeparation = Math.max(this.minimalTickSeparation, d);
    }

    public void setBounds(double d, double d2) {
        this.len = this.isYAxis ? d2 : d;
    }

    public int getFittingTicks(double d) {
        int n = (int)Math.floor(this.len * d / this.minimalTickSeparation);
        return Math.max(n, 1);
    }

    public int getPreferredNumericTicks(double d) {
        double d2 = this.isYAxis ? 45.0 : 60.0;
        int n = (int)Math.round(this.len * d / d2);
        return Math.max(n, 1);
    }

    public void resetOutRange() {
        this.setOutRange(Range.ZERO_ONE);
    }

    public final Range getOutRange() {
        return this.outRange;
    }

    public final void setOutRange(Range range) {
        this.outRange = range;
    }
}

