/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.FormatInfo;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.VisInterface;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.format.RAVEFormatter;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.label.TextContentPart;
import com.ibm.vis.engine.internal.grammar.label.TextProducer;
import com.ibm.vis.engine.internal.grammar.scale.CategoricalScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.ScaleFitInfo;
import com.ibm.vis.engine.internal.grammar.scale.ScaleGeometry;
import com.ibm.vis.engine.internal.grammar.scale.Tick;
import com.ibm.vis.engine.internal.grammar.scale.transform.ScaleTransform;
import com.ibm.vis.engine.internal.grammar.scale.transform.ScaleTransformBuilder;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.geom.Dim;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class ScaleSpan {
    protected Range scaleOutRange;
    protected Range finalOutRange;
    protected Range originalFinalOutRange;
    protected Range finalExtendedOutRange;
    protected final Unit inputUnit;
    private Object[] tickLabelContentSpec;
    public static final String CONTENT_ARG_TICK = "tick";
    public static final String FORMAT_INFO = "format_info";
    protected final Integer desiredTicks;
    protected final ScaleFitInfo fitInfo;
    protected RAVEFormatter specifiedFormatter;
    protected ScaleTransform scaleTransform;
    private boolean isSpanMatching;
    private Boolean outRangeSetFromSpec = null;
    protected VisInterface iVis;
    private Double suggestedSize = null;
    protected Field dataField;
    protected String transformMethod;
    public final VisContext visContext;
    protected double spanLengthPreTransform;

    public ScaleSpan(Unit unit, Integer n, ScaleFitInfo scaleFitInfo, RAVEFormatter rAVEFormatter, VisContext visContext, Range range, String string) {
        this.transformMethod = string;
        this.desiredTicks = n;
        this.inputUnit = unit;
        this.fitInfo = scaleFitInfo;
        this.setScaleOutRange(range == null ? Range.ZERO_ONE : range);
        this.originalFinalOutRange = this.finalOutRange.copy();
        this.specifiedFormatter = rAVEFormatter;
        this.visContext = visContext;
        this.isSpanMatching = false;
        if (this.visContext != null) {
            this.iVis = this.visContext.getParentVis();
        }
        ScaleTransformBuilder.registerExtensions();
        this.scaleTransform = ScaleTransformBuilder.create(string);
    }

    public abstract boolean isApplicable(Unit var1);

    public abstract Double getBase(boolean var1);

    public Unit getInputUnit() {
        return this.inputUnit;
    }

    public abstract void addTicks(List<Tick> var1, boolean var2);

    public abstract void addAllTicks(List<Tick> var1, boolean var2);

    public abstract Dim getMaxTickLabelSize(Font var1);

    public abstract Double toZeroOne(Number var1, Unit var2, boolean var3);

    public abstract Double zeroOneToDataValue(double var1);

    public void setupForExtent(ScaleGeometry scaleGeometry) {
        this.fitInfo.setGeometry(scaleGeometry);
        double d = this.getOutRange().getRange();
        int n = scaleGeometry.getFittingTicks(d);
        if (this.desiredTicks != null) {
            this.setupForTickCount(this.desiredTicks, this.desiredTicks * 2);
        } else if (this.inputUnit.measure.categorical) {
            this.setupForTickCount(n, n);
        } else {
            int n2 = scaleGeometry.getPreferredNumericTicks(d);
            if (n2 < 5) {
                n2 = Math.min(5, n);
            }
            this.setupForTickCount(n2, n);
        }
    }

    protected Range getTickOutRange() {
        Range range = this.getOutRange().copy();
        range.setMax(this.scaleOutRange.getMax() == 1.0 ? Math.max(1.0, range.getMax()) : range.getMax());
        range.setMin(this.scaleOutRange.getMin() == 0.0 ? Math.min(0.0, range.getMin()) : range.getMin());
        return range;
    }

    public Double getSuggestedElementSize(double d, Double d2) {
        double d3;
        Double d4 = null;
        double d5 = d3 = this.finalOutRange != null && this.finalOutRange.isComplete() ? this.finalOutRange.getRange() : 1.0;
        if (d2 != null) {
            Range range = this.getAdjustedInputRange();
            double d6 = range != null && range.isComplete() ? range.getRange() : 1.0;
            d4 = d * d2 * d3 / d6;
        } else if (this instanceof CategoricalScaleSpan) {
            int n = Math.max(this.getCategoryCount(), 2);
            d4 = d * d3 / (double)n;
        }
        return d4;
    }

    public abstract void addMinorTicks(List<Tick> var1);

    public abstract double getTickMin();

    public abstract double getTickSize();

    public abstract Range getInputRange();

    public abstract Range getAdjustedInputRange();

    public abstract Unit getTickUnit();

    public abstract void setupForTickCount(int var1, int var2);

    public abstract void setupMaxTickCount(int var1);

    public abstract int computeTickCount();

    public void getUndefinedParametersFrom(ScaleSpan scaleSpan) {
        this.specifiedFormatter = this.specifiedFormatter == null ? scaleSpan.specifiedFormatter : this.specifiedFormatter;
        this.fitInfo.copyFrom(scaleSpan.fitInfo);
    }

    public void adaptInputNumDomainFrom(ScaleSpan scaleSpan) {
    }

    public abstract int getCategoryCount();

    public abstract double getGoodDisplaySpanSize();

    public void prepareOutRange(Range range, double d, double d2) {
        this.finalOutRange = this.scaleOutRange.remap(range);
        this.finalExtendedOutRange = this.finalOutRange.expandedBy(d, d2);
    }

    public ScaleFitInfo getFitInfo() {
        return this.fitInfo;
    }

    public void addToGroup(ArrayList<ScaleSpan> arrayList, ArrayList<ScaleSpan> arrayList2) {
        double d;
        double d2 = this.getCumulativeOverlap(arrayList);
        if (d2 <= (d = this.getCumulativeOverlap(arrayList2))) {
            arrayList.add(this);
        } else {
            arrayList2.add(this);
        }
    }

    double getCumulativeOverlap(ArrayList<ScaleSpan> arrayList) {
        double d = 0.0;
        Range range = this.scaleOutRange;
        for (ScaleSpan scaleSpan : arrayList) {
            if (this.outRangeSetFromSpec == null || !this.outRangeSetFromSpec.booleanValue() || !scaleSpan.outRangeSetFromSpec.booleanValue()) continue;
            d += range.getOverlap(scaleSpan.getOutRange());
        }
        return d;
    }

    public abstract boolean isUnitApplicable(Number var1, Unit var2);

    public TextContent addFormattingContentToTickLabel(String string, int n, FormatInfo formatInfo) {
        Object object;
        TextContent textContent = null;
        if (this.tickLabelContentSpec != null && this.tickLabelContentSpec.length > 0) {
            this.tickLabelContentSpec = TextProducer.updateEmptyFieldMethodToLabel(this.tickLabelContentSpec);
            object = new HashMap();
            ((HashMap)object).put(CONTENT_ARG_TICK, string);
            ((HashMap)object).put(FORMAT_INFO, formatInfo);
            textContent = TextProducer.makeTextContentWithContext(this.iVis, null, this.tickLabelContentSpec, n, (HashMap<String, Object>)object);
        }
        if (textContent == null) {
            object = new TextContent(this.visContext.getMinimumFontSize());
            TextContentPart textContentPart = new TextContentPart(string, null, this.visContext.getMinimumFontSize());
            textContentPart.setFormatInfo(formatInfo);
            ((TextContent)object).addTextContentPart(textContentPart);
            return object;
        }
        return textContent;
    }

    public final boolean isMatchingSpan() {
        return this.isSpanMatching;
    }

    public final void setSpanMatching(boolean bl) {
        this.isSpanMatching = bl;
    }

    public final Boolean isOutRangeSetFromSpec() {
        return this.outRangeSetFromSpec;
    }

    public final void setOutRangeSetFromSpec(Boolean bl) {
        this.outRangeSetFromSpec = bl;
    }

    public final Range getOutRange() {
        return this.finalOutRange;
    }

    public final Range getScaleOutRange() {
        return this.scaleOutRange;
    }

    public final Range getExtendedOutRange() {
        return this.finalExtendedOutRange;
    }

    public void setScaleOutRange(Range range) {
        this.scaleOutRange = range;
        this.finalOutRange = range;
        this.finalExtendedOutRange = range;
    }

    public void setTickLabelContent(Object[] objectArray) {
        this.tickLabelContentSpec = objectArray;
    }

    public abstract double getDataMaxValue();

    public Double getSuggestedSize(Number number) {
        return this.suggestedSize;
    }

    public final void setSuggestedSize(Double d) {
        this.suggestedSize = d;
    }

    public abstract Tick createTickForLocation(double var1);

    public abstract boolean areCompatible(ScaleSpan var1);

    public void setPreTransformSpanLength(double d) {
        this.spanLengthPreTransform = d * this.scaleOutRange.getRange();
    }

    public Field getDataField() {
        return this.dataField;
    }

    public final void setDataField(Field field) {
        this.dataField = field;
        RAVEFormatter rAVEFormatter = field.getSpecifiedFormatter();
        if (rAVEFormatter != null) {
            this.specifiedFormatter = rAVEFormatter;
        }
    }
}

