/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.VisInterface;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.format.RAVEFormatter;
import com.ibm.vis.engine.internal.grammar.scale.CategoricalDomain;
import com.ibm.vis.engine.internal.grammar.scale.CategoricalScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.EmptyScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.LogScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.NumericScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.ScaleFitInfo;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.SpanOutRangeBuilder;
import com.ibm.vis.engine.internal.grammar.scale.TimeScaleSpan;
import com.ibm.vis.engine.internal.grammar.units.Measure;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.spec.internal.FormatSpec;
import com.ibm.vis.spec.internal.SpanSpec;

public class ScaleSpanBuilder {
    public static ScaleSpan createForCategories(CategoricalDomain categoricalDomain, String[] stringArray, Unit unit, ScaleFitInfo scaleFitInfo, RAVEFormatter rAVEFormatter, VisContext visContext, Field field) {
        return new CategoricalScaleSpan(unit, null, scaleFitInfo, rAVEFormatter, visContext, null, null, stringArray, categoricalDomain, field);
    }

    public static ScaleSpan createForRange(Range range, Unit unit, ScaleFitInfo scaleFitInfo, Integer n, Double d, RAVEFormatter rAVEFormatter, VisContext visContext, Field field, Integer n2) {
        Range range2;
        Range range3 = range2 = d != null ? range.expand(d / 2.0) : range;
        if (range2.isEmpty()) {
            ScaleFitInfo scaleFitInfo2 = new ScaleFitInfo(true, false, false, n2);
            scaleFitInfo2.copyFrom(scaleFitInfo);
            return new EmptyScaleSpan(unit, 0, scaleFitInfo2, rAVEFormatter, visContext, null, null);
        }
        if (unit.measure == Measure.DATETIME) {
            TimeScaleSpan timeScaleSpan = new TimeScaleSpan(unit, n, scaleFitInfo, rAVEFormatter, visContext, null, null, null, null, range2, field, false, false);
            timeScaleSpan.setAppliedGranularity(d);
            return timeScaleSpan;
        }
        NumericScaleSpan numericScaleSpan = new NumericScaleSpan(unit, n, scaleFitInfo, rAVEFormatter, visContext, Range.ZERO_ONE, null, null, null, range2, field, false, false);
        numericScaleSpan.setAppliedGranularity(d);
        return numericScaleSpan;
    }

    public static ScaleSpan createFromSpec(SpanSpec spanSpec, boolean bl, VisInterface visInterface, Boolean bl2, Unit unit, Field field, Integer n) {
        Object object;
        Range range;
        Range range2;
        VisContext visContext = visInterface != null ? visInterface.getVisContext() : null;
        ScaleSpan scaleSpan = null;
        String string = spanSpec.unit;
        Unit unit2 = unit;
        if (unit2 == null) {
            unit2 = spanSpec.categories == null ? Unit.RATIO : Unit.CATEGORICAL;
        }
        boolean bl3 = (range2 = (range = SpanOutRangeBuilder.createFromSpec(spanSpec.outRange))) != null;
        boolean bl4 = spanSpec.ignoreZero != null && spanSpec.ignoreZero != false;
        Unit unit3 = Unit.get(string, unit2);
        if (unit3.measure.categorical) {
            Object object2;
            object = new CategoricalDomain(-1, bl);
            boolean bl5 = "data".equals(spanSpec.method);
            ((CategoricalDomain)object).setFollowDataOrder(bl5);
            ((CategoricalDomain)object).setDefinedValues(spanSpec.categories);
            boolean bl6 = ((CategoricalDomain)object).restrictToExisting = bl2 != null && bl2 != false;
            if (spanSpec.categoryWeights != null) {
                ((CategoricalDomain)object).setSortCategoriesByWeight("orderByWeight".equals(spanSpec.method));
                Field field2 = (Field)visInterface.getByID(spanSpec.categoryWeights.categories.$ref);
                object2 = (Field)visInterface.getByID(spanSpec.categoryWeights.weights.$ref);
                ((CategoricalDomain)object).setCategoryWeights(field2, (Field)object2);
            }
            boolean bl7 = true;
            if ("exact".equals(spanSpec.fit)) {
                bl7 = false;
            }
            object2 = new ScaleFitInfo(bl7, false, bl4, n);
            scaleSpan = new CategoricalScaleSpan(unit3, null, (ScaleFitInfo)object2, null, visContext, range2, spanSpec.method, null, (CategoricalDomain)object, field);
        } else {
            object = spanSpec.min;
            Number number = spanSpec.max;
            double d = object == null ? Double.NaN : ((Number)object).doubleValue();
            double d2 = number == null ? Double.NaN : number.doubleValue();
            Range range3 = new Range(d, d2);
            boolean bl8 = range3.isComplete();
            boolean bl9 = false;
            bl9 = "exact".equals(spanSpec.fit) ? false : ("nice".equals(spanSpec.fit) ? true : spanSpec.min == null || spanSpec.max == null);
            ScaleFitInfo scaleFitInfo = new ScaleFitInfo(bl9, false, bl4, n);
            scaleSpan = unit3.measure == Measure.DATETIME ? new TimeScaleSpan(unit3, null, scaleFitInfo, null, visContext, range2, spanSpec.method, spanSpec.tickDelta, spanSpec.minorDivisions, range3, field, string != null, bl8) : ("log".equals(spanSpec.method) ? new LogScaleSpan(unit3, null, scaleFitInfo, null, visContext, range2, spanSpec.method, spanSpec.tickDelta, spanSpec.minorDivisions, range3, field, string != null, bl8) : new NumericScaleSpan(unit3, null, scaleFitInfo, null, visContext, range2, spanSpec.method, spanSpec.tickDelta, spanSpec.minorDivisions, range3, field, string != null, bl8));
        }
        if (scaleSpan != null && spanSpec.tickLabel != null) {
            scaleSpan.setTickLabelContent(spanSpec.tickLabel);
        }
        scaleSpan.setOutRangeSetFromSpec(bl3);
        if (field != null) {
            scaleSpan.specifiedFormatter = field.getLocalFormatter() != null && field.getLocalFormatterType() == Field.LocalFormatterType.POSITION ? field.getLocalFormatter() : field.getSpecifiedFormatter();
        } else {
            object = null;
            if (visContext != null) {
                object = visContext.getLocale();
            }
            scaleSpan.specifiedFormatter = RAVEFormatter.makeFromSpec(new FormatSpec(), (String)object);
        }
        return scaleSpan;
    }
}

