/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.SpanOutRangeSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class SpanOutRangeBuilder {
    public static Range createFromSpec(SpanOutRangeSpec spanOutRangeSpec) {
        if (spanOutRangeSpec != null) {
            if (spanOutRangeSpec.min == null) {
                spanOutRangeSpec.min = 0.0;
            }
            if (spanOutRangeSpec.max == null) {
                spanOutRangeSpec.max = 1.0;
            }
            SpanOutRangeBuilder.validateOutRangeSpec(spanOutRangeSpec);
            return new Range(spanOutRangeSpec.min.doubleValue(), spanOutRangeSpec.max.doubleValue());
        }
        return null;
    }

    private static void validateOutRangeSpec(SpanOutRangeSpec spanOutRangeSpec) {
        if (spanOutRangeSpec.min.doubleValue() >= spanOutRangeSpec.max.doubleValue()) {
            throw new SpecException("outRange.max value must be larger than outRange.min", ErrorCode.SPEC_INVALID_VALUE, null);
        }
    }
}

