/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.globalization.NumericShapingInfo;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Point;
import com.ibm.vis.spec.internal.StyleSpec;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Tick {
    public final TextContent content;
    public double location;
    public final double value;
    private final ScaleSpan span;

    public Tick(TextContent textContent, double d, double d2, ScaleSpan scaleSpan) {
        this.content = textContent;
        this.location = d;
        this.value = d2;
        this.span = scaleSpan;
    }

    public ScaleSpan getSpan() {
        return this.span;
    }

    public TextContent getContent() {
        return this.content;
    }

    public TextContent getContentClone() {
        if (this.content != null) {
            return this.content.clone();
        }
        return null;
    }

    public String toString() {
        if (this.content != null) {
            return this.content.getText() + ": " + this.location;
        }
        return "" + this.location;
    }

    public Text makeText(Point point, String string, String string2, Font font, String string3, NumericShapingInfo numericShapingInfo, StyleSpec styleSpec, Dim dim, boolean bl, boolean bl2) {
        return ItemBuilder.makeText(this.content, point.getX(), point.getY(), string, string2, font, styleSpec, null, dim, bl, string3, numericShapingInfo, bl2);
    }

    public double getLocationMappedToExtent(Dim dim, boolean bl) {
        if (bl) {
            return (1.0 - this.location) * dim.getHeight();
        }
        return this.location * dim.getWidth();
    }

    public final double getLocation() {
        return this.location;
    }

    public static double[] getTicksLocation(List<Tick> list, Dim dim, boolean bl) {
        double[] dArray = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            dArray[i] = list.get(i).getLocationMappedToExtent(dim, bl);
        }
        return dArray;
    }

    public static boolean isZeroth(int n, Tick tick) {
        return n == 0 && tick.location == 0.0;
    }

    public boolean isTickAtExtent(boolean bl, Dim dim) {
        if (bl) {
            return this.getLocationMappedToExtent(dim, true) == 0.0;
        }
        return this.getLocationMappedToExtent(dim, false) == dim.getWidth();
    }

    public double getAdjacentTickSpace(int n, List<Tick> list) {
        double d = 1.0;
        if (n > 0) {
            d = Math.abs(this.location - list.get((int)(n - 1)).location);
        }
        if (n < list.size() - 1) {
            double d2 = Math.abs(this.location - list.get((int)(n + 1)).location);
            d = Math.min(d, d2);
        }
        return d;
    }
}

