/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale;

import com.ibm.vis.engine.internal.FormatInfo;
import com.ibm.vis.engine.internal.VisContext;
import com.ibm.vis.engine.internal.VisInterface;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.format.RAVEFormatter;
import com.ibm.vis.engine.internal.grammar.label.TextContent;
import com.ibm.vis.engine.internal.grammar.scale.ContinuousScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.ScaleFitInfo;
import com.ibm.vis.engine.internal.grammar.scale.ScaleGeometry;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.scale.Tick;
import com.ibm.vis.engine.internal.grammar.units.Measure;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.units.UnitConverter;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.DateUtil;
import com.ibm.vis.engine.internal.scene.Font;
import com.ibm.vis.engine.internal.scene.ItemBuilder;
import com.ibm.vis.engine.internal.struct.Text;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.monitor.LogComponent;
import java.util.ArrayList;
import java.util.List;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
class TimeScaleSpan
extends ContinuousScaleSpan {
    private Object tickDomainMinDate;
    private int maxTickCount = -1;
    private int calculatedDesiredTickCount = -1;

    TimeScaleSpan(Unit unit, Integer n, ScaleFitInfo scaleFitInfo, RAVEFormatter rAVEFormatter, VisContext visContext, Range range, String string, Number number, Number number2, Range range2, Field field, boolean bl, boolean bl2) {
        super(unit, n, scaleFitInfo, rAVEFormatter, visContext, range, string, number, number2, range2, field, bl, bl2);
        this.dataField = field;
        if (this.getUseTickDeltaFromSpec() && this.getTickDelta() < 1.0) {
            if (this.visContext.getLogger().hasListeners()) {
                this.visContext.getLogger().grammarWarning(LogComponent.CommonGrammar, "badValueTickDelta (tickDelta must be greater than 1 in time scales)");
            }
            this.setUseTickDeltaFromSpec(false);
        }
        if (this.getUseTickDeltaFromSpec() && this.getTickDelta() != Math.floor(this.getTickDelta()) && this.visContext.getLogger().hasListeners()) {
            this.visContext.getLogger().grammarWarning(LogComponent.CommonGrammar, "unsupportedValueTickDelta (tickDelta should be integer, will be rounded down to integer)");
        }
    }

    @Override
    public Dim getMaxTickLabelSize(Font font) {
        double d = 0.0;
        double d2 = 0.0;
        if (this.calculatedDesiredTickCount == -1) {
            this.calculatedDesiredTickCount = this.desiredTicks != null ? this.desiredTicks : 5;
        }
        if (this.maxTickCount == -1) {
            this.maxTickCount = 20;
        }
        Range range = this.expandInitialRange(this.getInputNumDomain());
        Range range2 = this.setupUnitAndRange(range, this.calculatedDesiredTickCount, this.maxTickCount);
        int n = this.setupMinDate(range, this.getTickDelta(), this.getTicksUnit());
        this.calculatedDesiredTickCount = range2.isComplete() ? (int)Math.ceil(range2.getRange() / this.getTickDelta()) : 0;
        Object object = DateUtil.INSTANCE.copy(this.tickDomainMinDate);
        for (int i = 0; i < this.calculatedDesiredTickCount; ++i) {
            TextContent textContent = this.getFormattedTickValue(object, this.getTicksUnit());
            Text text = ItemBuilder.makeText(textContent, 0.0, 0.0, "start", "middleOfFirstLine", font, null, null, new Dim(Double.MAX_VALUE, Double.MAX_VALUE), false, null, this.visContext.getNumericShapingInfo(), this.visContext.getTooltipsForTruncatedText());
            DateUtil.INSTANCE.increment(object, this.getTicksUnit(), n);
            d = Math.max(d, text.calculateTextWidth());
            d2 = Math.max(d2, text.getHeight());
        }
        return new Dim(d, d2);
    }

    private Object convertToDate(double d) {
        return DateUtil.INSTANCE.toDate(d, this.inputUnit, this.dataField == null ? "GMT" : this.dataField.timeZone);
    }

    @Override
    public int computeTickCount() {
        return this.computeTicks(null, false);
    }

    @Override
    public void addTicks(List<Tick> list, boolean bl) {
        if (this.getInputNumDomain().getRange() == 0.0 && this.desiredTicks == null) {
            double d = this.scaleTransform.transformToZeroOne(this.getInputNumDomain().getMin());
            Object object = DateUtil.INSTANCE.toDate(this.getInputNumDomain().getMin(), this.inputUnit, this.dataField != null ? this.dataField.timeZone : "GMT");
            Tick tick = new Tick(this.getFormattedTickValue(object, this.inputUnit == Unit.TIMESTAMP ? Unit.SECOND : Unit.DAY), this.getOutRange().fromZeroOne(d), this.getInputNumDomain().getMin(), this);
            list.add(tick);
            return;
        }
        this.computeTicks(list, true);
    }

    protected TextContent getFormattedTickValue(Object object, Unit unit) {
        String string = this.dataField != null ? this.dataField.id : null;
        double d = DateUtil.INSTANCE.fromDateObject(object, this.inputUnit);
        int n = this.dataField != null ? this.dataField.getNearestMatchingRowIndex(d) : -1;
        String string2 = this.visContext.formatContext.formatDate(object, this.specifiedFormatter, -1, string, unit, this.dataField != null ? DateUtil.INSTANCE.getAxisTimeZone(this.dataField.timeZone, unit.name) : "GMT");
        VisInterface visInterface = this.visContext.getParentVis();
        Field field = (Field)visInterface.getByID(string);
        FormatInfo formatInfo = null;
        if (field != null) {
            formatInfo = field.getFormatInfo(d, n, null);
        }
        return this.addFormattingContentToTickLabel(string2, n, formatInfo);
    }

    private int computeTicks(List<Tick> list, boolean bl) {
        ArrayList<Tick> arrayList;
        int n;
        block7: {
            Tick tick;
            double d;
            if (!this.getInputNumDomain().isComplete()) {
                return 0;
            }
            Object object = DateUtil.INSTANCE.copy(this.tickDomainMinDate);
            n = 0;
            int n2 = 0;
            double d2 = -1.0;
            arrayList = null;
            if (bl) {
                arrayList = new ArrayList<Tick>();
            }
            do {
                ++n2;
                double d3 = DateUtil.INSTANCE.fromDateObject(object, this.inputUnit);
                d = this.scaleTransform.transformToZeroOne(d3);
                if (this.shouldAddTick(d3)) {
                    if (arrayList != null) {
                        tick = new Tick(this.getFormattedTickValue(object, this.getTicksUnit()), this.getOutRange().fromZeroOne(d), d3, this);
                        arrayList.add(tick);
                    }
                    ++n;
                }
                if (d > 1.0001 || Double.isNaN(d)) break block7;
                DateUtil.INSTANCE.increment(object, this.getTicksUnit(), (int)Math.floor(this.getTickDelta()));
            } while (n2 <= 20 || d != d2);
            if (arrayList != null) {
                arrayList = null;
                tick = new Tick(this.getFormattedTickValue(object, this.getTicksUnit()), this.getOutRange().fromZeroOne(d), d, this);
                list.add(tick);
            }
            n = 1;
        }
        if (arrayList != null) {
            list.addAll(arrayList);
        }
        return n;
    }

    @Override
    public void addMinorTicks(List<Tick> list) {
        double d;
        double d2 = d = !this.getUseMinorDivisionsFromSpec() ? (double)this.getTicksUnit().minorDivisions : this.getMinorDivisions();
        if (d < 2.0) {
            return;
        }
        Object object = DateUtil.INSTANCE.copy(this.tickDomainMinDate);
        DateUtil.INSTANCE.increment(object, this.getTicksUnit(), -((int)Math.floor(this.getTickDelta())));
        double d3 = 0.0;
        do {
            double d4 = DateUtil.INSTANCE.fromDateObject(object, this.inputUnit);
            DateUtil.INSTANCE.increment(object, this.getTicksUnit(), (int)Math.floor(this.getTickDelta()));
            double d5 = DateUtil.INSTANCE.fromDateObject(object, this.inputUnit);
            int n = 1;
            while ((double)n < d) {
                double d6 = d4 + (d5 - d4) * (double)n / d;
                d3 = this.scaleTransform.transformToZeroOne(d6);
                if (d3 >= -1.0E-8 && d3 <= 1.00000001) {
                    Tick tick = new Tick(null, this.getOutRange().fromZeroOne(d3), d6, this);
                    list.add(tick);
                }
                ++n;
            }
        } while (!(d3 > 1.0001));
    }

    @Override
    protected void makeNumericSpanDetails(int n, int n2) {
        Range range = this.expandInitialRange(this.getInputNumDomain());
        Range range2 = this.setupUnitAndRange(range, n, n2);
        int n3 = this.setupMinDate(range, this.getTickDelta(), this.getTicksUnit());
        int n4 = range2.isComplete() ? (int)Math.ceil(range2.getRange() / this.getTickDelta()) : 0;
        Object object = DateUtil.INSTANCE.copy(this.tickDomainMinDate);
        DateUtil.INSTANCE.increment(object, this.getTicksUnit(), n4 * n3);
        if (DateUtil.INSTANCE.fromDateObject(object, this.inputUnit) < range.getMax()) {
            DateUtil.INSTANCE.increment(object, this.getTicksUnit(), n3);
        }
        Range range3 = new Range(DateUtil.INSTANCE.fromDateObject(this.tickDomainMinDate, this.inputUnit), DateUtil.INSTANCE.fromDateObject(object, this.inputUnit));
        this.setModifiedInputNumDomain(this.fitInfo.finalizeRange(this.getInputNumDomain(), range3, this.scaleTransform));
        this.scaleTransform.setRange(this.getModifiedInputNumDomain());
    }

    protected int setupMinDate(Range range, double d, Unit unit) {
        this.tickDomainMinDate = this.convertToDate(range.getMin());
        int n = (int)Math.floor(d);
        DateUtil.INSTANCE.floorToUnitMultiple(this.tickDomainMinDate, unit, n);
        return n;
    }

    private Range setupUnitAndRange(Range range, int n, int n2) {
        Range range2;
        Unit unit = this.inputUnit == Unit.TIMESTAMP ? Unit.SECOND : Unit.DAY;
        ArrayList<Unit> arrayList = TimeScaleSpan.getTimeUnits(Measure.TIME.units);
        if (this.getUseTickDeltaFromSpec()) {
            Unit unit2 = this.findBestUnit(this.getTickDeltaFromSpec(), unit, arrayList, n);
            this.setTicksUnit(unit2 != null ? unit2 : unit);
            range2 = UnitConverter.convertRange(range, unit, this.getTicksUnit());
            this.setTickDelta(UnitConverter.convert(this.getTickDeltaFromSpec(), unit, this.getTicksUnit()));
        } else {
            Unit unit3 = this.findBestUnit(range.getRange(), this.inputUnit, arrayList, n);
            this.setTicksUnit(unit3 != null ? unit3 : unit);
            range2 = UnitConverter.convertRange(range, this.inputUnit, this.getTicksUnit());
            this.setTickDelta(this.applyMultipliers(range2, 1.0, this.getTicksUnit().multipliers, n + 1, n2 + 1));
        }
        if (this.getTickDelta() < 1.0) {
            this.setTickDelta(1.0);
        }
        return range2;
    }

    private static ArrayList<Unit> getTimeUnits(ArrayList<Unit> arrayList) {
        ArrayList<Unit> arrayList2 = new ArrayList<Unit>(arrayList);
        arrayList2.remove(Unit.TIME);
        return arrayList2;
    }

    @Override
    public Tick createTickForLocation(double d) {
        Tick tick = null;
        if (this.getInputNumDomain().getRange() == 0.0 && this.desiredTicks == null) {
            Object object = DateUtil.INSTANCE.toDate(this.getInputNumDomain().getMin(), this.inputUnit, this.dataField.timeZone);
            tick = new Tick(this.getFormattedTickValue(object, this.inputUnit == Unit.TIMESTAMP ? Unit.SECOND : Unit.DAY), d, this.getInputNumDomain().getMin(), this);
        } else {
            Object object = DateUtil.INSTANCE.toDate(this.zeroOneToDataValue(this.getOutRange().toZeroOne(d)), this.inputUnit, this.dataField != null ? this.dataField.timeZone : "GMT");
            double d2 = DateUtil.INSTANCE.fromDateObject(object, this.inputUnit);
            tick = new Tick(this.getFormattedTickValue(object, this.inputUnit == Unit.TIMESTAMP ? Unit.SECOND : Unit.DAY), d, d2, this);
        }
        return tick;
    }

    @Override
    public ContinuousScaleSpan makeCopyWithoutTickInfo() {
        return new TimeScaleSpan(this.inputUnit, null, this.fitInfo, this.specifiedFormatter, this.visContext, this.getOutRange(), this.transformMethod, null, this.minorDivisions, this.inputNumDomain, this.dataField, this.hasUnitDefinedInSpec, this.isNumDomainDefinedInSpec());
    }

    @Override
    public boolean areCompatible(ScaleSpan scaleSpan) {
        if (this == scaleSpan) {
            return true;
        }
        if (!(scaleSpan instanceof TimeScaleSpan)) {
            return false;
        }
        TimeScaleSpan timeScaleSpan = (TimeScaleSpan)scaleSpan;
        return this.inputUnit.equals(timeScaleSpan.inputUnit) && this.inputNumDomain.equals(timeScaleSpan.inputNumDomain);
    }

    @Override
    public void setupForExtent(ScaleGeometry scaleGeometry) {
        this.fitInfo.setGeometry(scaleGeometry);
        this.maxTickCount = scaleGeometry.getFittingTicks(this.getOutRange().getRange());
        if (this.desiredTicks != null) {
            this.setupForTickCount(this.desiredTicks, this.desiredTicks * 2);
        } else if (this.inputUnit.measure.categorical) {
            this.setupForTickCount(this.maxTickCount, this.maxTickCount);
        } else {
            this.calculatedDesiredTickCount = scaleGeometry.getPreferredNumericTicks(this.getOutRange().getRange());
            if (this.calculatedDesiredTickCount < 5) {
                this.calculatedDesiredTickCount = Math.min(5, this.maxTickCount);
            }
            this.setupForTickCount(this.calculatedDesiredTickCount, this.maxTickCount);
        }
    }
}

