/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale.transform;

import com.ibm.vis.engine.internal.grammar.scale.transform.ScaleTransform;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class LogScaleTransform
extends ScaleTransform {
    private final int base;
    private final double oneOverLoggedBase;
    private static final int BASE_10 = 10;
    private static final int BASE_2 = 2;

    public LogScaleTransform() {
        this.base = 10;
        this.oneOverLoggedBase = 1.0 / Math.log(this.base);
    }

    public final int getBase() {
        return this.base;
    }

    @Override
    public double transform(double d) {
        if (d < 0.0) {
            return Double.NaN;
        }
        return Math.log(d) * this.oneOverLoggedBase;
    }

    @Override
    public double transformToZeroOne(double d) {
        double d2 = super.transformToZeroOne(d);
        if (Double.isInfinite(d2) && d2 < 0.0) {
            return 0.0;
        }
        return d2;
    }

    @Override
    public double inverse(double d) {
        return Math.pow(this.base, d);
    }

    @Override
    public double getMinorTickDivisions(double d) {
        double d2 = d;
        if (this.base >= 2) {
            d2 = this.base - 1;
        }
        return d2;
    }

    @Override
    public double getIntermediatePoint(double d, double d2) {
        if (d == d2) {
            return d2;
        }
        double d3 = this.transform(d);
        double d4 = Math.floor(d3);
        double d5 = d3 - d4;
        double d6 = d < d2 ? Math.ceil(this.inverse(d5)) * this.inverse(d4) : Math.floor(this.inverse(d5)) * this.inverse(d4);
        return d6;
    }

    @Override
    public boolean allowsZero() {
        return false;
    }
}

