/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale.transform;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class ScaleTransform {
    private Range range;

    public double transformToZeroOne(double d) {
        if (this.range != null) {
            return this.range.toZeroOne(this.transform(d));
        }
        return Double.NaN;
    }

    public final double transformFromZeroOne(double d) {
        if (this.range != null) {
            return this.inverse(this.range.fromZeroOne(d));
        }
        return Double.NaN;
    }

    public abstract double transform(double var1);

    public abstract double inverse(double var1);

    public abstract double getMinorTickDivisions(double var1);

    public abstract double getIntermediatePoint(double var1, double var3);

    public abstract boolean allowsZero();

    public double getOriginInZeroOne(boolean bl) {
        double d = this.transformToZeroOne(0.0);
        if (Double.isNaN(d)) {
            return bl ? 1.0 : 0.0;
        }
        return bl ? 1.0 - d : d;
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = new Range(this.transform(range.getMin()), this.transform(range.getMax()));
    }
}

