/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.scale.transform;

import com.ibm.vis.engine.internal.extension.ExtensionFactory;
import com.ibm.vis.engine.internal.extension.RAVEExtensionManager;
import com.ibm.vis.engine.internal.grammar.scale.transform.LinearScaleTransform;
import com.ibm.vis.engine.internal.grammar.scale.transform.LogScaleTransform;
import com.ibm.vis.engine.internal.grammar.scale.transform.ScaleTransform;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ScaleTransformBuilder
implements ExtensionFactory {
    public static final String TRANSFORM_LOG = "log";
    public static final String TRANSFORM_LINEAR = "linear";
    private static boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void registerExtensions() {
        if (initialized) return;
        Class<ScaleTransformBuilder> clazz = ScaleTransformBuilder.class;
        synchronized (ScaleTransformBuilder.class) {
            if (initialized) return;
            RAVEExtensionManager.INSTANCE.registerDefaultFactory(new ScaleTransformBuilder());
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Object newInstance(String string, Object object) {
        if (string != null) {
            ScaleTransform scaleTransform = null;
            if (TRANSFORM_LINEAR.equals(string)) {
                scaleTransform = new LinearScaleTransform();
            } else if (TRANSFORM_LOG.equals(string)) {
                scaleTransform = new LogScaleTransform();
            }
            return scaleTransform;
        }
        return null;
    }

    public static ScaleTransform create(String string) {
        ScaleTransform scaleTransform = null;
        if (string != null) {
            scaleTransform = (ScaleTransform)RAVEExtensionManager.INSTANCE.newInstance(string, null);
        }
        if (scaleTransform == null) {
            scaleTransform = (ScaleTransform)RAVEExtensionManager.INSTANCE.newInstance(TRANSFORM_LINEAR, null);
        }
        return scaleTransform;
    }
}

