/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.units;

import com.ibm.vis.engine.internal.grammar.units.MeasureType;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.ArrayList;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class Measure {
    public static final Measure LENGTH = new Measure(MeasureType.LENGTH, false, true);
    public static final Measure MASS = new Measure(MeasureType.MASS, false, true);
    public static final Measure COUNT = new Measure(MeasureType.COUNT, false, true);
    public static final Measure TIME = new Measure(MeasureType.TIME, false, false);
    public static final Measure DATETIME = new Measure(MeasureType.DATETIME, false, false);
    public static final Measure TEMPERATURE = new Measure(MeasureType.TEMPERATURE, false, true);
    public static final Measure ANGLE = new Measure(MeasureType.ANGLE, false, false);
    public static final Measure CURRENCY = new Measure(MeasureType.CURRENCY, false, true);
    public static final Measure CATEGORY = new Measure(MeasureType.CATEGORY, true, false);
    public static final Measure ORDINAL = new Measure(MeasureType.ORDINAL, true, false);
    public static final Measure NUMERIC = new Measure(MeasureType.NUMERIC, false, true);
    static final Measure LOG = new Measure(MeasureType.NUMERIC, false, false);
    public static final double PT_IN = 0.0138888889;
    public static final double PC_IN = 0.1666666667;
    public static final double CM_IN = 0.3937007874;
    public static final double MM_IN = 0.0393700787;
    public final MeasureType type;
    public final boolean categorical;
    public final boolean zeroMeaningful;
    public final ArrayList<Unit> units;

    private Measure(MeasureType measureType, boolean bl, boolean bl2) {
        this.type = measureType;
        this.categorical = bl;
        this.zeroMeaningful = bl2;
        this.units = new ArrayList();
    }

    public boolean isGeneric() {
        return this.type == Measure.NUMERIC.type || this.type == Measure.CATEGORY.type;
    }

    public boolean matches(Measure measure) {
        if (this.type == measure.type) {
            return true;
        }
        if (this.type == Measure.NUMERIC.type && !measure.categorical) {
            return true;
        }
        if (measure.type == Measure.NUMERIC.type && !this.categorical) {
            return true;
        }
        if (this.type == Measure.CATEGORY.type && measure.categorical) {
            return true;
        }
        return measure.type == Measure.CATEGORY.type && this.categorical;
    }
}

