/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.units;

import com.ibm.vis.engine.internal.grammar.units.Measure;
import com.ibm.vis.engine.internal.grammar.units.UnitMatchingCodes;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2012\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class Unit {
    private static final HashMap<String, Unit> all = new HashMap(30);
    private static final double[] METRIC = new double[]{2.0, 2.5, 5.0, 10.0};
    private static final double[] INTEGRAL = new double[]{2.0, 5.0, 10.0};
    private static final double[] BASE12 = new double[]{0.5, 2.0, 3.0, 6.0, 12.0, 24.0};
    private static final double[] BASE60 = new double[]{0.5, 2.0, 3.0, 6.0, 12.0, 15.0, 30.0};
    private static final double[] BASE8 = new double[]{0.5, 2.0, 4.0, 8.0, 16.0};
    private static final double FEET_METERS = 0.3048;
    public static final Unit METER = new Unit("meter", "m", false, Measure.LENGTH, "metric", 1.0, METRIC, 4, false);
    public static final Unit CENTIMETER = new Unit("centimeter", "cm", false, Measure.LENGTH, "metric", 0.01, METRIC, 4, false);
    public static final Unit KILOMETER = new Unit("kilometer", "km", false, Measure.LENGTH, "metric", 1000.0, METRIC, 4, false);
    public static final Unit FOOT = new Unit("foot", "ft", false, Measure.LENGTH, "imperial", 0.3048, BASE12, 4, false);
    public static final Unit INCH = new Unit("inch", "in", false, Measure.LENGTH, "imperial", 0.025400000000000002, BASE12, 4, false);
    public static final Unit MILE = new Unit("mile", "m", false, Measure.LENGTH, "imperial", 1609.344, BASE12, 4, false);
    private static final double POUND_GRAMS = 453.59237;
    public static final Unit GRAM = new Unit("gram", "g", false, Measure.MASS, "metric", 1.0, METRIC, 4, false);
    public static final Unit KILOGRAM = new Unit("kilogram", "kg", false, Measure.MASS, "metric", 1000.0, METRIC, 4, false);
    public static final Unit OUNCE = new Unit("ounce", "oz", false, Measure.MASS, "imperial", 28.349523125, BASE8, 4, false);
    public static final Unit POUND = new Unit("pound", "lb", false, Measure.MASS, "imperial", 453.59237, BASE8, 4, false);
    public static final Unit TON = new Unit("ton", "t", false, Measure.MASS, "imperial", 907184.74, METRIC, 4, false);
    public static final Unit COUNT = new Unit("count", "", false, Measure.COUNT, "metric", 1.0, INTEGRAL, 4, false);
    public static final Unit KILO = new Unit("thousands", "k", false, Measure.COUNT, "metric", 1000.0, INTEGRAL, 4, false);
    public static final Unit MEGA = new Unit("millions", "m", false, Measure.COUNT, "metric", 1000000.0, INTEGRAL, 4, false);
    public static final Unit BYTE = new Unit("byte", "b", false, Measure.COUNT, "storage", 1.0, INTEGRAL, 4, false);
    public static final Unit KILOBYTE = new Unit("kilobyte", "k", false, Measure.COUNT, "storage", 1024.0, INTEGRAL, 4, false);
    public static final Unit MEGABYTE = new Unit("megabyte", "M", false, Measure.COUNT, "storage", 1048576.0, INTEGRAL, 4, false);
    public static final Unit GIGABYTE = new Unit("gigabyte", "G", false, Measure.COUNT, "storage", 1.073741824E9, INTEGRAL, 4, false);
    public static final Unit TERABYTE = new Unit("terabyte", "T", false, Measure.COUNT, "storage", 1.099511627776E12, INTEGRAL, 4, false);
    public static final Unit DATE = new Unit("date", "", false, Measure.DATETIME, "metric", 86400.0, null, -1, false);
    public static final Unit TIMESTAMP = new Unit("timestamp", "", false, Measure.DATETIME, "metric", 1.0, null, -1, false);
    public static final Unit SECOND = new Unit("second", "s", false, Measure.TIME, "metric", 1.0, BASE60, 4, false);
    public static final Unit MINUTE = new Unit("minute", "m", false, Measure.TIME, "metric", 60.0, BASE60, 4, false);
    public static final Unit HOUR = new Unit("hour", "h", false, Measure.TIME, "metric", 3600.0, BASE12, 4, false);
    public static final Unit DAY = new Unit("day", "d", false, Measure.TIME, "metric", 86400.0, new double[]{2.0, 7.0, 14.0}, 4, false);
    public static final Unit WEEK = new Unit("week", "wk", false, Measure.TIME, "metric", 604800.0, INTEGRAL, 7, false);
    public static final Unit MONTH = new Unit("month", "mth", false, Measure.TIME, "metric", 2629800.0, BASE12, 4, false);
    public static final Unit QUARTER = new Unit("quarter", "q", false, Measure.TIME, "metric", 7889400.0, BASE8, 3, false);
    public static final Unit YEAR = new Unit("year", "yr", false, Measure.TIME, "metric", 3.15576E7, INTEGRAL, 5, false);
    public static final Unit CENTURY = new Unit("century", "C.", true, Measure.TIME, "metric", 3.15576E9, INTEGRAL, 4, false);
    public static final Unit TIME = new Unit("time", "", false, Measure.TIME, "metric", 1.0, BASE12, 4, false);
    public static final Unit KELVIN = new Unit("kelvin", "K", false, Measure.TEMPERATURE, "kelvin", 1.0, METRIC, 4, false);
    public static final Unit CELSIUS = new Unit("celcius", "C", false, Measure.TEMPERATURE, "celsisu", 0.0, METRIC, 4, false);
    public static final Unit FAHRENHEIT = new Unit("fahrenheit", "F", false, Measure.TEMPERATURE, "fahrenheit", 0.0, INTEGRAL, 4, false);
    public static final Unit RADIAN = new Unit("radian", "r", false, Measure.ANGLE, "metric", 1.0, METRIC, 4, false);
    public static final Unit DEGREE = new Unit("degree", "deg", false, Measure.ANGLE, "imperial", Math.PI / 180, BASE60, 4, false);
    public static final Unit DOLLARS = new Unit("dollar", "$", true, Measure.CURRENCY, "dollar", 1.0, METRIC, 4, false);
    public static final Unit EURO = new Unit("euro", "\u20ac", true, Measure.CURRENCY, "euro", 1.0, METRIC, 4, false);
    public static final Unit CATEGORICAL = new Unit("categorical", "", false, Measure.CATEGORY, "none", 1.0, INTEGRAL, 0, false);
    public static final Unit ORDINAL = new Unit("ordinal", "", false, Measure.ORDINAL, "none", 1.0, INTEGRAL, 0, false);
    public static final Unit RATIO = new Unit("numeric", "", false, Measure.NUMERIC, "none", 1.0, METRIC, 4, false);
    private static final Unit LOG = new Unit("log", "", false, Measure.LOG, "none", 1.0, METRIC, 4, false);
    public final String name;
    public final String abbreviation;
    public final Measure measure;
    public final String system;
    public final double baseConversionFactor;
    public final double[] multipliers;
    public final int minorDivisions;
    private final boolean prefixAbbrev;
    private final boolean customUnit;

    public static synchronized Unit get(String string, Unit unit) {
        if (string == null) {
            return unit;
        }
        Unit unit2 = all.get(string.toLowerCase());
        if (unit2 != null) {
            return unit2;
        }
        return new Unit(string.toLowerCase(), "", false, unit.measure, string, 1.0, unit.multipliers, unit.minorDivisions, true);
    }

    public final boolean isCustomUnit() {
        return this.customUnit;
    }

    public static boolean isWildCard(Unit unit) {
        return unit == TIME;
    }

    public static boolean isTime(Unit unit) {
        return unit == DATE || unit == TIMESTAMP;
    }

    private Unit(String string, String string2, boolean bl, Measure measure, String string3, double d, double[] dArray, int n, boolean bl2) {
        this.name = string;
        this.abbreviation = string2;
        this.prefixAbbrev = bl;
        this.measure = measure;
        this.system = string3;
        this.baseConversionFactor = d;
        this.multipliers = dArray;
        this.minorDivisions = n;
        this.customUnit = bl2;
        all.put(string, this);
        measure.units.add(this);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Unit)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.customUnit) {
            return false;
        }
        Unit unit = (Unit)object;
        return unit.customUnit && this.name.equals(unit.name) && this.measure.matches(unit.measure);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isPrefixAbbrev() {
        return this.prefixAbbrev;
    }

    public UnitMatchingCodes getMatchingLevel(Unit unit) {
        if (unit == null) {
            return UnitMatchingCodes.NO_MATCH;
        }
        boolean bl = unit.measure.matches(this.measure);
        if (!bl) {
            return UnitMatchingCodes.NO_MATCH;
        }
        boolean bl2 = unit.system.equals(this.system);
        if (!bl2) {
            return UnitMatchingCodes.MEASURE_MATCH;
        }
        return unit.name.equals(this.name) ? UnitMatchingCodes.UNIT_MATCH : UnitMatchingCodes.SYSTEM_MATCH;
    }
}

