/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.units;

import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.grammar.units.Measure;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.spec.internal.PreferredSizeSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class UnitConverter {
    public static final double IN_PX = 96.0;

    public static double convert(double d, Unit unit, Unit unit2) {
        if (unit == unit2) {
            return d;
        }
        if (unit.measure == Measure.TIME && unit2.measure == Measure.DATETIME) {
            if (unit2 == Unit.DATE) {
                return UnitConverter.convert(d, unit, Unit.DAY);
            }
            if (unit2 == Unit.TIMESTAMP) {
                return UnitConverter.convert(d, unit, Unit.SECOND);
            }
        }
        if (unit2.measure == Measure.TIME && unit.measure == Measure.DATETIME) {
            if (unit == Unit.DATE) {
                return UnitConverter.convert(d, Unit.DAY, unit2);
            }
            if (unit == Unit.TIMESTAMP) {
                return UnitConverter.convert(d, Unit.SECOND, unit2);
            }
        }
        if (unit.measure != unit2.measure) {
            if (unit.measure.matches(unit2.measure)) {
                return d;
            }
            return Double.NaN;
        }
        double d2 = unit.baseConversionFactor;
        double d3 = unit2.baseConversionFactor;
        if (d2 == 0.0 || d3 == 0.0) {
            return UnitConverter.convertSpecialCases(d, unit, unit2);
        }
        return d * d2 / d3;
    }

    public static Range convertRange(Range range, Unit unit, Unit unit2) {
        double d = UnitConverter.convert(range.getMin(), unit, unit2);
        double d2 = UnitConverter.convert(range.getMax(), unit, unit2);
        return new Range(d, d2);
    }

    private static double convertSpecialCases(double d, Unit unit, Unit unit2) {
        if (unit.measure == Measure.TEMPERATURE) {
            if (unit == Unit.CELSIUS && unit2 == Unit.FAHRENHEIT) {
                return d * 1.8 + 32.0;
            }
            if (unit == Unit.FAHRENHEIT && unit2 == Unit.CELSIUS) {
                return (d - 32.0) / 1.8;
            }
            if (unit == Unit.CELSIUS && unit2 == Unit.KELVIN) {
                return d + 273.15;
            }
            if (unit == Unit.KELVIN && unit2 == Unit.CELSIUS) {
                return d - 273.15;
            }
            if (unit == Unit.FAHRENHEIT && unit2 == Unit.KELVIN) {
                return (d - 32.0) / 1.8 + 273.15;
            }
            if (unit == Unit.KELVIN && unit2 == Unit.FAHRENHEIT) {
                return (d - 273.15) * 1.8 + 32.0;
            }
        } else if (unit.measure == Measure.TIME) {
            if (unit == Unit.MONTH && unit2 == Unit.YEAR) {
                return d / 12.0;
            }
            if (unit == Unit.YEAR && unit2 == Unit.MONTH) {
                return d * 12.0;
            }
        }
        return Double.NaN;
    }

    public static Double convertLength(Object object, Double d, Double d2) {
        Double d3;
        if (object == null) {
            return null;
        }
        if (BasicFactory.isNumber(object)) {
            Number number = (Number)object;
            double d4 = number.doubleValue();
            return Double.isNaN(d4) ? null : Double.valueOf(d4);
        }
        if (BasicFactory.isString(object)) {
            String string = (String)object;
            int n = string.length();
            if (string.endsWith("%%")) {
                if (d2 == null) {
                    return null;
                }
                return UnitConverter.tryParse(string.substring(0, n - 2), d2 / 100.0);
            }
            if (string.endsWith("%")) {
                if (d == null) {
                    return null;
                }
                return UnitConverter.tryParse(string.substring(0, n - 1), d / 100.0);
            }
            if (string.endsWith("px")) {
                return UnitConverter.tryParse(string.substring(0, n - 2), 1.0);
            }
            if (string.endsWith("pt")) {
                return UnitConverter.tryParse(string.substring(0, n - 2), 1.3333333344);
            }
            if (string.endsWith("pc")) {
                return UnitConverter.tryParse(string.substring(0, n - 2), 16.0000000032);
            }
            if (string.endsWith("cm")) {
                return UnitConverter.tryParse(string.substring(0, n - 2), 37.795275590399996);
            }
            if (string.endsWith("mm")) {
                return UnitConverter.tryParse(string.substring(0, n - 2), 3.7795275551999996);
            }
            if (string.endsWith("in")) {
                return UnitConverter.tryParse(string.substring(0, n - 2), 96.0);
            }
            return UnitConverter.tryParse(string, 1.0);
        }
        PreferredSizeSpec preferredSizeSpec = (PreferredSizeSpec)object;
        Double d5 = preferredSizeSpec.preferred == null ? null : UnitConverter.convertLength(preferredSizeSpec.preferred, d, d2);
        Double d6 = preferredSizeSpec.max == null ? null : UnitConverter.convertLength(preferredSizeSpec.max, d, d2);
        Double d7 = d3 = preferredSizeSpec.min == null ? null : UnitConverter.convertLength(preferredSizeSpec.min, d, d2);
        if (d5 == null) {
            d5 = d6 != null && d3 != null ? Double.valueOf((d6 + d3) / 2.0) : (d6 == null ? d3 : d6);
        } else {
            if (d6 != null) {
                Double d8 = d5 = d5 > d6 ? d6 : d5;
            }
            if (d3 != null) {
                d5 = d5 < d3 ? d3 : d5;
            }
        }
        return d5;
    }

    public static boolean isNegativeLength(Object object) {
        if (object == null) {
            return false;
        }
        if (BasicFactory.isNumber(object)) {
            return ((Number)object).doubleValue() < 0.0;
        }
        String string = (String)object;
        return string.startsWith("-");
    }

    private static Double tryParse(String string, double d) {
        try {
            double d2 = Double.parseDouble(string) * d;
            return Double.isNaN(d2) ? null : Double.valueOf(d2);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

