/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.values;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.values.DerivedValueProducer;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class DerivedValueProvider
extends ValueProvider {
    private final DerivedValueProducer target;
    private final String functionName;
    private final ValueProvider variableProvider;

    public DerivedValueProvider(Integer n, DerivedValueProducer derivedValueProducer, String string, ValueProvider valueProvider) {
        super(n);
        assert (derivedValueProducer != null);
        assert (string != null);
        assert (valueProvider != null);
        this.target = derivedValueProducer;
        this.functionName = string;
        this.variableProvider = valueProvider;
    }

    @Override
    public double getNumber(Row row) {
        double d = this.variableProvider.getNumber(row);
        return this.target.getDerivedValue(this.functionName, d, this.getSpan()).doubleValue();
    }

    @Override
    public Double toZeroOne(double d, Scale scale) {
        return this.variableProvider.toZeroOne(d, scale);
    }

    @Override
    public boolean getIncludeInRange() {
        return this.variableProvider.getIncludeInRange();
    }

    @Override
    public Range getRange() {
        Range range = this.variableProvider.getRange();
        Number number = this.target.getDerivedValue(this.functionName, range.getMin(), this.getSpan());
        Number number2 = this.target.getDerivedValue(this.functionName, range.getMax(), this.getSpan());
        if (number != null && number2 != null) {
            return new Range(number.doubleValue(), number2.doubleValue());
        }
        return null;
    }

    @Override
    public boolean isCategorical() {
        return false;
    }

    @Override
    public String getLabel() {
        return this.variableProvider.getLabel();
    }

    @Override
    public Field getBaseField() {
        return null;
    }

    @Override
    public Unit getUnit() {
        return this.variableProvider.getUnit();
    }

    @Override
    public Double getGranularity() {
        return this.variableProvider.getGranularity();
    }

    @Override
    public void enableOrdering(boolean bl) {
    }
}

