/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.values;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.format.RAVEFormatter;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class FieldValueProvider
extends ValueProvider {
    private final Field field;
    private final boolean includeInRange;
    private boolean allowOrdering;

    public FieldValueProvider(Integer n, Field field, boolean bl) {
        super(n);
        assert (field != null);
        this.field = field;
        this.includeInRange = bl;
        this.allowOrdering = false;
    }

    @Override
    public double getNumber(Row row) {
        Field field = this.field;
        if (field != null) {
            int n = field.getIndex();
            double[] dArray = row.data;
            if (dArray != null && n < dArray.length) {
                double d = dArray[n];
                int[] nArray = field.order;
                if (nArray != null) {
                    if (!this.allowOrdering) {
                        throw new SpecException("Order given for categories other than stacked values.", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
                    }
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] != (int)d) continue;
                        return i;
                    }
                }
                return d;
            }
        }
        return Double.NaN;
    }

    @Override
    public boolean getIncludeInRange() {
        return this.includeInRange;
    }

    @Override
    public boolean isCategorical() {
        return this.getUnit().measure.categorical;
    }

    @Override
    public Double getMinimalDataDiff() {
        return this.field.getMinimalDataDiff();
    }

    @Override
    public String[] getCategories() {
        return this.field.categories;
    }

    @Override
    public Range getRange() {
        return this.field.range;
    }

    @Override
    public String getLabel() {
        return this.field.label;
    }

    @Override
    public Field getBaseField() {
        return this.field;
    }

    @Override
    public Unit getUnit() {
        return this.field.unit;
    }

    @Override
    public Double getGranularity() {
        return this.field.granularity;
    }

    @Override
    public RAVEFormatter getFormatter() {
        return this.field.getSpecifiedFormatter();
    }

    @Override
    public void enableOrdering(boolean bl) {
        this.allowOrdering = bl;
    }
}

