/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.values;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class NumberValueProvider
extends ValueProvider {
    private final Number number;
    private final boolean includeInRange;
    private final Unit unit;

    public NumberValueProvider(Integer n, Number number, boolean bl, Unit unit) {
        super(n);
        assert (number != null);
        this.number = number;
        this.includeInRange = bl;
        this.unit = unit;
    }

    @Override
    public double getNumber(Row row) {
        return this.number.doubleValue();
    }

    @Override
    public boolean getIncludeInRange() {
        return this.includeInRange;
    }

    @Override
    public boolean isCategorical() {
        return this.unit != null ? this.unit.measure.categorical : false;
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public String[] getCategories() {
        if (this.isCategorical()) {
            return new String[]{"0"};
        }
        return null;
    }

    @Override
    public Range getRange() {
        return new Range(this.number.doubleValue(), this.number.doubleValue());
    }

    @Override
    public String getLabel() {
        return BasicFactory.unformattedNumber(this.number);
    }

    @Override
    public Field getBaseField() {
        return null;
    }

    @Override
    public Double getGranularity() {
        return null;
    }

    @Override
    public void enableOrdering(boolean bl) {
    }
}

