/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.values;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class PercentageValueProvider
extends ValueProvider {
    private final Number fraction;

    public PercentageValueProvider(Integer n, Number number) {
        super(n);
        this.fraction = number;
        this.type = ValueProvider.ProviderType.PERCENTAGE;
    }

    @Override
    public double getNumber(Row row) {
        return this.fraction.doubleValue();
    }

    @Override
    public Double toZeroOne(double d, Scale scale) {
        Range range = scale.getPaddedRange();
        return range.fromZeroOne(this.fraction.doubleValue());
    }

    @Override
    public Range getRange() {
        return new Range(this.fraction.doubleValue(), this.fraction.doubleValue());
    }

    @Override
    public boolean getIncludeInRange() {
        return false;
    }

    @Override
    public boolean isCategorical() {
        return false;
    }

    @Override
    public Unit getUnit() {
        return null;
    }

    @Override
    public String getLabel() {
        return this.fraction.toString();
    }

    @Override
    public Field getBaseField() {
        return null;
    }

    @Override
    public Double getGranularity() {
        return null;
    }

    @Override
    public void enableOrdering(boolean bl) {
    }
}

