/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.values;

import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.data.Range;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.format.RAVEFormatter;
import com.ibm.vis.engine.internal.grammar.scale.Scale;
import com.ibm.vis.engine.internal.grammar.scale.ScaleSpan;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public abstract class ValueProvider {
    protected ProviderType type = ProviderType.NONE;
    private Integer span = null;

    public ValueProvider(Integer n) {
        this.span = n;
    }

    public abstract double getNumber(Row var1);

    public Double toZeroOne(double d, Scale scale) {
        return scale.toZeroOne(d, this.getUnit(), this.getSpan());
    }

    public ScaleSpan getMatchingSpan(Number number, Scale scale) {
        return scale.getMatchingSpan(number, this.getUnit());
    }

    public abstract boolean getIncludeInRange();

    public abstract Field getBaseField();

    public abstract boolean isCategorical();

    public abstract String getLabel();

    public abstract Unit getUnit();

    public abstract Double getGranularity();

    public abstract Range getRange();

    public Double getMinimalDataDiff() {
        return null;
    }

    public RAVEFormatter getFormatter() {
        return null;
    }

    public String[] getCategories() {
        if (this.getUnit() != null && this.getUnit().measure.categorical) {
            return new String[0];
        }
        return null;
    }

    public abstract void enableOrdering(boolean var1);

    public final Integer getSpan() {
        return this.span;
    }

    public ProviderType getType() {
        return this.type;
    }

    public static enum ProviderType {
        NONE,
        PERCENTAGE;

    }
}

