/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.grammar.values;

import com.ibm.vis.engine.internal.IdentifiableItem;
import com.ibm.vis.engine.internal.VisInterface;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.format.RAVEFormatter;
import com.ibm.vis.engine.internal.grammar.units.Unit;
import com.ibm.vis.engine.internal.grammar.values.DefaultValueProvider;
import com.ibm.vis.engine.internal.grammar.values.DerivedValueProducer;
import com.ibm.vis.engine.internal.grammar.values.DerivedValueProvider;
import com.ibm.vis.engine.internal.grammar.values.FieldValueProvider;
import com.ibm.vis.engine.internal.grammar.values.NumberValueProvider;
import com.ibm.vis.engine.internal.grammar.values.PercentageValueProvider;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.SpecException;
import com.ibm.vis.spec.internal.AestheticSpec;
import com.ibm.vis.spec.internal.ComponentSpec;
import com.ibm.vis.spec.internal.ElementRefSpec;
import com.ibm.vis.spec.internal.FieldValueRefSpec;
import com.ibm.vis.spec.internal.PositionSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ValueProviderFactory {
    public static final ValueProvider DEFAULT = new DefaultValueProvider(null, false, Unit.CATEGORICAL);

    public static ValueProvider makePositionProvider(PositionSpec positionSpec, VisInterface visInterface) {
        Integer n = positionSpec.span == null ? null : Integer.valueOf(positionSpec.span.intValue());
        int n2 = 0;
        if (positionSpec.derivedValue != null) {
            ++n2;
        }
        if (positionSpec.field != null) {
            ++n2;
        }
        if (positionSpec.value != null) {
            ++n2;
        }
        if (n2 != 1) {
            throw new SpecException("Positions must specify exactly one of 'field', 'value', or 'derivedValue'", ErrorCode.SPEC_INVALID_PARAMETERS, null);
        }
        if (positionSpec.derivedValue != null) {
            return ValueProviderFactory.makeFromDerivedValue(visInterface, positionSpec.derivedValue.target, positionSpec.derivedValue.functionName, positionSpec.derivedValue.variable, n);
        }
        if (positionSpec.field != null) {
            return ValueProviderFactory.makeFromField(visInterface, positionSpec.field, Field.LocalFormatterType.POSITION, false, n);
        }
        boolean bl = positionSpec.includeInRange;
        return ValueProviderFactory.makeFromValue(positionSpec.value, bl, null, n);
    }

    public static ValueProvider makeComponentProvider(ComponentSpec componentSpec, VisInterface visInterface) {
        int n = 0;
        if (componentSpec.field != null) {
            ++n;
        }
        if (componentSpec.value != null) {
            ++n;
        }
        if (n != 1) {
            throw new SpecException("Components must specify exactly one of 'field' or 'value'", ErrorCode.SPEC_INVALID_PARAMETERS, null);
        }
        if (componentSpec.field != null) {
            return ValueProviderFactory.makeFromField(visInterface, componentSpec.field, Field.LocalFormatterType.COMPONENT, false, null);
        }
        return ValueProviderFactory.makeFromNumber(componentSpec.value, false, Unit.CATEGORICAL, null);
    }

    public static ValueProvider makeAestheticProvider(AestheticSpec aestheticSpec, VisInterface visInterface) {
        int n = 0;
        if (aestheticSpec.field != null) {
            ++n;
        }
        if (aestheticSpec.value != null) {
            ++n;
        }
        if (n != 1) {
            throw new SpecException("Aesthetics must specify exactly one of 'field' or 'value'", ErrorCode.SPEC_INVALID_PARAMETERS, null);
        }
        if (aestheticSpec.field != null) {
            return ValueProviderFactory.makeFromField(visInterface, aestheticSpec.field, Field.LocalFormatterType.AESTHETICS, false, null);
        }
        return ValueProviderFactory.makeFromNumber(aestheticSpec.value, false, null, null);
    }

    static ValueProvider makeFromDerivedValue(VisInterface visInterface, ElementRefSpec elementRefSpec, String string, Object object, Integer n) {
        assert (elementRefSpec != null);
        assert (string != null);
        assert (object != null);
        IdentifiableItem identifiableItem = visInterface.getByID(elementRefSpec.$ref);
        if (!(identifiableItem instanceof DerivedValueProducer)) {
            return DEFAULT;
        }
        ValueProvider valueProvider = object instanceof FieldValueRefSpec ? ValueProviderFactory.makeFromField(visInterface, (FieldValueRefSpec)object, Field.LocalFormatterType.POSITION, false, n) : ValueProviderFactory.makeFromValue(object, false, null, n);
        return new DerivedValueProvider(n, (DerivedValueProducer)((Object)identifiableItem), string, valueProvider);
    }

    static ValueProvider makeFromField(VisInterface visInterface, FieldValueRefSpec fieldValueRefSpec, Field.LocalFormatterType localFormatterType, boolean bl, Integer n) {
        assert (fieldValueRefSpec != null);
        IdentifiableItem identifiableItem = visInterface.getByID(fieldValueRefSpec.$ref);
        if (identifiableItem instanceof Field) {
            if (fieldValueRefSpec.format != null) {
                Field field = (Field)identifiableItem;
                field.setLocalFormatter(RAVEFormatter.makeFromSpec(fieldValueRefSpec.format, visInterface.getVisContext().getLocale()), localFormatterType);
                return new FieldValueProvider(n, field, bl);
            }
            ((Field)identifiableItem).setLocalFormatter(null, null);
            return new FieldValueProvider(n, (Field)identifiableItem, bl);
        }
        throw new SpecException("The reference is not defined in the spec: " + fieldValueRefSpec.$ref, ErrorCode.SPEC_UNDEFINED_REFERENCE, null);
    }

    static ValueProvider makeFromValue(Object object, boolean bl, Unit unit, Integer n) {
        assert (object != null);
        if (BasicFactory.isNumber(object)) {
            return ValueProviderFactory.makeFromNumber((Number)object, bl, unit, n);
        }
        if (BasicFactory.isString(object)) {
            return ValueProviderFactory.makeFromString((String)object, unit, n);
        }
        return DEFAULT;
    }

    static ValueProvider makeFromNumber(Number number, boolean bl, Unit unit, Integer n) {
        assert (number != null);
        return new NumberValueProvider(n, number, bl, unit);
    }

    static ValueProvider makeFromString(String string, Unit unit, Integer n) {
        try {
            if (string.endsWith("%")) {
                return new PercentageValueProvider(n, Double.parseDouble(string.substring(0, string.length() - 1)) / 100.0);
            }
            return new NumberValueProvider(n, Double.parseDouble(string), false, unit);
        }
        catch (Exception exception) {
            throw new SpecException("only '%' and numbers are supported as string values in element position.", ErrorCode.SPEC_INVALID_LENGTH, null);
        }
    }
}

