/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.image;

import com.ibm.vis.engine.internal.image.ImageResource;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.scenetree.provisional.ShapeProperty;
import com.ibm.vis.scenetree.provisional.TransformInfoImpl;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public final class ImageFill
implements ShapeProperty {
    private String method;
    private ImageResource source;
    private double alpha;
    private double x;
    private double y;
    private double width;
    private double height;
    private boolean clip;
    private String highlightRectID;
    private int tileX;
    private int tileY;
    private TransformInfoImpl transformInfo;

    private ImageFill(String string, ImageResource imageResource, double d, double d2, double d3, double d4, double d5, boolean bl, String string2, int n, int n2) {
        assert (n > 0);
        assert (n2 > 0);
        assert (d5 >= 0.0);
        assert (d5 <= 1.0);
        this.method = string;
        this.source = imageResource;
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
        this.alpha = d5;
        this.clip = bl;
        this.highlightRectID = string2;
        this.tileX = n;
        this.tileY = n2;
    }

    public static ImageFill createIcon(ImageResource imageResource, Rect rect, double d, boolean bl, String string) {
        return new ImageFill("icon", imageResource, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), d, bl, string, 1, 1);
    }

    public static ImageFill createTexture(ImageResource imageResource, Rect rect, double d, boolean bl, int n, int n2) {
        return new ImageFill("texture", imageResource, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), d, bl, null, n, n2);
    }

    public static ImageFill createFit(ImageResource imageResource, Rect rect, double d, boolean bl) {
        return new ImageFill("fit", imageResource, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), d, bl, null, 1, 1);
    }

    public static ImageFill createStretch(ImageResource imageResource, Rect rect, double d, boolean bl) {
        return new ImageFill("stretch", imageResource, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), d, bl, null, 1, 1);
    }

    public static ImageFill createFill(ImageResource imageResource, Rect rect, double d, boolean bl) {
        return new ImageFill("fill", imageResource, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), d, bl, null, 1, 1);
    }

    public String getMethod() {
        return this.method;
    }

    public ImageResource getImageResource() {
        return this.source;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean isClipped() {
        return this.clip;
    }

    public String getHighlightRectID() {
        return this.highlightRectID;
    }

    public int getTileX() {
        return this.tileX;
    }

    public int getTileY() {
        return this.tileY;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ImageFill)) {
            return false;
        }
        ImageFill imageFill = (ImageFill)object;
        if (this.highlightRectID == null ? imageFill.highlightRectID != null : !this.highlightRectID.equals(imageFill.highlightRectID)) {
            return false;
        }
        return this.alpha == imageFill.alpha && this.clip == imageFill.clip && this.method.equals(imageFill.method) && this.source.equals(imageFill.source) && this.tileX == imageFill.tileX && this.tileY == imageFill.tileY && this.x == imageFill.x && this.y == imageFill.y && this.width == imageFill.width && this.height == imageFill.height && this.transformInfo == imageFill.transformInfo;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.alpha * 255.0);
        n = 31 * n + (this.clip ? 1231 : 1237);
        n = 31 * n + (this.highlightRectID == null ? 0 : this.highlightRectID.hashCode());
        n = 31 * n + this.method.hashCode();
        n = 31 * n + this.source.hashCode();
        n = 31 * n + this.tileX;
        n = 31 * n + this.tileY;
        n = 31 * n + (int)(this.x * 1000.0);
        n = 31 * n + (int)(this.y * 1000.0);
        n = 31 * n + (int)(this.width * 1000.0);
        n = 31 * n + (int)(this.height * 1000.0);
        if (this.transformInfo != null) {
            n = 31 * n + this.transformInfo.hashCode();
        }
        return n;
    }

    public ImageFill createResizedFill(double d, double d2) {
        if (d == this.width && d2 == this.height) {
            return this;
        }
        return new ImageFill(this.method, this.source, this.x, this.y, d, d2, this.alpha, this.clip, this.highlightRectID, this.tileX, this.tileY);
    }

    public ImageFill createMovedFill(double d, double d2) {
        if (this.x == d && this.y == d2) {
            return this;
        }
        return new ImageFill(this.method, this.source, d, d2, this.width, this.height, this.alpha, this.clip, this.highlightRectID, this.tileX, this.tileY);
    }

    public ImageFill createFillInBounds(double d, double d2, double d3, double d4) {
        if (this.x == d && this.y == d2 && d3 == this.width && d4 == this.height) {
            return this;
        }
        return new ImageFill(this.method, this.source, d, d2, d3, d4, this.alpha, this.clip, this.highlightRectID, this.tileX, this.tileY);
    }

    public ImageFill createClippedFill(boolean bl) {
        if (bl == this.clip) {
            return this;
        }
        return new ImageFill(this.method, this.source, this.x, this.y, this.width, this.height, this.alpha, bl, this.highlightRectID, this.tileX, this.tileY);
    }

    public ImageFill createTiledFill(int n, int n2) {
        if (this.tileX == n && this.tileY == n2) {
            return this;
        }
        return new ImageFill(this.method, this.source, this.x, this.y, this.width, this.height, this.alpha, this.clip, this.highlightRectID, n, n2);
    }

    public ImageFill createHighlightedFill(String string) {
        if (string.equals(this.highlightRectID)) {
            return this;
        }
        return new ImageFill(this.method, this.source, this.x, this.y, this.width, this.height, this.alpha, this.clip, string, this.tileX, this.tileY);
    }

    public TransformInfoImpl getTransformInfo() {
        if (this.transformInfo == null) {
            this.transformInfo = new TransformInfoImpl();
        }
        return this.transformInfo;
    }
}

