/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.image;

import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.resource.GraphicNativeResource;
import com.ibm.vis.engine.internal.resource.ResourceService;
import com.ibm.vis.spec.internal.ResourceSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2013,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ImageResource {
    private GraphicNativeResource iGraphRes;
    protected boolean loaded;
    protected double width;
    protected double height;
    private String[] URIs;
    private String embeddedData;
    private String type;
    private ResourceSpec spec;

    protected ImageResource(ResourceSpec resourceSpec) {
        this.spec = (ResourceSpec)resourceSpec.copy();
        this.URIs = this.spec.URIs;
        this.embeddedData = this.spec.embeddedData;
        this.type = this.spec.type;
        this.loaded = false;
    }

    public static ImageResource create(ResourceSpec resourceSpec) {
        ImageResource imageResource = new ImageResource(resourceSpec);
        imageResource.load();
        return imageResource;
    }

    public boolean isLoaded() {
        if (!this.loaded) {
            this.load();
        }
        return this.loaded;
    }

    protected void load() {
        if (this.iGraphRes == null) {
            ResourceService resourceService = ResourceService.getInstance();
            this.iGraphRes = (GraphicNativeResource)resourceService.getResource(this.spec, null);
        }
        if (!this.iGraphRes.isBlocked()) {
            this.iGraphRes.getData();
            this.width = this.iGraphRes.getWidth();
            this.height = this.iGraphRes.getHeight();
            this.loaded = true;
        }
    }

    public final GraphicNativeResource getNativeResource() {
        return this.iGraphRes;
    }

    public String[] getURIs() {
        return this.URIs;
    }

    public String getEmbeddedData() {
        return this.embeddedData;
    }

    public String getType() {
        return this.type;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }
}

