/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.defender;

import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.data.Field;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.interaction.defender.ZoomAction;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.spec.internal.VisJSONSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class DefenderFocus {
    protected Vis vis;
    protected Vis controllerVis;
    String thumbnailDataUnit;

    public DefenderFocus(Vis vis, Vis vis2) {
        this.vis = vis;
        this.controllerVis = vis2;
        this.thumbnailDataUnit = this.getThumbnailDataUnit(vis.getGrammar());
    }

    public VisJSONSpec updateSpec(double[] dArray) {
        if (dArray.length == 2) {
            Grammar[] grammarArray = this.vis.getGrammar();
            for (int i = 0; i < grammarArray.length; ++i) {
                if (DefenderFocus.isThumbnail(grammarArray[i])) continue;
                ZoomAction zoomAction = new ZoomAction(grammarArray[i]);
                zoomAction.zoomToCoordinatesWithDataFilter(new Double[]{null, dArray[0]}, new Double[]{null, dArray[1]}, true, this.thumbnailDataUnit);
            }
        }
        return this.vis.getCurrentSpec();
    }

    private String getThumbnailDataUnit(Grammar[] grammarArray) {
        String string = null;
        block0: for (int i = 0; i < grammarArray.length; ++i) {
            if (!DefenderFocus.isThumbnail(grammarArray[i])) continue;
            Grammar grammar = this.controllerVis.getGrammar()[i];
            Element[] elementArray = grammar.elements;
            for (int j = 0; j < elementArray.length; ++j) {
                ValueProvider valueProvider = elementArray[j].positions[1];
                Field field = valueProvider.getBaseField();
                if (field == null || string != null) continue;
                string = field.unit.name;
                continue block0;
            }
        }
        return string;
    }

    public static boolean isThumbnail(Grammar grammar) {
        Element[] elementArray;
        boolean bl = false;
        String string = "scrollUnit";
        for (Element element : elementArray = grammar.elements) {
            if (!string.equals(element.interactionType)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

