/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.defender;

import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.Vis;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.interaction.effect.EffectBuilder;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.struct.Schema;
import com.ibm.vis.engine.internal.struct.Shape;
import com.ibm.vis.geom.Dim;
import com.ibm.vis.geom.Rect;
import com.ibm.vis.spec.internal.BoundsSpec;
import com.ibm.vis.spec.internal.ElementsSpec;
import com.ibm.vis.spec.internal.PositionSpec;
import com.ibm.vis.spec.internal.StyleSpec;
import com.ibm.vis.spec.internal.SymbolShapeSpec;
import com.ibm.vis.spec.internal.SymbolSpec;
import com.ibm.vis.spec.internal.VisJSONSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ScrollUnitRenderer {
    private static final String RECT_RIGHT = "rectRight";
    private static final String RECT_LEFT = "rectLeft";
    private static final String MEDIAN = "median";
    private static final String SECOND_GRABBER = "secondGrabber";
    private static final String FIRST_GRABBER = "firstGrabber";
    private static final String MAIN_GRABBER = "mainGrabber";
    private static final String PERCENTAGE_STRING = "%";
    protected double last;
    protected Shape shape;
    private EffectBuilder builder;
    private boolean blnScroll;
    private Shape mainGrabber;
    private Shape firstGrabber;
    private Shape secondGrabber;
    private Shape median;
    private Shape rectLeft;
    private Shape rectRight;
    private double thumbNailWidth;
    private String clickedPart;
    Vis vis;
    public static final String INTERACTION_SCROLL_UNIT = "scrollUnit";

    public void install(EffectBuilder effectBuilder, Vis vis) {
        if (effectBuilder != null) {
            this.builder = effectBuilder;
        }
        this.shape = vis.retrieveDefenderScrollUnit();
        if (this.shape != null) {
            this.setGrabbers();
            this.thumbNailWidth = this.getThumbNailGrammarWidth();
        }
    }

    public void setStartPoint(double d, double d2) {
        String string = this.getPartContainingPoint(d, d2);
        if (string != null) {
            this.last = d;
            this.blnScroll = true;
            this.clickedPart = string;
        } else {
            this.blnScroll = false;
        }
    }

    public double[] updateScrollUnit(double d, Shape shape, Shape shape2, Shape shape3, Shape shape4, boolean bl) {
        if (this.blnScroll) {
            double d2 = d - this.last;
            if (bl) {
                this.last = d;
            }
            this.readjustScrollUnit(d2, shape, shape2, shape3, shape4, bl);
        }
        return this.getScrollUnitCoordinates((Rect)shape.getGeom(), (Rect)shape2.getGeom(), (Rect)shape3.getGeom(), (Rect)shape4.getGeom());
    }

    public double[] getScrollUnitPosition() {
        return this.getScrollUnitCoordinates((Rect)this.firstGrabber.getGeom(), (Rect)this.secondGrabber.getGeom(), (Rect)this.mainGrabber.getGeom(), (Rect)this.median.getGeom());
    }

    private void readjustScrollUnit(double d, Shape shape, Shape shape2, Shape shape3, Shape shape4, boolean bl) {
        boolean bl2 = true;
        boolean bl3 = true;
        if (Math.round(shape.getX()) == Math.round(shape2.getX())) {
            bl2 = this.setOverlaidGrabber(d, shape, shape3, shape4);
            bl3 = false;
        }
        if ((MEDIAN.equals(this.clickedPart) || MAIN_GRABBER.equals(this.clickedPart)) && bl2) {
            this.moveScrollUnit(d, shape, shape2, shape3, shape4);
        } else if (FIRST_GRABBER.equals(this.clickedPart)) {
            this.dragGrabber(d, shape);
        } else if (SECOND_GRABBER.equals(this.clickedPart)) {
            this.dragGrabber(d, shape2);
        }
        this.adjustMedian(shape, shape2, shape4);
        this.validateAndRepositionGrabber(shape, shape, shape2, shape4);
        this.validateAndRepositionGrabber(shape2, shape, shape2, shape4);
        if (bl3) {
            this.updateBaseGrabber(shape3, shape4);
        }
        if (Math.round(shape.getX()) == Math.round(shape2.getX())) {
            this.setOverlaidGrabber(d, shape, shape3, shape4);
        }
        if (bl) {
            this.adjustInactiveRegions();
        }
    }

    private void validateAndRepositionGrabber(Shape shape, Shape shape2, Shape shape3, Shape shape4) {
        if (shape.getX() < 0.0) {
            shape.setX(0.0);
            shape4.setX(shape.getX() + shape.getWidth() / 2.0);
            shape4.setWidth(Math.abs(shape2.getX() - shape3.getX()));
        } else if (shape.getX() + shape.getWidth() > this.thumbNailWidth) {
            shape.setX(this.thumbNailWidth - shape.getWidth());
            shape4.setWidth(Math.abs(shape2.getX() - shape3.getX()));
        }
    }

    private void adjustMedian(Shape shape, Shape shape2, Shape shape3) {
        double d = shape.getX() <= shape2.getX() ? shape.getX() : shape2.getX();
        double d2 = shape.getX() >= shape2.getX() ? shape.getX() : shape2.getX();
        double d3 = shape.getWidth();
        shape3.setX(d + d3 / 2.0);
        shape3.setWidth(d2 - d);
    }

    private void dragGrabber(double d, Shape shape) {
        d = this.capShiftXForGrabber(d, (Rect)shape.getGeom());
        shape.setX(shape.getX() + d);
    }

    private void adjustInactiveRegions() {
        this.rectLeft.setWidth(this.median.getX() - this.rectLeft.getX());
        this.rectRight.setX(this.median.getX() + this.median.getWidth());
        this.rectRight.setWidth(this.thumbNailWidth - this.rectLeft.getWidth() - this.median.getWidth());
    }

    private boolean setOverlaidGrabber(double d, Shape shape, Shape shape2, Shape shape3) {
        boolean bl = true;
        shape3.setX(shape.getX() + shape.getWidth() / 3.0);
        shape3.setWidth(shape.getWidth() / 3.0);
        shape2.setWidth(shape.getHeight() / 2.0);
        if (Math.round(shape.getX()) == 0L) {
            shape2.setX(shape3.getX());
        } else {
            shape2.setX(shape3.getX() - shape.getHeight() / 2.0);
        }
        if (shape2.getX() < 0.0 && d <= 0.0) {
            shape2.setX(0.0);
            bl = false;
        } else if (shape2.getX() + shape2.getWidth() > this.thumbNailWidth) {
            shape2.setX(this.thumbNailWidth - shape2.getWidth());
            bl = false;
        }
        return bl;
    }

    private void updateBaseGrabber(Shape shape, Shape shape2) {
        shape.setX(shape2.getX() + shape2.getWidth() / 4.0);
        shape.setWidth(shape2.getWidth() / 2.0);
    }

    private void moveScrollUnit(double d, Shape shape, Shape shape2, Shape shape3, Shape shape4) {
        d = this.capShiftX(d);
        shape3.affine(1.0, d, 1.0, 0.0, false);
        shape.affine(1.0, d, 1.0, 0.0, false);
        shape2.affine(1.0, d, 1.0, 0.0, false);
        shape4.affine(1.0, d, 1.0, 0.0, false);
    }

    private double capShiftX(double d) {
        double d2 = this.firstGrabber.getX() <= this.secondGrabber.getX() ? this.firstGrabber.getX() : this.secondGrabber.getX();
        double d3 = this.firstGrabber.getX() >= this.secondGrabber.getX() ? this.firstGrabber.getX() : this.secondGrabber.getX();
        double d4 = this.firstGrabber.getWidth();
        if (d < 0.0 && d + d2 < 0.0) {
            return -d2;
        }
        if (d > 0.0 && d + d3 + d4 > this.thumbNailWidth) {
            return this.thumbNailWidth - (d3 + d4);
        }
        return d;
    }

    private double capShiftXForGrabber(double d, Rect rect) {
        if (d < 0.0 && d + rect.getX() < 0.0) {
            return -rect.getX();
        }
        if (d > 0.0 && d + rect.getX() + rect.getWidth() > this.thumbNailWidth) {
            return this.thumbNailWidth - (rect.getX() + rect.getWidth());
        }
        return d;
    }

    private void setGrabbers() {
        Shape[] shapeArray = this.shape.getParts();
        for (int i = 0; i < shapeArray.length; ++i) {
            if (MAIN_GRABBER.equals(shapeArray[i].getElementPart())) {
                this.mainGrabber = shapeArray[i];
                this.mainGrabber.setRelativeToParent(false);
                continue;
            }
            if (FIRST_GRABBER.equals(shapeArray[i].getElementPart())) {
                this.firstGrabber = shapeArray[i];
                this.firstGrabber.setRelativeToParent(false);
                continue;
            }
            if (SECOND_GRABBER.equals(shapeArray[i].getElementPart())) {
                this.secondGrabber = shapeArray[i];
                this.secondGrabber.setRelativeToParent(false);
                continue;
            }
            if (MEDIAN.equals(shapeArray[i].getElementPart())) {
                this.median = shapeArray[i];
                this.median.setRelativeToParent(false);
                continue;
            }
            if (RECT_LEFT.equals(shapeArray[i].getElementPart())) {
                this.rectLeft = shapeArray[i];
                this.rectLeft.setRelativeToParent(false);
                continue;
            }
            if (!RECT_RIGHT.equals(shapeArray[i].getElementPart())) continue;
            this.rectRight = shapeArray[i];
            this.rectRight.setRelativeToParent(false);
        }
    }

    private String getPartContainingPoint(double d, double d2) {
        String string = null;
        if (this.firstGrabber.getGeom().containsPt(d, d2)) {
            string = this.firstGrabber.getElementPart();
        } else if (this.secondGrabber.getGeom().containsPt(d, d2)) {
            string = this.secondGrabber.getElementPart();
        } else if (this.median.getGeom().containsPt(d, d2)) {
            string = this.median.getElementPart();
        } else if (this.mainGrabber.getGeom().containsPt(d, d2)) {
            string = this.mainGrabber.getElementPart();
        }
        return string;
    }

    public double[] getScrollUnitCoordinates(Rect rect, Rect rect2, Rect rect3, Rect rect4) {
        double[] dArray = new double[4];
        double d = rect.getWidth() / 2.0;
        dArray[0] = rect4.getY();
        dArray[1] = rect4.getY() + rect4.getHeight();
        if (rect.getX() == rect2.getX()) {
            dArray[2] = rect3.getX();
            dArray[3] = rect3.getX() + d >= this.thumbNailWidth ? this.thumbNailWidth : rect3.getX() + d;
        } else {
            dArray[2] = rect4.getX();
            dArray[3] = rect4.getX() + rect4.getWidth();
        }
        return dArray;
    }

    public void resetGrabbers(Shape shape, Shape shape2, Shape shape3, Shape shape4) {
        Shape[] shapeArray = this.shape.getParts();
        for (int i = 0; i < shapeArray.length; ++i) {
            if (MAIN_GRABBER.equals(shapeArray[i].getElementPart())) {
                this.mainGrabber = shape3;
                continue;
            }
            if (FIRST_GRABBER.equals(shapeArray[i].getElementPart())) {
                this.firstGrabber = shape;
                continue;
            }
            if (SECOND_GRABBER.equals(shapeArray[i].getElementPart())) {
                this.secondGrabber = shape2;
                continue;
            }
            if (!MEDIAN.equals(shapeArray[i].getElementPart())) continue;
            this.median = shape4;
        }
    }

    private double getThumbNailGrammarWidth() {
        return ((Rect)this.rectLeft.getGeom()).getWidth() + ((Rect)this.median.getGeom()).getWidth() + ((Rect)this.rectRight.getGeom()).getWidth();
    }

    public Shape getScrollUnit() {
        return this.shape;
    }

    public boolean isBlnScroll() {
        return this.blnScroll;
    }

    public VisJSONSpec updateSpec(double[] dArray, Vis vis) {
        if (dArray.length == 2) {
            Grammar[] grammarArray = vis.getGrammar();
            block0: for (int i = 0; i < grammarArray.length; ++i) {
                Element[] elementArray;
                for (Element element : elementArray = grammarArray[i].elements) {
                    if (!INTERACTION_SCROLL_UNIT.equals(element.interactionType)) continue;
                    this.updateScrollUnitSpec(dArray, element);
                    continue block0;
                }
            }
        }
        return vis.getCurrentSpec();
    }

    private void updateScrollUnitSpec(double[] dArray, Element element) {
        ElementsSpec elementsSpec = element.spec;
        StyleSpec styleSpec = elementsSpec.style;
        SymbolSpec symbolSpec = (SymbolSpec)styleSpec.symbol;
        PositionSpec[] positionSpecArray = elementsSpec.position;
        Schema schema = (Schema)this.shape;
        Shape[] shapeArray = schema.getParts();
        Dim dim = element.calculateDefaultShapeSize(styleSpec);
        double d = dim.getWidth();
        double d2 = dim.getHeight();
        Rect rect = (Rect)this.median.getGeom();
        double d3 = rect.getX() + rect.getWidth() / 2.0;
        double d4 = schema.getBounds().getY() + d2 / 2.0;
        double d5 = d3 - d / 2.0;
        double d6 = d4 - d2 / 2.0;
        PositionSpec positionSpec = new PositionSpec();
        positionSpec.field = positionSpecArray[1].field;
        positionSpec.value = (dArray[0] + dArray[1]) / 2.0;
        positionSpecArray[1] = positionSpec;
        for (int i = 0; i < shapeArray.length; ++i) {
            Shape shape = shapeArray[i];
            String string = shape.getElementPart();
            if (RECT_LEFT.equals(string) || RECT_RIGHT.equals(string)) continue;
            for (int j = 0; j < symbolSpec.shape.length; ++j) {
                SymbolShapeSpec symbolShapeSpec = symbolSpec.shape[j];
                if (!string.equals(symbolShapeSpec.part)) continue;
                ScrollUnitRenderer.modifyShape(symbolShapeSpec, (Rect)shape.getGeom(), d5, d6, d, d2);
            }
        }
    }

    private static void modifyShape(SymbolShapeSpec symbolShapeSpec, Rect rect, double d, double d2, double d3, double d4) {
        BoundsSpec boundsSpec = new BoundsSpec();
        boundsSpec.left = (rect.getX() - d) * 100.0 / d3 + PERCENTAGE_STRING;
        boundsSpec.top = (rect.getY() - d2) * 100.0 / d4 + PERCENTAGE_STRING;
        boundsSpec.width = rect.getWidth() * 100.0 / d3 + PERCENTAGE_STRING;
        boundsSpec.height = rect.getHeight() * 100.0 / d4 + PERCENTAGE_STRING;
        symbolShapeSpec.bounds = boundsSpec;
    }

    public Shape getFirstGrabber() {
        return this.firstGrabber;
    }

    public Shape getSecondGrabber() {
        return this.secondGrabber;
    }

    public Shape getMedian() {
        return this.median;
    }

    public double getThumbNailWidth() {
        return this.thumbNailWidth;
    }

    public Shape getMainGrabber() {
        return this.mainGrabber;
    }

    public final String getClickedPart() {
        return this.clickedPart;
    }

    public final Vis getVis() {
        return this.vis;
    }
}

