/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.defender;

import com.ibm.vis.engine.internal.Grammar;
import com.ibm.vis.engine.internal.data.Data;
import com.ibm.vis.engine.internal.data.Row;
import com.ibm.vis.engine.internal.grammar.element.Element;
import com.ibm.vis.engine.internal.grammar.values.ValueProvider;
import com.ibm.vis.engine.internal.nativeImpl.BasicFactory;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.spec.internal.DimensionSpec;
import com.ibm.vis.spec.internal.ScaleSpec;
import com.ibm.vis.spec.internal.SpanSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012,2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ZoomAction {
    Grammar grammar;

    public ZoomAction(Grammar grammar) {
        this.grammar = grammar;
    }

    public void zoomToCoordinatesWithDataFilter(Double[] doubleArray, Double[] doubleArray2, boolean bl, String string) {
        if (doubleArray == null || doubleArray2 == null) {
            return;
        }
        DimensionSpec[] dimensionSpecArray = this.grammar.gSpec.coordinates.dimensions;
        Element[] elementArray = this.grammar.elements;
        Map<String, Integer> map = this.cacheElementDataRows(elementArray);
        for (int i = 0; i < dimensionSpecArray.length; ++i) {
            Object object;
            SpanSpec spanSpec = new SpanSpec();
            if (doubleArray[i] == null || doubleArray2[i] == null) continue;
            if (bl) {
                object = new ArrayList();
                for (int j = 0; j < elementArray.length; ++j) {
                    int n = ZoomAction.getSortColumnIndex(elementArray[j], i);
                    if (n == -1) continue;
                    this.filterElementDataRows(doubleArray[i], doubleArray2[i], n, elementArray[j].data.id, (List<String>)object, map);
                }
                object.clear();
            }
            spanSpec.min = doubleArray[i];
            spanSpec.max = doubleArray2[i];
            spanSpec.unit = string;
            object = new ScaleSpec();
            ((ScaleSpec)object).spans = new SpanSpec[]{spanSpec};
            dimensionSpecArray[i].scale = object;
        }
        map.clear();
    }

    private static int getSortColumnIndex(Element element, int n) {
        ValueProvider valueProvider = element.positions[n];
        if (valueProvider != null && valueProvider.getBaseField() != null) {
            return valueProvider.getBaseField().getIndex();
        }
        return -1;
    }

    private void filterElementDataRows(Double d, Double d2, int n, String string, List<String> list, Map<String, Integer> map) {
        Row[] rowArray;
        if (!list.contains(string) && (rowArray = this.grammar.vis.retrieveZoomData(string)) != null && rowArray.length > 0) {
            int n2;
            double[][] dArray = this.getNumberArrayFromRow(rowArray);
            int n3 = this.getStartIndexOfDataForZoomStartPoint(dArray, n, d);
            int n4 = this.getEndIndexOfDataForZoomEndPoint(dArray, n, d2);
            ArrayList<double[]> arrayList = new ArrayList<double[]>();
            for (n2 = n3; n2 <= n4; ++n2) {
                arrayList.add(dArray[n2]);
            }
            n2 = map.get(string);
            int n5 = arrayList.size();
            this.grammar.vis.getCurrentSpec().data[n2].rows = (double[][])arrayList.toArray((T[])new double[n5][]);
            list.add(string);
        }
    }

    private double[][] getNumberArrayFromRow(Row[] rowArray) {
        double[][] dArrayArray = new double[rowArray.length][];
        for (int i = 0; i < rowArray.length; ++i) {
            dArrayArray[i] = rowArray[i].data;
        }
        return dArrayArray;
    }

    private int getStartIndexOfDataForZoomStartPoint(double[][] dArray, int n, double d) {
        Double d2 = dArray[0][n];
        if (d < d2) {
            d = d2;
        }
        int n2 = this.getZoomBounds(dArray, d, n);
        d2 = dArray[n2][n];
        if (n2 > 0 && d2 > d) {
            --n2;
        }
        return n2;
    }

    private int getEndIndexOfDataForZoomEndPoint(double[][] dArray, int n, double d) {
        double d2 = dArray[dArray.length - 1][n];
        if (d > d2) {
            d = d2;
        }
        int n2 = this.getZoomBounds(dArray, d, n);
        d2 = dArray[n2][n];
        if (n2 < dArray.length - 1 && d2 < d) {
            ++n2;
        }
        return n2;
    }

    private int getZoomBounds(double[][] dArray, double d, int n) {
        int n2 = 0;
        int n3 = dArray.length - 1;
        int n4 = 0;
        while (n2 <= n3) {
            n4 = Math.round((n2 + n3) / 2);
            double d2 = dArray[n4][n];
            if (d2 < d) {
                n2 = n4 + 1;
                continue;
            }
            if (d2 > d) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return n4;
    }

    private Map<String, Integer> cacheElementDataRows(Element[] elementArray) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 0; i < elementArray.length; ++i) {
            String string = elementArray[i].data.id;
            Data[] dataArray = this.grammar.vis.getData();
            for (int j = 0; j < dataArray.length; ++j) {
                if (dataArray[j] == null || BasicFactory.compareTo(dataArray[j].id, string) != 0) continue;
                Row[] rowArray = dataArray[j].rows;
                hashMap.put(string, j);
                if (this.grammar.vis.retrieveZoomData(string) != null) continue;
                this.grammar.vis.cacheZoomData(string, rowArray);
            }
        }
        return hashMap;
    }
}

