/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.effect;

import com.ibm.json.java.JSONObject;
import com.ibm.vis.engine.internal.interaction.effect.Effect;
import com.ibm.vis.engine.internal.interaction.effect.EffectBuilder;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.SpecUtil;
import com.ibm.vis.engine.internal.scene.StyleBuilder;
import com.ibm.vis.engine.internal.struct.ShapePoly;
import com.ibm.vis.geom.Poly;
import com.ibm.vis.scenetree.internal.CompositeSceneNode;
import com.ibm.vis.scenetree.internal.SceneNodeFactory;
import com.ibm.vis.scenetree.internal.SceneNodeImpl;
import com.ibm.vis.spec.internal.ColorSpec;
import com.ibm.vis.spec.internal.StyleSpec;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011,2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class AddPolygonEffect
extends Effect {
    private SceneNodeImpl polygonItem = SceneNodeFactory.createShapeNode(null);
    private final StyleSpec style;

    public AddPolygonEffect(int n, JSONObject jSONObject) {
        super(0);
        if (jSONObject != null) {
            this.style = (StyleSpec)SpecUtil.createSpecObject(jSONObject, "com.ibm.vis.spec.StyleSpec");
        } else {
            ColorSpec colorSpec = new ColorSpec();
            colorSpec.r = 255;
            colorSpec.g = 255;
            colorSpec.b = 255;
            colorSpec.a = 0.5;
            this.style = new StyleSpec();
            this.style.fill = colorSpec;
        }
    }

    public void setPolygon(Poly poly) {
        if (this.polygonItem != null && this.polygonItem.getParent() != null) {
            ((CompositeSceneNode)this.polygonItem.getParent()).removeChild(this.polygonItem);
        }
        ShapePoly shapePoly = new ShapePoly(poly.getX(), poly.getY(), poly.isClosed(), null);
        StyleBuilder.modifyShapeStyle(shapePoly, this.style);
        this.polygonItem = shapePoly.createSceneNode();
    }

    @Override
    public void install(EffectBuilder effectBuilder) {
        if (this.polygonItem != null) {
            effectBuilder.addTemporaryItem(this.polygonItem, null);
        }
        super.install(effectBuilder);
    }
}

