/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.effect;

import com.ibm.vis.engine.internal.interaction.easing.BackOutEasingFunction;
import com.ibm.vis.engine.internal.interaction.easing.BounceOutEasingFunction;
import com.ibm.vis.engine.internal.interaction.easing.LinearEasingFunction;
import com.ibm.vis.engine.internal.interaction.easing.QuadInOutEasingFunction;
import com.ibm.vis.engine.internal.interaction.effect.CompositeEffect;
import com.ibm.vis.engine.internal.interaction.effect.Effect;
import com.ibm.vis.engine.internal.interaction.effect.FadeInEffect;
import com.ibm.vis.engine.internal.interaction.effect.FadeOutEffect;
import com.ibm.vis.engine.internal.interaction.effect.FlyInEffect;
import com.ibm.vis.engine.internal.interaction.effect.GrowEffect;
import com.ibm.vis.engine.internal.interaction.effect.RevealEffect;
import com.ibm.vis.engine.internal.interaction.effect.Transition;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.engine.internal.nativeImpl.IntHashMap;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;
import com.ibm.vis.interaction.ChangeEffect;
import com.ibm.vis.interaction.ChangeEffects;
import com.ibm.vis.interaction.EasingFunction;
import com.ibm.vis.interaction.events.RaveListener;
import com.ibm.vis.interaction.internal.events.EventDispatcher;
import java.util.HashMap;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2012, 2014\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class ChangeEffectsImpl
extends ChangeEffects {
    private final EventDispatcher eventDispatcher;
    private final IntHashMap<ChangeEffect> effectsMap = new IntHashMap();
    HashMap<String, EasingFunction> easingFunctions;

    public ChangeEffectsImpl(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
        this.easingFunctions = new HashMap();
        this.easingFunctions.put("linear", new LinearEasingFunction());
        this.easingFunctions.put("easeInOutQuad", new QuadInOutEasingFunction());
        this.easingFunctions.put("easeOutBack", new BackOutEasingFunction());
        this.easingFunctions.put("easeOutBounce", new BounceOutEasingFunction());
    }

    @Override
    public ChangeEffect makeTransitionEffect(int n) {
        Transition transition = new Transition(n);
        transition.setEventDispatcher(this.eventDispatcher);
        return transition;
    }

    @Override
    public ChangeEffect makeGrowEffect(int n) {
        GrowEffect growEffect = new GrowEffect(n);
        growEffect.setEventDispatcher(this.eventDispatcher);
        return growEffect;
    }

    @Override
    public ChangeEffect makeRevealEffect(int n) {
        RevealEffect revealEffect = new RevealEffect(n);
        revealEffect.setEventDispatcher(this.eventDispatcher);
        return revealEffect;
    }

    @Override
    public ChangeEffect makeFadeInEffect(int n) {
        FadeInEffect fadeInEffect = new FadeInEffect(n, 1);
        fadeInEffect.setEventDispatcher(this.eventDispatcher);
        return fadeInEffect;
    }

    @Override
    public ChangeEffect makeFadeOutEffect(int n) {
        FadeOutEffect fadeOutEffect = new FadeOutEffect(n, 1);
        fadeOutEffect.setEventDispatcher(this.eventDispatcher);
        return fadeOutEffect;
    }

    @Override
    public ChangeEffect makeFlyInEffect(int n) {
        FlyInEffect flyInEffect = new FlyInEffect(n, 1);
        flyInEffect.setEventDispatcher(this.eventDispatcher);
        return flyInEffect;
    }

    @Override
    public ChangeEffect makeSimultaneous(ChangeEffect changeEffect, ChangeEffect changeEffect2) {
        CompositeEffect compositeEffect = CompositeEffect.makeCompositeEffect(new Effect[]{(Effect)changeEffect, (Effect)changeEffect2});
        return compositeEffect;
    }

    @Override
    public ChangeEffect makeSimultaneousEffects(ChangeEffect[] changeEffectArray) {
        if (changeEffectArray == null) {
            throw new EngineException("Null array passed to makeSimultaneousEffects", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        int n = 0;
        for (int i = 0; i < changeEffectArray.length; ++i) {
            if (changeEffectArray[i] == null) continue;
            ++n;
        }
        if (n == 0) {
            throw new EngineException("Array passed to makeSimultaneousEffects has no non-null effects", ErrorCode.ENGINE_ILLEGAL_ARGUMENT, null);
        }
        Effect[] effectArray = new Effect[n];
        n = 0;
        for (int i = 0; i < changeEffectArray.length; ++i) {
            if (changeEffectArray[i] == null) continue;
            effectArray[n++] = (Effect)changeEffectArray[i];
        }
        CompositeEffect compositeEffect = CompositeEffect.makeCompositeEffect(effectArray);
        return compositeEffect;
    }

    @Override
    public ChangeEffect makeSequential(ChangeEffect changeEffect, ChangeEffect changeEffect2) {
        throw new EngineException("Combined sequential effects are not supported yet", ErrorCode.ENGINE_UNSUPPORTED_OPERATION, null);
    }

    @Override
    public void setChangeEffect(ChangeEffect changeEffect, int n) {
        if (changeEffect == null) {
            this.effectsMap.remove(n);
        } else {
            this.effectsMap.put(n, changeEffect);
        }
    }

    @Override
    public ChangeEffect getChangeEffect(int n) {
        return this.effectsMap.get(n);
    }

    @Override
    public void addEffectListener(RaveListener raveListener) {
        this.eventDispatcher.addListenerToGroup("EffectStartEvent", raveListener);
        this.eventDispatcher.addListenerToGroup("EffectEndEvent", raveListener);
    }

    @Override
    public void removeEffectListener(RaveListener raveListener) {
        this.eventDispatcher.removeListenerFromGroup("EffectStartEvent", raveListener);
        this.eventDispatcher.removeListenerFromGroup("EffectEndEvent", raveListener);
    }

    @Override
    public EasingFunction getEasingFunction(String string) {
        return this.easingFunctions.get(string);
    }
}

