/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vis.engine.internal.interaction.effect;

import com.ibm.vis.engine.internal.interaction.effect.Effect;
import com.ibm.vis.engine.internal.interaction.effect.EffectBuilder;
import com.ibm.vis.engine.internal.interaction.effect.Transition;
import com.ibm.vis.engine.internal.nativeImpl.Copyright;
import com.ibm.vis.exceptions.ErrorCode;
import com.ibm.vis.exceptions.internal.EngineException;

@Copyright(value="\r\n\r\nLicensed Materials - Property of IBM\r\n\r\nIBM Business Analytics: Rapidly Adaptive Visualization Engine\r\n\r\n(C) Copyright IBM Corp. 2011, 2013\r\n\r\nUS Government Users Restricted Rights - Use, duplication or\r\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\r\n\r\n")
public class CompositeEffect
extends Effect {
    protected final Effect[] effects;

    private CompositeEffect(int n, Effect[] effectArray) {
        super(n);
        this.setTarget(-1);
        this.effects = effectArray;
    }

    public Effect[] getEffects() {
        return this.effects;
    }

    @Override
    public void install(EffectBuilder effectBuilder) {
        super.install(effectBuilder);
        for (Effect effect : this.effects) {
            effect.install(effectBuilder);
        }
    }

    @Override
    public void setStartTime(int n) {
    }

    @Override
    public void setDuration(int n) {
        this.getDuration();
    }

    @Override
    public int getStartTime() {
        return 0;
    }

    @Override
    public int getDuration() {
        int n = 0;
        for (Effect effect : this.effects) {
            n = Math.max(n, effect.getTime());
        }
        this.duration = n;
        return n;
    }

    @Override
    public int getTime() {
        return this.getDuration();
    }

    public static CompositeEffect makeCompositeEffect(Effect[] effectArray) {
        if (effectArray == null || effectArray.length < 1) {
            throw new EngineException("There should be at least one effect to make a composite effect", ErrorCode.ENGINE_COMPOSITE_EFFECT_NO_CHILD, null);
        }
        int n = 0;
        for (Effect effect : effectArray) {
            if (effect instanceof Transition) {
                throw new EngineException("Use of Transition simultaneously with another effect is unsupported.", ErrorCode.ENGINE_TRANSITION_UNSUPPORTED_SIMULTANEOUS_EFFECT, null);
            }
            n = Math.max(n, effect.getTime());
        }
        return new CompositeEffect(n, effectArray);
    }

    @Override
    public void fireOnEffectStartEvent() {
    }

    @Override
    public void fireOnEffectEndEvent() {
    }
}

